;------------------------------------------------------------------------------
; File:		hardy.clp
; Author:       Jussi Stader
; Date:		7/12/94
; Connections:	clips.clp
;
; Contents:	functions generally useful for HARDY applications
; Updates:
;
;------------------------------------------------------------------------------
;;; ---------------------------------------------------------------------------
;;;		Things in this file
;;; ---------------------------------------------------------------------------
;;; (defglobal ?*date*)
;;; (defglobal ?*author*)
;;; (get-date ?card)
;;; (get-author ?card)
;;; (diagram-image-get-string-attribute ?card ?image ?attribute)
;;; (get-all-node-image-arcs ?card ?node-image)
;;; (get-selected-type-image ?card ?arc-node ?type ?mode)
;;; (add-to-sorted-by-position ?card ?image ?sorted ?x ?y)
;;; (sort-node-images-by-position ?card ?images)
;;; (sort-arc-images-by-position ?card ?images ?side)
;;; (get-whole-arc ?card ?junction)
;;; (get-rest-junction-arc ?card ?arc-image ?junction-image)
;;; (get-other-junction-arc ?card ?arc-image ?junction-image ?from-to)
;;; (skip-junction ?card ?node-image ?func-name)
;;; (arc-image-get-node-object ?card ?arc-image ?from-to)
;;; (get-a-leg-attribute ?card ?junction ?attribute)
;;; (get-stem-attribute ?card ?junct ?attribute)
;;; (arc-image-get-image ?card ?arc-image ?from-to)
;;; (get-arc-image-attribute ?card ?arc-image ?from-to ?attribute)
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;	Notes and General Comments
;------------------------------------------------------------------------------
; 
; (assumptions, particularities, hacks, todos)
; 
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------




;;; (defglobal ?*date*)
;;; (defglobal ?*author*)
;; these globals are set in the functions get-date and get-author using the 
;; functions will always return values, the functions will ask the user if the 
;; globals equal "" (as below)
(defglobal ?*date* = "")
(defglobal ?*author* = "")


;;;----------------------------------------------------------------------------
;;;			General Utils
;;;----------------------------------------------------------------------------

;;; (get-date ?card)
;;; Return: date string
; ask for date/author if yet unknown (once per session)
; card id used for parent when asking
(deffunction get-date (?new-card)
  (if (eq ?*date* "") then 
    (bind ?*date* (get-text-from-user "Please enter today's date" "" 
			0 (card-get-frame ?new-card))))
  (return ?*date*)
)
;;; (get-author ?card)
;;; Return: author string
(deffunction get-author (?new-card)
  (if (eq ?*author* "") then
    (bind ?*author* (get-text-from-user "Please enter your name" ""
			0 (card-get-frame ?new-card))))
  (return ?*author*) 
)



;;;----------------------------------------------------------------------------
;;;			short-cuts (mostly skipping objects)
;;;----------------------------------------------------------------------------

;;; (diagram-image-get-string-attribute ?card ?image ?attribute)
;;; Return: attribute value string or ""
;; get an attribute value from the image's object 
(deffunction diagram-image-get-string-attribute (?card ?image ?att)
 (diagram-object-get-string-attribute
	?card
   	(diagram-image-get-object ?card ?image)
	?att) 
)

;;; (get-all-node-image-arcs ?card ?node-image)
;;; Return: mv of arc images
;; collect all node's arc images - don't bother with junctions
(deffunction get-all-node-image-arcs (?card ?node-image)
  (bind ?arcs (create$))
  (bind ?arc-image (node-image-get-first-arc-image ?card ?node-image))
  (while (neq -1 ?arc-image) do
    (bind ?arcs (append ?arcs ?arc-image))
    (bind ?arc-image (node-image-get-next-arc-image)))
  (return ?arcs)
)

;;; (get-selected-type-image ?card ?arc-node ?type ?mode)
;;; Return: image (mode "one") or multivalue of images or (create$)
;; go through images until one/all selected images of the given type found 
;; dont care for given type is ""
;; returns (create$) if none found 
(deffunction get-selected-type-image (?card ?arc-node ?type ?mode)
  (bind ?selected (create$))
  (if (eq ?arc-node "node") then
    (bind ?image (diagram-card-get-first-node-image ?card))
    (bind ?function "(diagram-card-get-next-node-image)")
   else (bind ?image (diagram-card-get-first-arc-image ?card))
   	(bind ?function "(diagram-card-get-next-arc-image)"))
   ;; go through images to find first/all selected of right type
  (while (neq ?image -1) do
    (if (eq 1 (diagram-image-selected ?card ?image)) then	;; selected
      (if (or (eq ?type "")			;; dont care
	      (eq (diagram-image-get-string-attribute ?card ?image "type")
	      	 ?type))					;; right type
       then (if (eq ?mode "one") then (return ?image)		;; ---> found
	   else (bind ?selected (append ?selected ?image))))	;; collect
      (if (and (eq ?type "")			;; dont care
	       (eq ?arc-node "node")
	       (eq 1 (node-image-is-junction ?card ?image)))	;; junction
       then (if (eq ?mode "one") then (return ?image)		;; ---> found
	   else (bind ?selected (append ?selected ?image)))))	;; collect
   (bind ?image (eval ?function)))
 (return ?selected) 
)


;;; (add-to-sorted-by-position ?card ?image ?sorted ?x ?y)
;;; Return: multivalue of images
;; adds an image at the right place to a list of images sorted by position 
;; (left-right, top-bottom) 
(deffunction add-to-sorted-by-position (?card ?image ?sorted ?x ?y)
  (if (eq (create$) ?sorted) then (return (create$ ?image))) ;;------>
  (bind ?sort (nth$ 1 ?sorted))
  (bind ?xs (diagram-image-get-x ?card ?sort))
  (if (or (< ?x ?xs)
	  (and (= ?x ?xs) (< ?y (diagram-image-get-y ?card ?sort))))
   then (return (insert$ ?sorted 1 ?image)))		 ;;------>
  (return
     (insert$ (add-to-sorted-by-position ?card ?image (rest$ ?sorted) ?x ?y)
	   1 ?sort)) )

;;; (sort-node-images-by-position ?card ?images)
;;; Return: multivalue of images
;; the given list of node images is returned sorted by position 
;; (left-right, top-bottom) 
(deffunction sort-node-images-by-position (?card ?images)
  ;;; left to right, top to bottom
  (bind ?sorted (create$))
  (bind ?count 1)
  (while (<= ?count (length$ ?images)) do
    (bind ?image (nth$ ?count ?images))
    (bind ?sorted (add-to-sorted-by-position ?card ?image ?sorted
	(diagram-image-get-x ?card ?image) (diagram-image-get-y ?card ?image)))
    (bind ?count (+ 1 ?count))) ; (format t "sorted: %s%n" (implode$ ?sorted))
  (return ?sorted) )

;;; (sort-arc-images-by-position ?card ?images ?side)
;;; Return: multivalue of images
;; NOTE: this needs real arc sorting by attachment order 
(deffunction sort-arc-images-by-position (?card ?images ?side)
  (sort-node-images-by-position ?card ?images) )


; ------------------------ first HARDY things -----------------------------
;;; NOTE go through these and see whether they overlap with above and below

;;; get the attribute value of the node on the specified side of the 
;;; given arc-image
; goes via node-images
(deffunction get-arc-node-attribute (?real-card ?arcimage ?fromto ?att)
  (if (eq ?fromto "from") then 
    (bind ?nodeimage (get-arc-image-from ?real-card ?arcimage)) else
    (bind ?nodeimage (get-arc-image-to ?real-card ?arcimage)))
  (if (neq ?nodeimage -1) then
    (bind ?node (get-object-from-image ?real-card ?nodeimage)))
  (if (neq ?node -1) then
    (get-object-string-attribute ?real-card ?node ?att))
)
;;; example: (get-arc-node-attribute ?card ?arcimage "from" "name")
;;;          (get-arc-node-attribute 1011 110 "from" "name") --> "Ucs Node"



;;; a node is a root (leaf) if none of its images has an arc-image coming
;;; into it (going out of it).
;;; for each node-image on the card check all its arc-images. If there is
;;; an incoming (outgoing) arc then the node is not a root (leaf), so stop
;;; for that node image and check the next node image.
;;; two lists are kept, edges and noedges, to make sure that image-object 
;;; difference does not interfere.
(deffunction find-diagram-edges (?real-card ?from-to)
  (bind ?edges (create$))
  (bind ?noedges (create$))
  (bind ?node-image (diagram-card-get-first-node-image ?real-card))
  (bind ?funct-start 
	(str-cat "(arc-image-get-image" ?from-to " " ?real-card " "))
  (while (neq ?node-image -1) do
    (bind ?node (diagram-image-get-object ?real-card ?node-image))
    (if (not (member$ ?node ?noedges)) then	; not disqualified
      (bind ?arc-image (node-image-get-first-arc-image ?real-card ?node-image))
      (while (neq -1 ?arc-image) do
        (if (eq ?node-image 			; not an edge
		(eval  (str-cat ?funct-start ?arc-image ")"))) then
	  (bind ?noedges (add-if-not-member ?node ?noedges))
	  (bind ?edges (remove-all ?node ?edges))	; update both lists
	  (bind ?arc-image -1)			; stop checking
         else (bind ?arc-image 			; else check on
		    (node-image-get-next-arc-image ?real-card ?node-image)))))
    (if (not (member$ ?node ?noedges)) then 	; checked all arcs - is edge
      (bind ?edges (add-if-not-member ?node ?edges)))
    (bind ?node-image (diagram-card-get-next-node-image ?real-card)))
)

(deffunction find-diagram-roots (?real-card)
  (find-diagram-edges ?real-card "To")
)
(deffunction find-diagram-leaves (?real-card)
  (find-diagram-edges ?real-card "From")
)

;;;----------------------------------------------------------------------------
;;;			junctions
;;;----------------------------------------------------------------------------

;;; (get-whole-arc ?card ?junction)
;;; Return: mv of arc images or FALSE (if node no junction)
(deffunction get-whole-junction-arc (?card ?junction)
  (if (eq 1 (node-image-is-junction ?card ?junction)) then
    (bind ?arcs (create$))
    (bind ?arc-image (node-image-get-first-arc-image ?card ?junction))
    (while (neq ?arc-image -1) do
      (bind ?arcs (append ?arcs ?arc-image))
      (bind ?arc-image (node-image-get-next-arc-image)))
    (return ?arcs))
)

;;; (get-rest-junction-arc ?card ?arc-image ?junction-image)
;;; Return: mv of arc images
(deffunction get-rest-junction-arc (?card ?arc-image ?junction)
  (bind ?arcs (get-whole-junction-arc ?card ?junction))
  (bind ?nth (member$ ?arc-image ?arcs))
  (if ?nth then (return (delete$ ?arcs ?nth ?nth))
   else (return ?arcs))
)

;;; (get-other-junction-arc ?card ?arc-image ?junction-image ?from-to)
;;; Return: mv of arc images
(deffunction get-other-junction-arc (?card ?arc-image ?junction ?from-to)
  (bind ?arcs (create$))
  (bind ?other-arc (node-image-get-first-arc-image ?card ?junction))
  (while (neq ?other-arc -1) do
    (bind ?node (get-arc-image-from ?card ?other-arc))
    (if (or (and (eq "from" ?from-to)  	  ;; given arc comes from junction
        	 (neq ?node ?junction))   ;; so from node should be different
	    (and (eq "to" ?from-to)	  ;; given arc is to junction
		 (eq ?node ?junction)))   ;; so from node should be same
     then (bind ?arcs (append ?arcs ?other-arc)))
    (bind ?other-arc (node-image-get-next-arc-image)))
  (return ?arcs)
)

;;; (skip-junction ?card ?node-image ?func-name)
;;; Return: node image or FALSE
;; return a real node, i.e. skip junction if from/to node is a junction
(deffunction skip-junction (?card ?node-image ?func-name)
  (if (eq 1 (node-image-is-junction ?card ?node-image)) then
    (bind ?arc-image (node-image-get-first-arc-image ?card ?node-image))
    (while (neq ?arc-image -1) do
      (bind ?other-node
	    (eval (str-cat "(" ?func-name " " ?card " " ?arc-image ")")))
      (if (neq ?node-image ?other-node) then
        (return ?other-node)
       else (bind ?arc-image (node-image-get-next-arc-image))))
    (return FALSE) ;; junction, but no node found - should not happen!
   else (return ?node-image)) )

;;; (arc-image-get-node-object ?card ?arc-image ?from-to)
;;; Return: node object or -1
;; get the object on the other side of the arc (skipping junctions)
(deffunction arc-image-get-node-object (?card ?arc-image ?from-to)
  (if (eq "from" ?from-to) then
     (bind ?func-name arc-image-get-image-from)
   else (bind ?func-name arc-image-get-image-to))
  (bind ?image (eval (str-cat "(" ?func-name " " ?card " " ?arc-image ")")))
  (bind ?image (skip-junction ?card ?image ?func-name))
  (if ?image then
    (return (diagram-image-get-object ?card ?image))
   else (return -1)) 
)


;;; (get-a-leg-attribute ?card ?junction ?attribute)
;;; Return: attribute value string or ""
;; goes through all the junction's legs and picks up the first 
;;  non-empty attribute value
(deffunction get-a-leg-attribute (?card ?junct ?attribute)
  (bind ?data "")
  (bind ?arc-image (node-image-get-first-arc-image ?card ?junct))
  ; search until data found or no more arc-legs
  (while (and (neq ?arc-image -1) (eq ?data "")) do
    (if (eq 1 (arc-image-is-leg ?card ?arc-image)) then
       (bind ?data 
	     (diagram-image-get-string-attribute ?card ?arc-image ?attribute)))
    (bind ?arc-image (node-image-get-next-arc-image)))
  (return ?data)
)

;;; (get-stem-attribute ?card ?junct ?attribute)
;;; Return: attribute value string or ""
;; finds junction stem and picks up its attribute
(deffunction get-stem-attribute (?card ?junct ?attribute)
  (bind ?arc-image (node-image-get-first-arc-image ?card ?junct))
  ; search until stem found
  (while (neq ?arc-image -1) do
    (if (eq 1 (arc-image-is-stem ?card ?arc-image)) then
      (return (diagram-image-get-string-attribute ?card ?arc-image ?attribute))
     else (bind ?arc-image (node-image-get-next-arc-image))))
  (return "")  ; no stem found
)


;;; (arc-image-get-image ?card ?arc-image ?from-to)
;;; Return: node image or -1
;; get the object on the other side of the arc (skipping junctions)
(deffunction arc-image-get-image (?card ?arc-image ?from-to)
  (if (eq "from" ?from-to) then
     (return (arc-image-get-image-from ?card ?arc-image))
   else (return (arc-image-get-image-to ?card ?arc-image)))
)

;;; (get-arc-image-attribute ?card ?arc-image ?from-to ?attribute)
;;; Return: attribute value string or ""
;; get a non-empty value for the given attribute of the arc-image 
;; or the image of another part of the junction arc.
;; Order: arc, arc on other side of junction, other arc on same side
(deffunction get-arc-image-attribute (?card ?arc-image ?from-to ?attribute)
  (bind ?data (diagram-image-get-string-attribute ?card ?arc-image ?attribute))
  (if (eq "" ?data) then	;;; arc has no own attribute value
    (bind ?junct (arc-image-get-image ?card ?arc-image ?from-to))
    (if (eq 1 (node-image-is-junction ?card ?junct)) then
      ;;; junction arc, so check other parts of arc
      (if (eq 1 (arc-image-is-stem ?card ?arc-image)) then
	;;; on other side of junction (nothing on same side)
        (bind ?data (get-a-leg-attribute ?card ?junct ?attribute))
       else ;;; original arc is a leg. first check stem (other side)
	(bind ?data (get-stem-attribute ?card ?junct ?attribute))
        (if (eq ?data "") then  ;;; no stem data. check other legs (same side)
          (bind ?data (get-a-leg-attribute ?card ?junct ?attribute))))))
  (return ?data)
)

