;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; BATCH FILE ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; File:   loader.clp
;;; Author: Ian Harrison
;;; Date:   7/11/94
;;;
;;; Description: This file is the batch file for the program.
;;;              It can be loaded either with the command line
;;;              option "-clips" of HARDY or with the menu option 
;;;              "File:Batch" of the HARDY Developer window. When executed it
;;;              loads the other source files and declares event handlers
;;;              for the "Project Management" diagram type.
;;;

;;; load the CLIPS source files:

(defglobal ?*selected-image-id* = 0)
(defglobal ?*process-list* = (create$))

(load "analysis.clp")
(load "eventhnd.clp")
(load "attribut.clp")


(register-event-handler CreateNodeImage "Task management" newNode)
(register-event-handler CustomMenu "Task management" customMenu)
(register-event-handler CreateCard "Task management" setTitle)
(register-event-handler NodeLeftClick "Task management" nodeLeftClick)
(register-event-handler NodeRightClick "Task management" nodeRightClick)

(unwatch all)
