(defglobal ?*attribute-frame* = 0)
(defglobal ?*attribute-panel* = 0)
(defglobal ?*node-name-item* = 0)
(defglobal ?*node-duration-item* = 0)
(defglobal ?*ok-button* = 0)
(defglobal ?*cancel-button* = 0)
(defglobal ?*nodeA* = -1)
(defglobal ?*cardA* = -1)


;;; Function: onCloseAttributes
;;; Arguments: the attribute frame 
;;; Description: This is the callback function that is called when the
;;;              attribute frame is closed

(deffunction onCloseAttributes (?frame)
    (window-delete ?frame)
    (bind ?*attribute-frame* 0)
    (return 1))

;;; Function: editName
;;; Arguments: The interface item that displays the name of the node
;;; Description: This is the callback function of the interface item
;;;              ?*node-name-item* of the attribute frame. It sets the
;;;              text item value to what the nodes current name is. 

(deffunction editName (?item)
    (bind ?name (diagram-object-get-string-attribute ?*cardA* ?*nodeA* "name")))

;;; Function: editDuration
;;; Arguments: The interface item that displays the duration of the node
;;; Description: This is the callback function of the interface item
;;;              ?*node-duration-item* of the attribute frame. It sets the
;;;              text item value to what the nodes current duration is. 

(deffunction editDuration (?item)
    (bind ?duration (diagram-object-get-string-attribute ?*cardA* ?*nodeA* 
 				 "duration")))

;;; Function: okAttributes
;;; Arguments: The Ok button in the attribute frame
;;; Description: This is the callback function of the interface item
;;;              ?*ok-button* of the attribute frame. It sets the
;;;              new attribute values in HARDY, and recalculates
;;;              critical path

(deffunction okAttributes (?item)
    (bind ?name (text-get-value ?*node-name-item*))
    (bind ?duration (text-get-value ?*node-duration-item*))
    (if (and (= 1 (diagram-image-selected ?*cardA*  ?*selected-image-id*))
             (= 1 (validStartNode ?*cardA* ?*selected-image-id*))) then
       (diagram-object-set-string-attribute ?*cardA* ?*nodeA* 
					    "name" ?name)
       (diagram-object-set-string-attribute ?*cardA* ?*nodeA* 
					    "duration" ?duration)
       (diagram-object-format-text ?*cardA* ?*nodeA*)
       (doAnalysis ?*cardA*)
     else
        (if (or (= 0 (diagram-image-selected ?*cardA* ?*selected-image-id*))
                (= 0 (validStartNode ?*cardA* ?*selected-image-id*))) then
           (diagram-object-set-string-attribute ?*cardA* ?*nodeA* 
					    "name" ?name)
           (diagram-object-set-string-attribute ?*cardA* ?*nodeA* 
					    "duration" ?duration)
           (diagram-object-format-text ?*cardA* ?*nodeA*)
           (message-box "Diagram not updated. Please select a root node and then choose menu item Evaluate: Critical Path to update diagram" 
                   OK 1 (card-get-frame ?*cardA*)))
     )
     (onCloseAttributes ?*attribute-frame*)
)

;;; Function: cancelAttributes
;;; Arguments: The Cancel button in the attribute frame
;;; Description: This is the callback function of the interface item
;;;              ?*cancel-button* of the attribute frame.

(deffunction cancelAttributes (?item)
    (onCloseAttributes ?*attribute-frame*))

;;; Function: createAttributeFrame
;;; Arguments: 
;;; Description: The attribute editing window is created

(deffunction createAttributeFrame ()
   (bind ?*attribute-frame* (frame-create 
				(card-get-frame ?*cardA*)
				"Attributes"
				-1 -1 300 250))
   (window-add-callback ?*attribute-frame* OnClose onCloseAttributes)
   (bind ?*attribute-panel* (panel-create 
				?*attribute-frame*
				0 0 300 250))
   (panel-set-label-position ?*attribute-panel* wxVERTICAL)
   (bind ?*node-name-item* (text-create ?*attribute-panel* editName
					"Name:" "" -1 -1 200 80))
   (panel-new-line ?*attribute-panel*)
   (bind ?*node-duration-item* (text-create ?*attribute-panel*
					    editDuration 
					    "Duration:" "" -1 -1 200 80))
   (panel-new-line ?*attribute-panel*)
   (bind ?*ok-button* (button-create ?*attribute-panel* okAttributes
				     "Ok"))
   (bind ?*cancel-button* (button-create ?*attribute-panel* cancelAttributes
					 "Cancel"))
   (panel-new-line ?*attribute-panel*)
   (panel-item-set-default ?*ok-button*)
   (window-fit ?*attribute-panel*)
   (window-fit ?*attribute-frame*)
   (window-centre ?*attribute-frame*)
)


;;; Function: initAttributeFrame
;;; Arguments: a diagram card id, a node object id
;;; Description: When node is control clicked on the Attribute editing
;;;              window appears

(deffunction initAttributeFrame (?card ?node-object)
   (bind ?*cardA* ?card)
   (bind ?*nodeA* ?node-object)
   (if (= 0 ?*attribute-frame*) then
      (createAttributeFrame))
   (bind ?node-name (diagram-object-get-string-attribute ?*cardA*
 			 ?*nodeA* "name"))
   (text-set-value ?*node-name-item* ?node-name)
   (bind ?node-duration (diagram-object-get-string-attribute ?*cardA*
                             ?*nodeA* "duration"))
   (text-set-value ?*node-duration-item* ?node-duration)
   (window-show ?*attribute-frame* 1)
)
