/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HTMLPanel
extends JFrame {
    private JEditorPane htmlPane;
    JButton button;
    JButton back;
    private URL helpURL;
    protected Stack stack = new Stack();

    public HTMLPanel(String string, boolean bl, String string2) {
        super("COBrA Help Browser");
        this.constructBrowser(string, bl, string2);
    }

    public HTMLPanel(String string, boolean bl) {
        super("COBrA");
        this.constructViewer(string, bl);
    }

    public void constructBrowser(String string, boolean bl, String string2) {
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        this.htmlPane.addHyperlinkListener(new Hyperactive());
        JScrollPane jScrollPane = new JScrollPane(this.htmlPane);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.back = new JButton("Back");
        this.back.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                URL uRL = (URL)HTMLPanel.this.stack.pop();
                HTMLPanel.this.displayURL(uRL);
                if (HTMLPanel.this.stack.empty()) {
                    HTMLPanel.this.stack.push(uRL);
                }
            }
        });
        this.button = new JButton("Dismiss");
        this.button.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLPanel.this.setVisible(false);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.back);
        jPanel.add(this.button);
        jScrollPane.setMinimumSize(new Dimension(600, 600));
        jScrollPane.setPreferredSize(new Dimension(600, 600));
        this.getContentPane().add((Component)jPanel, "South");
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.initDoc(string, bl, string2);
        this.pack();
        this.setVisible(true);
    }

    public void constructViewer(String string, boolean bl) {
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        this.htmlPane.addHyperlinkListener(new Hyperactive());
        JScrollPane jScrollPane = new JScrollPane(this.htmlPane);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.button = new JButton("Dismiss");
        this.button.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLPanel.this.setVisible(false);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.button);
        jScrollPane.setMinimumSize(new Dimension(600, 600));
        jScrollPane.setPreferredSize(new Dimension(600, 600));
        this.getContentPane().add((Component)jPanel, "South");
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.initDoc(string, bl);
        this.pack();
        this.setVisible(true);
    }

    private void initDoc(String string, boolean bl, String string2) {
        String string3 = string;
        try {
            if (!bl) {
                string3 = "file:" + System.getProperty("user.dir") + System.getProperty("file.separator") + string;
            }
            this.helpURL = new URL(string3);
            URL uRL = new URL(string2);
            this.displayURL(this.helpURL, uRL);
            this.stack.push(this.helpURL);
        }
        catch (Exception exception) {
            System.err.println("Couldn't create help URL: " + string);
        }
    }

    private void initDoc(String string, boolean bl) {
        String string2 = string;
        try {
            if (!bl) {
                string2 = "file:" + System.getProperty("user.dir") + System.getProperty("file.separator") + string;
            }
            this.helpURL = new URL(string2);
            this.displayURL(this.helpURL);
            this.stack.push(this.helpURL);
        }
        catch (Exception exception) {
            System.err.println("Couldn't create help URL: " + string);
        }
    }

    private void displayURL(URL uRL, URL uRL2) {
        try {
            this.htmlPane.setPage(uRL);
        }
        catch (IOException iOException) {
            System.err.println("Attempted to read a bad URL: " + uRL);
            try {
                this.htmlPane.setPage(uRL2);
            }
            catch (IOException iOException2) {
                System.err.println("Attempted to read a bad URL: " + uRL2);
                this.htmlPane.setText("Could not find " + uRL.toString() + " or connect to " + uRL2.toString());
            }
        }
    }

    private void displayURL(URL uRL) {
        try {
            this.htmlPane.setPage(uRL);
        }
        catch (IOException iOException) {
            System.err.println("Attempted to read a bad URL: " + uRL);
            this.htmlPane.setText("Could not find " + uRL.toString());
        }
    }

    public static void main(String[] stringArray) {
        HTMLPanel hTMLPanel = new HTMLPanel("cobra.html", false);
        hTMLPanel.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        hTMLPanel.pack();
        hTMLPanel.setVisible(true);
    }

    class Hyperactive
    implements HyperlinkListener {
        Hyperactive() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                try {
                    HTMLPanel.this.stack.push(hyperlinkEvent.getURL());
                    jEditorPane.setPage(hyperlinkEvent.getURL());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }
}

