/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.sweb;

import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JProgressBar;
import org.xspan.applications.COBrA.datamodels.GoDbxref;
import org.xspan.applications.COBrA.datamodels.GoOntology;
import org.xspan.applications.COBrA.datamodels.GoRelationship;
import org.xspan.applications.COBrA.datamodels.GoRelationshipType;
import org.xspan.applications.COBrA.datamodels.GoRelationshipVector;
import org.xspan.applications.COBrA.datamodels.GoTerm;
import org.xspan.applications.COBrA.exceptions.InvalidParameterException;
import org.xspan.applications.COBrA.io.GoXMLReader;
import org.xspan.applications.COBrA.io.Namespace;
import org.xspan.applications.COBrA.messages.Message;
import org.xspan.applications.COBrA.messages.MessageVector;
import org.xspan.applications.COBrA.sweb.SWEBTools;
import org.xspan.applications.COBrA.util.HTMLPanel;

public class RDFSTools
extends SWEBTools {
    int swebModelType;
    public Namespace namespace;
    protected HashMap relationshipTypes;
    protected HashMap relationshipTypesForRDFGen;
    MessageVector messages;
    protected HashMap goTermMap;
    JProgressBar progressBar;
    String message;
    String outputFile = "analysis.html";

    public RDFSTools(HashMap hashMap) {
        this.setModelType(SWEBTools.XSPAN_RDFS);
        this.namespace = new Namespace(Namespace.RDFS_ED);
        this.messages = new MessageVector();
        this.addLine(hashMap.toString());
        this.relationshipTypes = hashMap;
        this.progressBar = null;
        this.message = "<html><title>Analysis of RDFS Models</title>\n <h3>Analysis of RDFS Models </h3>\n<body>\n";
        HashMap hashMap2 = new HashMap();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            hashMap2.put(hashMap.get(string), string);
        }
        this.relationshipTypesForRDFGen = hashMap2;
    }

    public void addLine(String string) {
        this.message = this.message + string + "<br>\n";
    }

    public void addLineNoBR(String string) {
        this.message = this.message + string + "\n";
    }

    public void setProgressBar(JProgressBar jProgressBar) {
        this.progressBar = jProgressBar;
    }

    public void validateRDFS(GoOntology goOntology) {
        Object object;
        Object object2;
        Model model;
        if (goOntology == null || goOntology.getRootTerm() == null || goOntology.getRootTerm().getChildren().size() == 0) {
            return;
        }
        Model model2 = null;
        InfModel infModel = null;
        Model model3 = model = this.createModel(goOntology.getRootTerm());
        try {
            object2 = new URL("http://www.xspan.org/obo.rdfs");
            object = new GoXMLReader(((URL)object2).openConnection());
            model2 = ((GoXMLReader)object).readRDF();
        }
        catch (IOException iOException) {
            this.addLine("Unable to open connection to " + this.namespace.DEFAULT_NS);
        }
        if (model2 != null) {
            model3 = model2.union(model);
            this.addLine("Base model has size: " + model3.size());
            this.addLine("Base model includes the XSPAN RDFS ontology ");
            infModel = ModelFactory.createRDFSModel(model3);
        } else {
            this.addLine("Base model has size: " + model.size());
            this.addLine("Base model excludes the XSPAN RDFS ontology, so validation is limited");
            infModel = ModelFactory.createRDFSModel(model);
        }
        this.addLine("Inferred model has size: " + infModel.size());
        object2 = infModel.validate();
        this.addLine("<p><b>Calling Jena RDFS validation</b> - checking datatypes only");
        if (object2.isValid()) {
            this.addLine("RDFS model is valid");
        } else {
            this.addLine("<b>RDFS model is NOT valid</b>");
        }
        object = object2.getReports();
        if (object.hasNext()) {
            this.addLineNoBR("Reports:\n<ul>");
            while (object.hasNext()) {
                this.addLineNoBR("<li>" + object.next());
            }
            this.addLine("</ul>");
        }
        this.addLine("<p><b>Analysis of subClassOf Relationships</b>");
        if (this.checkSubClass(model3, infModel)) {
            this.addLine("No equivalent classes detected in the ontology");
        }
        GenericRuleReasoner genericRuleReasoner = new GenericRuleReasoner(Rule.parseRules("[rule1:(?a http://www.xspan.org/obo.rdfs#part_of ?b) (?b http://www.xspan.org/obo.rdfs#part_of ?c) -> (?a http://www.xspan.org/obo.rdfs#part_of ?c)]"));
        InfModel infModel2 = ModelFactory.createInfModel(genericRuleReasoner, model3);
        this.addLine("<p><b>Analysis of part_of Relationships</b>");
        if (this.checkPart_of(model3, infModel2)) {
            this.addLine("No equivalent parts detected in the ontology");
        }
        this.addLine("<p><b>Analysis of Graph Structure</b>");
        Vector vector = new Vector();
        if (this.checkChildren(new Stack(), new GoRelationship(goOntology.getRootTerm(), new GoRelationshipType(null, null, "")), vector)) {
            this.addLine("No cycles detected in the graph");
        } else {
            this.addLineNoBR("Graph contains a cycle at:\n<ul>");
            for (int i = 0; i < vector.size(); ++i) {
                this.addLineNoBR("<li> " + ((GoRelationship)vector.elementAt(i)).toString() + " " + ((GoRelationship)vector.elementAt(i)).getRelative().getIdPrefix() + ":" + ((GoRelationship)vector.elementAt(i)).getRelative().getId());
            }
            this.addLine("</ul>");
        }
        this.addLine("\n</html>");
        this.showMessage();
    }

    public boolean checkPart_of(Model model, Model model2) {
        Vector vector = new Vector();
        boolean bl = true;
        StmtIterator stmtIterator = model.listStatements(new SimpleSelector(null, ResourceFactory.createProperty("http://www.xspan.org/obo.rdfs#part_of"), (RDFNode)null){

            public boolean selects(Statement statement) {
                RDFNode rDFNode = statement.getObject();
                return rDFNode instanceof Resource;
            }
        });
        block0: while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            Resource resource = statement.getSubject();
            Resource resource2 = (Resource)statement.getObject();
            StmtIterator stmtIterator2 = model2.listStatements(new SimpleSelector(resource2, ResourceFactory.createProperty("http://www.xspan.org/obo.rdfs#part_of"), resource));
            while (stmtIterator2.hasNext()) {
                Statement statement2 = stmtIterator2.nextStatement();
                Resource resource3 = statement2.getSubject();
                Resource resource4 = (Resource)statement2.getObject();
                if (!resource.getLocalName().equals(resource4.getLocalName()) || !resource.getNameSpace().equals(resource4.getNameSpace()) || !resource2.getLocalName().equals(resource3.getLocalName()) || !resource2.getNameSpace().equals(resource3.getNameSpace())) continue;
                this.addLine("Class " + resource.getLocalName().toString() + " is equivalent to class " + resource2.getLocalName().toString() + " [" + resource2.getLocalName().toString() + " may be a sub-part of itself]");
                if (!bl) continue block0;
                bl = false;
                continue block0;
            }
        }
        return bl;
    }

    public boolean checkSubClass(Model model, Model model2) {
        Vector vector = new Vector();
        boolean bl = true;
        StmtIterator stmtIterator = model.listStatements(new SimpleSelector(null, RDFS.subClassOf, (RDFNode)null){

            public boolean selects(Statement statement) {
                RDFNode rDFNode = statement.getObject();
                return rDFNode instanceof Resource;
            }
        });
        block0: while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            Resource resource = statement.getSubject();
            Resource resource2 = (Resource)statement.getObject();
            StmtIterator stmtIterator2 = model2.listStatements(new SimpleSelector(resource2, RDFS.subClassOf, resource));
            while (stmtIterator2.hasNext()) {
                Statement statement2 = stmtIterator2.nextStatement();
                Resource resource3 = statement2.getSubject();
                Resource resource4 = (Resource)statement2.getObject();
                if (!resource.getLocalName().equals(resource4.getLocalName()) || !resource.getNameSpace().equals(resource4.getNameSpace()) || !resource2.getLocalName().equals(resource3.getLocalName()) || !resource2.getNameSpace().equals(resource3.getNameSpace())) continue;
                this.addLine("Class " + resource.getLocalName().toString() + " is equivalent to class " + resource2.getLocalName().toString() + " [" + resource2.getLocalName().toString() + " may be a subclass of itself]");
                if (!bl) continue block0;
                bl = false;
                continue block0;
            }
        }
        return bl;
    }

    protected boolean checkChildren(Stack stack, GoRelationship goRelationship, Vector vector) {
        boolean bl = true;
        if (stack.search(goRelationship) == -1) {
            stack.push(goRelationship);
            for (int i = 0; i < goRelationship.getRelative().getChildren().size(); ++i) {
                if (this.checkChildren(stack, goRelationship.getRelative().getChildren().getRelationship(i), vector)) continue;
                bl = false;
            }
            stack.pop();
        } else {
            bl = false;
            boolean bl2 = true;
            for (int i = 0; i < vector.size(); ++i) {
                if (!((GoRelationship)vector.elementAt(i)).equals(goRelationship)) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                vector.addElement(goRelationship);
            }
        }
        return bl;
    }

    public void showMessage() {
        this.writeFile(this.message);
        new HTMLPanel(this.outputFile, false);
    }

    public void compare(GoOntology goOntology, GoOntology goOntology2) {
        if (goOntology == null || goOntology.getRootTerm() == null || goOntology2 == null || goOntology2.getRootTerm() == null) {
            return;
        }
        if (goOntology.getRootTerm().getChildren().size() == 0 || goOntology2.getRootTerm().getChildren().size() == 0) {
            return;
        }
        Model model = this.createModel(goOntology.getRootTerm());
        Model model2 = this.createModel(goOntology2.getRootTerm());
        this.compareModels(model, model2);
        this.addLine("\n</html>");
        this.showMessage();
    }

    public GoOntology merge(GoOntology goOntology, GoOntology goOntology2) {
        if (goOntology == null || goOntology.getRootTerm() == null || goOntology2 == null || goOntology2.getRootTerm() == null) {
            return null;
        }
        this.makeCommonRoot(goOntology, goOntology2);
        Model model = this.createModel(goOntology.getRootTerm());
        Model model2 = this.createModel(goOntology2.getRootTerm());
        Model model3 = model.union(model2);
        return this.createOntology(model3);
    }

    public GoOntology infer(GoOntology goOntology, String string) {
        if (goOntology == null || goOntology.getRootTerm() == null || string == null || string.equals("")) {
            return null;
        }
        if (goOntology.getRootTerm().getChildren().size() == 0) {
            return null;
        }
        Model model = this.createModel(goOntology.getRootTerm());
        GenericRuleReasoner genericRuleReasoner = new GenericRuleReasoner(Rule.parseRules(string));
        InfModel infModel = ModelFactory.createInfModel(genericRuleReasoner, model);
        return this.createOntology(infModel);
    }

    public void makeCommonRoot(GoOntology goOntology, GoOntology goOntology2) {
        if (goOntology2.getRootTerm().getChildren().size() == 0) {
            goOntology2.setRootTerm(goOntology.getRootTerm());
            return;
        }
        GoTerm goTerm = goOntology.getRootTerm();
        if (goTerm.getChildren().size() > 0) {
            if (goTerm.equals(goOntology2.getRootTerm())) {
                goOntology.setRootTerm(goOntology2.getRootTerm());
                return;
            }
            GoRelationshipType goRelationshipType = ((GoRelationship)goTerm.getChildren().elementAt(0)).getRelationshipType();
            this.addLine("root relationship:" + goRelationshipType.toString());
            GoTerm goTerm2 = (GoTerm)goTerm.clone();
            goOntology.setRootTerm(goTerm2);
            GoTerm goTerm3 = (GoTerm)goTerm.clone();
            GoTerm goTerm4 = goOntology2.getRootTerm();
            goOntology2.setRootTerm(goTerm4);
            goTerm3.addChild(new GoRelationship(goOntology2.getRootTerm(), goRelationshipType));
            goOntology2.getRootTerm().addParent(new GoRelationship(goTerm3, goRelationshipType));
            goOntology2.setRootTerm(goTerm3);
        } else {
            goOntology.setRootTerm(goOntology2.getRootTerm());
        }
    }

    public GoOntology createOntology(Model model) {
        GoOntology goOntology = new GoOntology();
        this.generateRoot(goOntology);
        if (model == null) {
            return null;
        }
        this.addLine("RDF model has size: " + model.size() + "\n");
        this.goTermMap = this.makeGoTerms(model);
        this.completeGoTerms(model, this.goTermMap);
        this.setRootLink(goOntology, this.goTermMap);
        return goOntology;
    }

    private boolean generateRoot(GoOntology goOntology) {
        String string = "root";
        String string2 = "00:00";
        try {
            GoTerm goTerm = new GoTerm(string, string2);
            goTerm.setStatus(GoTerm.AUTOGEN);
            goOntology.setRootTerm(goTerm);
        }
        catch (InvalidParameterException invalidParameterException) {
            this.messages.addMessage(new Message("Error while generating root node: " + invalidParameterException.getMessage(), 2));
            return false;
        }
        return true;
    }

    public HashMap makeGoTerms(Model model) {
        GoTerm goTerm;
        String string;
        String string2;
        Resource resource;
        Statement statement;
        this.goTermMap = new HashMap();
        StmtIterator stmtIterator = model.listStatements(new SimpleSelector(null, RDF.type, (RDFNode)null){

            public boolean selects(Statement statement) {
                RDFNode rDFNode = statement.getObject();
                return rDFNode instanceof Resource;
            }
        });
        while (stmtIterator.hasNext()) {
            statement = stmtIterator.nextStatement();
            resource = statement.getSubject();
            string2 = resource.getLocalName();
            string = resource.getNameSpace();
            Resource resource2 = (Resource)statement.getObject();
            String string3 = resource2.getLocalName();
            String string4 = resource2.getNameSpace();
            try {
                string2 = string2.replace('.', ':');
                goTerm = new GoTerm("", string2);
                goTerm.setNameSpace(string);
                goTerm.setRDFType(string3);
                goTerm.setRDFTypeNameSpace(string4);
                this.goTermMap.put(string2, goTerm);
            }
            catch (InvalidParameterException invalidParameterException) {
                this.messages.addMessage(new Message("Error while generating GoTerms: " + invalidParameterException.getMessage(), 2));
                return null;
            }
        }
        stmtIterator = model.listStatements(new SimpleSelector(null, null, (RDFNode)null){

            public boolean selects(Statement statement) {
                Property property = statement.getPredicate();
                return property.getLocalName().equals(Namespace.NAME);
            }
        });
        while (stmtIterator.hasNext()) {
            statement = stmtIterator.nextStatement();
            resource = statement.getSubject();
            string2 = resource.getLocalName();
            string = resource.getNameSpace();
            if (this.goTermMap.containsKey(string2 = string2.replace('.', ':'))) continue;
            try {
                goTerm = new GoTerm("", string2);
                goTerm.setNameSpace(string);
                goTerm.setStatus(GoTerm.EXTERNAL);
                this.goTermMap.put(string2, goTerm);
            }
            catch (InvalidParameterException invalidParameterException) {
                this.messages.addMessage(new Message("Error while generating GoTerms: " + invalidParameterException.getMessage(), 2));
                return null;
            }
        }
        return this.goTermMap;
    }

    public void completeGoTerms(Model model, HashMap hashMap) {
        long l = model.size();
        long l2 = l / 80L;
        this.iterateOverPropertyOnLiteral(model, this.namespace.NAME_PROP, l2);
        this.iterateOverPropertyOnResource(model, this.namespace.SUBCLASSOF_PROP, l2);
        this.iterateOverPropertyOnResource(model, this.namespace.PART_OF_PROP, l2);
        this.iterateOverPropertyOnResource(model, this.namespace.SUBEVENToF_PROP, l2);
        this.iterateOverPropertyOnResource(model, this.namespace.LINEAGE_PROP, l2);
        this.iterateOverPropertyOnResource(model, this.namespace.IS_REFERENCE_PROP, l2);
        this.iterateOverPropertyOnResource(model, this.namespace.HAS_MAPPING_PROP, l2);
        this.iterateOverPropertyOnLiteral(model, this.namespace.SYNONYM_PROP, l2);
        this.iterateOverPropertyOnLiteral(model, this.namespace.DEFINITION_PROP, l2);
        this.iterateOverPropertyOnLiteral(model, this.namespace.N_ASSOCIATIONS_PROP, l2);
        this.iterateOverPropertyOnLiteral(model, this.namespace.ACCESSION_PROP, l2);
        this.iterateOverPropertyOnLiteral(model, Namespace.CREATOR, l2);
        this.iterateOverPropertyOnLiteral(model, Namespace.DATE, l2);
        this.iterateOverPropertyOnBlank(model, this.namespace.DBXREF_PROP, l2);
    }

    public void iterateOverPropertyOnResource(Model model, Property property, long l) {
        String string = "";
        String string2 = "";
        long l2 = 0L;
        String string3 = property.getLocalName();
        String string4 = Namespace.getGORelation(string3);
        if (string4 == null) {
            return;
        }
        StmtIterator stmtIterator = model.listStatements(new SimpleSelector(null, property, (RDFNode)null));
        while (stmtIterator.hasNext()) {
            Object object;
            GoTerm goTerm;
            GoTerm goTerm2;
            Statement statement = stmtIterator.nextStatement();
            Resource resource = statement.getSubject();
            string = resource.getLocalName();
            string = string.replace('.', ':');
            RDFNode rDFNode = statement.getObject();
            if (!(rDFNode instanceof Resource)) {
                return;
            }
            string2 = ((Resource)rDFNode).getLocalName();
            string2 = string2.replace('.', ':');
            if (!this.goTermMap.containsKey(string)) continue;
            if (this.goTermMap.containsKey(string2)) {
                goTerm2 = (GoTerm)this.goTermMap.get(string);
                goTerm = (GoTerm)this.goTermMap.get(string2);
                object = (GoRelationshipType)this.relationshipTypes.get(string4);
                goTerm.addChild(new GoRelationship(goTerm2, (GoRelationshipType)object));
                goTerm2.addParent(new GoRelationship(goTerm, (GoRelationshipType)object));
                continue;
            }
            try {
                goTerm2 = (GoTerm)this.goTermMap.get(string);
                object = ((Resource)rDFNode).getNameSpace();
                goTerm = new GoTerm("", string2);
                goTerm.setStatus(GoTerm.EXTERNAL);
                goTerm.setNameSpace((String)object);
                this.goTermMap.put(string2, goTerm);
                GoRelationshipType goRelationshipType = (GoRelationshipType)this.relationshipTypes.get(string4);
                goTerm.addChild(new GoRelationship(goTerm2, goRelationshipType));
                goTerm2.addParent(new GoRelationship(goTerm, goRelationshipType));
            }
            catch (InvalidParameterException invalidParameterException) {
                this.messages.addMessage(new Message("Error while generating GoTerms: " + invalidParameterException.getMessage(), 2));
                return;
            }
        }
    }

    public void iterateOverPropertyOnLiteral(Model model, Property property, long l) {
        String string = "";
        String string2 = "";
        long l2 = 0L;
        String string3 = property.getLocalName();
        StmtIterator stmtIterator = model.listStatements(new SimpleSelector(null, property, (RDFNode)null));
        while (stmtIterator.hasNext()) {
            if (l2 == l) {
                l2 = 0L;
                if (this.progressBar != null) {
                    this.progressBar.setValue(this.progressBar.getValue() + 1);
                }
            } else {
                ++l2;
            }
            Statement statement = stmtIterator.nextStatement();
            Resource resource = statement.getSubject();
            string = resource.getLocalName();
            string = string.replace('.', ':');
            RDFNode rDFNode = statement.getObject();
            if (!this.goTermMap.containsKey(string)) continue;
            GoTerm goTerm = (GoTerm)this.goTermMap.get(string);
            if (string3.equals(Namespace.NAME)) {
                goTerm.setName(((Object)rDFNode).toString());
                continue;
            }
            if (string3.equals(Namespace.SYNONYM)) {
                goTerm.addSynonym(((Object)rDFNode).toString());
                continue;
            }
            if (string3.equals(Namespace.DEFINITION)) {
                goTerm.setDefinition(((Object)rDFNode).toString());
                continue;
            }
            if (string3.equals(Namespace.N_ASSOCIATIONS)) {
                goTerm.setN_Associations(((Object)rDFNode).toString());
                continue;
            }
            if (string3.equals(Namespace.ACCESSION)) {
                goTerm.setAccession(((Object)rDFNode).toString());
                continue;
            }
            if (property.equals(Namespace.CREATOR)) {
                goTerm.setCreator(((Object)rDFNode).toString());
                continue;
            }
            if (!property.equals(Namespace.DATE)) continue;
            goTerm.setDate(((Object)rDFNode).toString());
        }
    }

    public void iterateOverPropertyOnBlank(Model model, Property property, long l) {
        String string = "";
        String string2 = "";
        long l2 = 0L;
        String string3 = property.getLocalName();
        StmtIterator stmtIterator = model.listStatements(new SimpleSelector(null, property, (RDFNode)null));
        while (stmtIterator.hasNext()) {
            if (l2 == l) {
                l2 = 0L;
                if (this.progressBar != null) {
                    this.progressBar.setValue(this.progressBar.getValue() + 1);
                }
            } else {
                ++l2;
            }
            Statement statement = stmtIterator.nextStatement();
            Resource resource = statement.getSubject();
            string = resource.getLocalName();
            string = string.replace('.', ':');
            RDFNode rDFNode = statement.getObject();
            if (!this.goTermMap.containsKey(string) || !(rDFNode instanceof Resource)) continue;
            GoTerm goTerm = (GoTerm)this.goTermMap.get(string);
            Resource resource2 = (Resource)rDFNode;
            if (!string3.equals(Namespace.DBXREF)) continue;
            Statement statement2 = resource2.getProperty(this.namespace.DATABASE_SYMBOL_PROP);
            Statement statement3 = resource2.getProperty(this.namespace.REFERENCE_PROP);
            if (statement2 == null || statement3 == null) continue;
            String string4 = ((Object)statement2.getObject()).toString();
            String string5 = ((Object)statement3.getObject()).toString();
            GoDbxref goDbxref = new GoDbxref(string4, string5);
            goTerm.addDbxref(goDbxref);
        }
    }

    public void setRootLink(GoOntology goOntology, HashMap hashMap) {
        GoTerm goTerm = null;
        GoTerm goTerm2 = null;
        int n = 0;
        GoRelationshipType goRelationshipType = (GoRelationshipType)this.relationshipTypes.get("%");
        GoTerm goTerm3 = goOntology.getRootTerm();
        Collection collection = hashMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && n < 2) {
            goTerm = (GoTerm)iterator.next();
            if (goTerm.getStatus() != GoTerm.DEFAULT || goTerm.getParents().size() != 0) continue;
            ++n;
            goTerm2 = goTerm;
        }
        if (n == 0) {
            this.messages.addMessage(new Message("The ontology contains no root term.", 1));
            return;
        }
        if (n == 1) {
            goOntology.setRootTerm(goTerm2);
            this.messages.addMessage(new Message("Setting root: " + goTerm2.toString() + ".", 1));
            System.out.print("setting root: " + goTerm2.toString() + "\n");
        } else {
            if (n > 1) {
                this.messages.addMessage(new Message("The ontology contains multiple root terms - now linked to 'root'.", 1));
            }
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                goTerm = (GoTerm)iterator.next();
                if (goTerm.getStatus() != GoTerm.DEFAULT || n != 0 && goTerm.getParents().size() != 0) continue;
                goTerm.addParent(new GoRelationship(goTerm3, goRelationshipType));
                goTerm3.addChild(new GoRelationship(goTerm, goRelationshipType));
                System.out.print("No parent for: " + goTerm.toString() + "\n");
            }
        }
    }

    public void compareModels(Model model, Model model2) {
        this.addLine("Comparing left and right RDFS models");
        this.addLine("Left model contains " + model.size() + " statements");
        this.addLine("Right model contains " + model2.size() + " statements");
        if (model.containsAny(model2)) {
            this.addLine("RDFS models contain statements in common");
            if (!model.isIsomorphicWith(model2)) {
                Object object;
                Object object2;
                this.addLine("RDFS models are NOT isomorphic");
                Model model3 = model.difference(model2);
                StmtIterator stmtIterator = model3.listStatements(new SimpleSelector(null, null, (RDFNode)null){

                    public boolean selects(Statement statement) {
                        Resource resource = statement.getSubject();
                        return !resource.isAnon();
                    }
                });
                this.addLine("Left RDFS model contains " + model3.size() + " more statements than right model (left minus right)");
                while (stmtIterator.hasNext()) {
                    object2 = stmtIterator.nextStatement();
                    this.printFullSPO((Statement)object2);
                }
                object2 = model2.difference(model);
                StmtIterator stmtIterator2 = object2.listStatements(new SimpleSelector(null, null, (RDFNode)null){

                    public boolean selects(Statement statement) {
                        Resource resource = statement.getSubject();
                        return !resource.isAnon();
                    }
                });
                this.addLine("Right RDFS model contains " + object2.size() + " more statements than left model (right minus left)");
                while (stmtIterator2.hasNext()) {
                    object = stmtIterator2.nextStatement();
                    this.printFullSPO((Statement)object);
                }
                if (model3.size() == 0L && object2.size() > 0L) {
                    this.addLine("Right RDFS model contains the left model");
                }
                if (object2.size() == 0L && model3.size() > 0L) {
                    this.addLine("Left RDFS model contains the right model");
                }
                object = model.intersection(model2);
                StmtIterator stmtIterator3 = object.listStatements(new SimpleSelector(null, null, (RDFNode)null){

                    public boolean selects(Statement statement) {
                        Resource resource = statement.getSubject();
                        return !resource.isAnon();
                    }
                });
                this.addLine("RDFS models intersect in " + object.size() + " statements");
            } else {
                this.addLine("RDFS models are isomorphic");
            }
        } else {
            this.addLine("RDFS models contain NO statements in common");
        }
    }

    public Model createModel(GoTerm goTerm) {
        Model model = ModelFactory.createDefaultModel();
        GoRelationshipVector goRelationshipVector = goTerm.getChildren();
        if (goRelationshipVector.isEmpty()) {
            System.out.println("The ontology " + goTerm.getName() + "with the id " + goTerm.getId() + " contains no go terms.");
            return null;
        }
        int n = 80 / goRelationshipVector.size();
        if (goTerm.getStatus() != GoTerm.AUTOGEN) {
            int n2;
            String string = goTerm.getIdPrefix() + "." + goTerm.getId();
            String string2 = goTerm.getNameSpace() + string;
            Resource resource = model.createResource(string2).addProperty(RDF.type, model.createResource(this.namespace.DEFAULT_NS + goTerm.getRDFType())).addProperty(this.namespace.NAME_PROP, goTerm.getName());
            this.addMoreStatements(model, goTerm, resource);
            GoRelationshipVector goRelationshipVector2 = goTerm.getParents();
            for (n2 = 0; n2 < goRelationshipVector2.size(); ++n2) {
                if (this.danglingParentCheck(model, goRelationshipVector2.getRelationship(n2), resource)) continue;
                return null;
            }
            for (n2 = 0; n2 < goRelationshipVector.size(); ++n2) {
                if (this.progressBar != null) {
                    this.progressBar.setValue(this.progressBar.getValue() + n);
                }
                this.addStatement(model, goRelationshipVector.getRelationship(n2), resource);
            }
        } else {
            for (int i = 0; i < goRelationshipVector.size(); ++i) {
                if (this.progressBar != null) {
                    this.progressBar.setValue(this.progressBar.getValue() + n);
                }
                this.addStatement(model, goRelationshipVector.getRelationship(i));
            }
        }
        return model;
    }

    private boolean addStatement(Model model, GoRelationship goRelationship, Resource resource) {
        if (!this.relationshipTypesForRDFGen.containsKey(goRelationship.getRelationshipType())) {
            return false;
        }
        String string = (String)this.relationshipTypesForRDFGen.get(goRelationship.getRelationshipType());
        Property property = this.namespace.getRDFSProperty(string);
        GoTerm goTerm = goRelationship.getRelative();
        String string2 = goTerm.getIdPrefix() + "." + goTerm.getId();
        String string3 = goTerm.getNameSpace() + string2;
        Resource resource2 = model.createResource(string3);
        resource2.addProperty(property, resource);
        if (model.contains(resource2, RDF.type)) {
            return true;
        }
        if (goTerm.getStatus() != GoTerm.EXTERNAL) {
            resource2.addProperty(RDF.type, model.createResource(this.namespace.DEFAULT_NS + goTerm.getRDFType()));
        }
        this.addMoreStatements(model, goTerm, resource2);
        GoRelationshipVector goRelationshipVector = goRelationship.getRelative().getParents();
        for (int i = 0; i < goRelationshipVector.size(); ++i) {
            if (this.danglingParentCheck(model, goRelationshipVector.getRelationship(i), resource2)) continue;
            return false;
        }
        GoRelationshipVector goRelationshipVector2 = goRelationship.getRelative().getChildren();
        if (goRelationshipVector2.isEmpty()) {
            return true;
        }
        for (int i = 0; i < goRelationshipVector2.size(); ++i) {
            if (this.addStatement(model, goRelationshipVector2.getRelationship(i), resource2)) continue;
            return false;
        }
        return true;
    }

    private boolean addStatement(Model model, GoRelationship goRelationship) {
        GoTerm goTerm = goRelationship.getRelative();
        String string = goTerm.getIdPrefix() + "." + goTerm.getId();
        String string2 = goTerm.getNameSpace() + string;
        Resource resource = model.createResource(string2);
        if (model.contains(resource, RDF.type)) {
            return true;
        }
        resource.addProperty(RDF.type, model.createResource(this.namespace.DEFAULT_NS + goTerm.getRDFType()));
        this.addMoreStatements(model, goTerm, resource);
        GoRelationshipVector goRelationshipVector = goRelationship.getRelative().getParents();
        for (int i = 0; i < goRelationshipVector.size(); ++i) {
            if (this.danglingParentCheck(model, goRelationshipVector.getRelationship(i), resource)) continue;
            return false;
        }
        GoRelationshipVector goRelationshipVector2 = goRelationship.getRelative().getChildren();
        if (goRelationshipVector2.isEmpty()) {
            return true;
        }
        for (int i = 0; i < goRelationshipVector2.size(); ++i) {
            if (this.addStatement(model, goRelationshipVector2.getRelationship(i), resource)) continue;
            return false;
        }
        return true;
    }

    private boolean danglingParentCheck(Model model, GoRelationship goRelationship, Resource resource) {
        GoTerm goTerm = goRelationship.getRelative();
        if (goTerm.getStatus() != GoTerm.EXTERNAL) {
            return true;
        }
        if (!this.relationshipTypesForRDFGen.containsKey(goRelationship.getRelationshipType())) {
            return false;
        }
        String string = (String)this.relationshipTypesForRDFGen.get(goRelationship.getRelationshipType());
        Property property = this.namespace.getRDFSProperty(string);
        String string2 = goTerm.getIdPrefix() + "." + goTerm.getId();
        String string3 = goTerm.getNameSpace() + string2;
        Resource resource2 = model.createResource(string3);
        resource.addProperty(property, resource2);
        return true;
    }

    private void addMoreStatements(Model model, GoTerm goTerm, Resource resource) {
        int n;
        String string = goTerm.getName();
        if (string != "") {
            resource.addProperty(this.namespace.NAME_PROP, string);
        }
        if ((string = goTerm.getN_Associations()) != "") {
            resource.addProperty(this.namespace.N_ASSOCIATIONS_PROP, string);
        }
        if ((string = goTerm.getDefinition()) != "") {
            resource.addProperty(this.namespace.DEFINITION_PROP, string);
        }
        if ((string = goTerm.getAccession()) != "") {
            resource.addProperty(this.namespace.ACCESSION_PROP, string);
        }
        if ((string = goTerm.getCreator()) != "") {
            resource.addProperty(Namespace.CREATOR, string);
        }
        if ((string = goTerm.getDate()) != "") {
            resource.addProperty(Namespace.DATE, string);
        }
        for (n = 0; n < goTerm.getSynonyms().size(); ++n) {
            resource.addProperty(this.namespace.SYNONYM_PROP, goTerm.getSynonyms().getString(n));
        }
        for (n = 0; n < goTerm.getDbxRefs().size(); ++n) {
            String string2 = goTerm.getDbxRefs().getDbxref(n).getDatabaseSymbol();
            String string3 = goTerm.getDbxRefs().getDbxref(n).getDbCrossReference();
            resource.addProperty(this.namespace.DBXREF_PROP, model.createResource().addProperty(this.namespace.DATABASE_SYMBOL_PROP, string2).addProperty(this.namespace.REFERENCE_PROP, string3));
        }
    }

    public void printSPO(Statement statement) {
        Resource resource = statement.getSubject();
        Property property = statement.getPredicate();
        RDFNode rDFNode = statement.getObject();
        this.printSPO(resource, property, rDFNode);
    }

    public void printFullSPO(Statement statement) {
        Resource resource = statement.getSubject();
        Property property = statement.getPredicate();
        RDFNode rDFNode = statement.getObject();
        this.printFullSPO(resource, property, rDFNode);
    }

    public void printSPO(Resource resource, Property property, RDFNode rDFNode) {
        System.out.print(resource.getLocalName());
        System.out.print("\t" + property.getLocalName() + " ");
        if (rDFNode instanceof Resource) {
            System.out.print("\t" + ((Resource)rDFNode).getLocalName());
        } else {
            System.out.print("\t\"" + ((Object)rDFNode).toString() + "\"");
        }
        System.out.print("\n");
    }

    public void printFullSPO(Resource resource, Property property, RDFNode rDFNode) {
        this.addLine("&lt " + ((Object)resource).toString() + " " + property.toString() + " " + ((Object)rDFNode).toString() + " &gt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void writeFile(String string) {
        block11: {
            OutputStreamWriter outputStreamWriter = null;
            File file = new File(System.getProperty("user.dir"), this.outputFile);
            outputStreamWriter = new FileWriter(file);
            int n = string.length();
            outputStreamWriter.write(string, 0, n);
            Object var6_6 = null;
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
                break block11;
            }
            catch (IOException iOException) {}
            break block11;
            {
                catch (IOException iOException) {
                    Object var6_7 = null;
                    try {
                        if (outputStreamWriter != null) {
                            outputStreamWriter.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

