/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.logging;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.xspan.applications.COBrA.COBrA;
import org.xspan.applications.COBrA.logging.LoggerCreator;

public class TaskGenerator {
    public static final int TASK_1 = 1;
    public static final int TASK_2 = 2;
    public static final int TASK_3 = 3;
    protected static int taskNo;
    protected static int subtask;
    protected static int maxTasks;
    protected static boolean started;
    protected static JLabel label;
    protected static JTextArea textArea;
    protected static JButton startButton;
    protected static JButton stopButton;
    protected static COBrA parent;

    public static void startTasks(COBrA cOBrA, int n) {
        taskNo = 1;
        subtask = -1;
        parent = cOBrA;
        maxTasks = n;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 3, 10));
        textArea = new JTextArea(5, 1);
        textArea.setEditable(false);
        textArea.setBackground(Color.LIGHT_GRAY);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setFont(new Font(textArea.getFont().getName(), textArea.getFont().getStyle(), textArea.getFont().getSize() + 3));
        textArea.setText("You are in task modus.\n This is a special modus of the tool.\nSome additional items are displayed, like this wizard.\nYou are asked to complete a number of tasks. All tasks are logged in a specified log file for later revision of the evaluator.\n\nPress \"Start Task\", when you are ready to perform the task.");
        jPanel.add((Component)textArea, "Center");
        label = new JLabel("Tasks");
        label.setFont(new Font(label.getFont().getName(), label.getFont().getStyle(), label.getFont().getSize() + 5));
        label.setBorder(BorderFactory.createEtchedBorder());
        final JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        startButton = new JButton("Start Task");
        startButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (taskNo <= maxTasks) {
                    started = true;
                    startButton.setEnabled(false);
                    stopButton.setEnabled(true);
                    TaskGenerator.nextTask(true);
                } else {
                    started = false;
                    startButton.setEnabled(false);
                    stopButton.setEnabled(false);
                    JOptionPane.showMessageDialog(parent, "All tasks have been completed.", "End of Tasks", 1);
                    parent.getContentPane().remove(jPanel2);
                    parent.getContentPane().doLayout();
                    parent.getContentPane().validate();
                    parent.resetSplitedPane();
                }
            }
        });
        stopButton = new JButton("End Task");
        stopButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                started = false;
                startButton.setEnabled(true);
                stopButton.setEnabled(false);
                TaskGenerator.nextTask(false);
                parent.setMenuAndToolBarEnabled(false);
            }
        });
        stopButton.setEnabled(false);
        jPanel3.add(startButton);
        jPanel3.add(stopButton);
        jPanel.add((Component)jPanel3, "South");
        jPanel2.add((Component)label, "North");
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        parent.getContentPane().add((Component)jPanel2, "East");
        parent.getContentPane().doLayout();
        parent.getContentPane().validate();
    }

    public static boolean isStarted() {
        return started;
    }

    protected static void nextTask(boolean bl) {
        switch (taskNo) {
            case 1: {
                TaskGenerator.startTaskOne(bl);
                break;
            }
            case 2: {
                TaskGenerator.startTaskTwo(bl);
                break;
            }
            case 3: {
                TaskGenerator.startTaskThree(bl);
                break;
            }
            default: {
                return;
            }
        }
    }

    protected static synchronized void startTaskOne(boolean bl) {
        switch (subtask) {
            case -1: {
                if (bl) {
                    label.setText("1st Task: Browsing");
                    textArea.setBackground(Color.DARK_GRAY);
                    textArea.setForeground(Color.LIGHT_GRAY);
                    textArea.setText("You are now ask to complete the first task. This task tests in general the browsing through the ontology.\n\nPress \"Start Task\", when you are ready to perform the task.");
                    stopButton.doClick();
                    break;
                }
                ++subtask;
                break;
            }
            case 0: {
                if (bl) {
                    stopButton.doClick();
                    LoggerCreator.getLogger().info("(1) Start of 1st task. Ontology Browsing");
                    break;
                }
                textArea.setBackground(Color.LIGHT_GRAY);
                textArea.setForeground(Color.BLACK);
                textArea.setText("1.  Open now the 'abstract mouse' ontology from the file'abstract_mouse.go' on the left side of the tool.\n\nPress \"Start Task\", when you are ready to perform the task.");
                ++subtask;
                break;
            }
            case 1: {
                if (bl) {
                    LoggerCreator.getLogger().info("(1.1) Start of 1st task (Browsing), 1st subtask (Open 1st ontology).");
                    parent.setMenuAndToolBarEnabled(true);
                    break;
                }
                LoggerCreator.getLogger().info("(1.1) End of 1st task (Browsing), 1st subtask (Open 1st ontology).");
                textArea.setText("2.  Click through the tree view of the ontology on the left side and find the term 'compact morula' which is a child term of 'mouse'.\n\nPress \"Start Task\", when you are ready to perform the task.");
                ++subtask;
                break;
            }
            case 2: {
                if (bl) {
                    LoggerCreator.getLogger().info("(1.2) Start of 1st task (Browsing), 2nd subtask (Find term in tree view in the ontology).");
                    parent.setMenuAndToolBarEnabled(true);
                    break;
                }
                LoggerCreator.getLogger().info("(1.2) End of 1st task (Browsing), 2nd subtask (Find term in tree view in the ontology).");
                textArea.setText("3.  Use now the search facility at the bottom of the left ontology panel to find the term 'compacted morula' and than use the 'Previous' and'Next' button to click trought the found terms.\n\nPress \"Start Task\", when you are ready to perform the task.");
                ++subtask;
                break;
            }
            case 3: {
                if (bl) {
                    LoggerCreator.getLogger().info("(1.3) Start of 1st task (Browsing), 3rd subtask (Find term with search facility in the ontology).");
                    parent.setMenuAndToolBarEnabled(true);
                    break;
                }
                LoggerCreator.getLogger().info("(1.3) End of 1st task (Browsing), 3rd subtask (Find term with search facility in the ontology).");
                textArea.setText("4.  Open now the 'drosophila' ontology from the filedrosophila.go on the right side of the tool.\n\nPress \"Start Task\", when you are ready to perform the task.");
                ++subtask;
                break;
            }
            case 4: {
                if (bl) {
                    LoggerCreator.getLogger().info("(1.4) Start of 1st task (Browsing), 4th subtask (Open 2nd ontology).");
                    parent.setMenuAndToolBarEnabled(true);
                    break;
                }
                LoggerCreator.getLogger().info("(1.4) End of 1st task (Browsing), 4th subtask (Open 2nd ontology).");
                textArea.setText("5.  Use the different views on the right and left side of the tool to click trough the different ontologies.\n\nPress \"Start Task\", when you are ready to perform the task.");
                ++subtask;
                break;
            }
            case 5: {
                if (bl) {
                    LoggerCreator.getLogger().info("(1.5) Start of 1st task (Browsing), 5th subtask (Click trough variouse views of the ontologies).");
                    parent.setMenuAndToolBarEnabled(true);
                    break;
                }
                LoggerCreator.getLogger().info("(1.5) End of 1st task (Browsing), 5th subtask (Click trough variouse views of the ontologies).");
                LoggerCreator.getLogger().info("(1) End of 1st task. Ontology Browsing");
                subtask = -1;
                ++taskNo;
                startButton.doClick();
                break;
            }
            default: {
                ++taskNo;
                subtask = -1;
            }
        }
    }

    protected static synchronized void startTaskTwo(boolean bl) {
        switch (subtask) {
            case -1: {
                if (bl) {
                    label.setText("2nd Task: Editing");
                    textArea.setBackground(Color.DARK_GRAY);
                    textArea.setForeground(Color.LIGHT_GRAY);
                    textArea.setText("You are now ask to complete the second task. This task tests in general the browsing through the ontology. \n\nPress \"Start Task\", when you are ready to perform the task.");
                    stopButton.doClick();
                    break;
                }
                ++subtask;
                break;
            }
            case 0: {
                if (bl) {
                    stopButton.doClick();
                    LoggerCreator.getLogger().info("(2) Start of 2nd task. Ontology Editing");
                    break;
                }
                textArea.setBackground(Color.LIGHT_GRAY);
                textArea.setForeground(Color.BLACK);
                textArea.setText("1.  You think now that the term 'one-cell stage' in the 'abstract mouse' ontology is also 'part-of' '4-8 cell stage'. Edit this new relationship.\n\nPress \"Start Task\", when you are ready to perform the task.");
                ++subtask;
                break;
            }
            case 1: {
                if (bl) {
                    LoggerCreator.getLogger().info("(2.1) Start of 2nd task (Editing), 1st subtask (Copy and Past term).");
                    parent.setMenuAndToolBarEnabled(true);
                    break;
                }
                LoggerCreator.getLogger().info("(2.1) End of 2nd task (Editing), 1st subtask (Copy and Past term).");
                textArea.setText("2.  You found out that this was a wrong decision. Remove now the link 'one-cell stage' from the parent term '4-8 cell stage'.\n\nPress \"Start Task\", when you are ready to perform the task.");
                ++subtask;
                break;
            }
            case 2: {
                if (bl) {
                    LoggerCreator.getLogger().info("(2.2) Start of 2nd task (Editing), 2nd subtask (Delete term link).");
                    parent.setMenuAndToolBarEnabled(true);
                    break;
                }
                LoggerCreator.getLogger().info("(2.2) End of 2nd task (Editing), 2nd subtask (Delete term link).");
                textArea.setText("3.  You now found out that the term 'embryo' is not longer used in the ontology. Delete the term from the ontology and attatch it's children to the term 'first polar body'.\n\nPress \"Start Task\", when you are ready to perform the task.");
                ++subtask;
                break;
            }
            case 3: {
                if (bl) {
                    LoggerCreator.getLogger().info("(2.3) Start of 2nd task (Editing), 3rd subtask (Delete term).");
                    parent.setMenuAndToolBarEnabled(true);
                    break;
                }
                LoggerCreator.getLogger().info("(2.2) End of 2nd task (Editing), 3rd subtask (Delete term).");
                textArea.setText("4. Add the new term 'third polar body' to the term 'mouse' in the 'abstract mouse' ontology.The new id for the term is 'EMAPA:00035000'.\n\nPress \"Start Task\", when you are ready to perform the task.");
                ++subtask;
                break;
            }
            case 4: {
                if (bl) {
                    LoggerCreator.getLogger().info("(2.4) Start of 2nd task (Editing), 4th subtask (Add new term).");
                    parent.setMenuAndToolBarEnabled(true);
                    break;
                }
                LoggerCreator.getLogger().info("(2.4) End of 2nd task (Editing), 4th subtask (Add new term).");
                LoggerCreator.getLogger().info("(2) End of 2nd task. Ontology Editing");
                subtask = -1;
                ++taskNo;
                startButton.doClick();
                break;
            }
            default: {
                ++taskNo;
                subtask = -1;
            }
        }
    }

    protected static synchronized void startTaskThree(boolean bl) {
        switch (subtask) {
            case -1: {
                if (bl) {
                    label.setText("3rd Task: Annotation");
                    textArea.setBackground(Color.DARK_GRAY);
                    textArea.setForeground(Color.LIGHT_GRAY);
                    textArea.setText("You are now ask to complete third task.This task tests in general the browsing through the ontology.\nPress \"Start Task\", when you are ready to perform the task.");
                    stopButton.doClick();
                    break;
                }
                ++subtask;
                break;
            }
            case 0: {
                if (bl) {
                    stopButton.doClick();
                    LoggerCreator.getLogger().info("(3) Start of 3rd task. Make Annotation");
                    break;
                }
                textArea.setBackground(Color.LIGHT_GRAY);
                textArea.setForeground(Color.BLACK);
                textArea.setText("1.  Open now the 'celegans simple' ontology from the file'celegans_simple.go' on the left side of the tool.\n\nPress \"Start Task\", when you are ready to perform the task.");
                ++subtask;
                break;
            }
            case 1: {
                if (bl) {
                    LoggerCreator.getLogger().info("(3.1) Start of 3rd task (Annotation), 1st subtask (Open ontology).");
                    parent.setMenuAndToolBarEnabled(true);
                    break;
                }
                LoggerCreator.getLogger().info("(3.1) End of 3rd task (Annotation), 1st subtask (Open ontology).");
                textArea.setText("2. Find term 'intestine' with the id 'WBdag:5772' in the 'celegans' ontology.\nPress \"Start Task\", when you are ready to perform the task.");
                ++subtask;
                break;
            }
            case 2: {
                if (bl) {
                    LoggerCreator.getLogger().info("(3.2) Start of 3rd task (Annotation), 2nd subtask (Find 1nd term).");
                    parent.setMenuAndToolBarEnabled(true);
                    break;
                }
                LoggerCreator.getLogger().info("(3.2) End of 3rd task (Annotation), 2nd subtask (Find 1nd term).");
                textArea.setText("3.  Find term 'embryonic fat body' with the id 'FBbt:5710' in the 'drosphilia' ontology.\n\nPress \"Start Task\", when you are ready to perform the task.");
                ++subtask;
                break;
            }
            case 3: {
                if (bl) {
                    LoggerCreator.getLogger().info("(3.3) Start of 3rd task (Annotation), 3rd subtask (Find 2nd term).");
                    parent.setMenuAndToolBarEnabled(true);
                    break;
                }
                LoggerCreator.getLogger().info("(3.3) End of 3rd task (Annotation), 3rd subtask (Find 2nd term).");
                textArea.setText("4.  Create the new Annotation 'Intestine-FatBodyHomology' with the id 'CL:0010006'. It has the cell type 'metabolising_cell' which has the id 'CL:0000181'. The homology type is 'CellFunctionHomology'\n\nPress \"Start Task\", when you are ready to perform the task.");
                ++subtask;
                break;
            }
            case 4: {
                if (bl) {
                    LoggerCreator.getLogger().info("(3.4) Start of 3rd task (Annotation), 4th subtask (Make the annotation).");
                    parent.setMenuAndToolBarEnabled(true);
                    break;
                }
                LoggerCreator.getLogger().info("(3.4) End of 3rd task (Annotation), 4th subtask (Make the annotation).");
                textArea.setText("4. Find the Annotation 'Intestine-FatBodyHomology' in the cell ontology.\n\nPress \"Start Task\", when you are ready to perform the task.");
                ++subtask;
                break;
            }
            case 5: {
                if (bl) {
                    LoggerCreator.getLogger().info("(3.5) Start of 3rd task (Annotation), 5th subtask (Find annotation).");
                    parent.setMenuAndToolBarEnabled(true);
                    break;
                }
                LoggerCreator.getLogger().info("(3.5) End of 3rd task (Annotation), 5th subtask (Find annotation).");
                LoggerCreator.getLogger().info("(3) End of 3rd task. Make Annotation");
                subtask = -1;
                ++taskNo;
                startButton.doClick();
                break;
            }
            default: {
                parent.setMenuAndToolBarEnabled(true);
                ++taskNo;
                subtask = -1;
            }
        }
    }

    static {
        started = false;
    }
}

