/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.logging;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.XMLFormatter;

public class LoggerCreator {
    protected static Logger logger;
    protected static Handler fileHandler;
    protected static Formatter formatter;

    public static void createXMLLogger(String string, Level level) throws IOException {
        LoggerCreator.createLogger(string, level);
        formatter = new XMLFormatter();
        fileHandler.setFormatter(formatter);
        logger.addHandler(fileHandler);
    }

    public static void createTextLogger(String string, Level level) throws IOException {
        LoggerCreator.createLogger(string, level);
        formatter = new SimpleFormatter();
        fileHandler.setFormatter(formatter);
        logger.addHandler(fileHandler);
    }

    public static void createNullLogger() {
        LoggerCreator.createLogger(Level.OFF);
    }

    protected static void createLogger(String string, Level level) throws IOException {
        LoggerCreator.createLogger(level);
        fileHandler = new FileHandler(string);
    }

    protected static void createLogger(Level level) {
        logger = Logger.getLogger("org.xspan.applications.COBrA.Logger");
        logger.setLevel(level);
    }

    public static Logger getLogger() {
        return Logger.getLogger("org.xspan.applications.COBrA.Logger");
    }
}

