/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.io;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import javax.swing.JProgressBar;
import org.xspan.applications.COBrA.datamodels.GoOntology;
import org.xspan.applications.COBrA.io.GoWriter;
import org.xspan.applications.COBrA.messages.MessageVector;
import org.xspan.applications.COBrA.sweb.OWLTools;
import org.xspan.applications.COBrA.sweb.RDFSTools;
import org.xspan.applications.COBrA.sweb.RDFTools;
import org.xspan.applications.COBrA.sweb.SWEBTools;

public class GoXMLWriter
extends GoWriter {
    protected BufferedWriter bufferedWriter;
    protected HashMap relationshipTypes;
    protected SWEBTools swebtool;
    protected Model model;

    public GoXMLWriter(OutputStreamWriter outputStreamWriter, JProgressBar jProgressBar, HashMap hashMap, int n) {
        this.progressBar = jProgressBar;
        this.messages = new MessageVector();
        this.relationshipTypes = new HashMap();
        this.bufferedWriter = new BufferedWriter(outputStreamWriter);
        this.swebtool = n == SWEBTools.XSPAN_RDFS ? new RDFSTools(hashMap) : (n == SWEBTools.XSPAN_OWL ? new OWLTools(hashMap) : new RDFTools(hashMap));
        this.swebtool.setProgressBar(this.progressBar);
    }

    public boolean write(GoOntology goOntology) {
        if (this.progressBar != null) {
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(100);
        }
        Model model = this.swebtool.createModel(goOntology.getRootTerm());
        model.write(this.bufferedWriter);
        if (this.progressBar != null) {
            this.progressBar.setValue(this.progressBar.getMaximum());
        }
        return true;
    }

    public void close() throws IOException {
        this.bufferedWriter.close();
    }
}

