/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.io;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JProgressBar;
import org.xspan.applications.COBrA.datamodels.GoOntology;
import org.xspan.applications.COBrA.io.GoReader;
import org.xspan.applications.COBrA.messages.MessageVector;
import org.xspan.applications.COBrA.sweb.OWLTools;
import org.xspan.applications.COBrA.sweb.RDFSTools;
import org.xspan.applications.COBrA.sweb.RDFTools;
import org.xspan.applications.COBrA.sweb.SWEBTools;

public class GoXMLReader
extends GoReader {
    protected BufferedReader bufferedReader;
    protected HashMap goTermMap;
    protected HashMap relationshipTypes;
    protected String relationshipSymbols;
    protected Model model;
    protected Vector goterms;
    protected SWEBTools swebtool;
    private boolean DEBUG = false;

    public GoXMLReader(File file, JProgressBar jProgressBar, HashMap hashMap, int n) throws FileNotFoundException, IOException {
        this(new FileReader(file), jProgressBar, hashMap, n);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
    }

    public GoXMLReader(URLConnection uRLConnection, JProgressBar jProgressBar, HashMap hashMap, int n) throws IOException {
        this(new InputStreamReader(uRLConnection.getInputStream()), jProgressBar, hashMap, n);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
    }

    public GoXMLReader(URLConnection uRLConnection) throws IOException {
        this.bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        this.progressBar = null;
    }

    private GoXMLReader(InputStreamReader inputStreamReader, JProgressBar jProgressBar, HashMap hashMap, int n) throws IOException {
        this.bufferedReader = new BufferedReader(inputStreamReader);
        this.progressBar = jProgressBar;
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.messages = new MessageVector();
        this.swebtool = n == SWEBTools.XSPAN_RDFS ? new RDFSTools(hashMap) : (n == SWEBTools.XSPAN_OWL ? new OWLTools(hashMap) : new RDFTools(hashMap));
        this.swebtool.setProgressBar(this.progressBar);
    }

    public GoOntology read() {
        if (this.progressBar != null) {
            this.progressBar.setValue(5);
        }
        this.model = this.readRDF();
        if (this.model == null) {
            return null;
        }
        if (this.progressBar != null) {
            this.progressBar.setValue(10);
        }
        GoOntology goOntology = this.swebtool.createOntology(this.model);
        if (this.progressBar != null) {
            this.progressBar.setValue(100);
        }
        if (this.DEBUG) {
            Model model = this.swebtool.createModel(goOntology.getRootTerm());
            this.swebtool.compareModels(this.model, model);
            this.swebtool.showMessage();
        }
        return goOntology;
    }

    public Model readRDF() {
        Model model;
        try {
            model = ModelFactory.createDefaultModel();
            if (this.bufferedReader == null) {
                throw new IllegalArgumentException(" read error");
            }
            RDFReader rDFReader = model.getReader();
            rDFReader.setProperty("error-mode", "lax");
            rDFReader.read(model, this.bufferedReader, "");
        }
        catch (Exception exception) {
            System.out.println("Exception in arp.read(): " + exception);
            return null;
        }
        return model;
    }

    public void close() throws IOException {
        this.bufferedReader.close();
    }
}

