/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.io;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.xspan.applications.COBrA.SwingWorker;
import org.xspan.applications.COBrA.datamodels.GoOntology;
import org.xspan.applications.COBrA.datamodels.GoRelationship;
import org.xspan.applications.COBrA.datamodels.GoRelationshipType;
import org.xspan.applications.COBrA.datamodels.GoRelationshipVector;
import org.xspan.applications.COBrA.datamodels.GoTerm;
import org.xspan.applications.COBrA.io.GoFlatFileReader;
import org.xspan.applications.COBrA.io.GoWriter;
import org.xspan.applications.COBrA.messages.Message;
import org.xspan.applications.COBrA.messages.MessageVector;

public class GoFlatFileWriter
extends GoWriter {
    protected BufferedWriter bufferedWriter;
    protected HashMap relationshipTypes;
    protected Stack relnStack;

    public GoFlatFileWriter(OutputStreamWriter outputStreamWriter, JProgressBar jProgressBar, HashMap hashMap) {
        this.progressBar = jProgressBar;
        this.messages = new MessageVector();
        this.relationshipTypes = new HashMap();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.relationshipTypes.put(hashMap.get(string), string);
        }
        this.bufferedWriter = new BufferedWriter(outputStreamWriter);
    }

    public boolean write(GoOntology goOntology) {
        try {
            if (this.progressBar != null) {
                this.progressBar.setMinimum(0);
                this.progressBar.setMaximum(goOntology.getNumberOfTerms());
            }
            this.writeHeader(goOntology);
            this.writeOntology(goOntology.getRootTerm());
        }
        catch (IOException iOException) {
            this.messages.addMessage(new Message("Error while writing the ontology: " + iOException.getMessage(), 2));
            iOException.printStackTrace();
            return false;
        }
        if (this.progressBar != null) {
            this.progressBar.setValue(this.progressBar.getMaximum());
        }
        return true;
    }

    private boolean writeHeader(GoOntology goOntology) throws IOException {
        String string = "!version:\t$Revision: " + goOntology.getNewGoVersion() + " $";
        Date date = new Date();
        String string2 = "!date:\t" + date.toString();
        this.bufferedWriter.write("!autogenerated-by:\tCOBrA\n");
        this.bufferedWriter.write(string2 + "\n");
        this.bufferedWriter.write(string + "\n");
        for (int i = 0; i < goOntology.getComments().size(); ++i) {
            this.bufferedWriter.write((String)goOntology.getComments().get(i) + "\n");
        }
        return true;
    }

    private boolean writeOntology(GoTerm goTerm) throws IOException {
        String string = "$" + goTerm.getName() + " ; " + goTerm.getIdPrefix() + ":" + goTerm.getId() + "\n";
        this.bufferedWriter.write(string);
        this.relnStack = new Stack();
        this.relnStack.push(new GoRelationship(goTerm, null));
        GoRelationshipVector goRelationshipVector = goTerm.getChildren();
        if (goRelationshipVector.isEmpty()) {
            this.messages.addMessage(new Message("The ontology " + goTerm.getName() + "with the id " + goTerm.getId() + " contains no go terms.", 1));
            return false;
        }
        for (int i = 0; i < goRelationshipVector.size(); ++i) {
            this.writeTerm(goRelationshipVector.getRelationship(i), 1, goTerm);
        }
        return true;
    }

    private boolean writeTerm(GoRelationship goRelationship, int n, GoTerm goTerm) throws IOException {
        if (!this.relationshipTypes.containsKey(goRelationship.getRelationshipType())) {
            this.messages.addMessage(new Message("The term " + goRelationship.getRelative().getName() + "with the id " + goRelationship.getRelative().getId() + " has the unknown relationship" + " type " + goRelationship.getRelationshipType().getRelationshipType(), 2));
            return false;
        }
        if (this.relnStack.search(goRelationship) > 0) {
            this.bufferedWriter.write(this.termToString(goRelationship, n, goTerm) + "\n");
        } else {
            this.relnStack.push(goRelationship);
            this.bufferedWriter.write(this.termToString(goRelationship, n, goTerm) + "\n");
            GoRelationshipVector goRelationshipVector = goRelationship.getRelative().getChildren();
            if (goRelationshipVector.isEmpty()) {
                return true;
            }
            ++n;
            for (int i = 0; i < goRelationshipVector.size(); ++i) {
                if (this.writeTerm(goRelationshipVector.getRelationship(i), n, goRelationship.getRelative())) continue;
                return false;
            }
        }
        if (this.progressBar != null) {
            this.progressBar.setValue(this.progressBar.getValue() + 1);
        }
        return true;
    }

    private String termToString(GoRelationship goRelationship, int n, GoTerm goTerm) {
        int n2;
        GoTerm goTerm2 = goRelationship.getRelative();
        String string = (String)this.relationshipTypes.get(goRelationship.getRelationshipType());
        GoRelationshipVector goRelationshipVector = goTerm2.getParents();
        String string2 = "";
        for (n2 = 0; n2 < n; ++n2) {
            string2 = string2 + " ";
        }
        string2 = string2 + string.trim() + " ";
        string2 = string2 + this.escapeName(goTerm2.getName()) + " ; ";
        string2 = string2 + goTerm2.getIdPrefix() + ":" + goTerm2.getId() + " ";
        for (n2 = 0; n2 < goTerm2.getAdditionalIds().size(); ++n2) {
            string2 = string2 + ", " + goTerm2.getAdditionalIds().getString(n2) + " ";
        }
        for (n2 = 0; n2 < goTerm2.getDbxRefs().size(); ++n2) {
            string2 = string2 + "; " + goTerm2.getDbxRefs().getDbxref(n2).getDbCrossReference() + " ";
        }
        for (n2 = 0; n2 < goTerm2.getSynonyms().size(); ++n2) {
            string2 = string2 + "; synonym:" + goTerm2.getSynonyms().getString(n2) + " ";
        }
        for (n2 = 0; n2 < goRelationshipVector.size(); ++n2) {
            if (goRelationshipVector.getRelationship(n2).getRelative().equals(goTerm)) continue;
            GoTerm goTerm3 = goRelationshipVector.getRelationship(n2).getRelative();
            String string3 = (String)this.relationshipTypes.get(goRelationshipVector.getRelationship(n2).getRelationshipType());
            string2 = string2 + " " + string3 + " " + this.escapeName(goTerm3.getName()) + " ; " + goTerm3.getIdPrefix() + ":" + goTerm3.getId();
        }
        return string2;
    }

    public String escapeName(String string) {
        return string;
    }

    public String escapeName_(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ',' || c == ';' || c == ':') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public void close() throws IOException {
        this.bufferedWriter.close();
    }

    public static void main(String[] stringArray) {
        try {
            HashMap<String, GoRelationshipType> hashMap = new HashMap<String, GoRelationshipType>();
            hashMap.put("%", new GoRelationshipType("is-a"));
            hashMap.put("<", new GoRelationshipType("part-of"));
            hashMap.put("~", new GoRelationshipType("lineage"));
            JFrame jFrame = new JFrame("TestFrame");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            jFrame.setSize(300, 200);
            JProgressBar jProgressBar = new JProgressBar();
            jProgressBar.setStringPainted(true);
            JProgressBar jProgressBar2 = new JProgressBar();
            jProgressBar2.setStringPainted(true);
            final JButton jButton = new JButton("Read");
            final JButton jButton2 = new JButton("Write");
            File file = new File("/home/s0231877/f.go");
            final GoFlatFileReader goFlatFileReader = new GoFlatFileReader(file, jProgressBar, hashMap);
            File file2 = new File("/home/s0231877/test.go");
            final GoFlatFileWriter goFlatFileWriter = new GoFlatFileWriter(new FileWriter(file2), jProgressBar2, hashMap);
            final SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    jButton.setEnabled(false);
                    GoOntology goOntology = goFlatFileReader.read();
                    if (goOntology == null) {
                        System.err.println(goFlatFileReader.getMessages());
                        return null;
                    }
                    return goOntology;
                }

                public void finished() {
                    try {
                        goFlatFileReader.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            };
            final SwingWorker swingWorker2 = new SwingWorker(){

                public Object construct() {
                    GoOntology goOntology = new GoOntology();
                    jButton2.setEnabled(false);
                    boolean bl = goFlatFileWriter.write(goOntology);
                    if (!bl) {
                        System.err.println(goFlatFileReader.getMessages());
                        return null;
                    }
                    return goOntology;
                }

                public void finished() {
                    try {
                        goFlatFileWriter.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            };
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    swingWorker.start();
                }
            };
            ActionListener actionListener2 = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    swingWorker2.start();
                }
            };
            jButton.addActionListener(actionListener);
            jButton2.addActionListener(actionListener2);
            JPanel jPanel = new JPanel(new FlowLayout());
            jPanel.add(jProgressBar);
            jPanel.add(jButton);
            jPanel.add(jProgressBar2);
            jPanel.add(jButton2);
            jFrame.getContentPane().add(jPanel);
            jFrame.setVisible(true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

