/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.io;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.xspan.applications.COBrA.SwingWorker;
import org.xspan.applications.COBrA.datamodels.GoDbxref;
import org.xspan.applications.COBrA.datamodels.GoOntology;
import org.xspan.applications.COBrA.datamodels.GoRelationship;
import org.xspan.applications.COBrA.datamodels.GoRelationshipType;
import org.xspan.applications.COBrA.datamodels.GoTerm;
import org.xspan.applications.COBrA.exceptions.InvalidParameterException;
import org.xspan.applications.COBrA.io.GoReader;
import org.xspan.applications.COBrA.messages.Message;
import org.xspan.applications.COBrA.messages.MessageVector;

public class GoFlatFileReader
extends GoReader {
    public static final String COMMENT = "!";
    public static final String DOMAIN_END = "$";
    protected BufferedReader bufferedReader;
    protected HashMap goTermMap;
    protected long lineCount = 0L;
    protected int actualLeadingSpaces = 0;
    protected Stack goTermStack;
    protected HashMap relationshipTypes;
    protected String relationshipSymbols;
    protected boolean domainNameRead = false;

    public GoFlatFileReader(File file, JProgressBar jProgressBar, HashMap hashMap) throws FileNotFoundException, IOException {
        this(new FileReader(file), jProgressBar, hashMap);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum((int)file.length());
    }

    public GoFlatFileReader(URLConnection uRLConnection, JProgressBar jProgressBar, HashMap hashMap) throws IOException {
        this(new InputStreamReader(uRLConnection.getInputStream()), jProgressBar, hashMap);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(uRLConnection.getContentLength());
    }

    private GoFlatFileReader(InputStreamReader inputStreamReader, JProgressBar jProgressBar, HashMap hashMap) throws IOException {
        this.progressBar = jProgressBar;
        this.messages = new MessageVector();
        this.goTermMap = new HashMap();
        this.goTermStack = new Stack();
        this.relationshipTypes = hashMap == null ? new HashMap() : hashMap;
        this.relationshipSymbols = "";
        Iterator iterator = this.relationshipTypes.keySet().iterator();
        while (iterator.hasNext()) {
            this.relationshipSymbols = this.relationshipSymbols + (String)iterator.next();
        }
        this.bufferedReader = new BufferedReader(inputStreamReader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GoOntology read() {
        GoOntology goOntology = new GoOntology();
        boolean bl = false;
        try {
            String string;
            while ((string = this.bufferedReader.readLine()) != null) {
                ++this.lineCount;
                if (string.startsWith(COMMENT)) {
                    if (this.domainNameRead) {
                        this.messages.addMessage(new Message("Error while reading the ontology: The file seems not to be in go flat file format.", 2));
                        return null;
                    }
                    this.parseComment(goOntology, string);
                } else if (string.startsWith(DOMAIN_END)) {
                    if (!bl) {
                        if (!this.generateRoot(goOntology, string)) {
                            return null;
                        }
                        goOntology.increseNumberOfTerms();
                        this.domainNameRead = true;
                    }
                } else {
                    if (!this.domainNameRead) {
                        this.messages.addMessage(new Message("Error while reading the ontology: The file seems not to be in go flat file format.", 2));
                        return null;
                    }
                    if (!this.parseTermLine(goOntology, string)) {
                        return null;
                    }
                    goOntology.increseNumberOfTerms();
                }
                if (this.progressBar == null) continue;
                this.progressBar.setValue(this.progressBar.getValue() + string.length());
            }
        }
        catch (IOException iOException) {
            this.messages.addMessage(new Message("Error while reading the ontology: " + iOException.getMessage(), 2));
            return null;
        }
        if (this.progressBar != null) {
            this.progressBar.setValue(this.progressBar.getMaximum());
        }
        return goOntology;
    }

    private boolean parseTermLine(GoOntology goOntology, String string) {
        int n = this.countNumberOfLeadingSpaces(string);
        string = string.trim();
        if (n < this.actualLeadingSpaces) {
            int n2 = this.actualLeadingSpaces - n;
            for (int i = 0; i <= n2; ++i) {
                this.goTermStack.pop();
                --this.actualLeadingSpaces;
            }
        } else if (n == this.actualLeadingSpaces) {
            this.goTermStack.pop();
            --this.actualLeadingSpaces;
        }
        return this.createGoTermWithRelations(string);
    }

    private boolean createGoTermWithRelations(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string = string.trim(), this.relationshipSymbols, true);
        if (stringTokenizer.countTokens() < 2) {
            this.messages.addMessage(new Message("The line " + this.lineCount + " seems to be corrupt. There must be at least the relationship symbol and the " + "information of the term.", 2));
            return false;
        }
        String string2 = stringTokenizer.nextToken();
        GoTerm goTerm = this.createGoTerm(stringTokenizer.nextToken());
        if (goTerm == null) {
            return false;
        }
        GoTerm goTerm2 = (GoTerm)this.goTermStack.peek();
        GoRelationshipType goRelationshipType = (GoRelationshipType)this.relationshipTypes.get(string2);
        if (goRelationshipType == null || !(goRelationshipType instanceof GoRelationshipType)) {
            this.messages.addMessage(new Message("The relationship symbol '" + string2 + "'  at line " + this.lineCount + " is not suported.", 2));
            return false;
        }
        goTerm2.addChild(new GoRelationship(goTerm, goRelationshipType));
        goTerm.addParent(new GoRelationship(goTerm2, goRelationshipType));
        this.goTermStack.push(goTerm);
        ++this.actualLeadingSpaces;
        return true;
    }

    private GoTerm createGoTerm(String string) {
        GoTerm goTerm = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string = string.trim(), ";");
        if (stringTokenizer.countTokens() < 2) {
            this.messages.addMessage(new Message("The line " + this.lineCount + " seems to be corrupt. There must be at least a term name and one " + "term id in the line.", 2));
            return null;
        }
        String string2 = stringTokenizer.nextToken().trim();
        string2 = this.unescape(string2);
        StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken().trim(), ",");
        String string3 = stringTokenizer2.nextToken().trim();
        if (this.goTermMap.containsKey(string3)) {
            if (!((GoTerm)this.goTermMap.get(string3)).getName().equals(string2)) {
                this.messages.addMessage(new Message("The term " + string3 + " at line " + this.lineCount + " already exist with the name " + ((GoTerm)this.goTermMap.get(string3)).getName() + ".", 2));
                return null;
            }
            return (GoTerm)this.goTermMap.get(string3);
        }
        try {
            goTerm = new GoTerm(string2, string3);
            while (stringTokenizer2.hasMoreTokens()) {
                goTerm.addAdditionalId(stringTokenizer2.nextToken().trim());
            }
            while (stringTokenizer.hasMoreTokens()) {
                String string4;
                String string5 = stringTokenizer.nextToken().trim();
                if (!string5.startsWith("synonym:")) {
                    stringTokenizer2 = new StringTokenizer(string5, ",");
                    string4 = stringTokenizer2.nextToken().trim();
                    StringTokenizer stringTokenizer3 = new StringTokenizer(string4, ":");
                    if (stringTokenizer3.countTokens() != 2) {
                        this.messages.addMessage(new Message("The term " + string3 + " at line " + this.lineCount + " contains a invalid database cross reference " + string4 + ".", 2));
                    }
                    String string6 = stringTokenizer3.nextToken();
                    GoDbxref goDbxref = new GoDbxref(string6, string4);
                    goTerm.addDbxref(goDbxref);
                    while (stringTokenizer2.hasMoreTokens()) {
                        string4 = stringTokenizer2.nextToken().trim();
                        new GoDbxref(string6, string4);
                        goTerm.addDbxref(goDbxref);
                    }
                    continue;
                }
                stringTokenizer2 = new StringTokenizer(string5, ",");
                string4 = stringTokenizer2.nextToken().trim();
                if (!string4.startsWith("synonym:")) {
                    this.messages.addMessage(new Message("The term " + string3 + " at line " + this.lineCount + " contains a invalid synonym " + string4 + ".", 2));
                    return null;
                }
                goTerm.addSynonym(string4.substring(string4.indexOf(":") + 1).trim());
                while (stringTokenizer2.hasMoreTokens()) {
                    goTerm.addSynonym(stringTokenizer2.nextToken().trim());
                }
            }
        }
        catch (InvalidParameterException invalidParameterException) {
            this.messages.addMessage(new Message("The line " + this.lineCount + " seems to be corrupt. Could not determine the term id.", 2));
            return null;
        }
        this.goTermMap.put(string3, goTerm);
        return goTerm;
    }

    private void parseComment(GoOntology goOntology, String string) {
        String string2;
        if (string.startsWith("!version:") && string.indexOf("$Revision:") != -1) {
            string2 = string.substring(string.lastIndexOf("Revision:") + 10, string.lastIndexOf(DOMAIN_END));
            try {
                goOntology.setGoVersion(Float.parseFloat(string2));
            }
            catch (NumberFormatException numberFormatException) {
                this.messages.addMessage(new Message("Could not determine the version number of the GO Ontology.", 2));
            }
        }
        if (string.startsWith("!date:")) {
            if (string.indexOf("$Date:") != -1) {
                string2 = string.substring(string.lastIndexOf("$Date:") + 6, string.lastIndexOf(DOMAIN_END));
                string2 = string2.trim();
                goOntology.setTimeStamp(string2);
            } else {
                string2 = string.substring(string.lastIndexOf("!date:") + 6);
                string2 = string2.trim();
                goOntology.setTimeStamp(string2);
            }
        } else {
            goOntology.addComment(string);
        }
    }

    private boolean generateRoot(GoOntology goOntology, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (stringTokenizer.countTokens() != 2) {
            this.messages.addMessage(new Message("The line " + this.lineCount + " seems" + " to be corrupt.", 0));
            return false;
        }
        String string2 = stringTokenizer.nextToken().substring(1).trim();
        string2 = this.unescape(string2);
        String string3 = stringTokenizer.nextToken().trim();
        try {
            GoTerm goTerm = new GoTerm(string2, string3);
            this.goTermMap.put(goTerm.getId(), goTerm);
            this.goTermStack.push(goTerm);
            goOntology.setRootTerm(goTerm);
        }
        catch (InvalidParameterException invalidParameterException) {
            this.messages.addMessage(new Message("Error while generating root node: " + invalidParameterException.getMessage(), 2));
            return false;
        }
        return true;
    }

    public String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                c = string.charAt(++i);
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private int countNumberOfLeadingSpaces(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ') continue;
            return i;
        }
        return string.length();
    }

    public void close() throws IOException {
        this.bufferedReader.close();
    }

    public static void main(String[] stringArray) {
        try {
            HashMap<String, GoRelationshipType> hashMap = new HashMap<String, GoRelationshipType>();
            hashMap.put("%", new GoRelationshipType("is-a"));
            hashMap.put("<", new GoRelationshipType("part-of"));
            hashMap.put("~", new GoRelationshipType("lineage"));
            JFrame jFrame = new JFrame("TestFrame");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            jFrame.setSize(300, 200);
            JProgressBar jProgressBar = new JProgressBar();
            jProgressBar.setStringPainted(true);
            final JButton jButton = new JButton("Read");
            URL uRL = new URL("http://www.geneontology.org/ontology/function.ontology");
            final GoFlatFileReader goFlatFileReader = new GoFlatFileReader(uRL.openConnection(), jProgressBar, hashMap);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SwingWorker swingWorker = new SwingWorker(this){
                        private final /* synthetic */ 2 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public Object construct() {
                            2.access$000(this.this$0).setEnabled(false);
                            GoOntology goOntology = 2.access$100(this.this$0).read();
                            if (goOntology == null) {
                                System.err.println(2.access$100(this.this$0).getMessages());
                                return null;
                            }
                            return goOntology;
                        }

                        public void finished() {
                            try {
                                2.access$100(this.this$0).close();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    };
                    swingWorker.start();
                }

                static /* synthetic */ JButton access$000(2 var0) {
                    return var0.jButton;
                }

                static /* synthetic */ GoFlatFileReader access$100(2 var0) {
                    return var0.goFlatFileReader;
                }
            };
            jButton.addActionListener(actionListener);
            JPanel jPanel = new JPanel();
            jPanel.add((Component)jProgressBar, "Center");
            jPanel.add((Component)jButton, "South");
            jFrame.getContentPane().add(jPanel);
            jFrame.setVisible(true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

