/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.gui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;

public class TextIcon
implements Icon {
    protected JLabel tmpLabel;
    private int bound = 2;
    protected Font font;
    protected FontMetrics fontMetrics;
    protected Color foregroundColor;
    protected Color backgroundColor;
    protected int iconWidth;
    protected int iconHeight;
    protected String text;

    public TextIcon(String string) {
        this(string, new Font("Arial", 0, 9));
    }

    public TextIcon(String string, Font font) {
        this(string, font, Color.white, Color.DARK_GRAY);
    }

    public TextIcon(String string, Color color, Color color2) {
        this(string, new Font("Arial", 0, 9), color, color2);
    }

    public TextIcon(String string, Font font, Color color, Color color2) {
        this.text = string;
        this.foregroundColor = color;
        this.backgroundColor = color2;
        this.font = font;
        this.tmpLabel = new JLabel();
        this.fontMetrics = this.tmpLabel.getFontMetrics(this.font);
        this.iconWidth = this.bound + this.fontMetrics.stringWidth(string);
        this.iconHeight = this.bound + this.fontMetrics.getHeight();
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Font font = graphics.getFont();
        graphics.setFont(this.font);
        if (this.backgroundColor != null) {
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(n, n2, this.getIconWidth(), this.getIconHeight());
        }
        graphics.setColor(this.foregroundColor);
        graphics.drawString(this.text, n + 1, n2 + this.iconHeight - 2);
        graphics.setFont(font);
    }

    public String toString() {
        return this.text;
    }
}

