/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.gui.util;

import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class DigitsTextField
extends JTextField {
    public int currentCheckNumber = 0;
    private NumberFormat numberFormatter = NumberFormat.getNumberInstance();

    public DigitsTextField(int n) {
        super(n);
        this.numberFormatter.setParseIntegerOnly(true);
    }

    protected String getValue() {
        int n = 0;
        String string = "";
        try {
            n = this.numberFormatter.parse(this.getText()).intValue();
            if (n == this.currentCheckNumber) {
                n = this.currentCheckNumber++;
            }
            if (n > this.currentCheckNumber) {
                this.currentCheckNumber = n;
            }
            if (n < this.currentCheckNumber) {
                this.currentCheckNumber = n;
            }
        }
        catch (ParseException parseException) {
            n = this.getText().equals(" ") ? -1 : ++this.currentCheckNumber;
        }
        string = new Integer(n).toString();
        if (string.equals("-1")) {
            string = "";
        }
        return string;
    }

    protected Document createDefaultModel() {
        return new CheckNumberDocument();
    }

    protected class CheckNumberDocument
    extends PlainDocument {
        protected CheckNumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            for (int i = 0; i < cArray2.length; ++i) {
                if (!Character.isDigit(cArray[i])) continue;
                cArray2[n2++] = cArray[i];
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }
    }
}

