/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.gui.tree;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.xspan.applications.COBrA.datamodels.GoRelationship;
import org.xspan.applications.COBrA.datamodels.GoRelationshipType;
import org.xspan.applications.COBrA.gui.tree.DragAndDropTree;
import org.xspan.applications.COBrA.gui.tree.GoTermNode;

public class GoTermTreeModel
extends DefaultTreeModel {
    Vector hiddenRelationshipe;
    DragAndDropTree tree;

    public GoTermTreeModel(DragAndDropTree dragAndDropTree, TreeNode treeNode, Vector vector) {
        this(dragAndDropTree, treeNode, vector, true);
    }

    public GoTermTreeModel(DragAndDropTree dragAndDropTree, TreeNode treeNode, Vector vector, boolean bl) {
        super(treeNode, bl);
        this.hiddenRelationshipe = vector == null ? new Vector() : vector;
        this.tree = dragAndDropTree;
    }

    public void addHiddenRelationshipTypes(GoRelationshipType goRelationshipType) {
        if (goRelationshipType != null && !this.hiddenRelationshipe.contains(goRelationshipType)) {
            this.hiddenRelationshipe.add(goRelationshipType);
            this.tree.setSelectionPath(new TreePath(((GoTermNode)this.getRoot()).getPath()));
        }
    }

    public void removeHiddenRelationshipTypes(GoRelationshipType goRelationshipType) {
        if (goRelationshipType != null && this.hiddenRelationshipe.contains(goRelationshipType)) {
            this.hiddenRelationshipe.remove(goRelationshipType);
        }
    }

    public void removeAllHiddenRelationshipTypes() {
        this.hiddenRelationshipe.removeAllElements();
    }

    public Object getChild(Object object, int n) throws ArrayIndexOutOfBoundsException {
        if (this.getChildCount(object) > 0) {
            return ((GoTermNode)object).getChildAt(n, this.hiddenRelationshipe);
        }
        return null;
    }

    public boolean isLeaf(Object object) {
        return this.getChildCount(object) == 0;
    }

    public int getChildCount(Object object) {
        return ((GoTermNode)object).getChildCount(this.hiddenRelationshipe);
    }

    public void reload() {
        this.reload(this.root);
    }

    public void reload(TreeNode treeNode) {
        if (treeNode != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(treeNode), null, null);
        }
    }

    public boolean containsHiddenRelationshipeTypes(GoRelationshipType goRelationshipType) {
        return this.hiddenRelationshipe.contains(goRelationshipType);
    }

    public Vector getHiddenRelationshipTypes() {
        return this.hiddenRelationshipe;
    }

    public TreePath findNodeForGoTerm(GoRelationship goRelationship) {
        Enumeration<TreeNode> enumeration = ((GoTermNode)this.getRoot()).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            GoTermNode goTermNode = (GoTermNode)enumeration.nextElement();
            if (!goTermNode.getNodeObject().getRelative().equals(goRelationship.getRelative())) continue;
            return new TreePath(goTermNode.getPath());
        }
        return null;
    }
}

