/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.gui.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.TreeCellRenderer;
import org.xspan.applications.COBrA.gui.tree.GoTermNode;

public final class GoTermTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private JTree tree;
    private boolean selected;
    private static Color treeBackgroundSelectionColor = Color.blue.darker();
    private static Color treeBackgroundNonSelectionColor = Color.white;
    private static Color treeTextSelectionColor = Color.white;
    private static Color treeTextNonSelectionColor = Color.black;

    public GoTermTreeCellRenderer() {
        this.setHorizontalAlignment(2);
    }

    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    public Font getFont() {
        Font font = super.getFont();
        if (font == null && this.tree != null) {
            font = this.tree.getFont();
        }
        return font;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        GoTermNode goTermNode = (GoTermNode)object;
        this.tree = jTree;
        this.setText(goTermNode.toString());
        this.setForeground(bl ? treeTextSelectionColor : treeTextNonSelectionColor);
        this.setEnabled(true);
        this.setIcon(goTermNode.getIcon());
        this.setComponentOrientation(jTree.getComponentOrientation());
        this.selected = bl;
        return this;
    }

    public void paint(Graphics graphics) {
        int n = -1;
        Icon icon = this.getIcon();
        n = this.getLabelStart();
        graphics.setColor(this.selected ? treeBackgroundSelectionColor : treeBackgroundNonSelectionColor);
        if (this.getComponentOrientation().isLeftToRight()) {
            graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight());
        } else {
            graphics.fillRect(0, 0, this.getWidth() - 1 - n, this.getHeight());
        }
        super.paint(graphics);
    }

    private int getLabelStart() {
        Icon icon = this.getIcon();
        if (icon != null && this.getText() != null) {
            return icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return 0;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            dimension = new Dimension(dimension.width + 3, dimension.height);
        }
        return dimension;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n4, int n5) {
    }

    public void repaint(Rectangle rectangle) {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text") {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, byte by, byte by2) {
    }

    public void firePropertyChange(String string, char c, char c2) {
    }

    public void firePropertyChange(String string, short s, short s2) {
    }

    public void firePropertyChange(String string, int n, int n2) {
    }

    public void firePropertyChange(String string, long l, long l2) {
    }

    public void firePropertyChange(String string, float f, float f2) {
    }

    public void firePropertyChange(String string, double d, double d2) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

