/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.gui.tree;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.xspan.applications.COBrA.datamodels.GoRelationship;
import org.xspan.applications.COBrA.gui.tree.DragAndDropTree;
import org.xspan.applications.COBrA.gui.tree.GoTermNode;
import org.xspan.applications.COBrA.gui.tree.TreeTools;

public class GoTermTreeCellEditor
extends JLabel
implements TreeCellEditor,
ActionListener,
TreeSelectionListener {
    protected DragAndDropTree tree = null;
    protected JTextField editor = null;
    protected GoRelationship item = null;
    protected int lastRow = -1;
    protected Vector listeners = null;
    protected Timer timer;
    protected TreePath lastPath;
    protected int offset;

    public GoTermTreeCellEditor(DragAndDropTree dragAndDropTree) {
        this.tree = dragAndDropTree;
        this.listeners = new Vector();
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        if (object instanceof GoTermNode) {
            GoTermNode goTermNode = (GoTermNode)object;
            this.item = goTermNode.getNodeObject();
            this.setText(goTermNode.toString() + "     ");
            this.setIcon(goTermNode.getIcon());
            this.setFont(jTree.getFont());
            return this;
        }
        return null;
    }

    public Object getCellEditorValue() {
        if (this.item != null && this.editor != null) {
            this.item.getRelative().setName(this.editor.getText());
        }
        return this.item;
    }

    public boolean isCellEditable(EventObject eventObject) {
        boolean bl = false;
        boolean bl2 = false;
        if (eventObject != null && eventObject.getSource() instanceof JTree) {
            this.setTree((DragAndDropTree)eventObject.getSource());
            if (eventObject instanceof MouseEvent) {
                TreePath treePath = this.tree.getPathForLocation(((MouseEvent)eventObject).getX(), ((MouseEvent)eventObject).getY());
                boolean bl3 = bl2 = this.lastPath != null && treePath != null && this.lastPath.equals(treePath);
                if (bl2) {
                    this.item = ((GoTermNode)treePath.getLastPathComponent()).getNodeObject();
                }
            }
        }
        if (this.canEditImmediately(eventObject)) {
            bl = true;
        } else if (bl2 && this.shouldStartEditingTimer(eventObject)) {
            this.startEditingTimer();
        } else if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        if (bl) {
            this.prepareEditor();
        }
        return bl;
    }

    protected boolean canEditImmediately(EventObject eventObject) {
        if (eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)eventObject)) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            return mouseEvent.getClickCount() > 2 && this.inHitRegion(mouseEvent.getX(), mouseEvent.getY());
        }
        return eventObject == null;
    }

    protected boolean inHitRegion(int n, int n2) {
        Rectangle rectangle;
        return this.lastRow == -1 || this.tree == null || (rectangle = this.tree.getRowBounds(this.lastRow)) == null || n > rectangle.x + this.offset || this.offset >= rectangle.width - 5;
    }

    protected boolean shouldStartEditingTimer(EventObject eventObject) {
        if (eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)eventObject)) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            return mouseEvent.getClickCount() == 1 && this.inHitRegion(mouseEvent.getX(), mouseEvent.getY());
        }
        return false;
    }

    protected void setTree(DragAndDropTree dragAndDropTree) {
        if (this.tree != dragAndDropTree) {
            if (this.tree != null) {
                this.tree.removeTreeSelectionListener(this);
            }
            this.tree = dragAndDropTree;
            if (this.tree != null) {
                this.tree.addTreeSelectionListener(this);
            }
            if (this.timer != null) {
                this.timer.stop();
            }
        }
    }

    protected void startEditingTimer() {
        if (this.timer == null) {
            this.timer = new Timer(1200, this);
            this.timer.setRepeats(false);
        }
        this.timer.start();
    }

    protected void prepareEditor() {
        if (this.item == null) {
            return;
        }
        String string = this.item.toString();
        this.editor = new JTextField(string);
        this.editor.addActionListener(this);
        this.editor.selectAll();
        this.editor.setFont(this.tree.getFont());
        this.add(this.editor);
        this.revalidate();
        TreePath treePath = this.tree.getPathForRow(this.lastRow);
        this.tree.startEditingAtPath(treePath);
    }

    protected void removeEditor() {
        if (this.editor != null) {
            this.remove(this.editor);
            this.editor.setVisible(false);
            this.editor = null;
            this.item = null;
        }
    }

    public void doLayout() {
        super.doLayout();
        if (this.editor != null) {
            int n = this.getIconTextGap();
            if (this.getIcon() != null) {
                n += this.getIcon().getIconWidth();
            }
            Dimension dimension = this.getSize();
            this.editor.setBounds(n, 0, dimension.width - n, dimension.height);
        }
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        if (this.item != null) {
            boolean bl = false;
            TreeTools.renameNode(this.tree, this.editor, this.item);
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = 0; i < this.listeners.size(); ++i) {
                CellEditorListener cellEditorListener = (CellEditorListener)this.listeners.elementAt(i);
                cellEditorListener.editingStopped(changeEvent);
            }
            this.removeEditor();
            return bl;
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            CellEditorListener cellEditorListener = (CellEditorListener)this.listeners.elementAt(i);
            cellEditorListener.editingStopped(changeEvent);
        }
        this.removeEditor();
        return true;
    }

    public void cancelCellEditing() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            CellEditorListener cellEditorListener = (CellEditorListener)this.listeners.elementAt(i);
            cellEditorListener.editingCanceled(changeEvent);
        }
        this.removeEditor();
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.addElement(cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.removeElement(cellEditorListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.tree.stopEditing();
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.tree != null) {
            this.lastPath = this.tree.getSelectionCount() == 1 ? this.tree.getSelectionPath() : null;
        }
        if (this.timer != null) {
            this.timer.stop();
        }
    }
}

