/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.gui.tree;

import java.awt.Cursor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;
import org.xspan.applications.COBrA.SwingWorker;
import org.xspan.applications.COBrA.datamodels.GoTerm;
import org.xspan.applications.COBrA.gui.tree.DragAndDropTree;
import org.xspan.applications.COBrA.gui.tree.GoTermNode;
import org.xspan.applications.COBrA.gui.tree.NodeMouseMenu;
import org.xspan.applications.COBrA.gui.tree.TransferableTreeNode;
import org.xspan.applications.COBrA.gui.tree.TreeTools;

public class GoTermNodeMouseMenu
extends NodeMouseMenu {
    DragAndDropTree tree;
    Vector relationshipTypes;
    TreePath path;

    public GoTermNodeMouseMenu(DragAndDropTree dragAndDropTree, Vector vector) {
        this.tree = dragAndDropTree;
        this.relationshipTypes = vector;
    }

    private void createMenu() {
        JMenuItem jMenuItem = new JMenuItem("ID : " + ((GoTermNode)this.path.getLastPathComponent()).getNodeObject().getRelative().getCompleteId());
        jMenuItem.setEnabled(false);
        jMenuItem.setIcon(((GoTermNode)this.path.getLastPathComponent()).getIcon());
        jMenuItem.setDisabledIcon(((GoTermNode)this.path.getLastPathComponent()).getIcon());
        this.add(jMenuItem);
        this.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Create Term");
        jMenuItem2.setToolTipText("Add a new child term to the selected term");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeTools.addNode(GoTermNodeMouseMenu.this.tree, (GoTermNode)GoTermNodeMouseMenu.this.path.getLastPathComponent(), GoTermNodeMouseMenu.this.relationshipTypes);
            }
        });
        this.add(jMenuItem2);
        this.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("Edit Term");
        jMenuItem3.setToolTipText("Edit the attributes of the term");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GoTermNode goTermNode = (GoTermNode)GoTermNodeMouseMenu.this.path.getLastPathComponent();
                TreeTools.editNode(GoTermNodeMouseMenu.this.tree, goTermNode, (GoTermNode)goTermNode.getParent(), GoTermNodeMouseMenu.this.relationshipTypes);
            }
        });
        this.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Rename Term");
        jMenuItem4.setToolTipText("Rename the term");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeTools.renameNode(GoTermNodeMouseMenu.this.tree, GoTermNodeMouseMenu.this.path);
            }
        });
        this.add(jMenuItem4);
        GoTerm goTerm = ((GoTermNode)this.path.getLastPathComponent()).getNodeObject().getRelative();
        JMenuItem jMenuItem5 = new JMenuItem("Delete Term");
        jMenuItem5.setToolTipText("Delete the selected term");
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingWorker swingWorker = new SwingWorker(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Object construct() {
                        ((JFrame)4.access$000(this.this$1).tree.getTopLevelAncestor()).setCursor(Cursor.getPredefinedCursor(3));
                        TreeTools.deleteNode(4.access$000(this.this$1).tree, (GoTermNode)4.access$000(this.this$1).path.getLastPathComponent(), 4.access$000(this.this$1).relationshipTypes, true);
                        return null;
                    }

                    public void finished() {
                        ((JFrame)4.access$000(this.this$1).tree.getTopLevelAncestor()).setCursor(Cursor.getDefaultCursor());
                    }
                };
                swingWorker.start();
            }

            static /* synthetic */ GoTermNodeMouseMenu access$000(4 var0) {
                return var0.GoTermNodeMouseMenu.this;
            }
        });
        this.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem("Delete Sub-Tree");
        jMenuItem6.setToolTipText("Remove the link from this term to its parent, and all dependent terms. Warning: IRREVERSIBLE");
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingWorker swingWorker = new SwingWorker(this){
                    private final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Object construct() {
                        6.access$100(this.this$1).tree.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
                        TreeTools.removeNode(6.access$100(this.this$1).tree, (GoTermNode)6.access$100(this.this$1).path.getLastPathComponent());
                        return null;
                    }

                    public void finished() {
                        6.access$100(this.this$1).tree.getTopLevelAncestor().setCursor(Cursor.getDefaultCursor());
                    }
                };
                swingWorker.start();
            }

            static /* synthetic */ GoTermNodeMouseMenu access$100(6 var0) {
                return var0.GoTermNodeMouseMenu.this;
            }
        });
        this.add(jMenuItem6);
        this.addSeparator();
        JMenuItem jMenuItem7 = new JMenuItem("Copy Term");
        jMenuItem7.setToolTipText("Copy the selected term");
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransferableTreeNode transferableTreeNode = new TransferableTreeNode((GoTermNode)GoTermNodeMouseMenu.this.path.getLastPathComponent());
                transferableTreeNode.setCopied(true);
                GoTermNodeMouseMenu.this.tree.getClipBoard().setContents(transferableTreeNode, GoTermNodeMouseMenu.this.tree);
                GoTerm goTerm = ((GoTermNode)GoTermNodeMouseMenu.this.path.getLastPathComponent()).getNodeObject().getRelative();
                String string = GoTermNodeMouseMenu.this.tree.getModel().getRoot().toString();
            }
        });
        this.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem("Paste Term");
        jMenuItem8.setToolTipText("Paste a copied term to a new parent.");
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Transferable transferable = GoTermNodeMouseMenu.this.tree.getClipBoard().getContents(this);
                if (transferable != null && transferable.isDataFlavorSupported(TransferableTreeNode.NODE_FLAVOR)) {
                    try {
                        GoTermNode goTermNode = (GoTermNode)transferable.getTransferData(TransferableTreeNode.NODE_FLAVOR);
                        GoTermNode goTermNode2 = (GoTermNode)GoTermNodeMouseMenu.this.path.getLastPathComponent();
                        TreeTools.pasteNode(GoTermNodeMouseMenu.this.tree, goTermNode, goTermNode2, ((TransferableTreeNode)transferable).isCopied());
                        GoTerm goTerm = ((GoTermNode)GoTermNodeMouseMenu.this.path.getLastPathComponent()).getNodeObject().getRelative();
                        GoTerm goTerm2 = goTermNode.getNodeObject().getRelative();
                        String string = GoTermNodeMouseMenu.this.tree.getModel().getRoot().toString();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        this.add(jMenuItem8);
    }

    public void setNode(TreePath treePath) {
        this.removeAll();
        this.path = treePath;
        this.tree.setSelectionPath(this.path);
        this.createMenu();
    }
}

