/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.gui.tree;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.xspan.applications.COBrA.gui.ChooseFromTreeDialog;
import org.xspan.applications.COBrA.gui.tree.DefaultTreeTransferHandler;
import org.xspan.applications.COBrA.gui.tree.GoTermNode;
import org.xspan.applications.COBrA.gui.tree.GoTermNodeMouseMenu;
import org.xspan.applications.COBrA.gui.tree.GoTermTreeCellEditor;
import org.xspan.applications.COBrA.gui.tree.GoTermTreeCellRenderer;
import org.xspan.applications.COBrA.gui.tree.GoTermTreeModel;
import org.xspan.applications.COBrA.gui.tree.MappingNodeMouseMenu;
import org.xspan.applications.COBrA.gui.tree.NodeMouseMenu;
import org.xspan.applications.COBrA.util.UserProfile;

public class DragAndDropTree
extends JTree
implements ClipboardOwner {
    Insets autoscrollInsets = new Insets(20, 20, 20, 20);
    protected NodeMouseMenu menu;
    protected Clipboard clipboard;
    protected UserProfile userProfile;
    protected TreePath currentPath = null;
    private MouseMenuHandler mmenuhandler;
    boolean isModified = false;

    public DragAndDropTree(GoTermNode goTermNode, Vector vector, boolean bl) {
        this.setAutoscrolls(true);
        this.setModel(new GoTermTreeModel(this, goTermNode, null));
        this.setCellRenderer(new GoTermTreeCellRenderer());
        this.setCellEditor(new GoTermTreeCellEditor(this));
        this.setRootVisible(true);
        this.setShowsRootHandles(false);
        this.getSelectionModel().setSelectionMode(1);
        if (bl) {
            new DefaultTreeTransferHandler(this, this, 3);
        } else {
            new DefaultTreeTransferHandler(this, this, 0);
        }
        if (bl) {
            this.menu = new GoTermNodeMouseMenu(this, vector);
            this.mmenuhandler = new MouseMenuHandler();
            this.addMouseListener(this.mmenuhandler);
            this.setEditable(true);
        }
        this.setToolTipText("");
        this.clipboard = new Clipboard("TreeClipBoard");
    }

    public void setMenu(ChooseFromTreeDialog chooseFromTreeDialog, ChooseFromTreeDialog chooseFromTreeDialog2, Vector vector, HashMap hashMap) {
        this.removeMouseListener(this.mmenuhandler);
        this.menu = new MappingNodeMouseMenu(this, chooseFromTreeDialog, chooseFromTreeDialog2, vector, hashMap);
        this.mmenuhandler = new MouseMenuHandler();
        this.addMouseListener(this.mmenuhandler);
        this.setEditable(true);
    }

    public void autoscroll(Point point) {
        Insets insets = this.getAutoscrollInsets();
        Rectangle rectangle = this.getVisibleRect();
        Rectangle rectangle2 = new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - (insets.left + insets.right), rectangle.height - (insets.top + insets.bottom));
        if (!rectangle2.contains(point)) {
            Rectangle rectangle3 = new Rectangle(point.x - insets.left, point.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
            this.scrollRectToVisible(rectangle3);
        }
    }

    public Insets getAutoscrollInsets() {
        return this.autoscrollInsets;
    }

    public Clipboard getClipBoard() {
        return this.clipboard;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) == -1) {
            return null;
        }
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        return ((GoTermNode)treePath.getLastPathComponent()).getToolTipText();
    }

    public static GoTermNode makeDeepCopy(GoTermNode goTermNode) {
        GoTermNode goTermNode2 = new GoTermNode(goTermNode.getNodeObject());
        Enumeration<TreeNode> enumeration = goTermNode.children();
        while (enumeration.hasMoreElements()) {
            goTermNode2.add(DragAndDropTree.makeDeepCopy((GoTermNode)enumeration.nextElement()));
        }
        return goTermNode2;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        System.out.println("Lost ownership");
    }

    public void showMenu(Point point) {
        TreePath treePath = this.getPathForLocation((int)point.getX(), (int)point.getY());
        if (treePath == null) {
            return;
        }
        this.menu.setNode(treePath);
        this.menu.show(this, (int)point.getX(), (int)point.getY());
    }

    public TreePath getTreePath() {
        return this.currentPath;
    }

    public boolean getIsModified() {
        return this.isModified;
    }

    public void setIsModified(boolean bl) {
        this.isModified = bl;
    }

    public void setUserProfile(UserProfile userProfile) {
        this.userProfile = userProfile;
    }

    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    final class MouseMenuHandler
    extends MouseAdapter {
        MouseMenuHandler() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            DragAndDropTree.this.currentPath = DragAndDropTree.this.getPathForLocation((int)point.getX(), (int)point.getY());
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                DragAndDropTree.this.showMenu(mouseEvent.getPoint());
            }
        }
    }
}

