/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.gui.tree;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.xspan.applications.COBrA.gui.tree.DragAndDropTree;
import org.xspan.applications.COBrA.gui.tree.GoTermNode;
import org.xspan.applications.COBrA.gui.tree.TransferableTreeNode;
import org.xspan.applications.COBrA.logging.LoggerCreator;
import org.xspan.applications.COBrA.logging.TaskGenerator;

public abstract class AbstractTreeTransferHandler
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    protected DragAndDropTree sourceTree;
    protected DragAndDropTree targetTree;
    protected DragSource dragSource;
    protected DropTarget dropTarget;
    protected static GoTermNode draggedNode;
    protected GoTermNode draggedNodeParent;
    protected static BufferedImage image;
    protected Rectangle rect2D = new Rectangle();
    protected boolean drawImage;

    protected AbstractTreeTransferHandler(DragAndDropTree dragAndDropTree, DragAndDropTree dragAndDropTree2, int n, boolean bl) {
        this.sourceTree = dragAndDropTree;
        this.targetTree = dragAndDropTree2;
        this.drawImage = bl;
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this.sourceTree, n, this);
        this.dropTarget = new DropTarget(this.targetTree, n, this);
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        if (dragSourceDropEvent.getDropSuccess() && dragSourceDropEvent.getDropAction() == 2 && this.draggedNodeParent != null) {
            ((DefaultTreeModel)this.sourceTree.getModel()).nodeStructureChanged(this.draggedNodeParent);
            this.sourceTree.expandPath(new TreePath(draggedNode.getPath()));
        }
    }

    public final void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        int n = dragSourceDragEvent.getDropAction();
        if (n == 1) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (n == 2) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else if (n == 0x40000000) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultLinkDrop);
        } else {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    public final void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        int n = dragSourceDragEvent.getDropAction();
        if (n == 1) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (n == 2) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    public final void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        int n = dragSourceDragEvent.getDropAction();
        if (n == 1) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (n == 2) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else if (n == 0x40000000) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultLinkDrop);
        } else {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    public final void dragExit(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }

    public final void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        TreePath treePath = this.sourceTree.getSelectionPath();
        if (treePath != null) {
            draggedNode = (GoTermNode)treePath.getLastPathComponent();
            this.draggedNodeParent = (GoTermNode)draggedNode.getParent();
            if (TaskGenerator.isStarted()) {
                LoggerCreator.getLogger().info("Dragged node [" + draggedNode.getNodeObject().getRelative().getCompleteId() + "] '" + draggedNode.getNodeObject().getRelative().getName() + "' from the parent node [" + this.draggedNodeParent.getNodeObject().getRelative().getCompleteId() + "] '" + this.draggedNodeParent.getNodeObject().getRelative().getName() + "' in the ontology '" + draggedNode.getRoot().toString() + "'.");
            }
            if (this.drawImage) {
                Rectangle rectangle = this.sourceTree.getPathBounds(treePath);
                JComponent jComponent = (JComponent)this.sourceTree.getCellRenderer().getTreeCellRendererComponent(this.sourceTree, draggedNode, false, this.sourceTree.isExpanded(treePath), ((DefaultTreeModel)this.sourceTree.getModel()).isLeaf(treePath.getLastPathComponent()), 0, false);
                jComponent.setBounds(rectangle);
                image = new BufferedImage(jComponent.getWidth(), jComponent.getHeight(), 3);
                Graphics2D graphics2D = image.createGraphics();
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                jComponent.setOpaque(false);
                jComponent.paint(graphics2D);
                graphics2D.dispose();
            }
            this.dragSource.startDrag(dragGestureEvent, DragSource.DefaultMoveNoDrop, image, new Point(0, 0), new TransferableTreeNode(draggedNode), this);
        }
    }

    public final void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        int n = dropTargetDragEvent.getDropAction();
        if (this.drawImage) {
            this.paintImage(point);
        }
        if (this.canPerformAction(this.targetTree, draggedNode, n, point)) {
            dropTargetDragEvent.acceptDrag(n);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public final void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.drawImage) {
            this.clearImage();
        }
    }

    public final void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        int n = dropTargetDragEvent.getDropAction();
        this.targetTree.autoscroll(point);
        if (this.drawImage) {
            this.paintImage(point);
        }
        if (this.canPerformAction(this.targetTree, draggedNode, n, point)) {
            dropTargetDragEvent.acceptDrag(n);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public final void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        int n = dropTargetDragEvent.getDropAction();
        if (this.drawImage) {
            this.paintImage(point);
        }
        if (this.canPerformAction(this.targetTree, draggedNode, n, point)) {
            dropTargetDragEvent.acceptDrag(n);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public final void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            if (this.drawImage) {
                this.clearImage();
            }
            int n = dropTargetDropEvent.getDropAction();
            Transferable transferable = dropTargetDropEvent.getTransferable();
            Point point = dropTargetDropEvent.getLocation();
            if (transferable.isDataFlavorSupported(TransferableTreeNode.NODE_FLAVOR) && this.canPerformAction(this.targetTree, draggedNode, n, point)) {
                GoTermNode goTermNode;
                TreePath treePath = this.targetTree.getPathForLocation(point.x, point.y);
                GoTermNode goTermNode2 = (GoTermNode)transferable.getTransferData(TransferableTreeNode.NODE_FLAVOR);
                if (this.executeDrop(this.targetTree, goTermNode2, goTermNode = (GoTermNode)treePath.getLastPathComponent(), n)) {
                    dropTargetDropEvent.acceptDrop(n);
                    dropTargetDropEvent.dropComplete(true);
                    return;
                }
            }
            dropTargetDropEvent.rejectDrop();
            dropTargetDropEvent.dropComplete(false);
        }
        catch (Exception exception) {
            System.err.println(exception);
            dropTargetDropEvent.rejectDrop();
            dropTargetDropEvent.dropComplete(false);
        }
    }

    private final void paintImage(Point point) {
        this.sourceTree.paintImmediately(this.rect2D.getBounds());
        this.rect2D.setRect((int)point.getX(), (int)point.getY(), image.getWidth(), image.getHeight());
        this.sourceTree.getGraphics().drawImage(image, (int)point.getX(), (int)point.getY(), this.sourceTree);
    }

    private final void clearImage() {
        this.sourceTree.paintImmediately(this.rect2D.getBounds());
    }

    public abstract boolean canPerformAction(DragAndDropTree var1, GoTermNode var2, int var3, Point var4);

    public abstract boolean executeDrop(DragAndDropTree var1, GoTermNode var2, GoTermNode var3, int var4);

    static {
        image = null;
    }
}

