/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.gui.nodebasedview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.xspan.applications.COBrA.datamodels.GoOntology;
import org.xspan.applications.COBrA.datamodels.GoRelationshipType;
import org.xspan.applications.COBrA.datamodels.GoRelationshipVector;
import org.xspan.applications.COBrA.gui.OntologyNodeBasedPanel;

public class RelativePanel
extends JPanel {
    public static final String PARENTS = "Parents :";
    public static final String CHILDRENS = "Children :";
    protected GoRelationshipVector relatives;
    protected JPanel relativePanel;
    protected OntologyNodeBasedPanel parentPanel;
    protected Vector listener;
    protected String relativeType;
    protected GoOntology ontology;
    protected Vector hiddenRelationshipe;

    public RelativePanel(OntologyNodeBasedPanel ontologyNodeBasedPanel, String string) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.relativeType = string;
        this.relatives = new GoRelationshipVector();
        this.parentPanel = ontologyNodeBasedPanel;
        this.relativePanel = new JPanel();
        this.relativePanel.setLayout(new BoxLayout(this.relativePanel, 1));
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font(jLabel.getFont().getName(), jLabel.getFont().getStyle(), jLabel.getFont().getSize() + 3));
        this.add((Component)jLabel, "North");
        this.add((Component)this.relativePanel, "Center");
        this.listener = new Vector();
        this.hiddenRelationshipe = new Vector();
    }

    public RelativePanel(OntologyNodeBasedPanel ontologyNodeBasedPanel, GoRelationshipVector goRelationshipVector, GoOntology goOntology, String string) {
        this(ontologyNodeBasedPanel, string);
        this.setRelatives(goRelationshipVector, goOntology);
    }

    public void setRelatives(GoRelationshipVector goRelationshipVector, GoOntology goOntology) {
        this.ontology = goOntology;
        this.relatives = goRelationshipVector;
        this.createRelativePanel();
    }

    public void addListener(ActionListener actionListener) {
        this.listener.add(actionListener);
    }

    public void removeListener(ActionListener actionListener) {
        this.listener.remove(actionListener);
    }

    protected void createRelativePanel() {
        this.relativePanel.removeAll();
        for (int i = 0; i < this.relatives.size(); ++i) {
            if (this.hiddenRelationshipe.contains(this.relatives.getRelationship(i).getRelationshipType())) continue;
            JButton jButton = new JButton("[" + this.relatives.getRelationship(i).getRelative().getCompleteId() + "] " + this.relatives.getRelationship(i).getRelative().getName());
            jButton.setIcon(this.relatives.getRelationship(i).getIcon());
            jButton.setAlignmentX(0.0f);
            jButton.setBorder(BorderFactory.createEmptyBorder());
            jButton.setCursor(Cursor.getPredefinedCursor(12));
            jButton.addActionListener(new RelativePressedAction(this.parentPanel, i));
            this.relativePanel.add(jButton);
        }
        this.relativePanel.validate();
    }

    public void addHiddenRelationshipType(GoRelationshipType goRelationshipType) {
        if (!this.hiddenRelationshipe.contains(goRelationshipType)) {
            this.hiddenRelationshipe.add(goRelationshipType);
            if (this.ontology != null) {
                if (this.relativeType.equals(CHILDRENS)) {
                    this.setRelatives(this.ontology.getRootTerm().getChildren(), this.ontology);
                } else if (this.relativeType.equals(PARENTS)) {
                    this.setRelatives(this.ontology.getRootTerm().getParents(), this.ontology);
                }
            }
        }
    }

    public void removeHiddenRelationshipType(GoRelationshipType goRelationshipType) {
        if (this.hiddenRelationshipe.contains(goRelationshipType)) {
            this.hiddenRelationshipe.remove(goRelationshipType);
        }
        this.createRelativePanel();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (int i = 0; i < this.relativePanel.getComponentCount(); ++i) {
            this.relativePanel.getComponent(i).setEnabled(bl);
        }
    }

    class RelativePressedAction
    extends AbstractAction {
        int index;
        OntologyNodeBasedPanel nodeBasedPanel;

        public RelativePressedAction(OntologyNodeBasedPanel ontologyNodeBasedPanel, int n) {
            this.nodeBasedPanel = ontologyNodeBasedPanel;
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Vector<Object> vector = new Vector<Object>(3);
            vector.add(RelativePanel.this.relativeType);
            vector.add(RelativePanel.this.relatives.getRelationship(this.index));
            ActionEvent actionEvent2 = new ActionEvent(vector, 0, "");
            for (int i = 0; i < RelativePanel.this.listener.size(); ++i) {
                ((ActionListener)RelativePanel.this.listener.get(i)).actionPerformed(actionEvent2);
            }
        }
    }
}

