/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.gui.editor;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import org.xspan.applications.COBrA.datamodels.GoRelationship;
import org.xspan.applications.COBrA.datamodels.GoRelationshipType;
import org.xspan.applications.COBrA.datamodels.GoTerm;
import org.xspan.applications.COBrA.gui.editor.PropertyEditorPanel;
import org.xspan.applications.COBrA.gui.tree.DragAndDropTree;
import org.xspan.applications.COBrA.gui.tree.GoTermNode;
import org.xspan.applications.COBrA.gui.tree.TreeTools;
import org.xspan.applications.COBrA.gui.util.IconJComboBoxRenderer;

public class RelativeEditorPanel
extends PropertyEditorPanel {
    Vector relationshipTypes;
    JComboBox relationshipTypeComboBox;
    JTextField termTextField;
    JButton termSelectButton;
    DragAndDropTree tree;
    GoTerm term = null;

    public RelativeEditorPanel(Vector vector, DragAndDropTree dragAndDropTree) {
        super(new GridLayout(2, 1));
        this.tree = dragAndDropTree;
        this.relationshipTypes = vector;
        this.relationshipTypeComboBox = new JComboBox(vector);
        this.relationshipTypeComboBox.setRenderer(new IconJComboBoxRenderer());
        this.termTextField = new JTextField(15);
        this.termTextField.setEditable(false);
        this.termSelectButton = new JButton("Select");
        this.termSelectButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(RelativeEditorPanel.this.termSelectButton)) {
                    int n;
                    GoTermNode goTermNode = TreeTools.selectNode(RelativeEditorPanel.this.tree, (GoTermNode)RelativeEditorPanel.this.tree.getSelectionPath().getLastPathComponent(), "Select resource node", RelativeEditorPanel.this.relationshipTypes, false);
                    if (goTermNode != null && !RelativeEditorPanel.this.currentSelectionIsParent && goTermNode.getNodeObject().equals(RelativeEditorPanel.this.currentSelection)) {
                        JOptionPane.showMessageDialog(null, "A term cannot be it's own parent", "Error", 0);
                        goTermNode = null;
                    }
                    if (goTermNode != null && RelativeEditorPanel.this.isExistingRelative(goTermNode)) {
                        JOptionPane.showMessageDialog(null, "This term is already an immediate parent", "Error", 0);
                        goTermNode = null;
                    }
                    if (goTermNode != null && !RelativeEditorPanel.this.currentSelectionIsParent && !TreeTools.checkParents(RelativeEditorPanel.this.currentSelection, goTermNode.getNodeObject())) {
                        JOptionPane.showMessageDialog(null, "This selection is not permitted as\n it will create a cycle in the ontology", "Error", 0);
                        goTermNode = null;
                    }
                    if (goTermNode != null && !RelativeEditorPanel.this.currentSelectionIsParent && !TreeTools.checkParentsGraph(RelativeEditorPanel.this.currentSelection, goTermNode.getNodeObject()) && (n = JOptionPane.showOptionDialog(null, "This selection will create a cycle in the graph\nContinue ?", "Warning", 0, 3, null, null, null)) != 0) {
                        goTermNode = null;
                    }
                    if (goTermNode == null) {
                        return;
                    }
                    RelativeEditorPanel.this.termTextField.setText(goTermNode.toString());
                    RelativeEditorPanel.this.term = goTermNode.getNodeObject().getRelative();
                }
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 3));
        jPanel.add(new JLabel("Relationship Type : "));
        jPanel.add(new JLabel(""));
        jPanel.add(this.relationshipTypeComboBox);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3));
        jPanel2.add(new JLabel("Select Relative : "));
        jPanel2.add(this.termTextField);
        jPanel2.add(this.termSelectButton);
        this.add(jPanel2);
    }

    public RelativeEditorPanel(Object object, Vector vector, DragAndDropTree dragAndDropTree) {
        this(vector, dragAndDropTree);
        this.setData(object);
    }

    public boolean isExistingRelative(GoTermNode goTermNode) {
        if (this.currentSelectionIsParent && goTermNode.getNodeObject().equals(this.currentSelection)) {
            return true;
        }
        ListModel listModel = this.currentList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            if (!goTermNode.getNodeObject().equals(listModel.getElementAt(i))) continue;
            return true;
        }
        return false;
    }

    public Object getData() {
        if (this.term != null) {
            return new GoRelationship(this.term, (GoRelationshipType)this.relationshipTypeComboBox.getSelectedItem());
        }
        return null;
    }

    public boolean setData(Object object) {
        if (object instanceof GoRelationship) {
            GoRelationship goRelationship = (GoRelationship)object;
            this.relationshipTypeComboBox.setSelectedItem(goRelationship.getRelationshipType());
            this.term = goRelationship.getRelative();
            this.termTextField.setText(this.term.toString());
        }
        return false;
    }

    public String getMessage() {
        if (this.term == null) {
            return "Select a node for the relative.";
        }
        return "";
    }

    public void emptyFields() {
        this.term = null;
        this.termTextField.setText("");
    }
}

