/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.gui.editor;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.DateFormatter;
import org.xspan.applications.COBrA.datamodels.GoHistory;
import org.xspan.applications.COBrA.datamodels.GoTerm;
import org.xspan.applications.COBrA.gui.editor.PropertyEditorPanel;
import org.xspan.applications.COBrA.gui.tree.DragAndDropTree;
import org.xspan.applications.COBrA.gui.tree.GoTermNode;
import org.xspan.applications.COBrA.gui.tree.TreeTools;

public class HistoryPropertyEditorPanel
extends PropertyEditorPanel {
    JTextField personTextField;
    JFormattedTextField dateTextField;
    JTextField rationalTextField;
    JComboBox historyTypeComboBox;
    JComboBox obsoletComboBox;
    JTextField resourceField;
    JButton resourceButton;
    DragAndDropTree tree;
    GoTerm resourceTerm = null;
    Vector relationshipTypes;

    public HistoryPropertyEditorPanel(DragAndDropTree dragAndDropTree, Vector vector) {
        this(new GoHistory(0, new Date(), "", "", false), dragAndDropTree, vector);
    }

    public HistoryPropertyEditorPanel(Object object, DragAndDropTree dragAndDropTree, Vector vector) {
        super(new GridLayout(6, 1));
        this.tree = dragAndDropTree;
        this.relationshipTypes = vector;
        this.personTextField = new JTextField(15);
        this.dateTextField = new JFormattedTextField(new DateFormatter(DateFormat.getDateInstance(0)));
        this.rationalTextField = new JTextField(10);
        Vector<String> vector2 = new Vector<String>();
        vector2.add("OBSOLET");
        vector2.add("NOT OBSOLET");
        this.obsoletComboBox = new JComboBox(vector2);
        this.resourceField = new JTextField(15);
        this.resourceField.setEditable(false);
        this.resourceButton = new JButton("Select");
        this.resourceButton.setEnabled(false);
        this.resourceButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(HistoryPropertyEditorPanel.this.resourceButton)) {
                    GoTermNode goTermNode = TreeTools.selectNode(HistoryPropertyEditorPanel.this.tree, (GoTermNode)HistoryPropertyEditorPanel.this.tree.getSelectionPath().getLastPathComponent(), "Select resource node", HistoryPropertyEditorPanel.this.relationshipTypes, false);
                    if (goTermNode == null) {
                        return;
                    }
                    HistoryPropertyEditorPanel.this.resourceField.setText(goTermNode.toString());
                    HistoryPropertyEditorPanel.this.resourceTerm = goTermNode.getNodeObject().getRelative();
                }
            }
        });
        this.historyTypeComboBox = new JComboBox(GoHistory.getHistoryTypes());
        this.historyTypeComboBox.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(HistoryPropertyEditorPanel.this.historyTypeComboBox)) {
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    if (jComboBox.getSelectedIndex() > 1) {
                        HistoryPropertyEditorPanel.this.resourceButton.setEnabled(true);
                    } else {
                        HistoryPropertyEditorPanel.this.resourceButton.setEnabled(false);
                    }
                }
            }
        });
        this.setData(object);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(new JLabel("History Type : "));
        jPanel.add(this.historyTypeComboBox);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.add(new JLabel("Referee Name : "));
        jPanel2.add(this.personTextField);
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        jPanel3.add(new JLabel("Editing Date : "));
        jPanel3.add(this.dateTextField);
        this.add(jPanel3);
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2));
        jPanel4.add(new JLabel("Rational : "));
        jPanel4.add(this.rationalTextField);
        this.add(jPanel4);
        JPanel jPanel5 = new JPanel(new GridLayout(1, 2));
        jPanel5.add(new JLabel("Obsolet State : "));
        jPanel5.add(this.obsoletComboBox);
        this.add(jPanel5);
        JPanel jPanel6 = new JPanel(new GridLayout(1, 3));
        jPanel6.add(new JLabel("Resource : "));
        jPanel6.add(this.resourceField);
        jPanel6.add(this.resourceButton);
        this.add(jPanel6);
    }

    public Object getData() {
        if (this.personTextField.getText().equals("") || this.rationalTextField.getText().equals("")) {
            return null;
        }
        if ((this.historyTypeComboBox.getSelectedIndex() == 2 || this.historyTypeComboBox.getSelectedIndex() == 3 || this.historyTypeComboBox.getSelectedIndex() == 4) && this.resourceTerm == null) {
            return null;
        }
        boolean bl = this.obsoletComboBox.getSelectedItem().equals("OBSOLET");
        Date date = (Date)this.dateTextField.getValue();
        return new GoHistory(this.historyTypeComboBox.getSelectedIndex(), date, this.personTextField.getText(), this.rationalTextField.getText(), bl, this.resourceTerm);
    }

    public boolean setData(Object object) {
        if (object instanceof GoHistory) {
            GoHistory goHistory = (GoHistory)object;
            this.historyTypeComboBox.setSelectedItem(goHistory.getHistoryTypeString());
            if (goHistory.isObsolet()) {
                this.obsoletComboBox.setSelectedItem("OBSOLET");
            } else {
                this.obsoletComboBox.setSelectedItem("NOT OBSOLET");
            }
            this.personTextField.setText(goHistory.getPerson());
            this.rationalTextField.setText(goHistory.getRationale());
            if (goHistory.getResource() != null) {
                this.resourceField.setText(goHistory.getResource().toString());
            }
            this.dateTextField.setValue(goHistory.getDate());
            return true;
        }
        return false;
    }

    public String getMessage() {
        if (this.personTextField.getText().equals("") || this.rationalTextField.getText().equals("")) {
            return "All fields have to be filled.";
        }
        if ((this.historyTypeComboBox.getSelectedIndex() == 2 || this.historyTypeComboBox.getSelectedIndex() == 3 || this.historyTypeComboBox.getSelectedIndex() == 4) && this.resourceTerm == null) {
            return "For this history type you have\nto choose a Resource.";
        }
        return "";
    }

    public void emptyFields() {
        this.dateTextField.setValue(new Date());
        this.personTextField.setText("");
        this.rationalTextField.setText("");
    }

    public String getName() {
        return "History";
    }
}

