/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.gui.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.DateFormatter;
import org.xspan.applications.COBrA.datamodels.GoAssociation;
import org.xspan.applications.COBrA.datamodels.GoDbxref;
import org.xspan.applications.COBrA.datamodels.GoHistory;
import org.xspan.applications.COBrA.datamodels.GoRelationship;
import org.xspan.applications.COBrA.datamodels.GoRelationshipType;
import org.xspan.applications.COBrA.datamodels.GoTerm;
import org.xspan.applications.COBrA.exceptions.InvalidParameterException;
import org.xspan.applications.COBrA.gui.editor.AssociationPropertyEditorPanel;
import org.xspan.applications.COBrA.gui.editor.DbxrefPropertyEditorPanel;
import org.xspan.applications.COBrA.gui.editor.GoTermPropertyPanel;
import org.xspan.applications.COBrA.gui.editor.HistoryPropertyEditorPanel;
import org.xspan.applications.COBrA.gui.editor.RelativeEditorPanel;
import org.xspan.applications.COBrA.gui.editor.StringPropertyEditorPanel;
import org.xspan.applications.COBrA.gui.editor.event.PropertyEditorAddAction;
import org.xspan.applications.COBrA.gui.editor.event.PropertyEditorEditAction;
import org.xspan.applications.COBrA.gui.editor.event.PropertyEditorRemoveAction;
import org.xspan.applications.COBrA.gui.tree.DragAndDropTree;
import org.xspan.applications.COBrA.gui.tree.GoTermNode;
import org.xspan.applications.COBrA.gui.util.DigitsTextField;
import org.xspan.applications.COBrA.gui.util.IconJComboBoxRenderer;
import org.xspan.applications.COBrA.util.UserProfile;

public class GoTermEditorPanel
extends JPanel {
    static boolean DEBUG = false;
    DragAndDropTree tree;
    Vector relationshipTypes;
    boolean hasParents;
    JTextField termNameText;
    JTextField idPrefixField;
    DigitsTextField idNumberField;
    JTextField namespaceField;
    Vector rdfVec;
    JComboBox rdfType;
    JTextArea definitionText;
    JTextField authorField;
    JFormattedTextField dateField;
    GoTermPropertyPanel additionalIdsPanel;
    GoTermPropertyPanel dbrefsPanel;
    GoTermPropertyPanel synonymPanel;
    GoTermPropertyPanel parentsPanel;
    GoTermPropertyPanel childrenPanel;
    GoTermPropertyPanel associationPanel;
    GoTermPropertyPanel historyPanel;
    JButton okButton = new JButton("OK");
    JButton canelButton = new JButton("Cancel");
    JComboBox relationshipTypeComboBox;
    GoRelationship relationship;
    GoTermNode parent;
    boolean editing;
    boolean canceled = true;

    public GoTermEditorPanel(DragAndDropTree dragAndDropTree, Vector vector, GoTermNode goTermNode) {
        this(null, dragAndDropTree, vector, goTermNode);
    }

    public GoTermEditorPanel(GoRelationship goRelationship, DragAndDropTree dragAndDropTree, Vector vector, GoTermNode goTermNode) {
        super(new FlowLayout());
        this.editing = goRelationship == null;
        this.tree = dragAndDropTree;
        this.relationshipTypes = vector;
        this.relationship = goRelationship;
        if (goRelationship == null && goTermNode != null) {
            this.hasParents = true;
            if (DEBUG) {
                System.out.println("create from parent: " + goTermNode.toString());
            }
        } else if (goRelationship != null && goTermNode == null) {
            if (DEBUG) {
                System.out.println("edit: " + goRelationship.toString());
            }
            this.hasParents = !this.relationship.equals(((GoTermNode)dragAndDropTree.getModel().getRoot()).getNodeObject());
        } else if (DEBUG) {
            System.out.println("some unknown option");
        }
        this.termNameText = new JTextField(40);
        this.idPrefixField = new JTextField(4);
        this.namespaceField = new JTextField(30);
        this.rdfVec = new Vector();
        this.rdfVec.add("ObjectClass");
        this.rdfVec.add("EventClass");
        this.rdfVec.add("term");
        this.rdfVec.add("Class");
        this.rdfType = new JComboBox(this.rdfVec);
        this.idNumberField = new DigitsTextField(8);
        this.definitionText = new JTextArea(5, 50);
        this.authorField = new JTextField(40);
        this.dateField = new JFormattedTextField(new DateFormatter(DateFormat.getDateInstance(3, Locale.UK)));
        this.relationshipTypeComboBox = new JComboBox(vector);
        this.relationshipTypeComboBox.setRenderer(new IconJComboBoxRenderer());
        this.parent = goTermNode;
        this.okButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!GoTermEditorPanel.this.getMessage().equals("")) {
                    GoTermEditorPanel.this.canceled = true;
                    JOptionPane.showMessageDialog(GoTermEditorPanel.this, GoTermEditorPanel.this.getMessage(), "Editing", 2);
                    return;
                }
                GoTermEditorPanel.this.canceled = false;
                GoTermEditorPanel.this.getTopLevelAncestor().setVisible(false);
            }
        });
        this.canelButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                GoTermEditorPanel.this.canceled = true;
                GoTermEditorPanel.this.getTopLevelAncestor().setVisible(false);
            }
        });
        this.createPanel();
        if (this.relationship != null) {
            this.setValues();
        } else {
            this.setProfileValues();
        }
        this.idPrefixField.setEditable(false);
        this.idNumberField.setEditable(false);
    }

    protected void setProfileValues() {
        UserProfile userProfile = this.tree.getUserProfile();
        this.idPrefixField.setText(userProfile.getIDPrefix());
        this.namespaceField.setText(userProfile.getNamespace());
        this.authorField.setText(userProfile.getName());
        this.dateField.setValue(new Date());
        this.rdfType.setSelectedItem("term");
        FindNextIDThread findNextIDThread = new FindNextIDThread(this.parent.getNodeObject().getRelative(), this.idNumberField, userProfile.getIDPrefix(), userProfile.getPadding());
        findNextIDThread.run();
    }

    protected void setValues() {
        int n;
        this.termNameText.setText(this.relationship.getRelative().getName());
        this.idPrefixField.setText(this.relationship.getRelative().getIdPrefix());
        this.idNumberField.setText(this.relationship.getRelative().getId());
        this.namespaceField.setText(this.relationship.getRelative().getNameSpace());
        this.definitionText.setText(this.relationship.getRelative().getDefinition());
        this.authorField.setText(this.relationship.getRelative().getCreator());
        if (!this.relationship.getRelative().getDate().equals("")) {
            this.dateField.setText(this.relationship.getRelative().getDate());
        } else {
            this.dateField.setValue(new Date());
        }
        String string = this.relationship.getRelative().getRDFType();
        if (!this.rdfVec.contains(string)) {
            this.rdfVec.add(string);
            this.rdfType = new JComboBox(this.rdfVec);
            this.rdfType.setSelectedItem(string);
        } else {
            this.rdfType.setSelectedItem(string);
        }
        for (n = 0; n < this.relationship.getRelative().getParents().size(); ++n) {
            this.parentsPanel.getData().addElement(this.relationship.getRelative().getParents().getRelationship(n));
            this.parentsPanel.removeButton.setEnabled(true);
        }
        for (n = 0; n < this.relationship.getRelative().getSynonyms().size(); ++n) {
            this.synonymPanel.getData().addElement(this.relationship.getRelative().getSynonyms().get(n));
        }
        for (n = 0; n < this.relationship.getRelative().getAdditionalIds().size(); ++n) {
            this.additionalIdsPanel.getData().addElement(this.relationship.getRelative().getAdditionalIds().get(n));
        }
        for (n = 0; n < this.relationship.getRelative().getAssociations().size(); ++n) {
            this.associationPanel.getData().addElement(this.relationship.getRelative().getAssociations().getAssociation(n));
        }
        for (n = 0; n < this.relationship.getRelative().getDbxRefs().size(); ++n) {
            this.dbrefsPanel.getData().addElement(this.relationship.getRelative().getDbxRefs().getDbxref(n));
        }
        for (n = 0; n < this.relationship.getRelative().getHistories().size(); ++n) {
            this.historyPanel.getData().addElement(this.relationship.getRelative().getHistories().getHistory(n));
        }
    }

    public void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void createPanel() {
        JPanel jPanel;
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Term Name: ");
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel3.add(this.termNameText);
        jPanel3.add(new JLabel("ID: "));
        jPanel3.add(this.idPrefixField);
        jPanel3.add(new JLabel(":"));
        jPanel3.add(this.idNumberField);
        JLabel jLabel2 = new JLabel("Namespace: ");
        JPanel jPanel4 = new JPanel(new FlowLayout());
        jPanel4.add(this.namespaceField);
        jPanel4.add(new JLabel("RDF type"));
        jPanel4.add(this.rdfType);
        JLabel jLabel3 = new JLabel("Definition: ");
        JScrollPane jScrollPane = new JScrollPane(this.definitionText);
        JLabel jLabel4 = new JLabel("Author:");
        JPanel jPanel5 = new JPanel(new FlowLayout());
        jPanel5.add(this.authorField);
        jPanel5.add(new JLabel("Date: "));
        jPanel5.add(this.dateField);
        this.constrain(jPanel2, jLabel, 0, 0, 1, 1, 1, 18, 0.0, 0.0, 1, 1, 1, 1);
        this.constrain(jPanel2, jPanel3, 1, 0, 1, 1, 1, 18, 0.0, 0.0, 1, 1, 1, 1);
        this.constrain(jPanel2, jLabel2, 0, 1, 1, 1, 1, 18, 0.0, 0.0, 1, 1, 1, 1);
        this.constrain(jPanel2, jPanel4, 1, 1, 1, 1, 1, 18, 0.0, 0.0, 1, 1, 1, 1);
        this.constrain(jPanel2, jLabel3, 0, 2, 1, 1, 1, 18, 0.0, 0.0, 1, 1, 1, 1);
        this.constrain(jPanel2, jScrollPane, 1, 2, 1, 1, 1, 18, 0.0, 0.0, 1, 1, 1, 1);
        this.constrain(jPanel2, jLabel4, 0, 3, 1, 1, 1, 18, 0.0, 0.0, 1, 1, 1, 1);
        this.constrain(jPanel2, jPanel5, 1, 3, 1, 1, 1, 18, 0.0, 0.0, 1, 1, 1, 1);
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.dbrefsPanel = new GoTermPropertyPanel("DB Cross Reference: ", new PropertyEditorAddAction(new DbxrefPropertyEditorPanel()), new PropertyEditorRemoveAction(), new PropertyEditorEditAction(new DbxrefPropertyEditorPanel()));
        this.additionalIdsPanel = new GoTermPropertyPanel("Additional IDs: ", new PropertyEditorAddAction(new StringPropertyEditorPanel("Additional IDs: ")), new PropertyEditorRemoveAction(), new PropertyEditorEditAction(new StringPropertyEditorPanel("Additional IDs: ")));
        this.synonymPanel = new GoTermPropertyPanel("Synonyms: ", new PropertyEditorAddAction(new StringPropertyEditorPanel("Synonyms: ")), new PropertyEditorRemoveAction(), new PropertyEditorEditAction(new StringPropertyEditorPanel("Synonyms: ")));
        this.associationPanel = new GoTermPropertyPanel("Associations: ", new PropertyEditorAddAction(new AssociationPropertyEditorPanel()), new PropertyEditorRemoveAction(), new PropertyEditorEditAction(new AssociationPropertyEditorPanel()));
        this.historyPanel = new GoTermPropertyPanel("History: ", new PropertyEditorAddAction(new HistoryPropertyEditorPanel(this.tree, this.relationshipTypes)), new PropertyEditorRemoveAction(), new PropertyEditorEditAction(new HistoryPropertyEditorPanel(this.tree, this.relationshipTypes)));
        if (this.parent != null) {
            this.parentsPanel = new GoTermPropertyPanel("Additional Parents: ", new PropertyEditorAddAction(new RelativeEditorPanel(this.relationshipTypes, this.tree)), new PropertyEditorRemoveAction(), null);
            if (this.relationship != null) {
                this.parentsPanel.setCurrentSelection(this.relationship, false);
            } else {
                this.parentsPanel.setCurrentSelection(this.parent.getNodeObject(), true);
            }
        } else {
            this.parentsPanel = new GoTermPropertyPanel("Parents: ", new PropertyEditorAddAction(new RelativeEditorPanel(this.relationshipTypes, this.tree)), new PropertyEditorRemoveAction(), null);
            if (this.relationship != null) {
                this.parentsPanel.setCurrentSelection(this.relationship, false);
            } else {
                this.parentsPanel.setCurrentSelection(this.parent.getNodeObject(), true);
            }
        }
        JPanel jPanel6 = new JPanel(new GridLayout(1, 3));
        if (this.parent != null) {
            jPanel6.add(new JLabel("Parent: "));
            jPanel6.add(this.relationshipTypeComboBox);
            jPanel6.add(new JLabel("  " + this.parent.toString()));
            jPanel6.setBorder(BorderFactory.createEtchedBorder());
        }
        this.add((Component)jPanel2, "North");
        if (this.parent != null) {
            jPanel = new JPanel(new GridLayout(7, 1));
            jPanel.add(jPanel6);
        } else {
            jPanel = new JPanel(new GridLayout(6, 1));
        }
        jPanel.add(this.parentsPanel);
        jPanel.add(this.additionalIdsPanel);
        jPanel.add(this.synonymPanel);
        jPanel.add(this.dbrefsPanel);
        jPanel.add(this.associationPanel);
        jPanel.add(this.historyPanel);
        jPanel.setPreferredSize(new Dimension(this.additionalIdsPanel.getPreferredSize().width + 5, 500));
        jPanel.setSize(jPanel.getPreferredSize());
        this.add((Component)jPanel, "Center");
        JPanel jPanel7 = new JPanel(new FlowLayout());
        jPanel7.add(this.okButton);
        jPanel7.add(this.canelButton);
        this.add(jPanel7);
        this.setPreferredSize(new Dimension(jPanel.getPreferredSize().width + 10, jPanel2.getHeight() + jPanel.getHeight() + jPanel7.getHeight() + 20));
        this.setSize(jPanel.getPreferredSize().width + 10, 790);
    }

    public void constrain(Container container, Component component, int n, int n2, int n4, int n5, int n6, int n7, double d, double d2, int n8, int n9, int n10, int n11) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n4;
        gridBagConstraints.gridheight = n5;
        gridBagConstraints.fill = n6;
        gridBagConstraints.anchor = n7;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        if (n8 + n10 + n9 + n11 > 0) {
            gridBagConstraints.insets = new Insets(n8, n9, n10, n11);
        }
        ((GridBagLayout)container.getLayout()).setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    protected boolean createTerm() {
        GoRelationship goRelationship;
        int n;
        Object object;
        GoTerm goTerm;
        if (this.termNameText.getText().equals("")) {
            return false;
        }
        if (this.idNumberField.getText().equals("")) {
            return false;
        }
        if (this.idPrefixField.getText().equals("")) {
            return false;
        }
        if (this.namespaceField.getText().equals("")) {
            return false;
        }
        try {
            goTerm = new GoTerm("", "0:0");
        }
        catch (InvalidParameterException invalidParameterException) {
            return false;
        }
        if (this.relationship != null) {
            goTerm.setCreator(this.relationship.getRelative().getCreator());
            goTerm.setDate(this.relationship.getRelative().getDate());
            goTerm.setDefinition(this.relationship.getRelative().getDefinition());
            goTerm.setRDFTypeNameSpace(this.relationship.getRelative().getRDFTypeNameSpace());
            goTerm.setN_Associations(this.relationship.getRelative().getN_Associations());
            goTerm.setAccession(this.relationship.getRelative().getAccession());
            goTerm.setStatus(this.relationship.getRelative().getStatus());
            for (int i = 0; i < this.relationship.getRelative().getChildren().size(); ++i) {
                object = this.relationship.getRelative().getChildren().getRelationship(i);
                ((GoRelationship)object).getRelative().getParents().removeRelationship(this.relationship);
                goTerm.addChild((GoRelationship)object);
                ((GoRelationship)object).getRelative().addParent(new GoRelationship(goTerm, ((GoRelationship)object).getRelationshipType()));
            }
        }
        this.relationship = new GoRelationship(goTerm, null);
        String string = this.definitionText.getText();
        if (string != null && !string.equals("")) {
            this.relationship.getRelative().setDefinition(new String(string));
        }
        string = this.authorField.getText();
        object = this.dateField.getText();
        if (string != null && !string.equals("") && object != null && !((String)object).equals("")) {
            this.relationship.getRelative().setCreator(new String(string));
            this.relationship.getRelative().setDate(new String((String)object));
        }
        this.relationship.getRelative().setName(this.termNameText.getText());
        this.relationship.getRelative().setId(this.idNumberField.getText());
        this.relationship.getRelative().setIdPrefix(this.idPrefixField.getText());
        this.relationship.getRelative().setNameSpace(this.namespaceField.getText());
        this.relationship.getRelative().setRDFType((String)this.rdfType.getSelectedItem());
        this.relationship.getRelative().getDbxRefs().removeAllElements();
        for (n = 0; n < this.dbrefsPanel.getData().size(); ++n) {
            this.relationship.getRelative().addDbxref((GoDbxref)this.dbrefsPanel.getData().getElementAt(n));
        }
        this.relationship.getRelative().getAdditionalIds().removeAllElements();
        for (n = 0; n < this.additionalIdsPanel.getData().size(); ++n) {
            this.relationship.getRelative().addAdditionalId((String)this.additionalIdsPanel.getData().getElementAt(n));
        }
        this.relationship.getRelative().getSynonyms().removeAllElements();
        for (n = 0; n < this.synonymPanel.getData().size(); ++n) {
            this.relationship.getRelative().addSynonym((String)this.synonymPanel.getData().getElementAt(n));
        }
        this.relationship.getRelative().getAssociations().removeAllElements();
        for (n = 0; n < this.associationPanel.getData().size(); ++n) {
            this.relationship.getRelative().addAssociation((GoAssociation)this.associationPanel.getData().getElementAt(n));
        }
        this.relationship.getRelative().getHistories().removeAllElements();
        for (n = 0; n < this.historyPanel.getData().size(); ++n) {
            this.relationship.getRelative().addHistory((GoHistory)this.historyPanel.getData().getElementAt(n));
        }
        if (this.parent != null) {
            GoRelationshipType goRelationshipType = (GoRelationshipType)this.relationshipTypeComboBox.getSelectedItem();
            goRelationship = new GoRelationship(this.parent.getNodeObject().getRelative(), goRelationshipType);
            this.relationship.getRelative().addParent(goRelationship);
            goRelationship.getRelative().addChild(new GoRelationship(this.relationship.getRelative(), goRelationshipType));
            this.relationship.setRelationshipType(goRelationshipType);
        }
        for (int i = 0; i < this.parentsPanel.getData().size(); ++i) {
            goRelationship = (GoRelationship)this.parentsPanel.getData().getElementAt(i);
            boolean bl = true;
            this.relationship.getRelative().addParent(goRelationship);
            goRelationship.getRelative().addChild(new GoRelationship(this.relationship.getRelative(), goRelationship.getRelationshipType()));
            if (!DEBUG) continue;
            System.out.print("+" + goRelationship.toString());
        }
        return true;
    }

    public String getMessage() {
        if (this.termNameText.getText().equals("")) {
            return "The GO term name field needs to contain a value.";
        }
        if (this.idNumberField.getText().equals("")) {
            return "The GO term id field needs to contain a value.";
        }
        if (this.idPrefixField.getText().equals("")) {
            return "The GO term id field needs to contain a value.";
        }
        if (this.hasParents && this.parent == null && this.parentsPanel.getData().size() == 0) {
            return "The GO term has no parents.";
        }
        if (!this.hasParents && this.parentsPanel.getData().size() > 0) {
            return "The GO term is no longer the root element.";
        }
        return "";
    }

    public GoRelationship getRelationship() {
        if (this.canceled) {
            return null;
        }
        if (!this.createTerm()) {
            return null;
        }
        return this.relationship;
    }

    class FindNextIDThread
    extends Thread {
        GoTerm startTerm;
        JTextField target;
        String idPrefix;
        int padding;

        public FindNextIDThread(GoTerm goTerm, JTextField jTextField, String string, int n) {
            this.startTerm = goTerm;
            this.target = jTextField;
            this.idPrefix = string;
            this.padding = n;
        }

        public void run() {
            String string = "";
            int n = this.findLastId(this.findRoot(this.startTerm), this.idPrefix) + 1;
            String string2 = new String("" + n);
            while (this.padding - string2.length() - string.length() > 0) {
                string = string.concat("0");
            }
            this.target.setText(string + string2);
        }

        protected GoTerm findRoot(GoTerm goTerm) {
            if (goTerm.getParents().size() == 0) {
                if (goTerm.getStatus() != GoTerm.EXTERNAL) {
                    return goTerm;
                }
                return null;
            }
            for (int i = 0; i < goTerm.getParents().size(); ++i) {
                GoTerm goTerm2 = this.findRoot(goTerm.getParents().getRelationship(i).getRelative());
                if (goTerm2 == null) continue;
                return goTerm2;
            }
            return null;
        }

        protected int findLastId(GoTerm goTerm, String string) {
            int n = goTerm.getIdPrefix().equals(string) ? goTerm.getIdAsInt() : 0;
            int n2 = n;
            for (int i = 0; i < goTerm.getChildren().size(); ++i) {
                n2 = this.findLastId(goTerm.getChildren().getRelationship(i).getRelative(), string);
                if (n2 <= n) continue;
                n = n2;
            }
            return n;
        }
    }
}

