/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.xspan.applications.COBrA.gui.util.DigitsTextField;
import org.xspan.applications.COBrA.gui.util.GUITools;
import org.xspan.applications.COBrA.util.UserProfile;

public class UserProfileDialog
extends JDialog {
    ProfilePanel profilePanel;
    UserProfile userProfile;

    public UserProfileDialog(JFrame jFrame, UserProfile userProfile) {
        super(jFrame, "User Profile", true);
        this.userProfile = userProfile;
        this.profilePanel = new ProfilePanel(userProfile);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout());
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (UserProfileDialog.this.profilePanel.getMessage().equals("")) {
                    UserProfileDialog.this.updateProfile();
                    UserProfileDialog.this.setVisible(false);
                } else {
                    JOptionPane.showMessageDialog(UserProfileDialog.this, UserProfileDialog.this.profilePanel.getMessage(), "Error", 0);
                }
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserProfileDialog.this.setVisible(false);
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)this.profilePanel, "Center");
        jPanel.add((Component)jPanel2, "South");
        this.getContentPane().add(jPanel);
        this.pack();
        GUITools.centerJFrame(this);
    }

    protected void updateProfile() {
        this.userProfile.setName(this.profilePanel.nameField.getText());
        this.userProfile.setIDPrefix(this.profilePanel.idField.getText());
        this.userProfile.setNamespace(this.profilePanel.namespaceField.getText());
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setParseIntegerOnly(true);
        try {
            this.userProfile.setPadding(numberFormat.parse(this.profilePanel.padField.getText()).intValue());
        }
        catch (ParseException parseException) {
            this.userProfile.setPadding(7);
        }
    }

    class ProfilePanel
    extends JPanel {
        JTextField nameField;
        JTextField idField;
        JTextField namespaceField;
        DigitsTextField padField;

        ProfilePanel(UserProfile userProfile) {
            this.setLayout(new BoxLayout(this, 1));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            JLabel jLabel = new JLabel(" User Name:                               ");
            this.nameField = new JTextField(20);
            jPanel.add(jLabel);
            jPanel.add(this.nameField);
            this.add(jPanel);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            JLabel jLabel2 = new JLabel(" Prefix for New Term IDs:           ");
            this.idField = new JTextField(5);
            jPanel2.add(jLabel2);
            jPanel2.add(this.idField);
            this.add(jPanel2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            JLabel jLabel3 = new JLabel(" Zero Padding for New Term IDs:");
            this.padField = new DigitsTextField(2);
            jPanel3.add(jLabel3);
            jPanel3.add(this.padField);
            this.add(jPanel3);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 0));
            JLabel jLabel4 = new JLabel(" Namespace for New Terms:       ");
            this.namespaceField = new JTextField(25);
            jPanel4.add(jLabel4);
            jPanel4.add(this.namespaceField);
            this.add(jPanel4);
            this.nameField.setText(userProfile.getName());
            this.idField.setText(userProfile.getIDPrefix());
            this.padField.setText(userProfile.getPadding() + "");
            this.namespaceField.setText(userProfile.getNamespace());
        }

        protected String getMessage() {
            String string = "";
            if (this.nameField.getText().equals("")) {
                string = string + "No name for the author specified.";
            } else if (this.idField.getText().equals("")) {
                string = string + "No ID specified";
            } else if (this.padField.getText().equals("")) {
                string = string + "No padding";
            } else if (this.namespaceField.getText().equals("")) {
                string = string + "No namespace specified";
            }
            return string;
        }
    }
}

