/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.xspan.applications.COBrA.datamodels.GoOntology;
import org.xspan.applications.COBrA.datamodels.GoRelationship;
import org.xspan.applications.COBrA.datamodels.GoRelationshipType;
import org.xspan.applications.COBrA.datamodels.GoTerm;
import org.xspan.applications.COBrA.exceptions.InvalidParameterException;
import org.xspan.applications.COBrA.gui.ChooseFromTreeDialog;
import org.xspan.applications.COBrA.gui.MyFrame;
import org.xspan.applications.COBrA.gui.OntologySearchPanel;
import org.xspan.applications.COBrA.gui.OntologyViewPanel;
import org.xspan.applications.COBrA.gui.tree.DragAndDropTree;
import org.xspan.applications.COBrA.gui.tree.GoTermNode;
import org.xspan.applications.COBrA.gui.tree.GoTermTreeModel;
import org.xspan.applications.COBrA.gui.tree.TransferableTreeNode;
import org.xspan.applications.COBrA.gui.tree.TreeTools;
import org.xspan.applications.COBrA.messages.Message;
import org.xspan.applications.COBrA.messages.MessageVector;
import org.xspan.applications.COBrA.util.UserProfile;

public class OntologyTreePanel
extends OntologyViewPanel
implements ActionListener {
    DragAndDropTree tree;
    MessageVector messages = new MessageVector();
    Stack relnStack;
    boolean isSaved = true;

    public OntologyTreePanel(Vector vector, boolean bl) {
        super(new BorderLayout());
        try {
            this.tree = new DragAndDropTree(new GoTermNode(new GoRelationship(new GoTerm("Ontology", "0:0"), new GoRelationshipType(null, null, ""))), vector, bl);
            this.add((Component)new JScrollPane(this.tree), "Center");
            OntologySearchPanel ontologySearchPanel = new OntologySearchPanel(this.tree);
            this.add((Component)ontologySearchPanel, "South");
        }
        catch (InvalidParameterException invalidParameterException) {
            this.messages.addMessage(new Message("The panel for the tree view could not be created.", 2));
        }
    }

    public OntologyTreePanel(DragAndDropTree dragAndDropTree) {
        super(new BorderLayout());
        this.tree = dragAndDropTree;
        this.add((Component)new JScrollPane(dragAndDropTree), "Center");
        OntologySearchPanel ontologySearchPanel = new OntologySearchPanel(this.tree);
        this.add((Component)ontologySearchPanel, "South");
    }

    public void setOntology(GoOntology goOntology) {
        this.ontology = goOntology;
        if (!this.createTree()) {
            return;
        }
    }

    public DragAndDropTree getTree() {
        return this.tree;
    }

    public void setMenu(ChooseFromTreeDialog chooseFromTreeDialog, ChooseFromTreeDialog chooseFromTreeDialog2, Vector vector, HashMap hashMap) {
        this.tree.setMenu(chooseFromTreeDialog, chooseFromTreeDialog2, vector, hashMap);
    }

    public void setIsSaved(boolean bl) {
        this.isSaved = bl;
        if (bl) {
            this.tree.setIsModified(false);
        }
    }

    public boolean getIsSaved() {
        return this.isSaved && !this.tree.getIsModified();
    }

    public GoRelationship getClipboardContents() {
        GoTermNode goTermNode = null;
        GoRelationship goRelationship = null;
        Transferable transferable = this.tree.getClipBoard().getContents(this);
        if (transferable != null && transferable.isDataFlavorSupported(TransferableTreeNode.NODE_FLAVOR)) {
            try {
                goTermNode = (GoTermNode)transferable.getTransferData(TransferableTreeNode.NODE_FLAVOR);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (goTermNode != null) {
            goRelationship = new GoRelationship((GoTerm)goTermNode.getNodeObject().getRelative().cloneWithoutRelatives(), goTermNode.getNodeObject().getRelationshipType());
        }
        return goRelationship;
    }

    public void pasteTerm(GoRelationship goRelationship) {
        TreePath treePath = this.tree.getTreePath();
        if (goRelationship != null) {
            if (treePath != null) {
                Enumeration<TreeNode> enumeration = ((GoTermNode)this.tree.getModel().getRoot()).depthFirstEnumeration();
                while (enumeration.hasMoreElements()) {
                    GoTermNode goTermNode = (GoTermNode)enumeration.nextElement();
                    if (!goTermNode.getNodeObject().equals(((GoTermNode)treePath.getLastPathComponent()).getNodeObject())) continue;
                    GoTermNode goTermNode2 = new GoTermNode(goRelationship);
                    TreeTools.addNodeToParent(this.tree, goTermNode2, goTermNode, goRelationship.getRelationshipType());
                    TreePath treePath2 = new TreePath(goTermNode2.getPath());
                    this.tree.scrollPathToVisible(treePath2);
                    this.tree.setSelectionPath(treePath2);
                }
                ((GoTermTreeModel)this.tree.getModel()).nodeChanged((GoTermNode)treePath.getLastPathComponent());
            } else {
                JOptionPane.showMessageDialog(null, "Select a destination for the copied term", "Error", 0);
            }
        }
    }

    public void replaceNamespace(String string, String string2) {
        if (string2 == null) {
            return;
        }
        GoRelationship goRelationship = ((GoTermNode)((GoTermTreeModel)this.tree.getModel()).getRoot()).getNodeObject();
        this.replaceNamespace(goRelationship, string, string2);
        TreePath treePath = this.tree.getTreePath();
        if (treePath != null) {
            GoTermNode goTermNode = (GoTermNode)treePath.getLastPathComponent();
            ((GoTermTreeModel)this.tree.getModel()).nodeChanged(goTermNode);
        }
    }

    protected void replaceNamespace(GoRelationship goRelationship, String string, String string2) {
        GoTerm goTerm = goRelationship.getRelative();
        if (string == null || goTerm.getNameSpace().equals(string)) {
            goTerm.setNameSpace(string2);
        }
        for (int i = 0; i < goTerm.getChildren().size(); ++i) {
            this.replaceNamespace(goTerm.getChildren().getRelationship(i), string, string2);
        }
    }

    public void setUserProfile(UserProfile userProfile) {
        this.tree.setUserProfile(userProfile);
    }

    public UserProfile getUserProfile() {
        return this.tree.getUserProfile();
    }

    public MessageVector getMessages() {
        return this.messages;
    }

    protected boolean createTree() {
        if (this.ontology == null) {
            this.messages.addMessage(new Message("The ontology for the panel was not set.", 2));
            return false;
        }
        this.relnStack = new Stack();
        GoTerm goTerm = this.ontology.getRootTerm();
        GoRelationship goRelationship = new GoRelationship(goTerm, new GoRelationshipType(null, null, ""));
        this.relnStack.push(goRelationship);
        GoTermNode goTermNode = new GoTermNode(goRelationship);
        for (int i = 0; i < goTerm.getChildren().size(); ++i) {
            this.addChildren(goTermNode, goTerm.getChildren().getRelationship(i));
        }
        GoTermTreeModel goTermTreeModel = new GoTermTreeModel(this.tree, goTermNode, null);
        this.tree.setModel(goTermTreeModel);
        this.tree.setSelectionPath(new TreePath(((GoTermNode)((GoTermTreeModel)this.tree.getModel()).getRoot()).getPath()));
        return true;
    }

    protected void addChildren(GoTermNode goTermNode, GoRelationship goRelationship) {
        if (this.ontology != null && this.relnStack.search(goRelationship) == -1) {
            this.relnStack.push(goRelationship);
            GoTermNode goTermNode2 = new GoTermNode(goRelationship);
            goTermNode.add(goTermNode2);
            for (int i = 0; i < goRelationship.getRelative().getChildren().size(); ++i) {
                this.addChildren(goTermNode2, goRelationship.getRelative().getChildren().getRelationship(i));
            }
            this.relnStack.pop();
        } else {
            System.out.println("Ontology contains a cycle: " + goRelationship.toString());
        }
    }

    public void addHiddenRelationshipType(GoRelationshipType goRelationshipType) {
        if (goRelationshipType != null) {
            ((GoTermTreeModel)this.tree.getModel()).addHiddenRelationshipTypes(goRelationshipType);
            ((GoTermTreeModel)this.tree.getModel()).reload();
        }
    }

    public void removeHiddenRelationshipType(GoRelationshipType goRelationshipType) {
        if (goRelationshipType != null) {
            ((GoTermTreeModel)this.tree.getModel()).removeHiddenRelationshipTypes(goRelationshipType);
            ((GoTermTreeModel)this.tree.getModel()).reload();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Vector vector;
        if (actionEvent.getSource() instanceof Vector && (vector = (Vector)actionEvent.getSource()).size() == 2 && vector.get(0) instanceof String && vector.get(1) instanceof GoRelationship) {
            TreePath treePath;
            String string = (String)vector.get(0);
            GoRelationship goRelationship = (GoRelationship)vector.get(1);
            GoTermTreeModel goTermTreeModel = (GoTermTreeModel)this.tree.getModel();
            if (string.equals("Children :")) {
                Serializable serializable;
                if (this.tree.getSelectionPath() == null) {
                    serializable = new TreePath(((GoTermNode)this.tree.getModel().getRoot()).getPath());
                    this.tree.setSelectionPath((TreePath)serializable);
                    this.tree.scrollPathToVisible((TreePath)serializable);
                }
                serializable = (GoTermNode)this.tree.getSelectionPath().getLastPathComponent();
                for (int i = 0; i < ((GoTermNode)serializable).getChildCount(goTermTreeModel.getHiddenRelationshipTypes()); ++i) {
                    if (!((GoTermNode)serializable).getChildAt(i, goTermTreeModel.getHiddenRelationshipTypes()).getNodeObject().equals(goRelationship)) continue;
                    TreePath treePath2 = new TreePath(((GoTermNode)serializable).getChildAt(i, goTermTreeModel.getHiddenRelationshipTypes()).getPath());
                    this.tree.setSelectionPath(treePath2);
                    this.tree.scrollPathToVisible(treePath2);
                    return;
                }
            } else if (string.equals("Parents :") && !goTermTreeModel.containsHiddenRelationshipeTypes(goRelationship.getRelationshipType()) && (treePath = goTermTreeModel.findNodeForGoTerm(goRelationship)) != null) {
                this.tree.setSelectionPath(treePath);
                this.tree.scrollPathToVisible(treePath);
            }
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.tree.addTreeSelectionListener(treeSelectionListener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.tree.removeTreeSelectionListener(treeSelectionListener);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.tree.setEditable(bl);
    }

    public static void main(String[] stringArray) {
        try {
            new MyFrame("Ontology Tree Frame");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }
}

