/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.xspan.applications.COBrA.gui.tree.DragAndDropTree;
import org.xspan.applications.COBrA.gui.tree.GoTermNode;
import org.xspan.applications.COBrA.gui.tree.GoTermTreeModel;
import org.xspan.applications.COBrA.logging.LoggerCreator;
import org.xspan.applications.COBrA.logging.TaskGenerator;
import org.xspan.applications.COBrA.util.Resources;

public class OntologySearchPanel
extends JPanel {
    JTextField searchField;
    JComboBox typeChooser;
    JButton startButton;
    JButton nextButton;
    JButton previousButton;
    JCheckBox startAtSelectionCheckBox;
    JCheckBox exactStringCheckBox;
    DragAndDropTree tree;
    Vector searchResult;
    int searchResultIndex = 0;

    public OntologySearchPanel(DragAndDropTree dragAndDropTree) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Find Terms"));
        this.tree = dragAndDropTree;
        ((GoTermTreeModel)this.tree.getModel()).addTreeModelListener(new ResetTreeModelListener());
        this.searchField = new JTextField(20);
        this.searchField.addActionListener(new ResetSearchAction());
        Vector<String> vector = new Vector<String>();
        vector.add("Name");
        vector.add("ID");
        vector.add("Synonym");
        this.typeChooser = new JComboBox(vector);
        this.typeChooser.addActionListener(new ResetSearchAction());
        this.startButton = new JButton("Find");
        this.startButton.setIcon(Resources.getFindIcon());
        this.startButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(OntologySearchPanel.this.startButton) && !OntologySearchPanel.this.searchField.equals("")) {
                    OntologySearchPanel.this.search();
                }
            }
        });
        this.nextButton = new JButton("Next");
        this.nextButton.setIcon(Resources.getNextIcon());
        this.nextButton.setVerticalTextPosition(0);
        this.nextButton.setHorizontalTextPosition(10);
        this.nextButton.setEnabled(false);
        this.nextButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(OntologySearchPanel.this.nextButton) && OntologySearchPanel.this.searchResult.size() > OntologySearchPanel.this.searchResultIndex) {
                    OntologySearchPanel.this.tree.setSelectionPath((TreePath)OntologySearchPanel.this.searchResult.get(OntologySearchPanel.this.searchResultIndex));
                    OntologySearchPanel.this.tree.scrollPathToVisible((TreePath)OntologySearchPanel.this.searchResult.get(OntologySearchPanel.this.searchResultIndex));
                    ++OntologySearchPanel.this.searchResultIndex;
                    if (0 < OntologySearchPanel.this.searchResultIndex) {
                        OntologySearchPanel.this.previousButton.setEnabled(true);
                    }
                    if (OntologySearchPanel.this.searchResult.size() == OntologySearchPanel.this.searchResultIndex) {
                        OntologySearchPanel.this.nextButton.setEnabled(false);
                        --OntologySearchPanel.this.searchResultIndex;
                    }
                }
            }
        });
        this.previousButton = new JButton("Previous");
        this.previousButton.setIcon(Resources.getPreviouseIcon());
        this.previousButton.setEnabled(false);
        this.previousButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(OntologySearchPanel.this.previousButton) && OntologySearchPanel.this.searchResultIndex > 0) {
                    --OntologySearchPanel.this.searchResultIndex;
                    OntologySearchPanel.this.tree.setSelectionPath((TreePath)OntologySearchPanel.this.searchResult.get(OntologySearchPanel.this.searchResultIndex));
                    OntologySearchPanel.this.tree.scrollPathToVisible((TreePath)OntologySearchPanel.this.searchResult.get(OntologySearchPanel.this.searchResultIndex));
                    if (OntologySearchPanel.this.searchResultIndex < OntologySearchPanel.this.searchResult.size()) {
                        OntologySearchPanel.this.nextButton.setEnabled(true);
                    }
                    if (OntologySearchPanel.this.searchResultIndex == 0) {
                        OntologySearchPanel.this.previousButton.setEnabled(false);
                        ++OntologySearchPanel.this.searchResultIndex;
                    }
                }
            }
        });
        this.startAtSelectionCheckBox = new JCheckBox("Start at selected term");
        this.startAtSelectionCheckBox.addActionListener(new ResetSearchAction());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.startAtSelectionCheckBox);
        this.exactStringCheckBox = new JCheckBox("Exact string");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(this.exactStringCheckBox);
        this.exactStringCheckBox.setSelected(false);
        this.searchResult = new Vector();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(this.searchField);
        jPanel3.add(this.startButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(jPanel);
        jPanel4.add(jPanel2);
        jPanel4.add(this.typeChooser);
        JPanel jPanel5 = new JPanel(new GridLayout(1, 2));
        jPanel5.add(this.previousButton);
        jPanel5.add(this.nextButton);
        this.add((Component)jPanel4, "North");
        this.add((Component)jPanel3, "Center");
        this.add((Component)jPanel5, "South");
    }

    protected void search() {
        this.reset();
        GoTermNode goTermNode = this.startAtSelectionCheckBox.isSelected() ? (this.tree.isSelectionEmpty() ? (GoTermNode)this.tree.getModel().getRoot() : (GoTermNode)this.tree.getSelectionPath().getLastPathComponent()) : (GoTermNode)this.tree.getModel().getRoot();
        Enumeration<TreeNode> enumeration = goTermNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            GoTermNode goTermNode2 = (GoTermNode)enumeration.nextElement();
            if (this.typeChooser.getSelectedItem().equals("Name")) {
                if (!goTermNode2.getNodeObject().getRelative().getName().equalsIgnoreCase(this.searchField.getText()) && (this.exactStringCheckBox.isSelected() || !goTermNode2.getNodeObject().getRelative().getName().matches(".*" + this.searchField.getText() + ".*"))) continue;
                this.searchResult.add(new TreePath(goTermNode2.getPath()));
                continue;
            }
            if (this.typeChooser.getSelectedItem().equals("ID")) {
                if (!goTermNode2.getNodeObject().getRelative().getCompleteId().equalsIgnoreCase(this.searchField.getText()) && (this.exactStringCheckBox.isSelected() || !goTermNode2.getNodeObject().getRelative().getCompleteId().matches(".*" + this.searchField.getText() + ".*"))) continue;
                this.searchResult.add(new TreePath(goTermNode2.getPath()));
                continue;
            }
            if (!this.typeChooser.getSelectedItem().equals("Synonym")) continue;
            for (int i = 0; i < goTermNode2.getNodeObject().getRelative().getSynonyms().size(); ++i) {
                if (!goTermNode2.getNodeObject().getRelative().getSynonyms().getString(i).equalsIgnoreCase(this.searchField.getText()) && (this.exactStringCheckBox.isSelected() || !goTermNode2.getNodeObject().getRelative().getSynonyms().getString(i).matches(".*" + this.searchField.getText() + ".*"))) continue;
                this.searchResult.add(new TreePath(goTermNode2.getPath()));
            }
        }
        if (!this.searchResult.isEmpty()) {
            this.tree.setSelectionPath((TreePath)this.searchResult.get(this.searchResultIndex));
            this.tree.scrollPathToVisible((TreePath)this.searchResult.get(this.searchResultIndex));
            ++this.searchResultIndex;
            if (this.searchResult.size() > 1) {
                this.nextButton.setEnabled(true);
            }
            if (TaskGenerator.isStarted()) {
                String string = this.tree.getModel().getRoot().toString();
                String string2 = this.exactStringCheckBox.isSelected() ? "exact to" : "similar to";
                LoggerCreator.getLogger().info("Search in ontology '" + string + "' for the " + this.typeChooser.getSelectedItem() + " " + string2 + " '" + this.searchField.getText() + "' was successful. Found " + this.searchResult.size() + " items.");
            }
        } else {
            if (TaskGenerator.isStarted()) {
                String string = this.tree.getModel().getRoot().toString();
                String string3 = this.exactStringCheckBox.isSelected() ? "exact to" : "similar to";
                LoggerCreator.getLogger().info("Search in ontology '" + string + "' for the " + this.typeChooser.getSelectedItem() + " " + string3 + " '" + this.searchField.getText() + "' was not successful.");
            }
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "No term found with the " + (String)this.typeChooser.getSelectedItem() + " \"" + this.searchField.getText() + "\".", "Find", 1);
        }
    }

    public void reset() {
        this.nextButton.setEnabled(false);
        this.previousButton.setEnabled(false);
        this.searchResult.removeAllElements();
        this.searchResultIndex = 0;
    }

    class ResetTreeModelListener
    implements TreeModelListener {
        ResetTreeModelListener() {
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            OntologySearchPanel.this.reset();
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            OntologySearchPanel.this.reset();
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            OntologySearchPanel.this.reset();
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            OntologySearchPanel.this.reset();
        }
    }

    class ResetSearchAction
    extends AbstractAction {
        ResetSearchAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OntologySearchPanel.this.reset();
        }
    }
}

