/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.xspan.applications.COBrA.datamodels.GoOntology;
import org.xspan.applications.COBrA.datamodels.GoRelationshipType;
import org.xspan.applications.COBrA.datamodels.GoTerm;
import org.xspan.applications.COBrA.gui.MySecFrame;
import org.xspan.applications.COBrA.gui.OntologyViewPanel;
import org.xspan.applications.COBrA.gui.nodebasedview.AssociationPanel;
import org.xspan.applications.COBrA.gui.nodebasedview.DbxRefPanel;
import org.xspan.applications.COBrA.gui.nodebasedview.HeadPanel;
import org.xspan.applications.COBrA.gui.nodebasedview.HistoryPanel;
import org.xspan.applications.COBrA.gui.nodebasedview.RelativePanel;
import org.xspan.applications.COBrA.gui.nodebasedview.StringValuesPanel;
import org.xspan.applications.COBrA.gui.tree.DragAndDropTree;
import org.xspan.applications.COBrA.gui.tree.GoTermNode;

public class OntologyNodeBasedPanel
extends OntologyViewPanel
implements TreeSelectionListener {
    GoTerm goTerm;
    HeadPanel headPanel;
    RelativePanel parentPanel;
    RelativePanel childrenPanel;
    DbxRefPanel dbxrefPanel;
    StringValuesPanel synonymPanel;
    StringValuesPanel additionalIdsPanel;
    AssociationPanel associationPanel;
    HistoryPanel historyPanel;
    JPanel termPanel = new JPanel();

    public OntologyNodeBasedPanel(GoTerm goTerm, GoOntology goOntology) {
        this();
        this.setGoTerm(goTerm, goOntology);
    }

    public OntologyNodeBasedPanel() {
        super(new BorderLayout());
        this.termPanel.setLayout(new BoxLayout(this.termPanel, 1));
        this.headPanel = new HeadPanel();
        this.parentPanel = new RelativePanel(this, "Parents :");
        this.childrenPanel = new RelativePanel(this, "Children :");
        this.additionalIdsPanel = new StringValuesPanel("Additional IDs :");
        this.synonymPanel = new StringValuesPanel("Synonyms :");
        this.dbxrefPanel = new DbxRefPanel();
        this.associationPanel = new AssociationPanel();
        this.historyPanel = new HistoryPanel();
        this.termPanel.add(this.headPanel);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.termPanel, "North");
        this.add((Component)new JScrollPane(jPanel), "Center");
    }

    public void setGoTerm(GoTerm goTerm, GoOntology goOntology) {
        this.goTerm = goTerm;
        this.ontology = goOntology;
        this.createPage();
    }

    protected void createPage() {
        this.headPanel.setHead(this.goTerm);
        this.termPanel.remove(this.parentPanel);
        this.termPanel.remove(this.childrenPanel);
        this.termPanel.remove(this.additionalIdsPanel);
        this.termPanel.remove(this.synonymPanel);
        this.termPanel.remove(this.dbxrefPanel);
        this.termPanel.remove(this.associationPanel);
        this.termPanel.remove(this.historyPanel);
        if (this.goTerm.getParents().size() > 0) {
            this.parentPanel.setRelatives(this.goTerm.getParents(), this.ontology);
            this.termPanel.add(this.parentPanel);
        }
        if (this.goTerm.getChildren().size() > 0) {
            this.childrenPanel.setRelatives(this.goTerm.getChildren(), this.ontology);
            this.termPanel.add(this.childrenPanel);
        }
        if (this.goTerm.getAdditionalIds().size() > 0) {
            this.additionalIdsPanel.setValues(this.goTerm.getAdditionalIds());
            this.termPanel.add(this.additionalIdsPanel);
        }
        if (this.goTerm.getSynonyms().size() > 0) {
            this.synonymPanel.setValues(this.goTerm.getSynonyms());
            this.termPanel.add(this.synonymPanel);
        }
        if (this.goTerm.getDbxRefs().size() > 0) {
            this.dbxrefPanel.setDbxrefs(this.goTerm.getDbxRefs());
            this.termPanel.add(this.dbxrefPanel);
        }
        if (this.goTerm.getAssociations().size() > 0) {
            this.associationPanel.setAssociations(this.goTerm.getAssociations());
            this.termPanel.add(this.associationPanel);
        }
        if (this.goTerm.getHistories().size() > 0) {
            this.historyPanel.setHistories(this.goTerm.getHistories());
            this.termPanel.add(this.historyPanel);
        }
        this.doLayout();
        this.validate();
        this.repaint();
    }

    public void addHiddenRelationshipType(GoRelationshipType goRelationshipType) {
        if (goRelationshipType != null) {
            this.parentPanel.addHiddenRelationshipType(goRelationshipType);
            this.childrenPanel.addHiddenRelationshipType(goRelationshipType);
        }
    }

    public void removeHiddenRelationshipType(GoRelationshipType goRelationshipType) {
        if (goRelationshipType != null) {
            this.parentPanel.removeHiddenRelationshipType(goRelationshipType);
            this.childrenPanel.removeHiddenRelationshipType(goRelationshipType);
        }
    }

    public void addListener(ActionListener actionListener) {
        this.childrenPanel.addListener(actionListener);
        this.parentPanel.addListener(actionListener);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.getSource() instanceof DragAndDropTree) {
            GoTermNode goTermNode = (GoTermNode)treeSelectionEvent.getPath().getLastPathComponent();
            this.setGoTerm(goTermNode.getNodeObject().getRelative(), this.ontology);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.parentPanel.setEnabled(bl);
        this.childrenPanel.setEnabled(bl);
    }

    public static void main(String[] stringArray) {
        try {
            new MySecFrame("Ontology Tree Frame");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }
}

