/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import org.xspan.applications.COBrA.SwingWorker;
import org.xspan.applications.COBrA.datamodels.GoOntology;
import org.xspan.applications.COBrA.datamodels.GoRelationshipType;
import org.xspan.applications.COBrA.gui.OntologyNodeBasedPanel;
import org.xspan.applications.COBrA.gui.util.GUITools;
import org.xspan.applications.COBrA.io.GoFlatFileReader;

class MySecFrame
extends JFrame {
    HashMap relationshipTypes = new HashMap();
    JProgressBar progressBar = new JProgressBar();
    GoFlatFileReader reader;
    SwingWorker readWorker;
    SwingWorker writeWorker;
    JLabel statusLabel;
    OntologyNodeBasedPanel nodeBasedPanel;
    JFileChooser fc = new JFileChooser();

    MySecFrame(String string) throws IOException {
        super(string);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        this.fc.setFileSelectionMode(0);
        GoRelationshipType goRelationshipType = new GoRelationshipType("is-a", Color.WHITE, Color.DARK_GRAY);
        this.relationshipTypes.put("%", goRelationshipType);
        GoRelationshipType goRelationshipType2 = new GoRelationshipType("part-of", Color.WHITE, Color.BLUE);
        this.relationshipTypes.put("<", goRelationshipType2);
        GoRelationshipType goRelationshipType3 = new GoRelationshipType("lineage", Color.WHITE, Color.RED);
        this.relationshipTypes.put("~", goRelationshipType3);
        this.progressBar.setStringPainted(true);
        this.statusLabel = new JLabel("Status");
        jPanel2.add(this.statusLabel);
        jPanel2.add(this.progressBar);
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        Vector<GoRelationshipType> vector = new Vector<GoRelationshipType>();
        vector.add(goRelationshipType);
        vector.add(goRelationshipType2);
        vector.add(goRelationshipType3);
        this.nodeBasedPanel = new OntologyNodeBasedPanel();
        jPanel.add((Component)this.nodeBasedPanel, "Center");
        jPanel.add((Component)jPanel2, "South");
        this.createMenuBar();
        this.getContentPane().add(jPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.setSize(400, 600);
        GUITools.centerJFrame(this);
        this.setVisible(true);
    }

    protected void createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Read File", 79);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        jMenuItem.addActionListener(new ReadActionListener());
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Exit", 69);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(69, 8));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem2);
        this.setJMenuBar(jMenuBar);
    }

    class ReadWorker
    extends SwingWorker {
        ReadWorker() {
        }

        public Object construct() {
            GoOntology goOntology = MySecFrame.this.reader.read();
            if (goOntology == null) {
                MySecFrame.this.statusLabel.setText(MySecFrame.this.reader.getMessages().getLastMessage().toString());
                return null;
            }
            MySecFrame.this.nodeBasedPanel.setGoTerm(goOntology.getRootTerm(), goOntology);
            return goOntology;
        }

        public void finished() {
            try {
                MySecFrame.this.reader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    class ReadActionListener
    implements ActionListener {
        ReadActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = MySecFrame.this.fc.showOpenDialog(MySecFrame.this);
            if (n == 0) {
                File file = MySecFrame.this.fc.getSelectedFile();
                try {
                    MySecFrame.this.reader = new GoFlatFileReader(file, MySecFrame.this.progressBar, MySecFrame.this.relationshipTypes);
                    MySecFrame.this.statusLabel.setText("Read " + file.getName());
                    MySecFrame.this.progressBar.setValue(0);
                    MySecFrame.this.readWorker = new ReadWorker();
                    MySecFrame.this.readWorker.start();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else if (n == 1) {
                MySecFrame.this.statusLabel.setForeground(Color.BLUE);
                MySecFrame.this.statusLabel.setText("Canceled read command.");
            }
        }
    }
}

