/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import org.xspan.applications.COBrA.SwingWorker;
import org.xspan.applications.COBrA.datamodels.GoOntology;
import org.xspan.applications.COBrA.datamodels.GoRelationshipType;
import org.xspan.applications.COBrA.gui.OntologyTreePanel;
import org.xspan.applications.COBrA.gui.util.GUITools;
import org.xspan.applications.COBrA.io.GoFlatFileReader;
import org.xspan.applications.COBrA.io.GoFlatFileWriter;

class MyFrame
extends JFrame {
    HashMap relationshipTypes = new HashMap();
    JProgressBar progressBar = new JProgressBar();
    GoFlatFileReader reader;
    GoFlatFileWriter writer;
    SwingWorker readWorker;
    SwingWorker writeWorker;
    JLabel statusLabel;
    OntologyTreePanel treePanel;
    JFileChooser fc = new JFileChooser();

    MyFrame(String string) throws IOException {
        super(string);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        this.fc.setFileSelectionMode(0);
        GoRelationshipType goRelationshipType = new GoRelationshipType("is-a", Color.WHITE, Color.DARK_GRAY);
        this.relationshipTypes.put("%", goRelationshipType);
        GoRelationshipType goRelationshipType2 = new GoRelationshipType("part-of", Color.WHITE, Color.BLUE);
        this.relationshipTypes.put("<", goRelationshipType2);
        GoRelationshipType goRelationshipType3 = new GoRelationshipType("lineage", Color.WHITE, Color.RED);
        this.relationshipTypes.put("~", goRelationshipType3);
        this.progressBar.setStringPainted(true);
        this.statusLabel = new JLabel("Status");
        jPanel2.add(this.statusLabel);
        jPanel2.add(this.progressBar);
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        Vector<GoRelationshipType> vector = new Vector<GoRelationshipType>();
        vector.add(goRelationshipType);
        vector.add(goRelationshipType2);
        vector.add(goRelationshipType3);
        this.treePanel = new OntologyTreePanel(vector, true);
        jPanel.add((Component)this.treePanel, "Center");
        jPanel.add((Component)jPanel2, "South");
        this.createMenuBar();
        this.getContentPane().add(jPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.setSize(400, 700);
        GUITools.centerJFrame(this);
        this.setVisible(true);
    }

    protected void createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Read File", 79);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        jMenuItem.addActionListener(new ReadActionListener());
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Save Ontology", 83);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        jMenuItem2.addActionListener(new WriteActionListener());
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("Exit", 69);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(69, 8));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem3);
        JMenu jMenu2 = new JMenu("Visible");
        jMenu2.setMnemonic(86);
        jMenuBar.add(jMenu2);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("is-a");
        jCheckBoxMenuItem.setSelected(true);
        jCheckBoxMenuItem.addActionListener(new HideActionListener((GoRelationshipType)this.relationshipTypes.get("%"), this.treePanel));
        jMenu2.add(jCheckBoxMenuItem);
        JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("part-of");
        jCheckBoxMenuItem2.setSelected(true);
        jCheckBoxMenuItem2.addActionListener(new HideActionListener((GoRelationshipType)this.relationshipTypes.get("<"), this.treePanel));
        jMenu2.add(jCheckBoxMenuItem2);
        JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem("lineage");
        jCheckBoxMenuItem3.setSelected(true);
        jCheckBoxMenuItem3.addActionListener(new HideActionListener((GoRelationshipType)this.relationshipTypes.get("~"), this.treePanel));
        jMenu2.add(jCheckBoxMenuItem3);
        this.setJMenuBar(jMenuBar);
    }

    class WriteWorker
    extends SwingWorker {
        WriteWorker() {
        }

        public Object construct() {
            boolean bl = MyFrame.this.writer.write(MyFrame.this.treePanel.ontology);
            if (!bl) {
                MyFrame.this.statusLabel.setText(MyFrame.this.writer.getMessages().getLastMessage().toString());
                return null;
            }
            return MyFrame.this.treePanel.ontology;
        }

        public void finished() {
            try {
                MyFrame.this.writer.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    class ReadWorker
    extends SwingWorker {
        ReadWorker() {
        }

        public Object construct() {
            GoOntology goOntology = MyFrame.this.reader.read();
            if (goOntology == null) {
                MyFrame.this.statusLabel.setText(MyFrame.this.reader.getMessages().getLastMessage().toString());
                return null;
            }
            MyFrame.this.treePanel.setOntology(goOntology);
            return MyFrame.this.treePanel.ontology;
        }

        public void finished() {
            try {
                MyFrame.this.reader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    class HideActionListener
    implements ActionListener {
        GoRelationshipType type;
        OntologyTreePanel panel;

        public HideActionListener(GoRelationshipType goRelationshipType, OntologyTreePanel ontologyTreePanel) {
            this.type = goRelationshipType;
            this.panel = ontologyTreePanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            if (!jCheckBoxMenuItem.isSelected()) {
                this.panel.addHiddenRelationshipType(this.type);
            } else {
                this.panel.removeHiddenRelationshipType(this.type);
            }
        }
    }

    class WriteActionListener
    implements ActionListener {
        WriteActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = MyFrame.this.fc.showSaveDialog(MyFrame.this);
            if (n == 0) {
                File file = MyFrame.this.fc.getSelectedFile();
                try {
                    MyFrame.this.writer = new GoFlatFileWriter(new FileWriter(file), MyFrame.this.progressBar, MyFrame.this.relationshipTypes);
                    MyFrame.this.statusLabel.setText("Write " + file.getName());
                    MyFrame.this.progressBar.setValue(0);
                    MyFrame.this.writeWorker = new WriteWorker();
                    MyFrame.this.writeWorker.start();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else if (n == 1) {
                MyFrame.this.statusLabel.setText("Canceled write command.");
            }
        }
    }

    class ReadActionListener
    implements ActionListener {
        ReadActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = MyFrame.this.fc.showOpenDialog(MyFrame.this);
            if (n == 0) {
                File file = MyFrame.this.fc.getSelectedFile();
                try {
                    MyFrame.this.reader = new GoFlatFileReader(file, MyFrame.this.progressBar, MyFrame.this.relationshipTypes);
                    MyFrame.this.statusLabel.setText("Read " + file.getName());
                    MyFrame.this.progressBar.setValue(0);
                    MyFrame.this.readWorker = new ReadWorker();
                    MyFrame.this.readWorker.start();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else if (n == 1) {
                MyFrame.this.statusLabel.setForeground(Color.BLUE);
                MyFrame.this.statusLabel.setText("Canceled read command.");
            }
        }
    }
}

