/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.DateFormatter;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.xspan.applications.COBrA.datamodels.GoOntology;
import org.xspan.applications.COBrA.datamodels.GoRelationship;
import org.xspan.applications.COBrA.datamodels.GoRelationshipType;
import org.xspan.applications.COBrA.datamodels.GoTerm;
import org.xspan.applications.COBrA.exceptions.InvalidParameterException;
import org.xspan.applications.COBrA.gui.ChooseFromTreeDialog;
import org.xspan.applications.COBrA.gui.tree.GoTermNode;
import org.xspan.applications.COBrA.gui.tree.GoTermTreeModel;
import org.xspan.applications.COBrA.gui.util.GUITools;
import org.xspan.applications.COBrA.logging.LoggerCreator;
import org.xspan.applications.COBrA.logging.TaskGenerator;
import org.xspan.applications.COBrA.util.UserProfile;

public class AnnotationEditorSimpleDialog
extends JDialog {
    AnnotationEditorPanel editorPanel;
    GoOntology mappingOntology;
    ChooseFromTreeDialog mappingOntologyDialog;
    HashMap relationshipTypes;
    String parentName;
    UserProfile userProfile;

    public AnnotationEditorSimpleDialog(JFrame jFrame, GoOntology goOntology, ChooseFromTreeDialog chooseFromTreeDialog, GoTerm goTerm, GoTerm goTerm2, Vector vector, HashMap hashMap, UserProfile userProfile) {
        super(jFrame, "Annotation", true);
        this.mappingOntology = goOntology;
        this.mappingOntologyDialog = chooseFromTreeDialog;
        this.relationshipTypes = hashMap;
        this.userProfile = userProfile;
        GoTerm goTerm3 = this.findMapping(goOntology, goTerm, goTerm2);
        if (goTerm3 != null) {
            System.out.println("existing mapping " + goTerm3.getIdPrefix() + ":" + goTerm3.getId());
            this.editorPanel = new AnnotationEditorPanel(goTerm3, goTerm, goTerm2, vector);
            this.deleteTermFromParent(goTerm3, (GoRelationshipType)this.relationshipTypes.get("%"));
            JOptionPane.showMessageDialog(this, "This mapping already exists,\nyou may edit or delete it", "Warning", 1);
        } else {
            this.editorPanel = new AnnotationEditorPanel(goTerm, goTerm2, vector, userProfile);
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout());
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AnnotationEditorSimpleDialog.this.editorPanel.getMessage().equals("")) {
                    AnnotationEditorSimpleDialog.this.createAnnotation();
                    AnnotationEditorSimpleDialog.this.setVisible(false);
                } else {
                    JOptionPane.showMessageDialog(AnnotationEditorSimpleDialog.this, AnnotationEditorSimpleDialog.this.editorPanel.getMessage(), "Annotation Error", 0);
                    if (TaskGenerator.isStarted()) {
                        LoggerCreator.getLogger().info("Make Annotation error : " + AnnotationEditorSimpleDialog.this.editorPanel.getMessage());
                    }
                }
            }
        });
        JButton jButton2 = goTerm3 != null ? new JButton("Delete") : new JButton("Cancel");
        jButton2.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationEditorSimpleDialog.this.setVisible(false);
                if (TaskGenerator.isStarted()) {
                    LoggerCreator.getLogger().info("Make Annotation canceled.");
                }
            }
        });
        jPanel2.add(jButton2);
        jPanel2.add(jButton);
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)this.editorPanel, "Center");
        jPanel.add((Component)jPanel2, "South");
        this.getContentPane().add(jPanel);
        this.pack();
        GUITools.centerJFrame(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public AnnotationEditorSimpleDialog(ChooseFromTreeDialog chooseFromTreeDialog, GoTerm goTerm, Vector vector, HashMap hashMap, boolean bl) {
        super(chooseFromTreeDialog, "Annotation", true);
        this.mappingOntology = chooseFromTreeDialog.treePanel.ontology;
        this.mappingOntologyDialog = chooseFromTreeDialog;
        this.relationshipTypes = hashMap;
        System.out.println("edit node " + goTerm.toString() + " [" + goTerm.getChildren().size() + "]");
        GoTerm goTerm2 = null;
        GoTerm goTerm3 = null;
        for (int i = 0; i < goTerm.getChildren().size(); ++i) {
            if (!goTerm.getChildren().getRelationship(i).getRelationshipType().equals((GoRelationshipType)this.relationshipTypes.get("^"))) continue;
            if (goTerm2 == null && goTerm3 == null) {
                goTerm2 = goTerm.getChildren().getRelationship(i).getRelative();
            }
            if (goTerm2 == null || goTerm3 != null || goTerm.getChildren().getRelationship(i).getRelative().getId().equals(goTerm2.getId()) || goTerm.getChildren().getRelationship(i).getRelative().getIdPrefix().equals(goTerm2.getIdPrefix())) continue;
            goTerm3 = goTerm.getChildren().getRelationship(i).getRelative();
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout());
        JButton jButton = new JButton("OK");
        if (bl) {
            if (goTerm2 != null && goTerm3 != null) {
                System.out.println("delete node " + goTerm.toString());
                this.deleteTermFromParent(goTerm, (GoRelationshipType)this.relationshipTypes.get("%"));
                return;
            }
            this.editorPanel = new AnnotationEditorPanel("This term cannot be deleted");
            jButton.addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AnnotationEditorSimpleDialog.this.setVisible(false);
                }
            });
        } else if (goTerm2 == null || goTerm3 == null) {
            this.editorPanel = new AnnotationEditorPanel("This term cannot be edited");
            jButton.addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AnnotationEditorSimpleDialog.this.setVisible(false);
                }
            });
        } else {
            this.deleteTermFromParent(goTerm, (GoRelationshipType)this.relationshipTypes.get("%"));
            this.editorPanel = new AnnotationEditorPanel(goTerm, goTerm2, goTerm3, vector);
            jButton.addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AnnotationEditorSimpleDialog.this.editorPanel.getMessage().equals("")) {
                        AnnotationEditorSimpleDialog.this.createAnnotation();
                        AnnotationEditorSimpleDialog.this.setVisible(false);
                    } else {
                        JOptionPane.showMessageDialog(AnnotationEditorSimpleDialog.this, AnnotationEditorSimpleDialog.this.editorPanel.getMessage(), "Annotation Error", 0);
                        if (TaskGenerator.isStarted()) {
                            LoggerCreator.getLogger().info("Make Annotation error : " + AnnotationEditorSimpleDialog.this.editorPanel.getMessage());
                        }
                    }
                }
            });
        }
        JButton jButton2 = new JButton("Delete");
        jButton2.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationEditorSimpleDialog.this.setVisible(false);
                if (TaskGenerator.isStarted()) {
                    LoggerCreator.getLogger().info("Make Annotation canceled.");
                }
            }
        });
        if (goTerm2 != null && goTerm3 != null) {
            jPanel2.add(jButton2);
        }
        jPanel2.add(jButton);
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)this.editorPanel, "Center");
        jPanel.add((Component)jPanel2, "South");
        this.getContentPane().add(jPanel);
        this.pack();
        GUITools.centerJFrame(this);
        if (bl) {
            this.setVisible(true);
        }
    }

    protected void createAnnotation() {
        GoTerm goTerm;
        String string;
        String string2 = this.editorPanel.annotationNameField.getText();
        GoTerm goTerm2 = this.editorPanel.tissue1;
        GoTerm goTerm3 = this.editorPanel.tissue2;
        String string3 = "";
        String string4 = this.editorPanel.annotationTextArea.getText();
        if (this.editorPanel.annotationTypeComboBox != null) {
            this.parentName = string = (String)this.editorPanel.annotationTypeComboBox.getSelectedItem();
            goTerm = this.findTerm(this.mappingOntology, this.parentName);
        } else {
            goTerm = this.mappingOntology.getRootTerm();
        }
        string = this.editorPanel.id != null ? this.editorPanel.id : this.findNextID(this.mappingOntology, this.userProfile.getIDPrefix(), this.userProfile.getPadding());
        String string5 = this.editorPanel.namespace != null ? this.editorPanel.namespace : this.userProfile.getNamespace();
        try {
            GoTerm goTerm4 = new GoTerm(string2, string);
            goTerm4.setDefinition(string4);
            goTerm4.setNameSpace(string5);
            goTerm4.setDate(this.editorPanel.dateTextField.getText());
            goTerm4.setCreator(this.editorPanel.authorNameField.getText());
            GoTerm goTerm5 = (GoTerm)goTerm2.clone();
            goTerm5.getChildren().removeAllElements();
            goTerm5.getParents().removeAllElements();
            goTerm5.setStatus(GoTerm.EXTERNAL);
            GoTerm goTerm6 = (GoTerm)goTerm3.clone();
            goTerm6.getChildren().removeAllElements();
            goTerm6.getParents().removeAllElements();
            goTerm6.setStatus(GoTerm.EXTERNAL);
            this.addTermToParent(goTerm4, goTerm, (GoRelationshipType)this.relationshipTypes.get("%"));
            this.addTermToParent(goTerm5, goTerm4, (GoRelationshipType)this.relationshipTypes.get("^"));
            this.addTermToParent(goTerm6, goTerm4, (GoRelationshipType)this.relationshipTypes.get("^"));
            System.out.println("adding mapping " + goTerm4.getIdPrefix() + ":" + goTerm4.getId());
        }
        catch (InvalidParameterException invalidParameterException) {
            // empty catch block
        }
        if (TaskGenerator.isStarted()) {
            LoggerCreator.getLogger().info("Make Annotation '" + string2 + "' finished with 1st tissue [" + goTerm2.getCompleteId() + "] '" + goTerm2.getName() + "' and 2nd tissue [" + goTerm3.getCompleteId() + "] '" + goTerm3.getName() + "'. Used cell types " + string3 + ".");
        }
    }

    public String findNextID(GoOntology goOntology, String string, int n) {
        String string2 = "";
        int n2 = this.findLastId(goOntology.getRootTerm(), string) + 1;
        String string3 = new String("" + n2);
        while (n - string3.length() - string2.length() > 0) {
            string2 = string2.concat("0");
        }
        return string + ":" + string2 + string3;
    }

    protected int findLastId(GoTerm goTerm, String string) {
        int n = goTerm.getIdPrefix().equals(string) ? goTerm.getIdAsInt() : 0;
        int n2 = n;
        for (int i = 0; i < goTerm.getChildren().size(); ++i) {
            n2 = this.findLastId(goTerm.getChildren().getRelationship(i).getRelative(), string);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public GoTerm findMapping(GoOntology goOntology, GoTerm goTerm, GoTerm goTerm2) {
        GoTerm goTerm3;
        GoTerm goTerm4 = goTerm3 = goOntology.getRootTerm();
        for (int i = 0; i < goTerm3.getChildren().size(); ++i) {
            goTerm4 = this.findChildMapping(goTerm3.getChildren().getRelationship(i).getRelative(), goTerm, goTerm2);
            if (goTerm4 == null) continue;
            return goTerm4;
        }
        return null;
    }

    protected GoTerm findChildMapping(GoTerm goTerm, GoTerm goTerm2, GoTerm goTerm3) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < goTerm.getChildren().size(); ++n) {
            if (goTerm.getChildren().getRelationship(n).getRelative().getId().equals(goTerm2.getId()) && goTerm.getChildren().getRelationship(n).getRelative().getIdPrefix().equals(goTerm2.getIdPrefix())) {
                bl = true;
            }
            if (goTerm.getChildren().getRelationship(n).getRelative().getId().equals(goTerm3.getId()) && goTerm.getChildren().getRelationship(n).getRelative().getIdPrefix().equals(goTerm3.getIdPrefix())) {
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            return goTerm;
        }
        for (n = 0; n < goTerm.getChildren().size(); ++n) {
            GoTerm goTerm4 = this.findChildMapping(goTerm.getChildren().getRelationship(n).getRelative(), goTerm2, goTerm3);
            if (goTerm4 == null) continue;
            return goTerm4;
        }
        return null;
    }

    public GoTerm findTerm(GoOntology goOntology, String string) {
        int n;
        GoTerm goTerm;
        GoTerm goTerm2 = goTerm = goOntology.getRootTerm();
        if (goTerm.getName().equals(string)) {
            return goTerm;
        }
        for (n = 0; n < goTerm.getChildren().size(); ++n) {
            goTerm2 = this.findChild(goTerm.getChildren().getRelationship(n).getRelative(), string);
            if (goTerm2 == null) continue;
            return goTerm2;
        }
        for (n = 0; n < goTerm.getChildren().size(); ++n) {
            goTerm2 = this.findChildren(goTerm.getChildren().getRelationship(n).getRelative(), string);
            if (goTerm2 == null) continue;
            return goTerm2;
        }
        return goTerm;
    }

    protected GoTerm findChild(GoTerm goTerm, String string) {
        if (goTerm.getName().equals(string)) {
            return goTerm;
        }
        return null;
    }

    protected GoTerm findChildren(GoTerm goTerm, String string) {
        if (goTerm.getName().equals(string)) {
            return goTerm;
        }
        GoTerm goTerm2 = goTerm;
        for (int i = 0; i < goTerm.getChildren().size(); ++i) {
            goTerm2 = this.findChildren(goTerm.getChildren().getRelationship(i).getRelative(), string);
            if (goTerm2 == null) continue;
            return goTerm2;
        }
        return null;
    }

    protected void addTermToParent(GoTerm goTerm, GoTerm goTerm2, GoRelationshipType goRelationshipType) {
        GoRelationship goRelationship = new GoRelationship(goTerm, goRelationshipType);
        GoRelationship goRelationship2 = new GoRelationship(goTerm2, goRelationshipType);
        goTerm.addParent(goRelationship2);
        goTerm2.addChild(goRelationship);
        GoTermTreeModel goTermTreeModel = (GoTermTreeModel)this.mappingOntologyDialog.getTree().getModel();
        this.mappingOntologyDialog.setIsSaved(false);
        Enumeration<TreeNode> enumeration = ((GoTermNode)goTermTreeModel.getRoot()).breadthFirstEnumeration();
        GoTermNode goTermNode = null;
        while (enumeration.hasMoreElements() && !(goTermNode = (GoTermNode)enumeration.nextElement()).getNodeObject().equals(goRelationship2)) {
        }
        if (goTermNode != null) {
            GoTermNode goTermNode2 = new GoTermNode(goRelationship);
            goTermTreeModel.insertNodeInto(goTermNode2, goTermNode, goTermNode.getChildCount());
            ((GoTermTreeModel)this.mappingOntologyDialog.getTree().getModel()).nodeChanged(goTermNode);
            ((GoTermTreeModel)this.mappingOntologyDialog.getTree().getModel()).nodeChanged(goTermNode2);
            TreePath treePath = new TreePath(goTermNode2.getPath());
            this.mappingOntologyDialog.getTree().scrollPathToVisible(treePath);
            this.mappingOntologyDialog.getTree().setSelectionPath(treePath);
        }
    }

    protected void deleteTermFromParent(GoTerm goTerm, GoRelationshipType goRelationshipType) {
        GoRelationship goRelationship = new GoRelationship(goTerm, goRelationshipType);
        GoTermTreeModel goTermTreeModel = (GoTermTreeModel)this.mappingOntologyDialog.getTree().getModel();
        this.mappingOntologyDialog.setIsSaved(false);
        Enumeration<TreeNode> enumeration = ((GoTermNode)goTermTreeModel.getRoot()).breadthFirstEnumeration();
        GoTermNode goTermNode = null;
        while (enumeration.hasMoreElements()) {
            goTermNode = (GoTermNode)enumeration.nextElement();
            if (!goTermNode.getNodeObject().equals(goRelationship)) continue;
            GoRelationship goRelationship2 = ((GoTermNode)goTermNode.getParent()).getNodeObject();
            goRelationship2.getRelative().getChildren().removeRelationshipForRelative(goTerm);
            goTermTreeModel.removeNodeFromParent(goTermNode);
            return;
        }
    }

    class AnnotationEditorPanel
    extends JPanel {
        JTextField annotationNameField;
        JTextField tissueOneNameField;
        JTextField tissueTwoNameField;
        JTextField authorNameField;
        JFormattedTextField dateTextField;
        JTextArea annotationTextArea;
        JComboBox annotationTypeComboBox = null;
        GoTerm tissue1;
        GoTerm tissue2;
        String namespace = null;
        String id = null;

        AnnotationEditorPanel(String string) {
            JLabel jLabel = new JLabel(string);
            this.add(jLabel);
        }

        AnnotationEditorPanel(GoTerm goTerm, GoTerm goTerm2, Vector vector, UserProfile userProfile) {
            this.setLayout(new BoxLayout(this, 1));
            this.tissue1 = goTerm;
            this.tissue2 = goTerm2;
            String string = goTerm.getName() + "-" + goTerm2.getName() + "-Mapping";
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            JLabel jLabel = new JLabel("Annotation Name : ");
            this.annotationNameField = new JTextField(25);
            jPanel.add(jLabel);
            jPanel.add(this.annotationNameField);
            this.add(jPanel);
            this.annotationNameField.setText(string);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            JLabel jLabel2 = new JLabel("Annotation Type : ");
            jLabel2.setPreferredSize(jLabel.getPreferredSize());
            Vector vector2 = vector;
            if (vector2 != null) {
                this.annotationTypeComboBox = new JComboBox(vector2);
                jPanel2.add(jLabel2);
                jPanel2.add(this.annotationTypeComboBox);
                this.add(jPanel2);
            }
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            JLabel jLabel3 = new JLabel("1st Concept : ");
            jLabel3.setPreferredSize(jLabel.getPreferredSize());
            this.tissueOneNameField = new JTextField(25);
            jPanel3.add(jLabel3);
            jPanel3.add(this.tissueOneNameField);
            this.add(jPanel3);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 0));
            JLabel jLabel4 = new JLabel("2nd Concept : ");
            jLabel4.setPreferredSize(jLabel.getPreferredSize());
            this.tissueTwoNameField = new JTextField(25);
            jPanel4.add(jLabel4);
            jPanel4.add(this.tissueTwoNameField);
            this.add(jPanel4);
            JPanel jPanel5 = new JPanel(new BorderLayout());
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BoxLayout(jPanel6, 0));
            JLabel jLabel5 = new JLabel("Author Name : ");
            jLabel5.setPreferredSize(jLabel.getPreferredSize());
            this.authorNameField = new JTextField(25);
            this.authorNameField.setText(userProfile.getName());
            jPanel6.add(jLabel5);
            jPanel6.add(this.authorNameField);
            this.add(jPanel6);
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout(new BoxLayout(jPanel7, 0));
            JLabel jLabel6 = new JLabel("Date : ");
            jLabel6.setPreferredSize(jLabel.getPreferredSize());
            this.dateTextField = new JFormattedTextField(new DateFormatter(DateFormat.getDateInstance(3, Locale.UK)));
            jPanel7.add(jLabel6);
            jPanel7.add(this.dateTextField);
            this.dateTextField.setValue(new Date());
            this.add(jPanel7);
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout(new BoxLayout(jPanel8, 0));
            JLabel jLabel7 = new JLabel("Annotation : ");
            jLabel7.setPreferredSize(jLabel.getPreferredSize());
            this.annotationTextArea = new JTextArea(6, 25);
            this.annotationTextArea.setBorder(this.tissueOneNameField.getBorder());
            jPanel8.add(jLabel7);
            jPanel8.add(this.annotationTextArea);
            this.add(jPanel8);
            this.setValues(goTerm.getName(), goTerm2.getName());
            this.setBorder(BorderFactory.createEtchedBorder());
        }

        AnnotationEditorPanel(GoTerm goTerm, GoTerm goTerm2, GoTerm goTerm3, Vector vector) {
            this.setLayout(new BoxLayout(this, 1));
            this.tissue1 = goTerm2;
            this.tissue2 = goTerm3;
            this.namespace = goTerm.getNameSpace();
            this.id = goTerm.getIdPrefix() + ":" + goTerm.getId();
            String string = goTerm.getName();
            String string2 = goTerm.getDefinition();
            String string3 = goTerm.getCreator();
            String string4 = goTerm.getDate();
            String string5 = goTerm.getParents().getRelationship(0).getRelative().getName();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            JLabel jLabel = new JLabel("Annotation Name : ");
            this.annotationNameField = new JTextField(25);
            jPanel.add(jLabel);
            jPanel.add(this.annotationNameField);
            this.add(jPanel);
            this.annotationNameField.setText(string);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            JLabel jLabel2 = new JLabel("Annotation Type : ");
            jLabel2.setPreferredSize(jLabel.getPreferredSize());
            Vector vector2 = vector;
            if (vector2 != null) {
                this.annotationTypeComboBox = new JComboBox(vector2);
                this.annotationTypeComboBox.setSelectedItem(string5);
                jPanel2.add(jLabel2);
                jPanel2.add(this.annotationTypeComboBox);
                this.add(jPanel2);
            }
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            JLabel jLabel3 = new JLabel("1st Concept : ");
            jLabel3.setPreferredSize(jLabel.getPreferredSize());
            this.tissueOneNameField = new JTextField(25);
            jPanel3.add(jLabel3);
            jPanel3.add(this.tissueOneNameField);
            this.add(jPanel3);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 0));
            JLabel jLabel4 = new JLabel("2nd Concept : ");
            jLabel4.setPreferredSize(jLabel.getPreferredSize());
            this.tissueTwoNameField = new JTextField(25);
            jPanel4.add(jLabel4);
            jPanel4.add(this.tissueTwoNameField);
            this.add(jPanel4);
            JPanel jPanel5 = new JPanel(new BorderLayout());
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BoxLayout(jPanel6, 0));
            JLabel jLabel5 = new JLabel("Author Name : ");
            jLabel5.setPreferredSize(jLabel.getPreferredSize());
            this.authorNameField = new JTextField(25);
            this.authorNameField.setText(string3);
            jPanel6.add(jLabel5);
            jPanel6.add(this.authorNameField);
            this.add(jPanel6);
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout(new BoxLayout(jPanel7, 0));
            JLabel jLabel6 = new JLabel("Date : ");
            jLabel6.setPreferredSize(jLabel.getPreferredSize());
            this.dateTextField = new JFormattedTextField();
            jPanel7.add(jLabel6);
            jPanel7.add(this.dateTextField);
            this.dateTextField.setValue(string4);
            this.add(jPanel7);
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout(new BoxLayout(jPanel8, 0));
            JLabel jLabel7 = new JLabel("Annotation : ");
            jLabel7.setPreferredSize(jLabel.getPreferredSize());
            this.annotationTextArea = new JTextArea(6, 25);
            this.annotationTextArea.setBorder(this.tissueOneNameField.getBorder());
            jPanel8.add(jLabel7);
            jPanel8.add(this.annotationTextArea);
            this.annotationTextArea.setText(string2);
            this.add(jPanel8);
            this.setValues(goTerm2.getName(), goTerm3.getName());
            this.setBorder(BorderFactory.createEtchedBorder());
        }

        protected void setValues(String string, String string2) {
            this.tissueOneNameField.setText(string);
            this.tissueTwoNameField.setText(string2);
        }

        protected String getMessage() {
            String string = "";
            if (this.annotationNameField.getText().equals("")) {
                string = string + "No name for the annotation specified.";
            } else if (this.tissueOneNameField.getText().equals("")) {
                string = string + "No term for the first tissue is selected.";
            } else if (this.tissueTwoNameField.getText().equals("")) {
                string = string + "No term for the second tissue is selected.";
            }
            return string;
        }
    }
}

