/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.datamodels;

import java.util.StringTokenizer;
import org.xspan.applications.COBrA.datamodels.GoAssociation;
import org.xspan.applications.COBrA.datamodels.GoAssociationVector;
import org.xspan.applications.COBrA.datamodels.GoDbxref;
import org.xspan.applications.COBrA.datamodels.GoDbxrefVector;
import org.xspan.applications.COBrA.datamodels.GoHistory;
import org.xspan.applications.COBrA.datamodels.GoHistoryVector;
import org.xspan.applications.COBrA.datamodels.GoRelationship;
import org.xspan.applications.COBrA.datamodels.GoRelationshipVector;
import org.xspan.applications.COBrA.exceptions.InvalidParameterException;
import org.xspan.applications.COBrA.io.Namespace;
import org.xspan.applications.COBrA.util.StringVector;

public class GoTerm {
    protected String name;
    protected String id;
    protected String idPrefix;
    protected StringVector synonyms;
    protected String definition;
    protected GoDbxrefVector dbxrefs;
    protected GoAssociationVector associations;
    protected GoHistoryVector histories;
    protected GoRelationshipVector parents;
    protected GoRelationshipVector children;
    protected StringVector additionalIds;
    protected String namespace;
    protected String RDFType;
    protected String RDFTypeNameSpace;
    protected String n_associations;
    protected String accession;
    protected int hasStatus;
    protected String creator;
    protected String date;
    protected boolean customiseToStringMethod = true;
    protected boolean hasMapping = false;
    public static int DEFAULT = 0;
    public static int AUTOGEN = 1;
    public static int EXTERNAL = 2;

    public GoTerm(String string, String string2) throws InvalidParameterException {
        this.name = string;
        this.setGoId(string2);
        this.synonyms = new StringVector();
        this.dbxrefs = new GoDbxrefVector();
        this.associations = new GoAssociationVector();
        this.histories = new GoHistoryVector();
        this.parents = new GoRelationshipVector();
        this.children = new GoRelationshipVector();
        this.additionalIds = new StringVector();
        this.definition = "";
        this.creator = "";
        this.date = "";
        this.namespace = Namespace.DEFAULT_NAMESPACE;
        this.RDFType = Namespace.DEFAULT_RDFTYPE;
        this.RDFTypeNameSpace = Namespace.DEFAULT_PROPERTYNAMESPACE;
        this.n_associations = "";
        this.accession = "";
        this.hasStatus = DEFAULT;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setGoId(String string) throws InvalidParameterException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() != 2) {
            throw new InvalidParameterException("The argument is not a GoId.");
        }
        this.idPrefix = stringTokenizer.nextToken();
        this.id = stringTokenizer.nextToken();
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setNameSpace(String string) {
        this.namespace = string;
    }

    public String getNameSpace() {
        return this.namespace;
    }

    public void setRDFType(String string) {
        this.RDFType = string;
    }

    public String getRDFType() {
        return this.RDFType;
    }

    public void setRDFTypeNameSpace(String string) {
        this.RDFTypeNameSpace = string;
    }

    public String getRDFTypeNameSpace() {
        return this.RDFTypeNameSpace;
    }

    public void setCreator(String string) {
        this.creator = string;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setDate(String string) {
        this.date = string;
    }

    public String getDate() {
        return this.date;
    }

    public String getDefCreatorDate() {
        String string = "";
        if (!this.definition.equals("")) {
            string = this.definition;
        }
        if (!this.creator.equals("") && !this.date.equals("")) {
            string = string + "\n[creator: " + this.creator + " " + this.date + "]";
        } else {
            if (!this.creator.equals("")) {
                string = string + "\n[creator: " + this.creator + "]";
            }
            if (!this.date.equals("")) {
                string = string + "\n[date: " + this.date + "]";
            }
        }
        return string;
    }

    public void setIdPrefix(String string) {
        this.idPrefix = string;
    }

    public void setStatus(int n) {
        this.hasStatus = n == AUTOGEN ? AUTOGEN : (n == EXTERNAL ? EXTERNAL : DEFAULT);
    }

    public void addAdditionalId(String string) {
        this.additionalIds.addString(string);
    }

    public void addSynonym(String string) {
        this.synonyms.addString(string);
    }

    public void addDbxref(GoDbxref goDbxref) {
        this.dbxrefs.addDbxref(goDbxref);
    }

    public void addAssociation(GoAssociation goAssociation) {
        this.associations.addAssociation(goAssociation);
    }

    public void addHistory(GoHistory goHistory) {
        this.histories.addHistory(goHistory);
    }

    public void setDefinition(String string) {
        this.definition = string;
    }

    public void setN_Associations(String string) {
        this.n_associations = string;
    }

    public void setAccession(String string) {
        this.accession = string;
    }

    public void addParent(GoRelationship goRelationship) {
        this.parents.addRelationship(goRelationship);
    }

    public void addChild(GoRelationship goRelationship) {
        this.children.addRelationship(goRelationship);
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public int getIdAsInt() {
        int n = -1;
        try {
            n = Integer.parseInt(this.id);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Warning: a non-integer ID " + this.idPrefix + ":" + this.id);
        }
        return n;
    }

    public String getIdPrefix() {
        return this.idPrefix;
    }

    public GoRelationshipVector getParents() {
        return this.parents;
    }

    public void setParents(GoRelationshipVector goRelationshipVector) {
        this.parents = new GoRelationshipVector();
        for (int i = 0; i < goRelationshipVector.size(); ++i) {
            this.parents.addRelationship(goRelationshipVector.getRelationship(i));
        }
    }

    public GoRelationshipVector getChildren() {
        return this.children;
    }

    public void setChildren(GoRelationshipVector goRelationshipVector) {
        this.children = new GoRelationshipVector();
        for (int i = 0; i < goRelationshipVector.size(); ++i) {
            this.children.addRelationship(goRelationshipVector.getRelationship(i));
        }
    }

    public StringVector getAdditionalIds() {
        return this.additionalIds;
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getN_Associations() {
        return this.n_associations;
    }

    public String getAccession() {
        return this.accession;
    }

    public int getStatus() {
        return this.hasStatus;
    }

    public GoAssociationVector getAssociations() {
        return this.associations;
    }

    public GoHistoryVector getHistories() {
        return this.histories;
    }

    public StringVector getSynonyms() {
        return this.synonyms;
    }

    public GoDbxrefVector getDbxRefs() {
        return this.dbxrefs;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GoTerm)) {
            return false;
        }
        GoTerm goTerm = (GoTerm)object;
        return goTerm.getCompleteId().equals(this.getCompleteId());
    }

    public boolean isMapped() {
        return this.hasMapping;
    }

    public void setMapped(boolean bl) {
        this.hasMapping = bl;
    }

    public String toString() {
        if (this.customiseToStringMethod) {
            GoRelationship goRelationship;
            int n;
            String string = "";
            for (n = 0; n < this.parents.size(); ++n) {
                goRelationship = this.parents.getRelationship(n);
                if (!goRelationship.getRelationshipType().getRelationshipType().equals("startStage")) continue;
                string = string + goRelationship.getRelative().getName();
                break;
            }
            for (n = 0; n < this.parents.size(); ++n) {
                goRelationship = this.parents.getRelationship(n);
                if (!goRelationship.getRelationshipType().getRelationshipType().equals("endStage")) continue;
                String string2 = goRelationship.getRelative().getName();
                if (string.equals(string2)) break;
                int n2 = string2.indexOf("Stage");
                if (n2 > 0 && n2 + 5 < string2.length()) {
                    string = string + "-" + string2.substring(n2 + 5);
                    break;
                }
                string = string + "-" + string2;
                break;
            }
            if (!string.equals("")) {
                return this.mappedName() + " [" + string + "]";
            }
            return this.mappedName();
        }
        return this.mappedName();
    }

    private String mappedName() {
        if (this.hasMapping) {
            return "@" + this.name;
        }
        return this.name;
    }

    public String getCompleteId() {
        return this.idPrefix + ":" + this.id;
    }

    public boolean hasMultipleParents() {
        return this.parents.size() > 1;
    }

    public boolean hasParents() {
        if (this.parents.size() > 0) {
            for (int i = 0; i < this.parents.size(); ++i) {
                GoRelationship goRelationship = this.parents.getRelationship(i);
                String string = goRelationship.getRelationshipType().getRelationshipType();
                if (goRelationship.getRelative().getStatus() != DEFAULT || !string.equals("subClassOf") && !string.equals("partOf       ") && !string.equals("lineage     ")) continue;
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        try {
            int n;
            GoTerm goTerm = new GoTerm(this.name, this.getCompleteId());
            goTerm.setDefinition(this.definition);
            goTerm.setNameSpace(this.namespace);
            goTerm.setRDFType(this.RDFType);
            goTerm.setRDFTypeNameSpace(this.RDFTypeNameSpace);
            goTerm.setN_Associations(this.n_associations);
            goTerm.setAccession(this.accession);
            goTerm.setStatus(this.hasStatus);
            goTerm.setCreator(this.creator);
            goTerm.setDate(this.date);
            goTerm.setMapped(this.hasMapping);
            for (n = 0; n < this.additionalIds.size(); ++n) {
                goTerm.addAdditionalId(this.additionalIds.getString(n));
            }
            for (n = 0; n < this.associations.size(); ++n) {
                goTerm.addAssociation(this.associations.getAssociation(n));
            }
            for (n = 0; n < this.children.size(); ++n) {
                goTerm.addChild(this.children.getRelationship(n));
            }
            for (n = 0; n < this.dbxrefs.size(); ++n) {
                goTerm.addDbxref(this.dbxrefs.getDbxref(n));
            }
            for (n = 0; n < this.histories.size(); ++n) {
                goTerm.addHistory(this.histories.getHistory(n));
            }
            for (n = 0; n < this.parents.size(); ++n) {
                goTerm.addParent(this.parents.getRelationship(n));
            }
            for (n = 0; n < this.synonyms.size(); ++n) {
                goTerm.addSynonym(this.synonyms.getString(n));
            }
            return goTerm;
        }
        catch (InvalidParameterException invalidParameterException) {
            return null;
        }
    }

    public Object cloneWithoutRelatives() {
        try {
            int n;
            GoTerm goTerm = new GoTerm(this.name, this.getCompleteId());
            goTerm.setDefinition(this.definition);
            goTerm.setNameSpace(this.namespace);
            goTerm.setRDFType(this.RDFType);
            goTerm.setRDFTypeNameSpace(this.RDFTypeNameSpace);
            goTerm.setN_Associations(this.n_associations);
            goTerm.setAccession(this.accession);
            goTerm.setStatus(this.hasStatus);
            goTerm.setCreator(this.creator);
            goTerm.setDate(this.date);
            goTerm.setMapped(this.hasMapping);
            for (n = 0; n < this.additionalIds.size(); ++n) {
                goTerm.addAdditionalId(this.additionalIds.getString(n));
            }
            for (n = 0; n < this.associations.size(); ++n) {
                goTerm.addAssociation(this.associations.getAssociation(n));
            }
            for (n = 0; n < this.dbxrefs.size(); ++n) {
                goTerm.addDbxref(this.dbxrefs.getDbxref(n));
            }
            for (n = 0; n < this.histories.size(); ++n) {
                goTerm.addHistory(this.histories.getHistory(n));
            }
            for (n = 0; n < this.synonyms.size(); ++n) {
                goTerm.addSynonym(this.synonyms.getString(n));
            }
            return goTerm;
        }
        catch (InvalidParameterException invalidParameterException) {
            return null;
        }
    }
}

