/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.datamodels;

import java.util.Date;
import java.util.Vector;
import org.xspan.applications.COBrA.datamodels.GoTerm;

public class GoHistory {
    public static final int GO_TERM_CREATED = 0;
    public static final int GO_TERM_DELETED = 1;
    public static final int GO_TERM_SPLIT = 2;
    public static final int GO_TERM_MOVED = 3;
    public static final int GO_TERM_MERGED = 4;
    protected int historyType;
    protected boolean obsolet;
    protected Date date;
    protected String person;
    protected String rationale;
    protected GoTerm resource;

    public GoHistory(int n, Date date, String string, String string2, boolean bl) {
        this(n, date, string, string2, bl, null);
    }

    public GoHistory(int n, Date date, String string, String string2, boolean bl, GoTerm goTerm) {
        this.historyType = n;
        this.date = date;
        this.person = string;
        this.rationale = string2;
        this.obsolet = bl;
        this.resource = goTerm;
    }

    public int getHistoryType() {
        return this.historyType;
    }

    public boolean isHistoryType(int n) {
        return this.historyType == n;
    }

    public Date getDate() {
        return this.date;
    }

    public String getPerson() {
        return this.person;
    }

    public String getRationale() {
        return this.rationale;
    }

    public boolean isObsolet() {
        return this.obsolet;
    }

    public GoTerm getResource() {
        return this.resource;
    }

    public String toString() {
        return this.rationale;
    }

    public static Vector getHistoryTypes() {
        Vector<String> vector = new Vector<String>();
        vector.add("TERM CREATED");
        vector.add("TERM DELETED");
        vector.add("TERM SPLIT");
        vector.add("TERM MOVED");
        vector.add("TERM MERGED");
        return vector;
    }

    public String getHistoryTypeString() {
        return (String)GoHistory.getHistoryTypes().get(this.historyType);
    }

    public Vector getValueVector() {
        Vector vector = new Vector(6);
        vector.add(GoHistory.getHistoryTypes().get(this.historyType));
        vector.add(this.person);
        vector.add(this.date.toString());
        if (this.obsolet) {
            vector.add("YES");
        } else {
            vector.add("NO");
        }
        vector.add(this.rationale);
        if (this.resource == null) {
            vector.add("");
        } else {
            vector.add(this.resource.getCompleteId());
        }
        return vector;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GoHistory)) {
            return false;
        }
        GoHistory goHistory = (GoHistory)object;
        if (this.historyType != goHistory.historyType) {
            return false;
        }
        if (!this.person.equals(goHistory.person)) {
            return false;
        }
        if (!this.date.equals(goHistory.date)) {
            return false;
        }
        if (!this.rationale.equals(goHistory.rationale)) {
            return false;
        }
        return this.obsolet == goHistory.obsolet;
    }
}

