/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA.datamodels;

import java.util.HashMap;
import org.xspan.applications.COBrA.datamodels.GoOntology;
import org.xspan.applications.COBrA.datamodels.GoRelationship;
import org.xspan.applications.COBrA.datamodels.GoRelationshipType;
import org.xspan.applications.COBrA.datamodels.GoRelationshipVector;
import org.xspan.applications.COBrA.datamodels.GoTerm;
import org.xspan.applications.COBrA.exceptions.InvalidParameterException;
import org.xspan.applications.COBrA.gui.tree.DragAndDropTree;
import org.xspan.applications.COBrA.gui.tree.GoTermNode;
import org.xspan.applications.COBrA.gui.tree.GoTermTreeModel;

public class GoCellOntology
extends GoOntology {
    public static final String HOMOLOGY_NAME = "Homology";
    public static final String ANALOGY_NAME = "Analogy";
    public static final String ASSOCIATION_NAME = "Association";
    public static final String CELL_FUNCTION_HOMOLOGY_NAME = "Cell-Function-Homology";
    public static final String TISSUE_HOMOLOGY_NAME = "Tissue-Homology";
    public static final String HOMOLOGY_ID = "CL:0010000";
    public static final String ANALOGY_ID = "CL:0010001";
    public static final String ASSOCIATION_ID = "CL:0010002";
    public static final String CELL_FUNCTION_HOMOLOGY_ID = "CL:0010003";
    public static final String TISSUE_HOMOLOGY_ID = "CL:0010004";
    HashMap relationshipTypes;
    DragAndDropTree cellOntologyTree;
    GoRelationship homology;
    GoRelationship analogy;
    GoRelationship association;
    GoRelationship cellFunctionHomology;
    GoRelationship tissueHomology;
    int lastIdNumber = 10004;

    public GoCellOntology(HashMap hashMap, DragAndDropTree dragAndDropTree) {
        this.relationshipTypes = hashMap;
        this.cellOntologyTree = dragAndDropTree;
    }

    public boolean hasHomologyStructure() {
        if (this.homology != null) {
            return true;
        }
        for (int i = 0; i < this.rootTerm.getChildren().size(); ++i) {
            GoTerm goTerm = this.rootTerm.getChildren().getRelationship(i).getRelative();
            if (!goTerm.getName().equals(HOMOLOGY_NAME)) continue;
            for (int j = 0; j < goTerm.getChildren().size(); ++j) {
                GoTerm goTerm2 = goTerm.getChildren().getRelationship(j).getRelative();
                if (!goTerm2.getName().equals(ANALOGY_NAME)) continue;
                for (int k = 0; k < goTerm.getChildren().size(); ++k) {
                    GoTerm goTerm3 = goTerm.getChildren().getRelationship(k).getRelative();
                    if (!goTerm3.getName().equals(ASSOCIATION_NAME)) continue;
                    for (int i2 = 0; i2 < goTerm.getChildren().size(); ++i2) {
                        GoTerm goTerm4 = goTerm.getChildren().getRelationship(i2).getRelative();
                        if (!goTerm4.getName().equals(CELL_FUNCTION_HOMOLOGY_NAME)) continue;
                        for (int i3 = 0; i3 < goTerm.getChildren().size(); ++i3) {
                            GoTerm goTerm5 = goTerm.getChildren().getRelationship(i3).getRelative();
                            if (!goTerm5.getName().equals(TISSUE_HOMOLOGY_NAME)) continue;
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public void setHomologyStructure() {
        GoRelationshipVector goRelationshipVector = this.rootTerm.getChildren();
        for (int i = 0; i < goRelationshipVector.size(); ++i) {
            if (!goRelationshipVector.getRelationship(i).getRelative().getCompleteId().equals(HOMOLOGY_ID)) continue;
            this.homology = goRelationshipVector.getRelationship(i);
            goRelationshipVector = this.homology.getRelative().getChildren();
            for (int j = 0; j < goRelationshipVector.size(); ++j) {
                if (goRelationshipVector.getRelationship(j).getRelative().getCompleteId().equals(ANALOGY_ID)) {
                    this.analogy = goRelationshipVector.getRelationship(j);
                }
                if (goRelationshipVector.getRelationship(j).getRelative().getCompleteId().equals(ASSOCIATION_ID)) {
                    this.association = goRelationshipVector.getRelationship(j);
                }
                if (goRelationshipVector.getRelationship(j).getRelative().getCompleteId().equals(CELL_FUNCTION_HOMOLOGY_ID)) {
                    this.cellFunctionHomology = goRelationshipVector.getRelationship(j);
                }
                if (!goRelationshipVector.getRelationship(j).getRelative().getCompleteId().equals(TISSUE_HOMOLOGY_ID)) continue;
                this.tissueHomology = goRelationshipVector.getRelationship(j);
            }
        }
    }

    public void createNewHomologyStructure() {
        if (!this.hasHomologyStructure()) {
            try {
                GoTermTreeModel goTermTreeModel = (GoTermTreeModel)this.cellOntologyTree.getModel();
                this.homology = new GoRelationship(new GoTerm(HOMOLOGY_NAME, HOMOLOGY_ID), (GoRelationshipType)this.relationshipTypes.get("%"));
                this.rootTerm.getChildren().addRelationship(this.homology);
                GoTermNode goTermNode = (GoTermNode)goTermTreeModel.getRoot();
                GoTermNode goTermNode2 = new GoTermNode(this.homology);
                goTermTreeModel.insertNodeInto(goTermNode2, goTermNode, goTermNode.getChildCount());
                this.analogy = new GoRelationship(new GoTerm(ANALOGY_NAME, ANALOGY_ID), (GoRelationshipType)this.relationshipTypes.get("%"));
                this.homology.getRelative().getChildren().addRelationship(this.analogy);
                GoTermNode goTermNode3 = new GoTermNode(this.analogy);
                goTermTreeModel.insertNodeInto(goTermNode3, goTermNode2, goTermNode2.getChildCount());
                this.association = new GoRelationship(new GoTerm(ASSOCIATION_NAME, ASSOCIATION_ID), (GoRelationshipType)this.relationshipTypes.get("%"));
                this.homology.getRelative().getChildren().addRelationship(this.association);
                GoTermNode goTermNode4 = new GoTermNode(this.association);
                goTermTreeModel.insertNodeInto(goTermNode4, goTermNode2, goTermNode2.getChildCount());
                this.cellFunctionHomology = new GoRelationship(new GoTerm(CELL_FUNCTION_HOMOLOGY_NAME, CELL_FUNCTION_HOMOLOGY_ID), (GoRelationshipType)this.relationshipTypes.get("%"));
                this.homology.getRelative().getChildren().addRelationship(this.cellFunctionHomology);
                GoTermNode goTermNode5 = new GoTermNode(this.cellFunctionHomology);
                goTermTreeModel.insertNodeInto(goTermNode5, goTermNode2, goTermNode2.getChildCount());
                this.tissueHomology = new GoRelationship(new GoTerm(TISSUE_HOMOLOGY_NAME, TISSUE_HOMOLOGY_ID), (GoRelationshipType)this.relationshipTypes.get("%"));
                this.homology.getRelative().getChildren().addRelationship(this.tissueHomology);
                GoTermNode goTermNode6 = new GoTermNode(this.tissueHomology);
                goTermTreeModel.insertNodeInto(goTermNode6, goTermNode2, goTermNode2.getChildCount());
                this.lastIdNumber = 10004;
            }
            catch (InvalidParameterException invalidParameterException) {
                // empty catch block
            }
        }
    }

    public void findLastId() {
        for (int i = 0; i < this.homology.getRelative().getChildren().size(); ++i) {
            this.findLastId(this.homology.getRelative().getChildren().getRelationship(i).getRelative());
            if (this.homology.getRelative().getChildren().getRelationship(i).getRelative().getIdAsInt() <= this.lastIdNumber) continue;
            this.lastIdNumber = this.homology.getRelative().getChildren().getRelationship(i).getRelative().getIdAsInt();
        }
    }

    protected void findLastId(GoTerm goTerm) {
        for (int i = 0; i < goTerm.getChildren().size(); ++i) {
            this.findLastId(goTerm.getChildren().getRelationship(i).getRelative());
            if (goTerm.getChildren().getRelationship(i).getRelative().getIdAsInt() <= this.lastIdNumber) continue;
            this.lastIdNumber = goTerm.getChildren().getRelationship(i).getRelative().getIdAsInt();
        }
    }

    public int getLastId() {
        return this.lastIdNumber;
    }

    public GoRelationship getAnalogy() {
        return this.analogy;
    }

    public GoRelationship getAssociation() {
        return this.association;
    }

    public GoRelationship getCellFunctionHomology() {
        return this.cellFunctionHomology;
    }

    public GoRelationship getTissueHomology() {
        return this.tissueHomology;
    }

    public GoRelationship getHomology() {
        return this.homology;
    }

    public GoRelationshipType getRelationshipTypeFor(String string) {
        return (GoRelationshipType)this.relationshipTypes.get(string);
    }

    public void increaseLastId() {
        ++this.lastIdNumber;
    }
}

