/*
 * Decompiled with CFR 0.152.
 */
package org.xspan.applications.COBrA;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.xspan.applications.COBrA.SwingWorker;
import org.xspan.applications.COBrA.datamodels.GoOntology;
import org.xspan.applications.COBrA.datamodels.GoRelationship;
import org.xspan.applications.COBrA.datamodels.GoRelationshipType;
import org.xspan.applications.COBrA.datamodels.GoTerm;
import org.xspan.applications.COBrA.gui.AboutBox;
import org.xspan.applications.COBrA.gui.AnnotationEditorDialog;
import org.xspan.applications.COBrA.gui.AnnotationEditorSimpleDialog;
import org.xspan.applications.COBrA.gui.ChooseFromTreeDialog;
import org.xspan.applications.COBrA.gui.NamespaceDialog;
import org.xspan.applications.COBrA.gui.OntologyNodeBasedPanel;
import org.xspan.applications.COBrA.gui.OntologyTreePanel;
import org.xspan.applications.COBrA.gui.OntologyViewPanel;
import org.xspan.applications.COBrA.gui.ShowRelationshipTypesDialog;
import org.xspan.applications.COBrA.gui.TextBox;
import org.xspan.applications.COBrA.gui.UserProfileDialog;
import org.xspan.applications.COBrA.gui.tree.GoTermNode;
import org.xspan.applications.COBrA.gui.tree.GoTermTreeModel;
import org.xspan.applications.COBrA.io.DAGEditReader;
import org.xspan.applications.COBrA.io.GoFlatFileReader;
import org.xspan.applications.COBrA.io.GoFlatFileWriter;
import org.xspan.applications.COBrA.io.GoReader;
import org.xspan.applications.COBrA.io.GoWriter;
import org.xspan.applications.COBrA.io.GoXMLReader;
import org.xspan.applications.COBrA.io.GoXMLWriter;
import org.xspan.applications.COBrA.logging.LoggerCreator;
import org.xspan.applications.COBrA.logging.TaskGenerator;
import org.xspan.applications.COBrA.sweb.OWLTools;
import org.xspan.applications.COBrA.sweb.RDFSTools;
import org.xspan.applications.COBrA.sweb.RDFTools;
import org.xspan.applications.COBrA.sweb.SWEBTools;
import org.xspan.applications.COBrA.util.HTMLPanel;
import org.xspan.applications.COBrA.util.Resources;
import org.xspan.applications.COBrA.util.UserProfile;

public class COBrA
extends JFrame {
    public static String versionNo = "1.16";
    public static String altURL = "http://www.xspan.org";
    public static String GO_FLAT = "GO flat file format";
    public static String DEDIT_FLAT = "DAGEdit flat file format";
    public static String GO_XML = "XML/RDF defined by GENEONTOLOGY.ORG";
    public static String GO_RDF = "RDF defined by GENEONTOLOGY.ORG";
    public static String XSPAN_RDFS = "RDFS defined by XSPAN.ORG";
    public static String XSPAN_OWL = "OWL defined by XSPAN.ORG";
    public static String GO_OWL = "OWL defined by GENEONTOLOGY.ORG";
    public static String[] FILE_READ_TYPES = new String[]{".xml", ".rdf", ".rdfs", ".owl"};
    public static int FILE_READ_COUNT = 4;
    public static String[] FILE_READ_INFO = new String[]{GO_XML, GO_RDF, XSPAN_RDFS, XSPAN_OWL};
    public static String[] FILE_WRITE_TYPES = new String[]{".owl", ".rdfs", ".rdf"};
    public static int FILE_WRITE_COUNT = 3;
    public static String[] FILE_WRITE_INFO = new String[]{XSPAN_OWL, XSPAN_RDFS, GO_RDF};
    protected JMenuBar menuBar;
    protected JToolBar toolBar;
    protected JPanel mainPanel;
    protected JSplitPane splitedOntologyPanel;
    protected File lastDirectory;
    protected JPanel buttomPanel;
    protected JPanel statusPanel;
    protected JLabel statusLabel;
    protected JProgressBar readWriteStatusBar;
    protected HashMap relationshipTypes;
    protected GoReader ontologyFileReader;
    protected GoWriter ontologyFileWriter;
    protected GoOntology leftOntology;
    protected GoOntology rightOntology;
    protected GoOntology mappingOntology;
    protected GoOntology referenceOntology;
    protected OntologyTreePanel leftOntologyTreePanel;
    protected OntologyTreePanel rightOntologyTreePanel;
    protected OntologyNodeBasedPanel leftOntologyNodeBasedPanel;
    protected OntologyNodeBasedPanel rightOntologyNodeBasedPanel;
    protected ChooseFromTreeDialog mappingOntologyDialog;
    protected ChooseFromTreeDialog referenceOntologyDialog;
    Vector viewPanelVectorLeft;
    Vector viewPanelVectorRight;
    JTabbedPane leftTabPane;
    JTabbedPane rightTabPane;
    JMenu visibleRelationshipTypesRightMenu;
    JMenu visibleRelationshipTypesLeftMenu;
    JTabbedPaneSelectionChangeListener tabChangeListener;
    boolean rightOntologyRead = false;
    boolean leftOntologyRead = false;
    protected JButton makeAnnotationButton;
    protected JButton saveRightButton;
    protected JButton saveLeftButton;
    protected JButton saveAsRightButton;
    protected JButton saveAsLeftButton;
    JCheckBoxMenuItem useReferenceMenuItem;
    protected File leftOntologyFile;
    protected String leftOntologyFileType;
    protected File rightOntologyFile;
    protected String rightOntologyFileType;
    protected File mappingOntologyFile;
    protected String mappingOntologyFileType;
    protected File referenceOntologyFile;
    protected boolean doTask = false;
    protected Vector mappingTypesConfig;
    protected String PREFIX;
    protected UserProfile userProfile;
    protected String ruleset;
    protected Vector activeToolBarComponents = new Vector();

    public COBrA(boolean bl) {
        super("COBrA");
        this.userProfile = new UserProfile();
        this.mappingTypesConfig = new Vector();
        this.mappingTypesConfig.addElement("CommonLineageHomology");
        this.mappingTypesConfig.addElement("EvolutionaryHomology");
        this.mappingTypesConfig.addElement("Analogy");
        this.mappingTypesConfig.addElement("CellTypeHomology");
        this.mappingTypesConfig.addElement("Association");
        this.ruleset = "[rule1:(?a http://www.geneontology.org/dtds/go.dtd#is_a ?b)\n (?b http://www.geneontology.org/dtds/go.dtd#is_a ?c)\n ->(?a http://www.geneontology.org/dtds/go.dtd#is_a ?c)]";
        if (bl) {
            this.doTask = true;
        }
        this.setIconImage(Resources.getCOBrAIcon().getImage());
        this.mainPanel = new JPanel(new BorderLayout());
        this.relationshipTypes = new HashMap();
        GoRelationshipType goRelationshipType = new GoRelationshipType(Resources.getIsaIcon(), Resources.getIsaMultiIcon(), "subClassOf");
        this.relationshipTypes.put("%", goRelationshipType);
        GoRelationshipType goRelationshipType2 = new GoRelationshipType(Resources.getPartOfIcon(), Resources.getPartOfMultiIcon(), "partOf       ");
        this.relationshipTypes.put("<", goRelationshipType2);
        GoRelationshipType goRelationshipType3 = new GoRelationshipType(Resources.getSubEventOfIcon(), Resources.getSubEventOfMultiIcon(), "subEventOf");
        this.relationshipTypes.put("@", goRelationshipType3);
        GoRelationshipType goRelationshipType4 = new GoRelationshipType(Resources.getLineageIcon(), Resources.getLineageMultiIcon(), "lineage     ");
        this.relationshipTypes.put("~", goRelationshipType4);
        GoRelationshipType goRelationshipType5 = new GoRelationshipType(Resources.getHomologyCellTypeIcon(), Resources.getHomologyCellTypeIcon(), "isReferenceForMapping");
        this.relationshipTypes.put("#", goRelationshipType5);
        GoRelationshipType goRelationshipType6 = new GoRelationshipType(Resources.getHomologyTissueTypeIcon(), Resources.getHomologyTissueTypeIcon(), "hasMapping");
        this.relationshipTypes.put("^", goRelationshipType6);
        GoRelationshipType goRelationshipType7 = new GoRelationshipType("startStage", Color.black, Color.white);
        this.relationshipTypes.put("{", goRelationshipType7);
        GoRelationshipType goRelationshipType8 = new GoRelationshipType("endStage", Color.black, Color.white);
        this.relationshipTypes.put("}", goRelationshipType8);
        GoRelationshipType goRelationshipType9 = new GoRelationshipType("instanceOf", Color.blue, Color.white);
        this.relationshipTypes.put(".", goRelationshipType9);
        Vector<GoRelationshipType> vector = new Vector<GoRelationshipType>();
        vector.add(goRelationshipType);
        vector.add(goRelationshipType2);
        vector.add(goRelationshipType3);
        vector.add(goRelationshipType4);
        vector.add(goRelationshipType7);
        vector.add(goRelationshipType8);
        vector.add(goRelationshipType9);
        this.tabChangeListener = new JTabbedPaneSelectionChangeListener();
        this.leftTabPane = new JTabbedPane();
        this.leftTabPane.addChangeListener(this.tabChangeListener);
        this.rightTabPane = new JTabbedPane();
        this.rightTabPane.addChangeListener(this.tabChangeListener);
        this.leftOntologyTreePanel = new OntologyTreePanel(vector, true);
        this.leftOntologyTreePanel.setUserProfile(this.userProfile);
        this.rightOntologyTreePanel = new OntologyTreePanel(vector, true);
        this.rightOntologyTreePanel.setUserProfile(this.userProfile);
        this.leftOntology = new GoOntology();
        this.leftOntologyNodeBasedPanel = new OntologyNodeBasedPanel();
        this.leftOntologyTreePanel.addTreeSelectionListener(this.leftOntologyNodeBasedPanel);
        this.leftOntologyNodeBasedPanel.addListener(this.leftOntologyTreePanel);
        this.rightOntology = new GoOntology();
        this.rightOntologyNodeBasedPanel = new OntologyNodeBasedPanel();
        this.rightOntologyTreePanel.addTreeSelectionListener(this.rightOntologyNodeBasedPanel);
        this.rightOntologyNodeBasedPanel.addListener(this.rightOntologyTreePanel);
        this.viewPanelVectorLeft = new Vector(4);
        this.viewPanelVectorRight = new Vector(4);
        this.viewPanelVectorLeft.add(this.leftOntologyTreePanel);
        this.viewPanelVectorLeft.add(this.leftOntologyNodeBasedPanel);
        this.viewPanelVectorLeft.add(this.rightOntologyTreePanel);
        this.viewPanelVectorLeft.add(this.rightOntologyNodeBasedPanel);
        this.viewPanelVectorRight.add(this.rightOntologyTreePanel);
        this.viewPanelVectorRight.add(this.rightOntologyNodeBasedPanel);
        this.viewPanelVectorRight.add(this.leftOntologyTreePanel);
        this.viewPanelVectorRight.add(this.leftOntologyNodeBasedPanel);
        this.splitedOntologyPanel = new JSplitPane(1, this.leftTabPane, this.rightTabPane);
        this.splitedOntologyPanel.setOneTouchExpandable(true);
        this.buttomPanel = new JPanel(new BorderLayout());
        this.statusPanel = new JPanel();
        this.statusPanel.setLayout(new BoxLayout(this.statusPanel, 0));
        JLabel jLabel = new JLabel("Status : ");
        jLabel.setEnabled(false);
        this.statusPanel.add(jLabel);
        this.statusLabel = new JLabel("Initialised");
        this.statusPanel.add(this.statusLabel);
        this.statusPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.readWriteStatusBar = new JProgressBar();
        this.readWriteStatusBar.setStringPainted(true);
        this.buttomPanel.add(this.statusPanel);
        this.lastDirectory = new File(System.getProperty("user.home"));
        this.makeAnnotationButton = new JButton(" Annotate ", Resources.getAnnotationIcon());
        this.makeAnnotationButton.addActionListener(new MakeAnnotationAction());
        this.makeAnnotationButton.setToolTipText("Make annotation");
        this.makeAnnotationButton.setEnabled(false);
        this.makeAnnotationButton.setForeground(Color.BLUE);
        this.createMenuBar();
        this.createToolBar();
        this.getContentPane().add((Component)this.splitedOntologyPanel, "Center");
        this.getContentPane().add((Component)this.buttomPanel, "South");
        this.mappingOntologyFile = null;
        this.referenceOntologyFile = null;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                COBrA.this.closeFrame("Really Exit?");
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                COBrA.this.splitedOntologyPanel.setDividerLocation(0.5);
            }
        });
        this.pack();
        this.setSize(900, 600);
        this.setVisible(true);
    }

    protected void closeFrame(String string) {
        int n = JOptionPane.showOptionDialog(this, string, "Exit Confirmation", 0, 3, null, null, null);
        if (n == 0) {
            String string2 = "";
            if (this.leftOntology != null && !this.leftOntologyTreePanel.getIsSaved()) {
                string2 = string2 + " the Left ontology;\n";
            }
            if (this.rightOntology != null && !this.rightOntologyTreePanel.getIsSaved()) {
                string2 = string2 + " the Right ontology;\n";
            }
            if (this.mappingOntology != null && !this.mappingOntologyDialog.getIsSaved()) {
                string2 = string2 + " the Mapping ontology;\n";
            }
            if (!string2.equals("")) {
                string2 = "There are unsaved changes to:\n" + string2 + "Quit anyway ?";
                int n2 = JOptionPane.showOptionDialog(this, string2, "Unsaved Changes", 0, 3, null, null, null);
                if (n2 == 0) {
                    this.exit();
                }
            } else {
                this.exit();
            }
        }
    }

    protected void closeFrameOK(String string) {
        JOptionPane.showMessageDialog(this, string, "Warning", 1);
    }

    protected void openUser() {
        UserProfileDialog userProfileDialog = new UserProfileDialog(this, this.userProfile);
        userProfileDialog.setVisible(true);
        this.leftOntologyTreePanel.setUserProfile(this.userProfile);
        this.rightOntologyTreePanel.setUserProfile(this.userProfile);
    }

    protected synchronized void exit() {
        this.dispose();
        System.exit(0);
    }

    protected void createToolBar() {
        this.toolBar = new JToolBar();
        JButton jButton = new JButton("Left", Resources.getReadLeftIcon());
        jButton.addActionListener(new ReadOntologyActionListener("Open File", this.leftOntology, 0));
        jButton.setToolTipText("Load left Ontology");
        this.toolBar.add(jButton);
        this.saveLeftButton = new JButton(Resources.getSaveLeftIcon());
        this.saveAsLeftButton = new JButton(Resources.getSaveAsLeftIcon());
        this.toolBar.addSeparator();
        JButton jButton2 = new JButton("Right", Resources.getReadRightIcon());
        jButton2.addActionListener(new ReadOntologyActionListener("Open File", this.rightOntology, 1));
        jButton2.setToolTipText("Load right Ontology");
        this.toolBar.add(jButton2);
        JButton jButton3 = new JButton("Mapping Ontology", Resources.getCellOntologyIcon());
        jButton3.setToolTipText("Show Mapping Ontology");
        jButton3.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (COBrA.this.mappingOntologyFile == null) {
                    COBrA.this.readOntology(2);
                }
                if (COBrA.this.mappingOntologyFile != null) {
                    COBrA.this.mappingOntologyDialog.setVisible(true);
                }
                JOptionPane.showMessageDialog(COBrA.this, "Check that the ID prefix in User Profile is correct", "Warning", 1);
            }
        });
        this.toolBar.add(jButton3);
        this.toolBar.addSeparator();
        JButton jButton4 = new JButton("Reference Ontology", Resources.getCellOntologyIcon());
        jButton4.setToolTipText("Show Reference Ontology");
        jButton4.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (COBrA.this.referenceOntologyFile == null) {
                    COBrA.this.readOntology(3);
                }
                if (COBrA.this.referenceOntologyFile != null) {
                    COBrA.this.referenceOntologyDialog.setVisible(true);
                }
            }
        });
        this.toolBar.add(jButton4);
        this.toolBar.addSeparator();
        this.saveRightButton = new JButton(Resources.getSaveRightIcon());
        this.saveAsRightButton = new JButton(Resources.getSaveAsRightIcon());
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.toolBar.add(this.makeAnnotationButton);
        this.getContentPane().add((Component)this.toolBar, "North");
    }

    protected void createMenuBar() {
        JMenuItem jMenuItem;
        Object object;
        Object object2;
        this.menuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        this.menuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Left Ontology");
        jMenu2.setIcon(Resources.getLeftSiteFileIcon());
        jMenu.add(jMenu2);
        JMenuItem jMenuItem2 = new JMenuItem("Create New Ontology");
        jMenuItem2.setIcon(Resources.getReadLeftIcon());
        jMenuItem2.addActionListener(new ReadOntologyActionListener("New ontology", this.leftOntology, 0, 6));
        jMenu2.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Open Left Ontology");
        jMenuItem3.setMnemonic(76);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(76, 8));
        jMenuItem3.addActionListener(new ReadOntologyActionListener("Open File", this.leftOntology, 0));
        jMenuItem3.setIcon(Resources.getReadLeftIcon());
        jMenu2.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Save Left Ontology");
        jMenuItem4.addActionListener(new WriteActionListener(0, 0));
        jMenuItem4.setIcon(Resources.getSaveLeftIcon());
        jMenu2.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Save Left Ontology As");
        jMenuItem5.addActionListener(new WriteActionListener(0, 1));
        jMenuItem5.setIcon(Resources.getSaveAsLeftIcon());
        jMenu2.add(jMenuItem5);
        JMenu jMenu3 = new JMenu("Right Ontology");
        jMenu3.setIcon(Resources.getRightSiteFileIcon());
        jMenu.add(jMenu3);
        JMenuItem jMenuItem6 = new JMenuItem("Create New Ontology");
        jMenuItem6.setIcon(Resources.getReadLeftIcon());
        jMenuItem6.addActionListener(new ReadOntologyActionListener("New ontology", this.rightOntology, 1, 6));
        jMenu3.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem("Open Right Ontology");
        jMenuItem7.setMnemonic(82);
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(82, 8));
        jMenuItem7.addActionListener(new ReadOntologyActionListener("Open File", this.rightOntology, 1));
        jMenuItem7.setIcon(Resources.getReadRightIcon());
        jMenu3.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem("Save Right Ontology");
        jMenuItem8.addActionListener(new WriteActionListener(1, 0));
        jMenuItem8.setIcon(Resources.getSaveRightIcon());
        jMenu3.add(jMenuItem8);
        JMenuItem jMenuItem9 = new JMenuItem("Save Right Ontology As");
        jMenuItem9.addActionListener(new WriteActionListener(1, 1));
        jMenuItem9.setIcon(Resources.getSaveAsRightIcon());
        jMenu3.add(jMenuItem9);
        JMenu jMenu4 = new JMenu("Mapping Ontology");
        jMenu4.setIcon(Resources.getRightSiteFileIcon());
        jMenu.add(jMenu4);
        JMenuItem jMenuItem10 = new JMenuItem("Create New Ontology");
        jMenuItem10.setIcon(Resources.getReadLeftIcon());
        jMenuItem10.setIcon(Resources.getReadRightIcon());
        jMenu4.add(jMenuItem10);
        jMenuItem10.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                COBrA.this.newMappingOntology();
                COBrA.this.mappingOntologyDialog.setVisible(true);
                JOptionPane.showMessageDialog(COBrA.this, "Check that the ID prefix in User Profile is correct", "Warning", 1);
            }
        });
        JMenuItem jMenuItem11 = new JMenuItem("Open Mapping Ontology");
        jMenuItem11.setIcon(Resources.getReadRightIcon());
        jMenu4.add(jMenuItem11);
        jMenuItem11.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                COBrA.this.readOntology(2);
                if (COBrA.this.mappingOntologyFile != null) {
                    COBrA.this.mappingOntologyDialog.setVisible(true);
                }
                JOptionPane.showMessageDialog(COBrA.this, "Check that the ID prefix in User Profile is correct", "Warning", 1);
            }
        });
        JMenuItem jMenuItem12 = new JMenuItem("Save Mapping Ontology");
        jMenuItem12.addActionListener(new WriteActionListener(2, 0));
        jMenuItem12.setIcon(Resources.getSaveRightIcon());
        jMenu4.add(jMenuItem12);
        JMenuItem jMenuItem13 = new JMenuItem("Save Mapping Ontology As");
        jMenuItem13.addActionListener(new WriteActionListener(2, 1));
        jMenuItem13.setIcon(Resources.getSaveAsRightIcon());
        jMenu4.add(jMenuItem13);
        JMenu jMenu5 = new JMenu("Reference Ontology");
        jMenu5.setIcon(Resources.getRightSiteFileIcon());
        jMenu.add(jMenu5);
        this.useReferenceMenuItem = new JCheckBoxMenuItem("Use Reference Ontology?");
        this.useReferenceMenuItem.setSelected(false);
        jMenu5.add(this.useReferenceMenuItem);
        this.useReferenceMenuItem.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (COBrA.this.useReferenceMenuItem.getState()) {
                    COBrA.this.readOntology(3);
                    if (COBrA.this.referenceOntologyFile != null) {
                        COBrA.this.referenceOntologyDialog.setVisible(true);
                        COBrA.this.useReferenceMenuItem.setSelected(true);
                    } else {
                        COBrA.this.useReferenceMenuItem.setSelected(false);
                    }
                }
            }
        });
        JMenuItem jMenuItem14 = new JMenuItem("Open Reference Ontology");
        jMenuItem14.setIcon(Resources.getReadRightIcon());
        jMenu5.add(jMenuItem14);
        jMenuItem14.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                COBrA.this.readOntology(3);
                if (COBrA.this.referenceOntologyFile != null) {
                    COBrA.this.referenceOntologyDialog.setVisible(true);
                    COBrA.this.useReferenceMenuItem.setSelected(true);
                }
            }
        });
        JMenuItem jMenuItem15 = new JMenuItem("Edit User Profile");
        jMenuItem15.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                COBrA.this.openUser();
            }
        });
        jMenuItem15.setIcon(Resources.getCOBrAIcon());
        jMenu.add(jMenuItem15);
        JMenuItem jMenuItem16 = new JMenuItem("Exit");
        jMenuItem16.setMnemonic(69);
        jMenuItem16.setAccelerator(KeyStroke.getKeyStroke(69, 8));
        jMenuItem16.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                COBrA.this.closeFrame("Really Exit?");
            }
        });
        jMenuItem16.setIcon(Resources.getExitIcon());
        jMenu.add(jMenuItem16);
        JMenu jMenu6 = new JMenu("Edit");
        jMenu6.setMnemonic(86);
        this.menuBar.add(jMenu6);
        JMenuItem jMenuItem17 = new JMenuItem("Paste Selection from Right to Left");
        jMenu6.add(jMenuItem17);
        jMenuItem17.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                GoRelationship goRelationship = COBrA.this.rightOntologyTreePanel.getClipboardContents();
                if (goRelationship == null) {
                    JOptionPane.showMessageDialog(COBrA.this, "First Copy a term in the Right ontology", "Error", 0);
                } else {
                    COBrA.this.leftOntologyTreePanel.pasteTerm(goRelationship);
                }
            }
        });
        JMenuItem jMenuItem18 = new JMenuItem("Paste Selection from Left to Right");
        jMenu6.add(jMenuItem18);
        jMenuItem18.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                GoRelationship goRelationship = COBrA.this.leftOntologyTreePanel.getClipboardContents();
                if (goRelationship == null) {
                    JOptionPane.showMessageDialog(COBrA.this, "First Copy a term in the Left ontology", "Error", 0);
                } else {
                    COBrA.this.rightOntologyTreePanel.pasteTerm(goRelationship);
                }
            }
        });
        JMenuItem jMenuItem19 = new JMenuItem("Search and Replace Namespace Left");
        jMenu6.add(jMenuItem19);
        jMenuItem19.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (COBrA.this.leftOntology == null) {
                    return;
                }
                NamespaceDialog namespaceDialog = new NamespaceDialog(COBrA.this);
                namespaceDialog.setVisible(true);
                String string = namespaceDialog.getOldNamespace();
                String string2 = namespaceDialog.getNewNamespace();
                COBrA.this.leftOntologyTreePanel.replaceNamespace(string, string2);
            }
        });
        JMenuItem jMenuItem20 = new JMenuItem("Search and Replace Namespace Right");
        jMenu6.add(jMenuItem20);
        jMenuItem20.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (COBrA.this.rightOntology == null) {
                    return;
                }
                NamespaceDialog namespaceDialog = new NamespaceDialog(COBrA.this);
                namespaceDialog.setVisible(true);
                String string = namespaceDialog.getOldNamespace();
                String string2 = namespaceDialog.getNewNamespace();
                COBrA.this.rightOntologyTreePanel.replaceNamespace(string, string2);
            }
        });
        this.visibleRelationshipTypesLeftMenu = new JMenu("Relationship Types Left");
        this.visibleRelationshipTypesLeftMenu.setIcon(Resources.getLeftSiteRelationshipIcon());
        jMenu6.add(this.visibleRelationshipTypesLeftMenu);
        Iterator iterator = this.relationshipTypes.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = (GoRelationshipType)this.relationshipTypes.get(object2);
            jMenuItem = new JCheckBoxMenuItem(((GoRelationshipType)object).getRelationshipType(), ((GoRelationshipType)object).getIcon());
            jMenuItem.setSelected(true);
            jMenuItem.addActionListener(new HideActionListener((GoRelationshipType)object, this.leftOntologyTreePanel, this.leftOntologyNodeBasedPanel));
            this.visibleRelationshipTypesLeftMenu.add(jMenuItem);
        }
        this.visibleRelationshipTypesRightMenu = new JMenu("Relationship Types Right");
        this.visibleRelationshipTypesRightMenu.setIcon(Resources.getRightSiteRelationshipIcon());
        jMenu6.add(this.visibleRelationshipTypesRightMenu);
        iterator = this.relationshipTypes.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = (GoRelationshipType)this.relationshipTypes.get(object2);
            jMenuItem = new JCheckBoxMenuItem(((GoRelationshipType)object).getRelationshipType(), ((GoRelationshipType)object).getIcon());
            jMenuItem.setSelected(true);
            jMenuItem.addActionListener(new HideActionListener((GoRelationshipType)object, this.rightOntologyTreePanel, this.rightOntologyNodeBasedPanel));
            this.visibleRelationshipTypesRightMenu.add(jMenuItem);
        }
        object2 = new JMenu("Tools");
        this.menuBar.add((JMenu)object2);
        object = new JMenuItem("Show Mapped Terms (@) Left");
        ((JMenu)object2).add((JMenuItem)object);
        ((AbstractButton)object).addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (COBrA.this.leftOntology == null || COBrA.this.mappingOntology == null) {
                    JOptionPane.showMessageDialog(COBrA.this, "First load Left and Mapping ontologies", "Error", 0);
                } else {
                    COBrA.this.showMappings(COBrA.this.leftOntology, COBrA.this.mappingOntology);
                }
            }
        });
        jMenuItem = new JMenuItem("Show Mapped Terms (@) Right");
        ((JMenu)object2).add(jMenuItem);
        jMenuItem.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (COBrA.this.leftOntology == null || COBrA.this.mappingOntology == null) {
                    JOptionPane.showMessageDialog(COBrA.this, "First load Right and Mapping ontologies", "Error", 0);
                } else {
                    COBrA.this.showMappings(COBrA.this.rightOntology, COBrA.this.mappingOntology);
                }
            }
        });
        JMenuItem jMenuItem21 = new JMenuItem("Merge Mapping Ontology into Left");
        ((JMenu)object2).add(jMenuItem21);
        jMenuItem21.addActionListener(new ReadOntologyActionListener("Merge ontologies", this.leftOntology, 0, 5));
        JMenuItem jMenuItem22 = new JMenuItem("Merge Mapping Ontology into Right");
        ((JMenu)object2).add(jMenuItem22);
        jMenuItem22.addActionListener(new ReadOntologyActionListener("Merge ontologies", this.rightOntology, 1, 5));
        JMenuItem jMenuItem23 = new JMenuItem("Apply Inference Rules to Left");
        ((JMenu)object2).add(jMenuItem23);
        jMenuItem23.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextBox textBox = new TextBox((Frame)COBrA.this, COBrA.this.ruleset);
                COBrA.this.ruleset = textBox.getText();
                if (COBrA.this.ruleset != null) {
                    ReadOntologyActionListener readOntologyActionListener = new ReadOntologyActionListener("Inferred ontology", COBrA.this.rightOntology, 1, 7);
                    readOntologyActionListener.actionPerformed(actionEvent);
                }
            }
        });
        JMenuItem jMenuItem24 = new JMenuItem("Compare RDF Models");
        ((JMenu)object2).add(jMenuItem24);
        jMenuItem24.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (COBrA.this.leftOntology == null || COBrA.this.rightOntology == null) {
                    return;
                }
                COBrA.this.setCursor(Cursor.getPredefinedCursor(3));
                RDFTools rDFTools = new RDFTools(COBrA.this.relationshipTypes);
                rDFTools.compare(COBrA.this.leftOntology, COBrA.this.rightOntology);
                COBrA.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        JMenuItem jMenuItem25 = new JMenuItem("Validate Left RDFS Model");
        ((JMenu)object2).add(jMenuItem25);
        jMenuItem25.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (COBrA.this.leftOntology == null) {
                    return;
                }
                COBrA.this.setCursor(Cursor.getPredefinedCursor(3));
                RDFSTools rDFSTools = new RDFSTools(COBrA.this.relationshipTypes);
                rDFSTools.validateRDFS(COBrA.this.leftOntology);
                COBrA.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        JMenuItem jMenuItem26 = new JMenuItem("Validate Right RDFS Model");
        ((JMenu)object2).add(jMenuItem26);
        jMenuItem26.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (COBrA.this.rightOntology == null) {
                    return;
                }
                COBrA.this.setCursor(Cursor.getPredefinedCursor(3));
                RDFSTools rDFSTools = new RDFSTools(COBrA.this.relationshipTypes);
                rDFSTools.validateRDFS(COBrA.this.rightOntology);
                COBrA.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        JMenu jMenu7 = new JMenu("Help");
        jMenu7.setMnemonic(72);
        this.menuBar.add(jMenu7);
        JMenuItem jMenuItem27 = new JMenuItem("Show Help");
        jMenuItem27.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                COBrA.this.setCursor(Cursor.getPredefinedCursor(3));
                HTMLPanel hTMLPanel = new HTMLPanel("cobra.html", false, altURL);
                COBrA.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        jMenu7.add(jMenuItem27);
        JMenuItem jMenuItem28 = new JMenuItem("Show Relationship Types");
        jMenuItem28.setMnemonic(82);
        jMenuItem28.addActionListener(new ShowRelationshipTypesAction(this.relationshipTypes));
        jMenu7.add(jMenuItem28);
        JMenuItem jMenuItem29 = new JMenuItem("About COBrA");
        jMenuItem29.setMnemonic(65);
        jMenuItem29.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                new AboutBox((Frame)COBrA.this, versionNo).setVisible(true);
            }
        });
        jMenu7.add(jMenuItem29);
        this.setJMenuBar(this.menuBar);
    }

    protected GoTerm makeRootTerm() {
        GoTerm goTerm;
        String string = this.userProfile.getIDPrefix() + ":";
        for (int i = 0; i < this.userProfile.getPadding(); ++i) {
            string = string + "0";
        }
        try {
            goTerm = new GoTerm("root", string);
        }
        catch (Exception exception) {
            return null;
        }
        return goTerm;
    }

    public void showMappings(GoOntology goOntology, GoOntology goOntology2) {
        if (goOntology == null || goOntology.getRootTerm() == null || goOntology2 == null || goOntology2.getRootTerm() == null) {
            return;
        }
        HashSet hashSet = this.findMappings(goOntology2);
        this.setTermMapping(hashSet, goOntology);
    }

    public HashSet findMappings(GoOntology goOntology) {
        GoTerm goTerm;
        GoTerm goTerm2 = goTerm = goOntology.getRootTerm();
        HashSet hashSet = new HashSet();
        for (int i = 0; i < goTerm.getChildren().size(); ++i) {
            this.findMappedIDs(hashSet, goTerm.getChildren().getRelationship(i).getRelative());
        }
        return hashSet;
    }

    public void findMappedIDs(HashSet hashSet, GoTerm goTerm) {
        int n;
        GoTerm goTerm2 = null;
        GoTerm goTerm3 = null;
        for (n = 0; n < goTerm.getChildren().size(); ++n) {
            if (!goTerm.getChildren().getRelationship(n).getRelationshipType().equals((GoRelationshipType)this.relationshipTypes.get("^"))) continue;
            if (goTerm2 == null && goTerm3 == null) {
                goTerm2 = goTerm.getChildren().getRelationship(n).getRelative();
            }
            if (goTerm2 == null || goTerm3 != null || goTerm.getChildren().getRelationship(n).getRelative().getId().equals(goTerm2.getId()) || goTerm.getChildren().getRelationship(n).getRelative().getIdPrefix().equals(goTerm2.getIdPrefix())) continue;
            goTerm3 = goTerm.getChildren().getRelationship(n).getRelative();
        }
        if (goTerm2 != null) {
            hashSet.add(goTerm2.getCompleteId());
        }
        if (goTerm3 != null) {
            hashSet.add(goTerm3.getCompleteId());
        }
        for (n = 0; n < goTerm.getChildren().size(); ++n) {
            this.findMappedIDs(hashSet, goTerm.getChildren().getRelationship(n).getRelative());
        }
    }

    public void setTermMapping(HashSet hashSet, GoOntology goOntology) {
        GoTerm goTerm = goOntology.getRootTerm();
        if (hashSet.contains(goTerm.getCompleteId())) {
            goTerm.setMapped(true);
        } else {
            goTerm.setMapped(false);
        }
        for (int i = 0; i < goTerm.getChildren().size(); ++i) {
            this.setTermMappingR(hashSet, goTerm.getChildren().getRelationship(i).getRelative());
        }
    }

    protected void setTermMappingR(HashSet hashSet, GoTerm goTerm) {
        if (hashSet.contains(goTerm.getCompleteId())) {
            goTerm.setMapped(true);
        } else {
            goTerm.setMapped(false);
        }
        for (int i = 0; i < goTerm.getChildren().size(); ++i) {
            this.setTermMappingR(hashSet, goTerm.getChildren().getRelationship(i).getRelative());
        }
    }

    protected void newMappingOntology() {
        Vector vector = new Vector(this.relationshipTypes.entrySet());
        OntologyTreePanel ontologyTreePanel = new OntologyTreePanel(vector, false);
        this.mappingOntology = new GoOntology();
        this.mappingOntologyFile = new File(this.lastDirectory, "saved_ontology_mappings.rdf");
        this.mappingOntologyFileType = GO_RDF;
        this.mappingOntology.setRootTerm(this.makeRootTerm());
        ontologyTreePanel.setOntology(this.mappingOntology);
        this.mappingOntologyDialog = new ChooseFromTreeDialog(this, "Mapping Ontology", ontologyTreePanel);
        this.mappingOntologyDialog.setIsSaved(false);
        this.mappingOntologyDialog.setModal(false);
        this.mappingOntologyDialog.setMenu(this.referenceOntologyDialog, this.mappingTypesConfig, this.relationshipTypes);
    }

    protected void readOntology(int n) {
        Accessible accessible;
        String string;
        Object object;
        File file;
        JFileChooser jFileChooser = new JFileChooser(this.lastDirectory);
        int n2 = jFileChooser.showOpenDialog(this);
        if (n2 == 0) {
            file = jFileChooser.getSelectedFile();
            object = file.getName();
            string = COBrA.selectFileType((String)object);
            if (string == null) {
                return;
            }
            try {
                accessible = new ProgressMonitor(this, "Read " + file.getName(), null, 0, 100);
                this.statusPanel.add(this.readWriteStatusBar);
                if (string == GO_XML || string == GO_RDF) {
                    this.ontologyFileReader = new GoXMLReader(file, this.readWriteStatusBar, this.relationshipTypes, SWEBTools.GO_RDF);
                } else if (string == XSPAN_RDFS) {
                    this.ontologyFileReader = new GoXMLReader(file, this.readWriteStatusBar, this.relationshipTypes, SWEBTools.XSPAN_RDFS);
                } else if (string == XSPAN_OWL) {
                    this.ontologyFileReader = new GoXMLReader(file, this.readWriteStatusBar, this.relationshipTypes, SWEBTools.XSPAN_OWL);
                } else if (string == GO_FLAT) {
                    this.ontologyFileReader = new GoFlatFileReader(file, this.readWriteStatusBar, this.relationshipTypes);
                } else if (string == DEDIT_FLAT) {
                    this.ontologyFileReader = new DAGEditReader(file, this.readWriteStatusBar, this.relationshipTypes);
                } else {
                    return;
                }
                this.statusLabel.setForeground(Color.BLACK);
                this.statusLabel.setText("Read " + file.getName() + "   ");
                this.readWriteStatusBar.setValue(0);
                ((ProgressMonitor)accessible).setProgress(0);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            return;
        }
        object = new Vector(this.relationshipTypes.entrySet());
        accessible = new OntologyTreePanel((Vector)object, false);
        if (n == 2) {
            this.mappingOntologyFile = file;
            this.mappingOntologyFileType = string;
            this.mappingOntology = new GoOntology();
            ReadWorker readWorker = new ReadWorker((OntologyTreePanel)accessible, this.mappingOntology, 2);
            readWorker.start();
            this.mappingOntologyDialog = new ChooseFromTreeDialog(this, "Mapping Ontology", (OntologyTreePanel)accessible);
            this.mappingOntologyDialog.setIsSaved(true);
            this.mappingOntologyDialog.setModal(false);
            this.mappingOntologyDialog.setMenu(this.referenceOntologyDialog, this.mappingTypesConfig, this.relationshipTypes);
        } else if (n == 3) {
            this.referenceOntologyFile = file;
            this.referenceOntology = new GoOntology();
            ReadWorker readWorker = new ReadWorker((OntologyTreePanel)accessible, this.referenceOntology, 3);
            readWorker.start();
            this.referenceOntologyDialog = new ChooseFromTreeDialog(this, "Reference Ontology", (OntologyTreePanel)accessible);
            if (this.mappingOntologyDialog != null) {
                this.mappingOntologyDialog.setMenu(this.referenceOntologyDialog, this.mappingTypesConfig, this.relationshipTypes);
            }
        }
    }

    public void resetSplitedPane() {
        this.splitedOntologyPanel.setDividerLocation(0.5);
    }

    public void setMenuAndToolBarEnabled(boolean bl) {
        int n;
        if (!bl && !this.toolBar.isEnabled()) {
            return;
        }
        for (n = 0; n < this.menuBar.getComponentCount(); ++n) {
            if (bl) {
                this.menuBar.getComponent(n).setEnabled(true);
                continue;
            }
            this.menuBar.getComponent(n).setEnabled(false);
        }
        if (!bl) {
            this.activeToolBarComponents.removeAllElements();
            this.toolBar.setEnabled(false);
        } else {
            this.toolBar.setEnabled(true);
        }
        for (n = 0; n < this.toolBar.getComponentCount(); ++n) {
            boolean bl2;
            if (bl) {
                bl2 = (Boolean)this.activeToolBarComponents.get(n);
                this.toolBar.getComponentAtIndex(n).setEnabled(bl2);
            } else {
                bl2 = this.toolBar.getComponent(n).isEnabled();
                this.activeToolBarComponents.add(new Boolean(bl2));
                this.toolBar.getComponentAtIndex(n).setEnabled(false);
            }
            this.leftOntologyTreePanel.setEnabled(bl);
            this.leftOntologyNodeBasedPanel.setEnabled(bl);
            this.rightOntologyTreePanel.setEnabled(bl);
            this.rightOntologyNodeBasedPanel.setEnabled(bl);
        }
    }

    public static String selectFileType(String string) {
        int n;
        Vector<String> vector = new Vector<String>();
        String string2 = GO_FLAT;
        for (n = 0; n < FILE_READ_COUNT; ++n) {
            if (!string.endsWith(FILE_READ_TYPES[n])) continue;
            vector.add(FILE_READ_INFO[n]);
            string2 = FILE_READ_INFO[n];
        }
        if (vector.size() == 0) {
            vector.add(GO_FLAT);
            vector.add(DEDIT_FLAT);
            string2 = string.endsWith(".go") ? GO_FLAT : DEDIT_FLAT;
            for (n = 0; n < FILE_READ_COUNT; ++n) {
                vector.add(FILE_READ_INFO[n]);
            }
        }
        Object[] objectArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = (String)vector.elementAt(i);
        }
        String string3 = "Select";
        if (vector.size() == 1) {
            string3 = "Confirm";
        }
        String string4 = (String)JOptionPane.showInputDialog(null, string3 + " the file format:", "Select", 1, null, objectArray, string2);
        return string4;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length == 1 && (stringArray[0].equals("-debug") || stringArray[0].equals("-d"))) {
            bl = true;
        } else {
            LoggerCreator.createNullLogger();
        }
        new COBrA(bl);
    }

    class ShowRelationshipTypesAction
    extends AbstractAction {
        HashMap relationshipTypes;

        ShowRelationshipTypesAction(HashMap hashMap) {
            this.relationshipTypes = hashMap;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new ShowRelationshipTypesDialog(COBrA.this, this.relationshipTypes).setVisible(true);
            if (TaskGenerator.isStarted()) {
                LoggerCreator.getLogger().info("Shows the Relationship Types with the icons.");
            }
        }
    }

    class MakeAnnotationAction
    extends AbstractAction {
        MakeAnnotationAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getSource() instanceof JButton ? "Tool Bar - Button." : "Menu Bar - Item.";
            if (COBrA.this.mappingOntology == null) {
                JOptionPane.showMessageDialog(COBrA.this, "First open a Mapping Ontology to store the annotations", "Annotation Error", 0);
                return;
            }
            if (COBrA.this.leftOntologyTreePanel.getTree().getSelectionPath() == null || COBrA.this.rightOntologyTreePanel.getTree().getSelectionPath() == null) {
                String string2 = "";
                if (COBrA.this.leftOntologyTreePanel.getTree().getSelectionPath() == null) {
                    string2 = "in the left";
                }
                if (COBrA.this.rightOntologyTreePanel.getTree().getSelectionPath() == null && !string2.equals("")) {
                    string2 = string2 + " and in the right";
                } else if (COBrA.this.rightOntologyTreePanel.getTree().getSelectionPath() == null) {
                    string2 = "in the right";
                }
                JOptionPane.showMessageDialog(COBrA.this, "Select the two tissues to make the annotation", "Annotation Error", 0);
                if (TaskGenerator.isStarted()) {
                    LoggerCreator.getLogger().info("Make Annotation intitialisation could not be processed, no tissue selected " + string2 + " ontology. Used" + string);
                }
                return;
            }
            GoTerm goTerm = ((GoTermNode)COBrA.this.leftOntologyTreePanel.getTree().getSelectionPath().getLastPathComponent()).getNodeObject().getRelative();
            GoTerm goTerm2 = ((GoTermNode)COBrA.this.rightOntologyTreePanel.getTree().getSelectionPath().getLastPathComponent()).getNodeObject().getRelative();
            if (COBrA.this.useReferenceMenuItem.getState()) {
                AnnotationEditorDialog annotationEditorDialog = new AnnotationEditorDialog(COBrA.this, COBrA.this.mappingOntology, COBrA.this.mappingOntologyDialog, COBrA.this.referenceOntologyDialog, goTerm, goTerm2, COBrA.this.mappingTypesConfig, COBrA.this.relationshipTypes, COBrA.this.userProfile);
                annotationEditorDialog.setVisible(true);
            } else {
                AnnotationEditorSimpleDialog annotationEditorSimpleDialog = new AnnotationEditorSimpleDialog(COBrA.this, COBrA.this.mappingOntology, COBrA.this.mappingOntologyDialog, goTerm, goTerm2, null, COBrA.this.relationshipTypes, COBrA.this.userProfile);
                annotationEditorSimpleDialog.setVisible(true);
            }
        }
    }

    class JTabbedPaneSelectionChangeListener
    implements ChangeListener {
        JTabbedPaneSelectionChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() instanceof JTabbedPane) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                if (jTabbedPane.equals(COBrA.this.leftTabPane)) {
                    if ((COBrA.this.leftOntologyRead || COBrA.this.rightOntologyRead) && (COBrA.this.rightTabPane.getSelectedIndex() == jTabbedPane.getSelectedIndex() && jTabbedPane.getTabCount() > 2 || COBrA.this.rightTabPane.getSelectedIndex() % 2 != jTabbedPane.getSelectedIndex() % 2)) {
                        int n;
                        int n2 = COBrA.this.leftTabPane.getSelectedIndex();
                        if (n2 == -1) {
                            return;
                        }
                        for (n = 0; n < COBrA.this.leftTabPane.getTabCount(); ++n) {
                            COBrA.this.leftTabPane.setComponentAt(n, new JPanel());
                        }
                        if (COBrA.this.leftTabPane.getTabCount() == 2 && COBrA.this.rightOntology.getRootTerm() != null && COBrA.this.leftTabPane.getSelectedComponent().getName().equals(COBrA.this.rightOntology.getRootTerm().getName())) {
                            COBrA.this.leftTabPane.setComponentAt(n2, (JPanel)COBrA.this.viewPanelVectorRight.get(n2));
                        } else {
                            COBrA.this.leftTabPane.setComponentAt(n2, (JPanel)COBrA.this.viewPanelVectorLeft.get(n2));
                        }
                        for (n = 0; n < COBrA.this.rightTabPane.getTabCount(); ++n) {
                            COBrA.this.rightTabPane.setEnabledAt(n, true);
                        }
                        if (n2 >= 2) {
                            COBrA.this.rightTabPane.setEnabledAt(n2 - 2, false);
                        } else if (COBrA.this.rightTabPane.getTabCount() > 2) {
                            COBrA.this.rightTabPane.setEnabledAt(n2 + 2, false);
                        } else {
                            COBrA.this.rightTabPane.setEnabledAt(n2, false);
                        }
                        if (TaskGenerator.isStarted()) {
                            String string = ((OntologyViewPanel)COBrA.this.leftTabPane.getSelectedComponent()).getOntology().getRootTerm().getName();
                            if (COBrA.this.leftTabPane.getSelectedComponent() instanceof OntologyNodeBasedPanel) {
                                LoggerCreator.getLogger().info("Selected Node Based view for the ontology " + string + " at the left side view.");
                            } else if (COBrA.this.leftTabPane.getSelectedComponent() instanceof OntologyTreePanel) {
                                LoggerCreator.getLogger().info("Selected Tree View for the ontology " + string + " at the left side view.");
                            }
                        }
                    }
                    COBrA.this.rightTabPane.getSelectedComponent().repaint();
                    COBrA.this.leftTabPane.getSelectedComponent().repaint();
                } else if (jTabbedPane.equals(COBrA.this.rightTabPane)) {
                    if ((COBrA.this.leftOntologyRead || COBrA.this.rightOntologyRead) && (COBrA.this.leftTabPane.getSelectedIndex() == jTabbedPane.getSelectedIndex() && jTabbedPane.getTabCount() > 2 || COBrA.this.leftTabPane.getSelectedIndex() % 2 != jTabbedPane.getSelectedIndex() % 2)) {
                        int n;
                        int n4 = COBrA.this.rightTabPane.getSelectedIndex();
                        if (n4 == -1) {
                            return;
                        }
                        for (n = 0; n < COBrA.this.rightTabPane.getTabCount(); ++n) {
                            COBrA.this.rightTabPane.setComponentAt(n, new JPanel());
                        }
                        if (COBrA.this.rightTabPane.getTabCount() == 2 && COBrA.this.leftOntology.getRootTerm() != null && COBrA.this.rightTabPane.getSelectedComponent().getName().equals(COBrA.this.leftOntology.getRootTerm().getName())) {
                            COBrA.this.rightTabPane.setComponentAt(n4, (JPanel)COBrA.this.viewPanelVectorLeft.get(n4));
                        } else {
                            COBrA.this.rightTabPane.setComponentAt(n4, (JPanel)COBrA.this.viewPanelVectorRight.get(n4));
                        }
                        for (n = 0; n < COBrA.this.leftTabPane.getTabCount(); ++n) {
                            COBrA.this.leftTabPane.setEnabledAt(n, true);
                        }
                        if (n4 >= 2) {
                            COBrA.this.leftTabPane.setEnabledAt(n4 - 2, false);
                        } else if (COBrA.this.leftTabPane.getTabCount() > 2) {
                            COBrA.this.leftTabPane.setEnabledAt(n4 + 2, false);
                        } else {
                            COBrA.this.leftTabPane.setEnabledAt(n4, false);
                        }
                        if (TaskGenerator.isStarted()) {
                            String string = ((OntologyViewPanel)COBrA.this.rightTabPane.getSelectedComponent()).getOntology().getRootTerm().getName();
                            if (COBrA.this.rightTabPane.getSelectedComponent() instanceof OntologyNodeBasedPanel) {
                                LoggerCreator.getLogger().info("Selected Node Based view for the ontology " + string + " at the right side view.");
                            } else if (COBrA.this.rightTabPane.getSelectedComponent() instanceof OntologyTreePanel) {
                                LoggerCreator.getLogger().info("Selected Tree View for the ontology " + string + " at the right side view.");
                            }
                        }
                    }
                    COBrA.this.rightTabPane.getSelectedComponent().repaint();
                    COBrA.this.leftTabPane.getSelectedComponent().repaint();
                }
            }
        }
    }

    class HideActionListener
    implements ActionListener {
        GoRelationshipType type;
        OntologyTreePanel treePanel;
        OntologyNodeBasedPanel nodeBasedPanel;

        public HideActionListener(GoRelationshipType goRelationshipType, OntologyTreePanel ontologyTreePanel, OntologyNodeBasedPanel ontologyNodeBasedPanel) {
            this.type = goRelationshipType;
            this.treePanel = ontologyTreePanel;
            this.nodeBasedPanel = ontologyNodeBasedPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            if (!jCheckBoxMenuItem.isSelected()) {
                this.treePanel.addHiddenRelationshipType(this.type);
                this.nodeBasedPanel.addHiddenRelationshipType(this.type);
                if (TaskGenerator.isStarted()) {
                    if (this.treePanel.equals(COBrA.this.leftOntologyTreePanel)) {
                        LoggerCreator.getLogger().info("Hide relationship type : " + this.type.getRelationshipType() + " for the left ontologt : " + this.treePanel.getOntology().getRootTerm().getName());
                    } else if (this.treePanel.equals(COBrA.this.rightOntologyTreePanel)) {
                        LoggerCreator.getLogger().info("Hide relationship type : " + this.type.getRelationshipType() + " for the right ontologt : " + this.treePanel.getOntology().getRootTerm().getName());
                    }
                }
            } else {
                this.treePanel.removeHiddenRelationshipType(this.type);
                this.nodeBasedPanel.removeHiddenRelationshipType(this.type);
                if (TaskGenerator.isStarted()) {
                    if (this.treePanel.equals(COBrA.this.leftOntologyTreePanel)) {
                        LoggerCreator.getLogger().info("Visualise relationship type : " + this.type.getRelationshipType() + " for the left ontologt : " + this.treePanel.getOntology().getRootTerm().getName());
                    } else if (this.treePanel.equals(COBrA.this.rightOntologyTreePanel)) {
                        LoggerCreator.getLogger().info("Visualise relationship type : " + this.type.getRelationshipType() + " for the right ontologt : " + this.treePanel.getOntology().getRootTerm().getName());
                    }
                }
            }
        }
    }

    class WriteWorker
    extends SwingWorker {
        static final int LEFT_SITE = 0;
        static final int RIGHT_SITE = 1;
        static final int MAPPING_ONTOLOGY = 2;
        int ontologySite;
        boolean exitAfterWrite = false;

        public void setExitAfterWrite(boolean bl) {
            this.exitAfterWrite = bl;
        }

        WriteWorker(int n) {
            this.ontologySite = n;
        }

        public Object construct() {
            COBrA.this.setCursor(Cursor.getPredefinedCursor(3));
            boolean bl = false;
            if (this.ontologySite == 0 && COBrA.this.leftOntology.getRootTerm() != null && (COBrA.this.leftTabPane.getSelectedComponent().equals(COBrA.this.leftOntologyNodeBasedPanel) || COBrA.this.leftTabPane.getSelectedComponent().equals(COBrA.this.leftOntologyTreePanel))) {
                bl = COBrA.this.ontologyFileWriter.write(COBrA.this.leftOntology);
            } else if (this.ontologySite == 0 && COBrA.this.rightOntology.getRootTerm() != null && (COBrA.this.leftTabPane.getSelectedComponent().equals(COBrA.this.rightOntologyNodeBasedPanel) || COBrA.this.leftTabPane.getSelectedComponent().equals(COBrA.this.rightOntologyTreePanel))) {
                bl = COBrA.this.ontologyFileWriter.write(COBrA.this.rightOntology);
            } else if (this.ontologySite == 1 && COBrA.this.leftOntology.getRootTerm() != null && (COBrA.this.rightTabPane.getSelectedComponent().equals(COBrA.this.leftOntologyNodeBasedPanel) || COBrA.this.rightTabPane.getSelectedComponent().equals(COBrA.this.leftOntologyTreePanel))) {
                bl = COBrA.this.ontologyFileWriter.write(COBrA.this.leftOntology);
            } else if (this.ontologySite == 1 && COBrA.this.rightOntology.getRootTerm() != null && (COBrA.this.rightTabPane.getSelectedComponent().equals(COBrA.this.rightOntologyNodeBasedPanel) || COBrA.this.rightTabPane.getSelectedComponent().equals(COBrA.this.rightOntologyTreePanel))) {
                bl = COBrA.this.ontologyFileWriter.write(COBrA.this.rightOntology);
            } else if (this.ontologySite == 2 && COBrA.this.mappingOntology != null) {
                bl = COBrA.this.ontologyFileWriter.write(COBrA.this.mappingOntology);
            }
            if (!bl) {
                COBrA.this.statusLabel.setForeground(Color.RED);
                COBrA.this.statusLabel.setText("Error writing file - ontology may be empty");
                return null;
            }
            return COBrA.this.leftOntology;
        }

        public void finished() {
            COBrA.this.setCursor(Cursor.getDefaultCursor());
            try {
                COBrA.this.ontologyFileWriter.close();
                COBrA.this.statusPanel.remove(COBrA.this.readWriteStatusBar);
                COBrA.this.statusPanel.repaint();
                if (this.exitAfterWrite) {
                    COBrA.this.exit();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                COBrA.this.statusPanel.remove(COBrA.this.readWriteStatusBar);
                COBrA.this.statusPanel.repaint();
            }
        }
    }

    class WriteActionListener
    implements ActionListener {
        public static final int SAVE = 0;
        public static final int SAVE_AS = 1;
        int ontologySite;
        int saveOrSaveAs;

        WriteActionListener(int n, int n2) {
            this.ontologySite = n;
            this.saveOrSaveAs = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            String string = actionEvent.getSource() instanceof JButton ? "Tool Bar - Button." : "Menu Bar - Item.";
            File file = null;
            String string2 = null;
            if (this.saveOrSaveAs == 1) {
                object2 = new String[FILE_WRITE_COUNT + 1];
                for (int i = 0; i < FILE_WRITE_COUNT; ++i) {
                    object2[i] = FILE_WRITE_INFO[i];
                }
                object2[COBrA.FILE_WRITE_COUNT] = GO_FLAT;
                string2 = (String)JOptionPane.showInputDialog(COBrA.this, "Select the file format\n(flat file formats may result in loss of information)", "Select", 1, null, (Object[])object2, object2[0]);
                if (string2 == null) {
                    return;
                }
                object = new JFileChooser(COBrA.this.lastDirectory);
                int n = ((JFileChooser)object).showSaveDialog(COBrA.this);
                if (n == 0) {
                    int n2;
                    file = ((JFileChooser)object).getSelectedFile();
                    String string3 = file.getPath();
                    for (n2 = 0; n2 < FILE_READ_COUNT; ++n2) {
                        if (!string3.endsWith(FILE_READ_TYPES[n2])) continue;
                        int n4 = string3.indexOf(FILE_READ_TYPES[n2]);
                        string3 = string3.substring(0, n4);
                    }
                    for (n2 = 0; n2 < FILE_WRITE_COUNT; ++n2) {
                        if (!string2.equals(FILE_WRITE_INFO[n2])) continue;
                        string3 = string3 + FILE_WRITE_TYPES[n2];
                        break;
                    }
                    file = new File(string3);
                    if (this.ontologySite == 1 && COBrA.this.rightTabPane.getSelectedComponent() != null) {
                        if (COBrA.this.rightTabPane.getSelectedComponent().equals(COBrA.this.leftOntologyNodeBasedPanel) || COBrA.this.rightTabPane.getSelectedComponent().equals(COBrA.this.leftOntologyTreePanel)) {
                            COBrA.this.leftOntologyFile = file;
                            COBrA.this.leftOntologyFileType = string2;
                        }
                        if (COBrA.this.rightTabPane.getSelectedComponent().equals(COBrA.this.rightOntologyNodeBasedPanel) || COBrA.this.rightTabPane.getSelectedComponent().equals(COBrA.this.rightOntologyTreePanel)) {
                            COBrA.this.rightOntologyFile = file;
                            COBrA.this.rightOntologyFileType = string2;
                        }
                    }
                    if (this.ontologySite == 0 && COBrA.this.leftTabPane.getSelectedComponent() != null) {
                        if (COBrA.this.leftTabPane.getSelectedComponent().equals(COBrA.this.leftOntologyNodeBasedPanel) || COBrA.this.leftTabPane.getSelectedComponent().equals(COBrA.this.leftOntologyTreePanel)) {
                            COBrA.this.leftOntologyFile = file;
                            COBrA.this.leftOntologyFileType = string2;
                        }
                        if (COBrA.this.leftTabPane.getSelectedComponent().equals(COBrA.this.rightOntologyNodeBasedPanel) || COBrA.this.leftTabPane.getSelectedComponent().equals(COBrA.this.rightOntologyTreePanel)) {
                            COBrA.this.rightOntologyFile = file;
                            COBrA.this.rightOntologyFileType = string2;
                        }
                    }
                    if (this.ontologySite == 2) {
                        COBrA.this.mappingOntologyFile = file;
                        COBrA.this.mappingOntologyFileType = string2;
                    }
                    if (COBrA.this.leftOntologyFile != null) {
                        if (COBrA.this.rightOntologyFile != null) {
                            COBrA.this.setTitle("COBrA  " + COBrA.this.leftOntologyFile.getName() + " - " + COBrA.this.rightOntologyFile.getName());
                        } else {
                            COBrA.this.setTitle("COBrA  " + COBrA.this.leftOntologyFile.getName());
                        }
                    } else if (COBrA.this.rightOntologyFile != null) {
                        COBrA.this.setTitle("COBrA  " + COBrA.this.rightOntologyFile.getName());
                    }
                } else if (n == 1) {
                    COBrA.this.statusLabel.setForeground(Color.BLUE);
                    COBrA.this.statusLabel.setText("Canceled write command.");
                    COBrA.this.statusPanel.remove(COBrA.this.readWriteStatusBar);
                    COBrA.this.statusPanel.repaint();
                    return;
                }
            }
            if (this.ontologySite == 0 && COBrA.this.leftTabPane.getSelectedComponent() != null) {
                if (COBrA.this.leftTabPane.getSelectedComponent().equals(COBrA.this.leftOntologyNodeBasedPanel) || COBrA.this.leftTabPane.getSelectedComponent().equals(COBrA.this.leftOntologyTreePanel)) {
                    file = COBrA.this.leftOntologyFile;
                    string2 = COBrA.this.leftOntologyFileType;
                }
                if (COBrA.this.leftTabPane.getSelectedComponent().equals(COBrA.this.rightOntologyNodeBasedPanel) || COBrA.this.leftTabPane.getSelectedComponent().equals(COBrA.this.rightOntologyTreePanel)) {
                    file = COBrA.this.rightOntologyFile;
                    string2 = COBrA.this.rightOntologyFileType;
                }
            }
            if (this.ontologySite == 1 && COBrA.this.rightTabPane.getSelectedComponent() != null) {
                if (COBrA.this.rightTabPane.getSelectedComponent().equals(COBrA.this.leftOntologyNodeBasedPanel) || COBrA.this.rightTabPane.getSelectedComponent().equals(COBrA.this.leftOntologyTreePanel)) {
                    file = COBrA.this.leftOntologyFile;
                    string2 = COBrA.this.leftOntologyFileType;
                }
                if (COBrA.this.rightTabPane.getSelectedComponent().equals(COBrA.this.rightOntologyNodeBasedPanel) || COBrA.this.rightTabPane.getSelectedComponent().equals(COBrA.this.rightOntologyTreePanel)) {
                    file = COBrA.this.rightOntologyFile;
                    string2 = COBrA.this.rightOntologyFileType;
                }
            }
            if (this.ontologySite == 2) {
                file = COBrA.this.mappingOntologyFile;
                string2 = COBrA.this.mappingOntologyFileType;
            }
            try {
                COBrA.this.statusPanel.add(COBrA.this.readWriteStatusBar);
                if (file == null) {
                    object2 = new ProgressMonitor(COBrA.this, "Error writing file", null, 0, 100);
                    COBrA.this.statusLabel.setForeground(Color.RED);
                    COBrA.this.statusLabel.setText("Error writing file: No Filename");
                    return;
                }
                object2 = new ProgressMonitor(COBrA.this, "Write " + file.getName(), null, 0, 100);
                COBrA.this.statusLabel.setForeground(Color.BLACK);
                COBrA.this.statusLabel.setText("Write " + file.getName() + "   ");
                System.out.println("saving file:" + file.getName());
                if (string2 == GO_RDF) {
                    COBrA.this.ontologyFileWriter = new GoXMLWriter(new FileWriter(file), COBrA.this.readWriteStatusBar, COBrA.this.relationshipTypes, SWEBTools.GO_RDF);
                } else if (string2 == XSPAN_RDFS) {
                    COBrA.this.ontologyFileWriter = new GoXMLWriter(new FileWriter(file), COBrA.this.readWriteStatusBar, COBrA.this.relationshipTypes, SWEBTools.XSPAN_RDFS);
                } else if (string2 == XSPAN_OWL) {
                    COBrA.this.ontologyFileWriter = new GoXMLWriter(new FileWriter(file), COBrA.this.readWriteStatusBar, COBrA.this.relationshipTypes, SWEBTools.XSPAN_OWL);
                } else if (string2 == GO_FLAT) {
                    COBrA.this.ontologyFileWriter = new GoFlatFileWriter(new FileWriter(file), COBrA.this.readWriteStatusBar, COBrA.this.relationshipTypes);
                } else {
                    object2 = new ProgressMonitor(COBrA.this, "Error writing file", null, 0, 100);
                    COBrA.this.statusLabel.setForeground(Color.RED);
                    COBrA.this.statusLabel.setText("Error writing file: Format is not supported");
                    return;
                }
                if (this.ontologySite == 0) {
                    COBrA.this.leftOntologyTreePanel.setIsSaved(true);
                } else if (this.ontologySite == 1) {
                    COBrA.this.rightOntologyTreePanel.setIsSaved(true);
                } else if (this.ontologySite == 2) {
                    COBrA.this.mappingOntologyDialog.setIsSaved(true);
                }
                COBrA.this.statusLabel.setForeground(Color.BLACK);
                COBrA.this.statusLabel.setText("Write " + file.getName() + "   ");
                COBrA.this.readWriteStatusBar.setValue(0);
                ((ProgressMonitor)object2).setProgress(0);
                object = new WriteWorker(this.ontologySite);
                ((SwingWorker)object).start();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                if (this.ontologySite == 0) {
                    COBrA.this.leftOntologyTreePanel.setIsSaved(false);
                } else if (this.ontologySite == 1) {
                    COBrA.this.rightOntologyTreePanel.setIsSaved(false);
                } else if (this.ontologySite == 2) {
                    COBrA.this.mappingOntologyDialog.setIsSaved(false);
                }
            }
        }
    }

    class ReadWorker
    extends SwingWorker {
        static final int LEFT_SITE = 0;
        static final int RIGHT_SITE = 1;
        static final int MAPPING_ONTOLOGY = 2;
        static final int REFERENCE_ONTOLOGY = 3;
        static final int READ_IN_ONTOLOGY = 4;
        static final int MERGED_ONTOLOGY = 5;
        static final int NEW_ONTOLOGY = 6;
        static final int INFERRED_ONTOLOGY = 7;
        int ontologySite;
        int ontologyType;
        GoOntology ontology;
        OntologyTreePanel panel;

        ReadWorker(OntologyTreePanel ontologyTreePanel, GoOntology goOntology, int n) {
            this.ontology = goOntology;
            this.ontologySite = n;
            this.ontologyType = 4;
            this.panel = ontologyTreePanel;
        }

        ReadWorker(OntologyTreePanel ontologyTreePanel, GoOntology goOntology, int n, int n2) {
            this.ontology = goOntology;
            this.ontologySite = n;
            this.ontologyType = n2;
            this.panel = ontologyTreePanel;
        }

        public Object construct() {
            SWEBTools sWEBTools;
            COBrA.this.setCursor(Cursor.getPredefinedCursor(3));
            GoOntology goOntology = null;
            if (this.ontologyType == 5) {
                sWEBTools = new OWLTools(COBrA.this.relationshipTypes);
                if (this.ontologySite == 0) {
                    goOntology = ((OWLTools)sWEBTools).merge(COBrA.this.leftOntology, COBrA.this.mappingOntology);
                } else if (this.ontologySite == 1) {
                    goOntology = ((OWLTools)sWEBTools).merge(COBrA.this.rightOntology, COBrA.this.mappingOntology);
                } else {
                    System.out.println(" error merging ontologies");
                }
            } else if (this.ontologyType == 7) {
                sWEBTools = new RDFTools(COBrA.this.relationshipTypes);
                goOntology = ((RDFTools)sWEBTools).infer(COBrA.this.leftOntology, COBrA.this.ruleset);
            } else if (this.ontologyType == 6) {
                goOntology = new GoOntology();
                goOntology.setRootTerm(COBrA.this.makeRootTerm());
                System.out.println("NEW ontol" + goOntology.toString());
            } else {
                goOntology = COBrA.this.ontologyFileReader.read();
            }
            if (goOntology == null) {
                System.out.println("onto is null");
                COBrA.this.statusLabel.setForeground(Color.RED);
                COBrA.this.statusLabel.setText("Error reading file");
                return null;
            }
            this.ontology.copy(goOntology);
            System.out.println("loaded ont:" + this.ontology.getRootTerm().toString());
            if (this.panel != null) {
                this.panel.setOntology(this.ontology);
            }
            if (this.ontologySite == 0) {
                int n;
                COBrA.this.leftOntologyTreePanel.setOntology(this.ontology);
                COBrA.this.leftOntologyNodeBasedPanel.setGoTerm(this.ontology.getRootTerm(), this.ontology);
                if (this.ontologyType == 6) {
                    COBrA.this.leftOntologyTreePanel.setIsSaved(false);
                }
                if (COBrA.this.rightTabPane.getSelectedIndex() > 1) {
                    COBrA.this.rightTabPane.setSelectedIndex(0);
                }
                COBrA.this.leftTabPane.removeChangeListener(COBrA.this.tabChangeListener);
                COBrA.this.rightTabPane.removeChangeListener(COBrA.this.tabChangeListener);
                if (COBrA.this.leftTabPane.getSelectedIndex() != -1 && COBrA.this.leftOntologyRead) {
                    COBrA.this.leftTabPane.removeTabAt(1);
                    COBrA.this.leftTabPane.removeTabAt(0);
                }
                if (COBrA.this.rightTabPane.getSelectedIndex() != -1) {
                    if (COBrA.this.leftOntologyRead && COBrA.this.rightOntologyRead) {
                        COBrA.this.rightTabPane.removeTabAt(3);
                        COBrA.this.rightTabPane.removeTabAt(2);
                    } else if (COBrA.this.leftOntologyRead) {
                        COBrA.this.rightTabPane.removeTabAt(1);
                        COBrA.this.rightTabPane.removeTabAt(0);
                    }
                }
                for (n = 0; n < COBrA.this.leftTabPane.getTabCount(); ++n) {
                    COBrA.this.leftTabPane.setComponentAt(n, new JPanel());
                }
                COBrA.this.leftTabPane.insertTab(this.ontology.getRootTerm().getName(), Resources.getTreeIcon(), COBrA.this.leftOntologyTreePanel, null, 0);
                COBrA.this.leftTabPane.insertTab(this.ontology.getRootTerm().getName(), Resources.getNodeBasedIcon(), new JPanel(), null, 1);
                COBrA.this.leftTabPane.setSelectedIndex(0);
                if (COBrA.this.rightTabPane.getSelectedIndex() == -1) {
                    for (n = 0; n < COBrA.this.rightTabPane.getTabCount(); ++n) {
                        COBrA.this.rightTabPane.setComponentAt(n, new JPanel());
                    }
                    COBrA.this.rightTabPane.addTab(this.ontology.getRootTerm().getName(), Resources.getTreeIcon(), new JPanel());
                    COBrA.this.rightTabPane.addTab(this.ontology.getRootTerm().getName(), Resources.getNodeBasedIcon(), COBrA.this.leftOntologyNodeBasedPanel);
                    COBrA.this.rightTabPane.setSelectedIndex(1);
                    COBrA.this.rightTabPane.setEnabledAt(0, false);
                } else {
                    COBrA.this.rightTabPane.addTab(this.ontology.getRootTerm().getName(), Resources.getTreeIcon(), new JPanel());
                    COBrA.this.rightTabPane.addTab(this.ontology.getRootTerm().getName(), Resources.getNodeBasedIcon(), new JPanel());
                    COBrA.this.rightTabPane.setEnabledAt(1, true);
                }
                if (COBrA.this.leftTabPane.getTabCount() == 2) {
                    COBrA.this.leftTabPane.setEnabledAt(1, false);
                }
                if ((n = COBrA.this.leftTabPane.getSelectedIndex()) >= 2) {
                    COBrA.this.rightTabPane.setEnabledAt(n - 2, false);
                } else if (COBrA.this.rightTabPane.getTabCount() > 2) {
                    COBrA.this.rightTabPane.setEnabledAt(n + 2, false);
                } else {
                    COBrA.this.rightTabPane.setEnabledAt(n, false);
                }
                COBrA.this.leftTabPane.addChangeListener(COBrA.this.tabChangeListener);
                COBrA.this.rightTabPane.addChangeListener(COBrA.this.tabChangeListener);
                if (this.ontologyType == 4) {
                    COBrA.this.tabChangeListener.stateChanged(new ChangeEvent(COBrA.this.leftTabPane));
                    COBrA.this.tabChangeListener.stateChanged(new ChangeEvent(COBrA.this.rightTabPane));
                }
                COBrA.this.leftOntologyRead = true;
                if (COBrA.this.rightOntologyRead) {
                    COBrA.this.makeAnnotationButton.setEnabled(true);
                }
                COBrA.this.saveLeftButton.setEnabled(true);
                COBrA.this.saveAsLeftButton.setEnabled(true);
                COBrA.this.saveRightButton.setEnabled(true);
                COBrA.this.saveAsRightButton.setEnabled(true);
                if (COBrA.this.leftOntologyFile != null) {
                    if (COBrA.this.rightOntologyFile != null) {
                        COBrA.this.setTitle("COBrA  " + COBrA.this.leftOntologyFile.getName() + " - " + COBrA.this.rightOntologyFile.getName());
                    } else {
                        COBrA.this.setTitle("COBrA  " + COBrA.this.leftOntologyFile.getName());
                    }
                } else if (COBrA.this.rightOntologyFile != null) {
                    COBrA.this.setTitle("COBrA  " + COBrA.this.rightOntologyFile.getName());
                }
                ((GoTermTreeModel)COBrA.this.leftOntologyTreePanel.getTree().getModel()).reload();
                COBrA.this.leftTabPane.getSelectedComponent().repaint();
                COBrA.this.rightTabPane.getSelectedComponent().repaint();
                return this.ontology;
            }
            if (this.ontologySite == 1) {
                int n;
                COBrA.this.rightOntologyTreePanel.setOntology(this.ontology);
                COBrA.this.rightOntologyNodeBasedPanel.setGoTerm(this.ontology.getRootTerm(), this.ontology);
                if (this.ontologyType == 6) {
                    COBrA.this.rightOntologyTreePanel.setIsSaved(false);
                }
                if (COBrA.this.leftTabPane.getSelectedIndex() > 1) {
                    COBrA.this.leftTabPane.setSelectedIndex(0);
                }
                COBrA.this.leftTabPane.removeChangeListener(COBrA.this.tabChangeListener);
                COBrA.this.rightTabPane.removeChangeListener(COBrA.this.tabChangeListener);
                if (COBrA.this.rightTabPane.getSelectedIndex() != -1 && COBrA.this.rightOntologyRead) {
                    COBrA.this.rightTabPane.removeTabAt(1);
                    COBrA.this.rightTabPane.removeTabAt(0);
                }
                if (COBrA.this.leftTabPane.getSelectedIndex() != -1) {
                    if (COBrA.this.leftOntologyRead && COBrA.this.rightOntologyRead) {
                        COBrA.this.leftTabPane.removeTabAt(3);
                        COBrA.this.leftTabPane.removeTabAt(2);
                    } else if (COBrA.this.rightOntologyRead) {
                        COBrA.this.leftTabPane.removeTabAt(1);
                        COBrA.this.leftTabPane.removeTabAt(0);
                    }
                }
                for (n = 0; n < COBrA.this.rightTabPane.getTabCount(); ++n) {
                    COBrA.this.rightTabPane.setComponentAt(n, new JPanel());
                }
                COBrA.this.rightTabPane.insertTab(this.ontology.getRootTerm().getName(), Resources.getTreeIcon(), COBrA.this.rightOntologyTreePanel, null, 0);
                COBrA.this.rightTabPane.insertTab(this.ontology.getRootTerm().getName(), Resources.getNodeBasedIcon(), new JPanel(), null, 1);
                COBrA.this.rightTabPane.setSelectedIndex(0);
                if (COBrA.this.leftTabPane.getSelectedIndex() == -1) {
                    for (n = 0; n < COBrA.this.leftTabPane.getTabCount(); ++n) {
                        COBrA.this.leftTabPane.setComponentAt(n, new JPanel());
                    }
                    COBrA.this.leftTabPane.addTab(this.ontology.getRootTerm().getName(), Resources.getTreeIcon(), new JPanel());
                    COBrA.this.leftTabPane.addTab(this.ontology.getRootTerm().getName(), Resources.getNodeBasedIcon(), COBrA.this.rightOntologyNodeBasedPanel);
                    COBrA.this.leftTabPane.setSelectedIndex(1);
                    COBrA.this.leftTabPane.setEnabledAt(0, false);
                } else {
                    COBrA.this.leftTabPane.addTab(this.ontology.getRootTerm().getName(), Resources.getTreeIcon(), new JPanel());
                    COBrA.this.leftTabPane.addTab(this.ontology.getRootTerm().getName(), Resources.getNodeBasedIcon(), new JPanel());
                    COBrA.this.leftTabPane.setEnabledAt(1, true);
                }
                if (COBrA.this.rightTabPane.getTabCount() == 2) {
                    COBrA.this.rightTabPane.setEnabledAt(1, false);
                }
                if ((n = COBrA.this.rightTabPane.getSelectedIndex()) >= 2) {
                    COBrA.this.leftTabPane.setEnabledAt(n - 2, false);
                } else if (COBrA.this.leftTabPane.getTabCount() > 2) {
                    COBrA.this.leftTabPane.setEnabledAt(n + 2, false);
                } else {
                    COBrA.this.leftTabPane.setEnabledAt(n, false);
                }
                COBrA.this.leftTabPane.addChangeListener(COBrA.this.tabChangeListener);
                COBrA.this.rightTabPane.addChangeListener(COBrA.this.tabChangeListener);
                if (this.ontologyType == 4) {
                    COBrA.this.tabChangeListener.stateChanged(new ChangeEvent(COBrA.this.leftTabPane));
                    COBrA.this.tabChangeListener.stateChanged(new ChangeEvent(COBrA.this.rightTabPane));
                }
                COBrA.this.rightOntologyRead = true;
                if (COBrA.this.leftOntologyRead) {
                    COBrA.this.makeAnnotationButton.setEnabled(true);
                }
                COBrA.this.saveLeftButton.setEnabled(true);
                COBrA.this.saveAsLeftButton.setEnabled(true);
                COBrA.this.saveRightButton.setEnabled(true);
                COBrA.this.saveAsRightButton.setEnabled(true);
                if (COBrA.this.leftOntologyFile != null) {
                    if (COBrA.this.rightOntologyFile != null) {
                        COBrA.this.setTitle("COBrA  " + COBrA.this.leftOntologyFile.getName() + " - " + COBrA.this.rightOntologyFile.getName());
                    } else {
                        COBrA.this.setTitle("COBrA  " + COBrA.this.leftOntologyFile.getName());
                    }
                } else if (COBrA.this.rightOntologyFile != null) {
                    COBrA.this.setTitle("COBrA  " + COBrA.this.rightOntologyFile.getName());
                }
                ((GoTermTreeModel)COBrA.this.rightOntologyTreePanel.getTree().getModel()).reload();
                COBrA.this.leftTabPane.getSelectedComponent().repaint();
                COBrA.this.rightTabPane.getSelectedComponent().repaint();
                return this.ontology;
            }
            return null;
        }

        public void finished() {
            COBrA.this.setCursor(Cursor.getDefaultCursor());
            try {
                if (this.ontologyType == 4) {
                    COBrA.this.ontologyFileReader.close();
                }
                COBrA.this.statusPanel.remove(COBrA.this.readWriteStatusBar);
                COBrA.this.statusPanel.repaint();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                COBrA.this.statusPanel.remove(COBrA.this.readWriteStatusBar);
                COBrA.this.statusPanel.repaint();
            }
        }
    }

    class ReadOntologyActionListener
    extends AbstractAction {
        GoOntology ontology;
        int ontologySite;
        int ontologyType;

        public ReadOntologyActionListener(String string, GoOntology goOntology, int n) {
            super(string);
            this.ontology = goOntology;
            this.ontologySite = n;
            this.ontologyType = 4;
        }

        public ReadOntologyActionListener(String string, GoOntology goOntology, int n, int n2) {
            super(string);
            this.ontology = goOntology;
            this.ontologySite = n;
            this.ontologyType = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.ontologyType == 5 || this.ontologyType == 6 || this.ontologyType == 7) {
                ReadWorker readWorker = new ReadWorker(null, this.ontology, this.ontologySite, this.ontologyType);
                readWorker.start();
                return;
            }
            JFileChooser jFileChooser = new JFileChooser(COBrA.this.lastDirectory);
            int n = jFileChooser.showOpenDialog(COBrA.this);
            String string = actionEvent.getSource() instanceof JButton ? "Tool Bar - Button." : "Menu Bar - Item.";
            if (n == 0) {
                String string2 = jFileChooser.getSelectedFile().getName();
                String string3 = COBrA.selectFileType(string2);
                if (string3 == null) {
                    return;
                }
                File file = jFileChooser.getSelectedFile();
                if (this.ontologySite == 0) {
                    COBrA.this.leftOntologyFile = file;
                    COBrA.this.leftOntologyFileType = string3;
                } else if (this.ontologySite == 1) {
                    COBrA.this.rightOntologyFile = file;
                    COBrA.this.rightOntologyFileType = string3;
                } else if (this.ontologySite == 2) {
                    COBrA.this.mappingOntologyFile = file;
                    COBrA.this.mappingOntologyFileType = string3;
                }
                try {
                    ProgressMonitor progressMonitor = new ProgressMonitor(COBrA.this, "Read " + file.getName(), null, 0, 100);
                    COBrA.this.statusPanel.add(COBrA.this.readWriteStatusBar);
                    if (string3 == GO_XML || string3 == GO_RDF) {
                        COBrA.this.ontologyFileReader = new GoXMLReader(file, COBrA.this.readWriteStatusBar, COBrA.this.relationshipTypes, SWEBTools.GO_RDF);
                    } else if (string3 == XSPAN_RDFS) {
                        COBrA.this.ontologyFileReader = new GoXMLReader(file, COBrA.this.readWriteStatusBar, COBrA.this.relationshipTypes, SWEBTools.XSPAN_RDFS);
                    } else if (string3 == XSPAN_OWL) {
                        COBrA.this.ontologyFileReader = new GoXMLReader(file, COBrA.this.readWriteStatusBar, COBrA.this.relationshipTypes, SWEBTools.XSPAN_OWL);
                    } else if (string3 == GO_FLAT) {
                        COBrA.this.ontologyFileReader = new GoFlatFileReader(file, COBrA.this.readWriteStatusBar, COBrA.this.relationshipTypes);
                    } else if (string3 == DEDIT_FLAT) {
                        COBrA.this.ontologyFileReader = new DAGEditReader(file, COBrA.this.readWriteStatusBar, COBrA.this.relationshipTypes);
                    } else {
                        return;
                    }
                    COBrA.this.statusLabel.setForeground(Color.BLACK);
                    COBrA.this.statusLabel.setText("Read " + file.getName() + "   ");
                    COBrA.this.readWriteStatusBar.setValue(0);
                    progressMonitor.setProgress(0);
                    ReadWorker readWorker = new ReadWorker(null, this.ontology, this.ontologySite);
                    readWorker.start();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else if (n == 1) {
                if (this.ontologySite == 0) {
                    if (TaskGenerator.isStarted()) {
                        LoggerCreator.getLogger().info("Read left ontology canceled. Used " + string);
                    }
                } else if (this.ontologySite == 1) {
                    if (TaskGenerator.isStarted()) {
                        LoggerCreator.getLogger().info("Read right ontology canceled. Used " + string);
                    }
                } else if (this.ontologySite == 2 && TaskGenerator.isStarted()) {
                    LoggerCreator.getLogger().info("Read cell ontology canceled. Used " + string);
                }
                COBrA.this.statusLabel.setForeground(Color.BLUE);
                COBrA.this.statusLabel.setText("Canceled read command.");
                COBrA.this.statusPanel.remove(COBrA.this.readWriteStatusBar);
                COBrA.this.statusPanel.repaint();
            }
        }
    }
}

