/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.rdf.implementation.syntax.sirpac;

import edu.stanford.db.rdf.vocabulary.order_20000527.RDFX;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.w3c.rdf.model.Literal;
import org.w3c.rdf.model.Model;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.RDFNode;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;
import org.w3c.rdf.syntax.RDFSerializer;
import org.w3c.rdf.util.RDFUtil;
import org.w3c.rdf.vocabulary.rdf_schema_19990303.RDFS;
import org.w3c.rdf.vocabulary.rdf_syntax_19990222.RDF;

public class SiRS
implements Comparator,
RDFSerializer {
    Model model;
    Hashtable namespaces = new Hashtable();
    Map overridenNamespaceMap = null;
    String rdfNsAbb = null;
    boolean ENABLE_EXPERIMENTAL = true;
    boolean useAbbrevSyntax = true;
    final char ABB_LONG = '\u0000';
    final char ABB_CDATA = '\u0001';
    final char ANYQUOTE = '\u0000';
    final int MAX_ABBLENGTH = 60;
    final String INDENT_ABB = "\t ";
    final String INDENT_LONG = "\t";

    public SiRS() {
    }

    public SiRS(Map map) {
        this.overridenNamespaceMap = map;
    }

    String IDorAbout(String string) throws ModelException {
        return " " + this.rdfNsAbb + ":about=\"" + this.shortcutPrefix(string) + "\"";
    }

    char abbrevQuote(String string) {
        int n = 0;
        boolean bl = false;
        boolean bl2 = true;
        int n2 = 0;
        while (n2 < string.length()) {
            int n4 = string.charAt(n2);
            if (n4 == 60 || n4 == 38) {
                return '\u0001';
            }
            if (n4 == 10) {
                bl = true;
            }
            if (n4 == 34 || n4 == 39) {
                if (n == 0) {
                    n = n4 == 34 ? 39 : 34;
                } else if (n4 == n) {
                    return '\u0001';
                }
            }
            if (!Character.isWhitespace((char)n4)) {
                bl2 = false;
            }
            ++n2;
        }
        if (bl2 && bl) {
            return '\u0001';
        }
        if (bl || string.length() > 60) {
            return bl2 ? (char)'\u0001' : '\u0000';
        }
        return (char)(n == 0 ? 34 : n);
    }

    boolean canAbbrev(String string) {
        if (string.length() > 60) {
            return false;
        }
        char c = this.abbrevQuote(string);
        return c == '\"' || c == '\'';
    }

    boolean canAbbrev(RDFNode rDFNode) throws ModelException {
        return this.useAbbrevSyntax && rDFNode instanceof Literal && this.canAbbrev(rDFNode.getLabel());
    }

    public int compare(Object object, Object object2) {
        try {
            Statement statement = (Statement)object;
            Statement statement2 = (Statement)object2;
            int n = this.compare(statement.subject(), statement2.subject());
            if (n != 0) {
                return n;
            }
            RDFNode rDFNode = statement.object();
            RDFNode rDFNode2 = statement2.object();
            boolean bl = rDFNode instanceof Resource;
            boolean bl2 = rDFNode2 instanceof Resource;
            if (bl && bl2) {
                return this.compare((Resource)rDFNode, (Resource)rDFNode2);
            }
            if (bl2) {
                return -1;
            }
            if (bl) {
                return 1;
            }
            bl = this.canAbbrev(rDFNode.getLabel());
            bl2 = this.canAbbrev(rDFNode2.getLabel());
            if (bl && !bl2) {
                return -1;
            }
            if (bl2 && !bl) {
                return 1;
            }
            n = this.compare(statement.predicate(), statement2.predicate());
            if (n != 0) {
                return n;
            }
            return rDFNode.getLabel().compareTo(rDFNode2.getLabel());
        }
        catch (ModelException modelException) {
            return 0;
        }
    }

    int compare(Resource resource, Resource resource2) throws ModelException {
        String string = resource.getNamespace();
        String string2 = resource2.getNamespace();
        if (string == null && string2 != null) {
            return -1;
        }
        if (string2 == null && string != null) {
            return 1;
        }
        if (string == null && string2 == null || string.equals(string2)) {
            return resource.getLocalName().compareTo(resource2.getLocalName());
        }
        return string.compareTo(string2);
    }

    String escapeAttValue(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<' || c == '>' || c == '&') {
                StringBuffer stringBuffer = new StringBuffer();
                this.escapeAttValue(stringBuffer, string);
                return stringBuffer.toString();
            }
            ++n;
        }
        return string;
    }

    void escapeAttValue(StringBuffer stringBuffer, String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
    }

    void escapeCDATA(PrintWriter printWriter, String string) {
        int n = 0;
        int n2 = 0;
        do {
            if ((n2 = string.indexOf("]]>", n)) >= 0) {
                printWriter.print(string.substring(n, n2 + 2));
                printWriter.print("]]><![CDATA[");
                n = n2 + 2;
                continue;
            }
            printWriter.print(string.substring(n));
        } while (n2 >= 0 && n < string.length());
    }

    void getNamespace(Hashtable hashtable, Resource resource) throws ModelException {
        String string = RDFUtil.getNamespace(resource);
        if (hashtable.containsKey(string)) {
            return;
        }
        hashtable.put(string, resource.getURI());
    }

    Hashtable getNamespaces(Iterator iterator) throws ModelException {
        Hashtable hashtable = new Hashtable();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            boolean bl = false;
            boolean bl2 = false;
            if (RDF.type.equals(statement.predicate())) {
                this.getNamespace(hashtable, (Resource)statement.object());
                bl = true;
            } else if (RDFS.subClassOf.equals(statement.predicate()) || RDFS.subPropertyOf.equals(statement.predicate())) {
                this.getNamespace(hashtable, statement.subject());
                this.getNamespace(hashtable, (Resource)statement.object());
                bl2 = true;
                bl = true;
            } else if (this.ENABLE_EXPERIMENTAL && RDFX.order.equals(statement.predicate())) {
                this.useAbbrevSyntax = false;
            }
            this.getNamespace(hashtable, statement.predicate());
            if (!bl2 && statement.subject().getNamespace() != null) {
                this.getNamespace(hashtable, statement.subject());
            }
            if (bl || !(statement.object() instanceof Resource) || ((Resource)statement.object()).getNamespace() == null) continue;
            this.getNamespace(hashtable, (Resource)statement.object());
        }
        return hashtable;
    }

    public void serialize(Model model, Writer writer) throws IOException, ModelException {
        Object object;
        Object object2;
        if (model == null) {
            return;
        }
        this.model = model;
        if (this.overridenNamespaceMap != null) {
            this.rdfNsAbb = (String)this.overridenNamespaceMap.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        }
        if (this.rdfNsAbb == null) {
            this.rdfNsAbb = "rdf";
        }
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.println("<?xml version='1.0' encoding='ISO-8859-1'?>");
        if (model.isEmpty()) {
            printWriter.println("<" + this.rdfNsAbb + ":RDF xmlns:" + this.rdfNsAbb + "=\"" + "http://www.w3.org/1999/02/22-rdf-syntax-ns#" + "\"/>");
            printWriter.flush();
            return;
        }
        Hashtable hashtable = new Hashtable();
        Statement[] statementArray = RDFUtil.getStatementArray(model);
        Arrays.sort(statementArray, this);
        List<Statement> list = Arrays.asList(statementArray);
        printWriter.println("<!DOCTYPE " + this.rdfNsAbb + ":RDF [");
        Hashtable hashtable2 = this.getNamespaces(list.iterator());
        int n = 0;
        String string = "\t ";
        this.namespaces.clear();
        hashtable2.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", this.rdfNsAbb);
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = null;
            if (this.overridenNamespaceMap != null) {
                object = (String)this.overridenNamespaceMap.get(object2);
            }
            while (object == null) {
                if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(object2)) {
                    object = this.rdfNsAbb;
                    continue;
                }
                if ("http://www.w3.org/TR/1999/PR-rdf-schema-19990303#".equals(object2)) {
                    object = "rdfs";
                    continue;
                }
                Object object3 = object = n <= 25 ? String.valueOf((char)(97 + n++)) : "n" + (n++ - 122 + 97);
                if (this.overridenNamespaceMap == null || !this.overridenNamespaceMap.containsValue(object)) continue;
                object = null;
            }
            this.namespaces.put(object2, object);
            printWriter.print(String.valueOf(string) + "<!ENTITY " + (String)object + " '" + (String)object2 + "'>");
            string = "\n\t ";
        }
        printWriter.println("\n]>");
        printWriter.print("<" + this.rdfNsAbb + ":RDF ");
        string = "";
        object2 = this.namespaces.elements();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            printWriter.print(String.valueOf(string) + "xmlns:" + (String)object + "=\"&" + (String)object + ";\"");
            string = "\n\t ";
        }
        printWriter.println(">");
        object = new Vector();
        Statement statement = null;
        Statement statement2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 <= list.size()) {
            block42: {
                block41: {
                    String string2;
                    Object object4;
                    RDFNode rDFNode;
                    Resource resource;
                    boolean bl;
                    Resource resource2;
                    statement = statement2;
                    statement2 = null;
                    if (n2 < list.size()) {
                        statement2 = list.get(n2);
                    }
                    if (statement != null && statement2 != null && statement.subject().equals(statement2.subject()) || n2 <= 0) break block41;
                    Statement statement3 = null;
                    String string3 = null;
                    boolean bl2 = false;
                    int n4 = 0;
                    while (n4 < ((Vector)object).size()) {
                        Statement statement4 = (Statement)((Vector)object).elementAt(n4);
                        Resource resource3 = statement4.predicate();
                        if (resource3.equals(RDF.type)) {
                            String string4 = RDFUtil.getLocalName((Resource)statement4.object());
                            if (!bl2 && SiRS.validXMLTag(string4)) {
                                statement3 = statement4;
                                string3 = String.valueOf(String.valueOf(this.namespaces.get(RDFUtil.getNamespace((Resource)statement3.object())))) + ":" + string4;
                                ((Vector)object).removeElementAt(n4--);
                                bl2 = true;
                            }
                        }
                        if (this.ENABLE_EXPERIMENTAL && statement4.subject() instanceof Statement && (RDFX.order.equals(resource3) || RDFX.backwardOrder.equals(resource3))) {
                            ((Vector)object).removeElementAt(n4--);
                        }
                        ++n4;
                    }
                    int n5 = 0;
                    int n6 = ((Vector)object).size();
                    if (statement3 == null && n6 == 0) break block42;
                    int n7 = 0;
                    while (n7 < n6) {
                        Statement statement5;
                        resource2 = (Statement)((Vector)object).elementAt(n7);
                        if (!this.canAbbrev(resource2.object())) break;
                        Statement statement6 = statement5 = n7 > 0 ? (Statement)((Vector)object).elementAt(n7 - 1) : null;
                        if (n7 > 0 && resource2.predicate().equals(statement5.predicate())) {
                            ((Vector)object).removeElementAt(n7);
                            ((Vector)object).removeElementAt(n7 - 1);
                            ((Vector)object).addElement(statement5);
                            ((Vector)object).addElement(resource2);
                            n6 -= 2;
                            n7 -= 2;
                            if (n5 > 0) {
                                --n5;
                            }
                        } else {
                            ++n5;
                        }
                        ++n7;
                    }
                    resource2 = statement.subject();
                    boolean bl3 = bl = n5 == ((Vector)object).size();
                    if (statement3 != null) {
                        printWriter.print("<" + string3);
                    } else {
                        printWriter.print("<" + this.rdfNsAbb + ":Description");
                    }
                    printWriter.print(this.IDorAbout(resource2.getLabel()));
                    int n8 = 0;
                    while (n8 < n5) {
                        Statement statement7 = (Statement)((Vector)object).elementAt(n8);
                        resource = statement7.predicate();
                        rDFNode = statement7.object();
                        object4 = (String)this.namespaces.get(RDFUtil.getNamespace(resource));
                        string2 = RDFUtil.getLocalName(resource);
                        char c = this.abbrevQuote(rDFNode.getLabel());
                        printWriter.print(String.valueOf(string) + (String)object4 + ":" + string2 + "=" + c + rDFNode.getLabel() + c);
                        ++n8;
                    }
                    if (bl) {
                        printWriter.println("/>");
                    } else {
                        printWriter.println('>');
                        int n9 = n5;
                        while (n9 < ((Vector)object).size()) {
                            String string5;
                            String string6;
                            resource = (Statement)((Vector)object).elementAt(n9);
                            rDFNode = resource.predicate();
                            object4 = resource.object();
                            string2 = (String)this.namespaces.get(RDFUtil.getNamespace(RDFX.order));
                            String string7 = "";
                            if (this.ENABLE_EXPERIMENTAL) {
                                string6 = RDFUtil.getObjectLiteral(this.model, resource, RDFX.order);
                                string5 = RDFUtil.getObjectLiteral(this.model, resource, RDFX.backwardOrder);
                                if (string6 != null) {
                                    string7 = String.valueOf(string7) + " " + string2 + ":order=\"" + string6 + "\"";
                                }
                                if (string5 != null) {
                                    string7 = String.valueOf(string7) + " " + string2 + ":backwardOrder=\"" + string5 + "\"";
                                }
                            }
                            string6 = (String)this.namespaces.get(RDFUtil.getNamespace((Resource)rDFNode));
                            string5 = RDFUtil.getLocalName((Resource)rDFNode);
                            if (object4 instanceof Resource) {
                                printWriter.println("\t<" + string6 + ":" + string5 + " " + this.rdfNsAbb + ":resource=\"" + this.shortcutPrefix(object4.getLabel()) + "\"" + string7 + "/>");
                            } else {
                                char c = this.abbrevQuote(object4.getLabel());
                                printWriter.print("\t<" + string6 + ":" + string5);
                                if (c == '\u0001') {
                                    printWriter.print(" xml:space='preserve'");
                                }
                                printWriter.print(String.valueOf(string7) + ">");
                                if (c == '\u0001') {
                                    printWriter.print("<![CDATA[");
                                    this.escapeCDATA(printWriter, object4.getLabel());
                                } else {
                                    printWriter.print(object4.getLabel());
                                }
                                if (c == '\u0001') {
                                    printWriter.print("]]>");
                                }
                                printWriter.println("</" + string6 + ":" + string5 + ">");
                            }
                            ++n9;
                        }
                        if (statement3 != null) {
                            printWriter.println("</" + string3 + ">");
                        } else {
                            printWriter.println("</" + this.rdfNsAbb + ":Description>");
                        }
                    }
                    ((Vector)object).setSize(0);
                }
                if (statement2 != null) {
                    ((Vector)object).addElement(statement2);
                }
            }
            ++n2;
        }
        printWriter.println("</" + this.rdfNsAbb + ":RDF>");
        printWriter.flush();
    }

    String shortcutPrefix(String string) {
        Enumeration enumeration = this.namespaces.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.length() <= 0 || !string.startsWith(string2)) continue;
            return "&" + this.namespaces.get(string2) + ";" + this.escapeAttValue(string.substring(string2.length()));
        }
        return this.escapeAttValue(string);
    }

    public void useExperimentalFeatures(boolean bl) {
        this.ENABLE_EXPERIMENTAL = bl;
    }

    static boolean validXMLTag(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isDigit(c) && !Character.isLetter(c) && c != '.' && c != '_' && c != '-') {
                return false;
            }
            ++n;
        }
        return true;
    }
}

