/*
 * Decompiled with CFR 0.152.
 */
package org.brownell.xml.aelfred2;

import java.io.BufferedInputStream;
import java.io.CharConversionException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.brownell.xml.aelfred2.SAXDriver;
import org.xml.sax.SAXException;

final class XmlParser {
    private static final boolean USE_CHEATS = true;
    private static final int DEFAULT_ATTR_COUNT = 23;
    public static final int CONTENT_UNDECLARED = 0;
    public static final int CONTENT_ANY = 1;
    public static final int CONTENT_EMPTY = 2;
    public static final int CONTENT_MIXED = 3;
    public static final int CONTENT_ELEMENTS = 4;
    public static final int ENTITY_UNDECLARED = 0;
    public static final int ENTITY_INTERNAL = 1;
    public static final int ENTITY_NDATA = 2;
    public static final int ENTITY_TEXT = 3;
    public static final int ATTRIBUTE_UNDECLARED = 0;
    public static final int ATTRIBUTE_CDATA = 1;
    public static final int ATTRIBUTE_ID = 2;
    public static final int ATTRIBUTE_IDREF = 3;
    public static final int ATTRIBUTE_IDREFS = 4;
    public static final int ATTRIBUTE_ENTITY = 5;
    public static final int ATTRIBUTE_ENTITIES = 6;
    public static final int ATTRIBUTE_NMTOKEN = 7;
    public static final int ATTRIBUTE_NMTOKENS = 8;
    public static final int ATTRIBUTE_ENUMERATED = 9;
    public static final int ATTRIBUTE_NOTATION = 10;
    private static Hashtable attributeTypeHash = new Hashtable(13);
    private static final int ENCODING_EXTERNAL = 0;
    private static final int ENCODING_UTF_8 = 1;
    private static final int ENCODING_ISO_8859_1 = 2;
    private static final int ENCODING_UCS_2_12 = 3;
    private static final int ENCODING_UCS_2_21 = 4;
    private static final int ENCODING_UCS_4_1234 = 5;
    private static final int ENCODING_UCS_4_4321 = 6;
    private static final int ENCODING_UCS_4_2143 = 7;
    private static final int ENCODING_UCS_4_3412 = 8;
    private static final int ENCODING_ASCII = 9;
    public static final int ATTRIBUTE_DEFAULT_UNDECLARED = 30;
    public static final int ATTRIBUTE_DEFAULT_SPECIFIED = 31;
    public static final int ATTRIBUTE_DEFAULT_IMPLIED = 32;
    public static final int ATTRIBUTE_DEFAULT_REQUIRED = 33;
    public static final int ATTRIBUTE_DEFAULT_FIXED = 34;
    private static final int INPUT_NONE = 0;
    private static final int INPUT_INTERNAL = 1;
    private static final int INPUT_EXTERNAL = 2;
    private static final int INPUT_STREAM = 3;
    private static final int INPUT_BUFFER = 4;
    private static final int INPUT_READER = 5;
    private static final int LIT_ENTITY_REF = 2;
    private static final int LIT_NORMALIZE = 4;
    private static final int LIT_ATTRIBUTE = 8;
    private static final int LIT_DISABLE_PE = 16;
    private static final int LIT_DISABLE_CREF = 32;
    private static final int LIT_DISABLE_EREF = 64;
    private static final int LIT_ENTITY_CHECK = 128;
    private static final int CONTEXT_NORMAL = 0;
    private static final int CONTEXT_LITERAL = 1;
    private SAXDriver handler;
    private Reader reader;
    private InputStream is;
    private int line;
    private int column;
    private int sourceType;
    private Stack inputStack;
    private URLConnection externalEntity;
    private int encoding;
    private int currentByteCount;
    private char[] readBuffer;
    private int readBufferPos;
    private int readBufferLength;
    private int readBufferOverflow;
    private static final int READ_BUFFER_MAX = 16384;
    private byte[] rawReadBuffer;
    private static int DATA_BUFFER_INITIAL;
    private char[] dataBuffer;
    private int dataBufferPos;
    private static int NAME_BUFFER_INITIAL;
    private char[] nameBuffer;
    private int nameBufferPos;
    private Hashtable elementInfo;
    private Hashtable entityInfo;
    private Hashtable notationInfo;
    private String currentElement;
    private int currentElementContent;
    private String basePublicId;
    private String baseURI;
    private int baseEncoding;
    private Reader baseReader;
    private InputStream baseInputStream;
    private char[] baseInputBuffer;
    private int baseInputBufferStart;
    private int baseInputBufferLength;
    private Stack entityStack;
    private boolean inLiteral;
    private boolean expandPE;
    private boolean peIsError;
    private static final int SYMBOL_TABLE_LENGTH = 1087;
    private Object[][] symbolTable;
    private String[] tagAttributes;
    private int tagAttributePos;
    private boolean sawCR;
    private boolean inCDATA;

    static {
        attributeTypeHash.put("CDATA", new Integer(1));
        attributeTypeHash.put("ID", new Integer(2));
        attributeTypeHash.put("IDREF", new Integer(3));
        attributeTypeHash.put("IDREFS", new Integer(4));
        attributeTypeHash.put("ENTITY", new Integer(5));
        attributeTypeHash.put("ENTITIES", new Integer(6));
        attributeTypeHash.put("NMTOKEN", new Integer(7));
        attributeTypeHash.put("NMTOKENS", new Integer(8));
        attributeTypeHash.put("NOTATION", new Integer(10));
        DATA_BUFFER_INITIAL = 4096;
        NAME_BUFFER_INITIAL = 1024;
    }

    XmlParser() {
        this.cleanupVariables();
    }

    private void cleanupVariables() {
        this.dataBuffer = null;
        this.nameBuffer = null;
        this.elementInfo = null;
        this.entityInfo = null;
        this.notationInfo = null;
        this.currentElement = null;
        this.inputStack = null;
        this.entityStack = null;
        this.externalEntity = null;
        this.tagAttributes = null;
        this.rawReadBuffer = null;
        this.symbolTable = null;
    }

    private void copyIso8859_1ReadBuffer(int n, char c) throws IOException {
        int n2 = 0;
        int n4 = this.readBufferPos;
        while (n2 < n) {
            char c2 = (char)(this.rawReadBuffer[n2] & 0xFF);
            if ((c2 & c) != 0) {
                throw new CharConversionException("non-ASCII character U+" + Integer.toHexString(c2));
            }
            this.readBuffer[n4] = c2;
            if (c2 == '\r') {
                this.sawCR = true;
            }
            ++n2;
            ++n4;
        }
        this.readBufferLength = n4;
    }

    private void copyUcs2ReadBuffer(int n, int n2, int n4) throws SAXException {
        int n5 = this.readBufferPos;
        if (n > 0 && n % 2 != 0) {
            this.encodingError("odd number of bytes in UCS-2 encoding", -1, n);
        }
        if (n2 == 0) {
            int n6 = 0;
            while (n6 < n) {
                char c = (char)(this.rawReadBuffer[n6 + 1] << 8);
                c = (char)(c | 0xFF & this.rawReadBuffer[n6]);
                this.readBuffer[n5++] = c;
                if (c == '\r') {
                    this.sawCR = true;
                }
                n6 += 2;
            }
        } else {
            int n7 = 0;
            while (n7 < n) {
                char c = (char)(this.rawReadBuffer[n7] << 8);
                c = (char)(c | 0xFF & this.rawReadBuffer[n7 + 1]);
                this.readBuffer[n5++] = c;
                if (c == '\r') {
                    this.sawCR = true;
                }
                n7 += 2;
            }
        }
        this.readBufferLength = n5;
    }

    private void copyUcs4ReadBuffer(int n, int n2, int n4, int n5, int n6) throws SAXException {
        int n7 = this.readBufferPos;
        if (n > 0 && n % 4 != 0) {
            this.encodingError("number of bytes in UCS-4 encoding not divisible by 4", -1, n);
        }
        int n8 = 0;
        while (n8 < n) {
            int n9 = (this.rawReadBuffer[n8] & 0xFF) << n2 | (this.rawReadBuffer[n8 + 1] & 0xFF) << n4 | (this.rawReadBuffer[n8 + 2] & 0xFF) << n5 | (this.rawReadBuffer[n8 + 3] & 0xFF) << n6;
            if (n9 < 65535) {
                this.readBuffer[n7++] = (char)n9;
                if (n9 == 13) {
                    this.sawCR = true;
                }
            } else if (n9 < 0x10FFFF) {
                this.readBuffer[n7++] = (char)(0xD8 | (n9 -= 65536) >> 10 & 0x3FF);
                this.readBuffer[n7++] = (char)(0xDC | n9 & 0x3FF);
            } else {
                this.encodingError("UCS-4 value out of range for Unicode", n9, n8);
            }
            n8 += 4;
        }
        this.readBufferLength = n7;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void copyUtf8ReadBuffer(int n) throws SAXException, IOException {
        int n2 = 0;
        int n4 = this.readBufferPos;
        char c = '\u0000';
        while (n2 < n) {
            block7: {
                byte by;
                block8: {
                    block9: {
                        if ((by = this.rawReadBuffer[n2++]) >= 0) break block8;
                        if ((by & 0xE0) != 192) break block9;
                        c = (char)((by & 0x1F) << 6 | this.getNextUtf8Byte(n2++, n));
                        break block7;
                    }
                    if ((by & 0xF0) == 224) {
                        c = (char)((by & 0xF) << 12 | this.getNextUtf8Byte(n2++, n) << 6 | this.getNextUtf8Byte(n2++, n));
                        break block7;
                    } else {
                        if ((by & 0xF8) == 240) {
                            int n5 = by & 7;
                            n5 = (n5 << 6) + this.getNextUtf8Byte(n2++, n);
                            n5 = (n5 << 6) + this.getNextUtf8Byte(n2++, n);
                            if ((n5 = (n5 << 6) + this.getNextUtf8Byte(n2++, n)) <= 65535) {
                                c = (char)n5;
                                break block7;
                            } else {
                                if (n5 > 0x10FFFF) {
                                    this.encodingError("UTF-8 value out of range for Unicode", n5, 0);
                                }
                                this.readBuffer[n4++] = (char)(0xD800 | (n5 -= 65536) >> 10);
                                this.readBuffer[n4++] = (char)(0xDC00 | n5 & 0x3FF);
                                continue;
                            }
                        }
                        this.encodingError("unsupported five or six byte UTF-8 sequence", 0xFF & by, n2);
                        c = '\u0000';
                    }
                    break block7;
                }
                c = (char)by;
            }
            this.readBuffer[n4++] = c;
            if (c != '\r') continue;
            this.sawCR = true;
        }
        this.readBufferLength = n4;
    }

    private void dataBufferAppend(char c) {
        if (this.dataBufferPos >= this.dataBuffer.length) {
            this.dataBuffer = (char[])this.extendArray(this.dataBuffer, this.dataBuffer.length, this.dataBufferPos);
        }
        this.dataBuffer[this.dataBufferPos++] = c;
    }

    private void dataBufferAppend(String string) {
        this.dataBufferAppend(string.toCharArray(), 0, string.length());
    }

    private void dataBufferAppend(char[] cArray, int n, int n2) {
        this.dataBuffer = (char[])this.extendArray(this.dataBuffer, this.dataBuffer.length, this.dataBufferPos + n2);
        System.arraycopy(cArray, n, this.dataBuffer, this.dataBufferPos, n2);
        this.dataBufferPos += n2;
    }

    private void dataBufferFlush() throws SAXException {
        if (this.currentElementContent == 4 && this.dataBufferPos > 0 && !this.inCDATA) {
            int n = 0;
            while (n < this.dataBufferPos) {
                if (!this.isWhitespace(this.dataBuffer[n])) {
                    this.handler.charData(this.dataBuffer, 0, this.dataBufferPos);
                    this.dataBufferPos = 0;
                }
                ++n;
            }
            if (this.dataBufferPos > 0) {
                this.handler.ignorableWhitespace(this.dataBuffer, 0, this.dataBufferPos);
                this.dataBufferPos = 0;
            }
        } else if (this.dataBufferPos > 0) {
            this.handler.charData(this.dataBuffer, 0, this.dataBufferPos);
            this.dataBufferPos = 0;
        }
    }

    private void dataBufferNormalize() {
        int n = 0;
        int n2 = 0;
        int n4 = this.dataBufferPos;
        while (n2 < n4 && this.isWhitespace(this.dataBuffer[n2])) {
            ++n2;
        }
        while (n4 > n2 && this.isWhitespace(this.dataBuffer[n4 - 1])) {
            --n4;
        }
        while (n2 < n4) {
            char c;
            if (this.isWhitespace(c = this.dataBuffer[n2++])) {
                while (n2 < n4 && this.isWhitespace(this.dataBuffer[n2++])) {
                }
                this.dataBuffer[n++] = 32;
                this.dataBuffer[n++] = this.dataBuffer[n2 - 1];
                continue;
            }
            this.dataBuffer[n++] = c;
        }
        this.dataBufferPos = n;
    }

    private String dataBufferToString() {
        String string = new String(this.dataBuffer, 0, this.dataBufferPos);
        this.dataBufferPos = 0;
        return string;
    }

    public Enumeration declaredAttributes(String string) {
        return this.declaredAttributes((Object[])this.elementInfo.get(string));
    }

    private Enumeration declaredAttributes(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Hashtable hashtable = (Hashtable)objectArray[2];
        if (hashtable == null) {
            return null;
        }
        return hashtable.keys();
    }

    public Enumeration declaredElements() {
        return this.elementInfo.keys();
    }

    public Enumeration declaredEntities() {
        return this.entityInfo.keys();
    }

    public Enumeration declaredNotations() {
        return this.notationInfo.keys();
    }

    private void detectEncoding() throws SAXException, IOException {
        byte[] byArray = new byte[4];
        this.is.mark(4);
        this.is.read(byArray);
        this.is.reset();
        if (XmlParser.tryEncoding(byArray, (byte)0, (byte)0, (byte)0, (byte)60)) {
            this.encoding = 5;
        } else if (XmlParser.tryEncoding(byArray, (byte)60, (byte)0, (byte)0, (byte)0)) {
            this.encoding = 6;
        } else if (XmlParser.tryEncoding(byArray, (byte)0, (byte)0, (byte)60, (byte)0)) {
            this.encoding = 7;
        } else if (XmlParser.tryEncoding(byArray, (byte)0, (byte)60, (byte)0, (byte)0)) {
            this.encoding = 8;
        } else if (XmlParser.tryEncoding(byArray, (byte)-2, (byte)-1)) {
            this.encoding = 3;
            this.is.read();
            this.is.read();
        } else if (XmlParser.tryEncoding(byArray, (byte)-1, (byte)-2)) {
            this.encoding = 4;
            this.is.read();
            this.is.read();
        } else if (XmlParser.tryEncoding(byArray, (byte)0, (byte)60, (byte)0, (byte)63)) {
            this.encoding = 3;
            this.error("no byte-order mark for UCS-2 entity");
        } else if (XmlParser.tryEncoding(byArray, (byte)60, (byte)0, (byte)63, (byte)0)) {
            this.encoding = 4;
            this.error("no byte-order mark for UCS-2 entity");
        } else if (XmlParser.tryEncoding(byArray, (byte)60, (byte)63, (byte)120, (byte)109)) {
            this.encoding = 1;
            this.read8bitEncodingDeclaration();
        } else {
            this.encoding = 1;
        }
    }

    void doParse(String string, String string2, Reader reader, InputStream inputStream, String string3) throws Exception {
        if (this.handler == null) {
            throw new IllegalStateException("no callback handler");
        }
        this.basePublicId = string2;
        this.baseURI = string;
        this.baseReader = reader;
        this.baseInputStream = inputStream;
        this.initializeVariables();
        this.setInternalEntity("amp", "&#38;");
        this.setInternalEntity("lt", "&#60;");
        this.setInternalEntity("gt", "&#62;");
        this.setInternalEntity("apos", "&#39;");
        this.setInternalEntity("quot", "&#34;");
        this.handler.startDocument();
        this.pushURL("[document]", this.basePublicId, this.baseURI, this.baseReader, this.baseInputStream, string3);
        try {
            this.parseDocument();
            this.handler.endDocument();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (this.baseReader != null) {
                try {
                    this.baseReader.close();
                }
                catch (IOException iOException) {}
            }
            if (this.baseInputStream != null) {
                try {
                    this.baseInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            this.cleanupVariables();
            throw throwable;
        }
        Object var7_6 = null;
        if (this.baseReader != null) {
            try {
                this.baseReader.close();
            }
            catch (IOException iOException) {}
        }
        if (this.baseInputStream != null) {
            try {
                this.baseInputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {}
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        this.cleanupVariables();
    }

    private void encodingError(String string, int n, int n2) throws SAXException {
        if (n != -1) {
            string = String.valueOf(string) + " (character code: 0x" + Integer.toHexString(n) + ')';
        }
        String string2 = this.externalEntity != null ? this.externalEntity.getURL().toString() : this.baseURI;
        this.handler.error(string, string2, -1, n2 + this.currentByteCount);
    }

    private void error(String string) throws SAXException {
        this.error(string, null, null);
    }

    private void error(String string, char c, String string2) throws SAXException {
        this.error(string, new Character(c).toString(), string2);
    }

    private void error(String string, String string2, String string3) throws SAXException {
        if (string2 != null) {
            string = String.valueOf(string) + " (found \"" + string2 + "\")";
        }
        if (string3 != null) {
            string = String.valueOf(string) + " (expected \"" + string3 + "\")";
        }
        String string4 = null;
        if (this.externalEntity != null) {
            string4 = this.externalEntity.getURL().toString();
        }
        this.handler.error(string, string4, this.line, this.column);
        throw new SAXException(string);
    }

    private Object extendArray(Object object, int n, int n2) {
        if (n2 < n) {
            return object;
        }
        Object[] objectArray = null;
        int n4 = n * 2;
        if (n4 <= n2) {
            n4 = n2 + 1;
        }
        if (object instanceof char[]) {
            objectArray = new char[n4];
        } else if (object instanceof Object[]) {
            objectArray = new Object[n4];
        } else {
            throw new RuntimeException();
        }
        System.arraycopy(object, 0, objectArray, 0, n);
        return objectArray;
    }

    private void filterCR(boolean bl) {
        int n;
        this.readBufferOverflow = -1;
        int n2 = n = this.readBufferPos;
        block3: while (n < this.readBufferLength) {
            switch (this.readBuffer[n]) {
                case '\r': {
                    if (n == this.readBufferLength - 1) {
                        if (bl) {
                            this.readBufferOverflow = 13;
                            --this.readBufferLength;
                            break block3;
                        }
                        this.readBuffer[n2++] = 10;
                        break block3;
                    }
                    if (this.readBuffer[n + 1] == '\n') {
                        ++n;
                    }
                    this.readBuffer[n2] = 10;
                    break;
                }
                default: {
                    this.readBuffer[n2] = this.readBuffer[n];
                    break;
                }
            }
            ++n2;
            ++n;
        }
        this.readBufferLength = n2;
    }

    private Object[] getAttribute(String string, String string2) {
        Hashtable hashtable = this.getElementAttributes(string);
        if (hashtable == null) {
            return null;
        }
        Object[] objectArray = (Object[])hashtable.get(string2);
        return objectArray;
    }

    public String getAttributeDefaultValue(String string, String string2) {
        Object[] objectArray = this.getAttribute(string, string2);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[1];
    }

    public int getAttributeDefaultValueType(String string, String string2) {
        Object[] objectArray = this.getAttribute(string, string2);
        if (objectArray == null) {
            return 30;
        }
        return (Integer)objectArray[2];
    }

    public String getAttributeEnumeration(String string, String string2) {
        Object[] objectArray = this.getAttribute(string, string2);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[3];
    }

    public String getAttributeExpandedValue(String string, String string2) throws Exception {
        Object[] objectArray = this.getAttribute(string, string2);
        if (objectArray == null) {
            return null;
        }
        if (objectArray[4] == null && objectArray[1] != null) {
            char[] cArray = new char[1];
            int n = 10;
            int n2 = this.getAttributeType(string, string2);
            if (n2 != 1 && n2 != 0) {
                n |= 4;
            }
            cArray[0] = 34;
            this.pushCharArray(null, cArray, 0, 1);
            this.pushString(null, (String)objectArray[1]);
            this.pushCharArray(null, cArray, 0, 1);
            objectArray[4] = this.readLiteral(n);
        }
        return (String)objectArray[4];
    }

    public int getAttributeType(String string, String string2) {
        Object[] objectArray = this.getAttribute(string, string2);
        if (objectArray == null) {
            return 0;
        }
        return (Integer)objectArray[0];
    }

    public int getColumnNumber() {
        return this.column;
    }

    private int getContentType(Object[] objectArray, int n) {
        if (objectArray == null) {
            return n;
        }
        int n2 = (Integer)objectArray[0];
        if (n2 == 0) {
            n2 = n;
        }
        return n2;
    }

    private Hashtable getElementAttributes(String string) {
        Object[] objectArray = (Object[])this.elementInfo.get(string);
        if (objectArray == null) {
            objectArray = this.setElement(string, 0, null);
        }
        return (Hashtable)objectArray[2];
    }

    public String getElementContentModel(String string) {
        Object[] objectArray = (Object[])this.elementInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[1];
    }

    public int getElementContentType(String string) {
        Object[] objectArray = (Object[])this.elementInfo.get(string);
        return this.getContentType(objectArray, 0);
    }

    public String getEntityNotationName(String string) {
        Object[] objectArray = (Object[])this.entityInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[4];
    }

    public String getEntityPublicId(String string) {
        Object[] objectArray = (Object[])this.entityInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[1];
    }

    public String getEntitySystemId(String string) {
        Object[] objectArray = (Object[])this.entityInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[2];
    }

    public int getEntityType(String string) {
        Object[] objectArray = (Object[])this.entityInfo.get(string);
        if (objectArray == null) {
            return 0;
        }
        return (Integer)objectArray[0];
    }

    public String getEntityValue(String string) {
        Object[] objectArray = (Object[])this.entityInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[3];
    }

    public int getLineNumber() {
        return this.line;
    }

    private int getNextUtf8Byte(int n, int n2) throws SAXException, IOException {
        int n4;
        if (n < n2) {
            n4 = this.rawReadBuffer[n];
        } else {
            n4 = this.is.read();
            if (n4 == -1) {
                this.encodingError("unfinished multi-byte UTF-8 sequence at EOF", -1, n);
            }
        }
        if ((n4 & 0xC0) != 128) {
            this.encodingError("bad continuation of multi-byte UTF-8 sequence", n4, n + 1);
        }
        return n4 & 0x3F;
    }

    public String getNotationPublicId(String string) {
        Object[] objectArray = (Object[])this.notationInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[0];
    }

    public String getNotationSystemId(String string) {
        Object[] objectArray = (Object[])this.notationInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[1];
    }

    private void initializeVariables() {
        this.line = 1;
        this.column = 0;
        this.dataBufferPos = 0;
        this.dataBuffer = new char[DATA_BUFFER_INITIAL];
        this.nameBufferPos = 0;
        this.nameBuffer = new char[NAME_BUFFER_INITIAL];
        this.elementInfo = new Hashtable();
        this.entityInfo = new Hashtable();
        this.notationInfo = new Hashtable();
        this.currentElement = null;
        this.currentElementContent = 0;
        this.sourceType = 0;
        this.inputStack = new Stack();
        this.entityStack = new Stack();
        this.externalEntity = null;
        this.tagAttributePos = 0;
        this.tagAttributes = new String[100];
        this.rawReadBuffer = new byte[16384];
        this.readBufferOverflow = -1;
        this.inLiteral = false;
        this.expandPE = false;
        this.peIsError = false;
        this.inCDATA = false;
        this.symbolTable = new Object[1087][];
    }

    /*
     * Unable to fully structure code
     */
    public String intern(char[] var1_1, int var2_2, int var3_3) {
        block5: {
            var4_4 = 0;
            var5_5 = 0;
            var7_6 = var2_2;
            while (var7_6 < var2_2 + var3_3) {
                var5_5 = 31 * var5_5 + var1_1[var7_6];
                ++var7_6;
            }
            var6_7 = this.symbolTable[var5_5 = (var5_5 & 0x7FFFFFFF) % 1087];
            if (var6_7 != null) ** GOTO lbl22
            var6_7 = new Object[8];
            break block5;
            while ((var8_8 = (char[])var6_7[var4_4]) != null) {
                if (((char[])var8_8).length == var3_3) {
                    var9_9 = 0;
                    while (var9_9 < ((Object)var8_8).length) {
                        if (var1_1[var2_2 + var9_9] != var8_8[var9_9]) break;
                        if (var9_9 == var3_3 - 1) {
                            return (String)var6_7[var4_4 + 1];
                        }
                        ++var9_9;
                    }
                }
                var4_4 += 2;
lbl22:
                // 2 sources

                if (var4_4 < var6_7.length) continue;
            }
            var6_7 = (Object[])this.extendArray(var6_7, var6_7.length, var4_4);
        }
        this.symbolTable[var5_5] = var6_7;
        var8_8 = new String(var1_1, var2_2, var3_3).intern();
        var6_7[var4_4] = var8_8.toCharArray();
        var6_7[var4_4 + 1] = var8_8;
        return var8_8;
    }

    private static boolean isExtender(char c) {
        return c == '\u00b7' || c == '\u02d0' || c == '\u02d1' || c == '\u0387' || c == '\u0640' || c == '\u0e46' || c == '\u0ec6' || c == '\u3005' || c >= '\u3031' && c <= '\u3035' || c >= '\u309d' && c <= '\u309e' || c >= '\u30fc' && c <= '\u30fe';
    }

    private final boolean isWhitespace(char c) {
        if (c > ' ') {
            return false;
        }
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    private void parseAttDef(String string) throws Exception {
        String string2 = null;
        String string3 = this.readNmtoken(true);
        this.requireWhitespace();
        int n = this.readAttType();
        if (n == 9 || n == 10) {
            string2 = this.dataBufferToString();
        }
        this.requireWhitespace();
        this.parseDefault(string, string3, n, string2);
    }

    private void parseAttlistDecl() throws Exception {
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        boolean bl = this.tryWhitespace();
        while (!this.tryRead('>')) {
            if (!bl) {
                this.error("whitespace required before attribute definition");
            }
            this.parseAttDef(string);
            bl = this.tryWhitespace();
        }
    }

    private void parseAttribute(String string) throws Exception {
        int n = 10;
        String string2 = this.readNmtoken(true);
        int n2 = this.getAttributeType(string, string2);
        this.parseEq();
        String string3 = n2 == 1 || n2 == 0 ? this.readLiteral(n) : this.readLiteral(n | 4);
        int n4 = 0;
        while (n4 < this.tagAttributePos) {
            if (string2.equals(this.tagAttributes[n4])) {
                this.error("duplicate attribute", string2, null);
            }
            ++n4;
        }
        this.handler.attribute(string2, string3, true);
        this.dataBufferPos = 0;
        if (this.tagAttributePos == this.tagAttributes.length) {
            String[] stringArray = new String[this.tagAttributes.length * 2];
            System.arraycopy(this.tagAttributes, 0, stringArray, 0, this.tagAttributePos);
            this.tagAttributes = stringArray;
        }
        this.tagAttributes[this.tagAttributePos++] = string2;
    }

    private void parseCDSect() throws Exception {
        this.parseUntil("]]>");
        this.dataBufferFlush();
    }

    private void parseCharData() throws Exception {
        char c;
        int n = 0;
        int n2 = 0;
        int n4 = this.readBufferPos;
        while (n4 < this.readBufferLength) {
            c = this.readBuffer[n4];
            switch (c) {
                case '\n': {
                    ++n;
                    n2 = 0;
                    break;
                }
                case '&': 
                case '<': {
                    int n5 = this.readBufferPos;
                    ++n2;
                    this.readBufferPos = n4;
                    if (n > 0) {
                        this.line += n;
                        this.column = n2;
                    } else {
                        this.column += n2;
                    }
                    this.dataBufferAppend(this.readBuffer, n5, n4 - n5);
                    return;
                }
                case ']': {
                    if (n4 + 2 < this.readBufferLength && this.readBuffer[n4 + 1] == ']' && this.readBuffer[n4 + 2] == '>') {
                        this.error("character data may not contain ']]>'");
                    }
                    ++n2;
                    break;
                }
                default: {
                    if (c < ' ' || c > '\ufffd') {
                        this.error("illegal XML character U+" + Integer.toHexString(c));
                    }
                }
                case '\t': 
                case '\r': {
                    ++n2;
                }
            }
            ++n4;
        }
        while (true) {
            c = this.readCh();
            switch (c) {
                case '&': 
                case '<': {
                    this.unread(c);
                    return;
                }
            }
            this.dataBufferAppend(c);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseCharRef() throws SAXException, IOException {
        block20: {
            block19: {
                block17: {
                    block18: {
                        var1_1 = 0;
                        if (!this.tryRead('x')) break block18;
                        block8: while (true) {
                            var2_2 = this.readCh();
                            switch (var2_2) {
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': 
                                case 'A': 
                                case 'B': 
                                case 'C': 
                                case 'D': 
                                case 'E': 
                                case 'F': 
                                case 'a': 
                                case 'b': 
                                case 'c': 
                                case 'd': 
                                case 'e': 
                                case 'f': {
                                    var1_1 *= 16;
                                    var1_1 += Integer.parseInt(new Character(var2_2).toString(), 16);
                                    continue block8;
                                }
                                default: {
                                    this.error("illegal character in character reference", var2_2, null);
                                    ** GOTO lbl26
                                }
                                case ';': {
                                    if (var1_1 >= 32) break block17;
                                }
                            }
                            break;
                        }
                    }
                    block9: while (true) {
                        var2_3 = this.readCh();
                        switch (var2_3) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                var1_1 *= 10;
                                var1_1 += Integer.parseInt(new Character(var2_3).toString(), 10);
                                continue block9;
                            }
                            default: {
                                this.error("illegal character in character reference", var2_3, null);
                            }
                            {
                                ** case 59:
                            }
                        }
                        break;
                    }
lbl26:
                    // 2 sources

                    if (var1_1 >= 32) break block17;
                    if (var1_1 != 10 && var1_1 != 9 && var1_1 != 13) break block19;
                }
                if ((var1_1 < 55296 || var1_1 > 57343) && var1_1 != 65534 && var1_1 != 65535 && var1_1 <= 0x10FFFF) break block20;
            }
            this.error("illegal XML character reference U+" + Integer.toHexString(var1_1));
        }
        if (var1_1 <= 65535) {
            this.dataBufferAppend((char)var1_1);
        } else if (var1_1 <= 0x10FFFF) {
            this.dataBufferAppend((char)(55296 | (var1_1 -= 65536) >> 10));
            this.dataBufferAppend((char)(56320 | var1_1 & 1023));
        } else {
            this.error("character reference " + var1_1 + " is too large for UTF-16", new Integer(var1_1).toString(), null);
        }
    }

    private void parseComment() throws Exception {
        boolean bl = this.expandPE;
        this.expandPE = false;
        this.parseUntil("--");
        this.require('>');
        this.expandPE = bl;
        this.handler.comment(this.dataBuffer, 0, this.dataBufferPos);
        this.dataBufferPos = 0;
    }

    private void parseConditionalSect() throws Exception {
        this.skipWhitespace();
        if (this.tryRead("INCLUDE")) {
            this.skipWhitespace();
            this.require('[');
            this.skipWhitespace();
            while (!this.tryRead("]]>")) {
                this.parseMarkupdecl();
                this.skipWhitespace();
            }
        } else if (this.tryRead("IGNORE")) {
            this.skipWhitespace();
            this.require('[');
            boolean bl = true;
            this.expandPE = false;
            int n = 1;
            while (n > 0) {
                char c = this.readCh();
                switch (c) {
                    case '<': {
                        if (this.tryRead("![")) {
                            ++n;
                        }
                    }
                    case ']': {
                        if (!this.tryRead("]>")) break;
                        --n;
                    }
                }
            }
            this.expandPE = true;
        } else {
            this.error("conditional section must begin with INCLUDE or IGNORE");
        }
    }

    private void parseContent() throws Exception {
        block17: while (true) {
            switch (this.currentElementContent) {
                case 1: 
                case 3: {
                    this.parseCharData();
                    break;
                }
                case 4: {
                    this.parseWhitespace();
                    break;
                }
            }
            char c = this.readCh();
            switch (c) {
                default: {
                    continue block17;
                }
                case '&': {
                    c = this.readCh();
                    if (c == '#') {
                        this.parseCharRef();
                        continue block17;
                    }
                    this.unread(c);
                    this.parseEntityRef(true);
                    continue block17;
                }
                case '<': 
            }
            this.dataBufferFlush();
            c = this.readCh();
            switch (c) {
                case '!': {
                    c = this.readCh();
                    switch (c) {
                        case '-': {
                            this.require('-');
                            this.parseComment();
                            continue block17;
                        }
                        case '[': {
                            this.require("CDATA[");
                            this.handler.startCDATA();
                            this.inCDATA = true;
                            this.parseCDSect();
                            this.inCDATA = false;
                            this.handler.endCDATA();
                            continue block17;
                        }
                    }
                    this.error("expected comment or CDATA section", c, null);
                    continue block17;
                }
                case '?': {
                    this.parsePI();
                    continue block17;
                }
                case '/': {
                    this.parseETag();
                    return;
                }
            }
            this.unread(c);
            this.parseElement();
        }
    }

    private void parseContentspec(String string) throws Exception {
        if (this.tryRead("EMPTY")) {
            this.setElement(string, 2, null);
            return;
        }
        if (this.tryRead("ANY")) {
            this.setElement(string, 1, null);
            return;
        }
        this.require('(');
        this.dataBufferAppend('(');
        this.skipWhitespace();
        if (this.tryRead("#PCDATA")) {
            this.dataBufferAppend("#PCDATA");
            this.parseMixed();
            this.setElement(string, 3, this.dataBufferToString());
        } else {
            this.parseElements();
            this.setElement(string, 4, this.dataBufferToString());
        }
    }

    private void parseCp() throws Exception {
        if (this.tryRead('(')) {
            this.dataBufferAppend('(');
            this.parseElements();
        } else {
            this.dataBufferAppend(this.readNmtoken(true));
            char c = this.readCh();
            switch (c) {
                case '*': 
                case '+': 
                case '?': {
                    this.dataBufferAppend(c);
                    break;
                }
                default: {
                    this.unread(c);
                    break;
                }
            }
        }
    }

    private void parseDefault(String string, String string2, int n, String string3) throws Exception {
        int n2 = 31;
        String string4 = null;
        int n4 = 168;
        if (this.tryRead('#')) {
            if (this.tryRead("FIXED")) {
                n2 = 34;
                this.requireWhitespace();
                string4 = this.readLiteral(n4);
            } else if (this.tryRead("REQUIRED")) {
                n2 = 33;
            } else if (this.tryRead("IMPLIED")) {
                n2 = 32;
            } else {
                this.error("illegal keyword for attribute default value");
            }
        } else {
            string4 = this.readLiteral(n4);
        }
        this.setAttribute(string, string2, n, string3, string4, n2);
    }

    private void parseDoctypedecl() throws Exception {
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        this.skipWhitespace();
        String[] stringArray = this.readExternalIds(false);
        this.handler.doctypeDecl(string, stringArray[0], stringArray[1]);
        this.skipWhitespace();
        if (this.tryRead('[')) {
            while (true) {
                this.expandPE = true;
                this.skipWhitespace();
                this.expandPE = false;
                if (this.tryRead(']')) break;
                this.expandPE = true;
                this.peIsError = true;
                this.parseMarkupdecl();
                this.expandPE = false;
                this.peIsError = false;
            }
        }
        if (stringArray[1] != null) {
            this.pushURL("[external subset]", stringArray[0], stringArray[1], null, null, null);
            while (true) {
                this.expandPE = true;
                this.skipWhitespace();
                this.expandPE = false;
                if (!this.tryRead('>')) {
                    this.expandPE = true;
                    this.parseMarkupdecl();
                    this.expandPE = false;
                    continue;
                }
                break;
            }
        } else {
            this.skipWhitespace();
            this.require('>');
        }
        this.handler.endDoctype();
        this.expandPE = false;
    }

    private void parseDocument() throws Exception {
        this.parseProlog();
        this.require('<');
        this.parseElement();
        try {
            this.parseMisc();
            char c = this.readCh();
            this.error("unexpected characters after document end", c, null);
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    private void parseETag() throws Exception {
        this.require(this.currentElement);
        this.skipWhitespace();
        this.require('>');
        this.handler.endElement(this.currentElement);
    }

    private void parseElement() throws Exception {
        String string;
        int n = this.currentElementContent;
        String string2 = this.currentElement;
        this.tagAttributePos = 0;
        this.currentElement = string = this.readNmtoken(true);
        Object[] objectArray = (Object[])this.elementInfo.get(string);
        this.currentElementContent = this.getContentType(objectArray, 1);
        boolean bl = this.tryWhitespace();
        char c = this.readCh();
        while (c != '/' && c != '>') {
            this.unread(c);
            if (!bl) {
                this.error("need whitespace between attributes");
            }
            this.parseAttribute(string);
            bl = this.tryWhitespace();
            c = this.readCh();
        }
        Enumeration enumeration = this.declaredAttributes(objectArray);
        if (enumeration != null) {
            block5: while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                int n2 = 0;
                while (n2 < this.tagAttributePos) {
                    if (this.tagAttributes[n2] == string3) continue block5;
                    ++n2;
                }
                this.handler.attribute(string3, this.getAttributeExpandedValue(string, string3), false);
            }
        }
        switch (c) {
            case '>': {
                this.handler.startElement(string);
                this.parseContent();
                break;
            }
            case '/': {
                this.require('>');
                this.handler.startElement(string);
                this.handler.endElement(string);
                break;
            }
        }
        this.currentElement = string2;
        this.currentElementContent = n;
    }

    private void parseElementdecl() throws Exception {
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        this.requireWhitespace();
        this.parseContentspec(string);
        this.skipWhitespace();
        this.require('>');
    }

    private void parseElements() throws Exception {
        char c;
        this.skipWhitespace();
        this.parseCp();
        this.skipWhitespace();
        char c2 = this.readCh();
        switch (c2) {
            case ')': {
                this.dataBufferAppend(')');
                c2 = this.readCh();
                switch (c2) {
                    case '*': 
                    case '+': 
                    case '?': {
                        this.dataBufferAppend(c2);
                        break;
                    }
                    default: {
                        this.unread(c2);
                    }
                }
                return;
            }
            case ',': 
            case '|': {
                c = c2;
                this.dataBufferAppend(c2);
                break;
            }
            default: {
                this.error("bad separator in content model", c2, null);
                return;
            }
        }
        while (true) {
            this.skipWhitespace();
            this.parseCp();
            this.skipWhitespace();
            c2 = this.readCh();
            if (c2 == ')') break;
            if (c2 != c) {
                this.error("bad separator in content model", c2, null);
                return;
            }
            this.dataBufferAppend(c2);
        }
        this.dataBufferAppend(')');
        c2 = this.readCh();
        switch (c2) {
            case '*': 
            case '+': 
            case '?': {
                this.dataBufferAppend(c2);
                return;
            }
        }
        this.unread(c2);
    }

    private void parseEntityDecl() throws Exception {
        boolean bl = false;
        this.expandPE = false;
        this.requireWhitespace();
        if (this.tryRead('%')) {
            bl = true;
            this.requireWhitespace();
        }
        this.expandPE = true;
        String string = this.readNmtoken(true);
        if (bl) {
            string = "%" + string;
        }
        this.requireWhitespace();
        char c = this.readCh();
        this.unread(c);
        if (c == '\"' || c == '\'') {
            String string2 = this.readLiteral(0);
            this.setInternalEntity(string, string2);
        } else {
            String[] stringArray = this.readExternalIds(false);
            if (stringArray[1] == null) {
                this.error("system identifer missing", string, null);
            }
            boolean bl2 = this.tryWhitespace();
            if (!bl && this.tryRead("NDATA")) {
                if (!bl2) {
                    this.error("whitespace required before NDATA");
                }
                this.requireWhitespace();
                String string3 = this.readNmtoken(true);
                this.setExternalDataEntity(string, stringArray[0], stringArray[1], string3);
            } else {
                this.setExternalTextEntity(string, stringArray[0], stringArray[1]);
            }
        }
        this.skipWhitespace();
        this.require('>');
    }

    private void parseEntityRef(boolean bl) throws SAXException, IOException {
        String string = this.readNmtoken(true);
        this.require(';');
        switch (this.getEntityType(string)) {
            case 0: {
                this.error("reference to undeclared entity", string, null);
                break;
            }
            case 1: {
                this.pushString(string, this.getEntityValue(string));
                break;
            }
            case 3: {
                if (bl) {
                    this.pushURL(string, this.getEntityPublicId(string), this.getEntitySystemId(string), null, null, null);
                    break;
                }
                this.error("reference to external entity in attribute value.", string, null);
                break;
            }
            case 2: {
                if (bl) {
                    this.error("unparsed entity reference in content", string, null);
                    break;
                }
                this.error("reference to external entity in attribute value.", string, null);
                break;
            }
        }
    }

    private void parseEnumeration(boolean bl) throws Exception {
        this.dataBufferAppend('(');
        this.skipWhitespace();
        this.dataBufferAppend(this.readNmtoken(bl));
        this.skipWhitespace();
        while (!this.tryRead(')')) {
            this.require('|');
            this.dataBufferAppend('|');
            this.skipWhitespace();
            this.dataBufferAppend(this.readNmtoken(bl));
            this.skipWhitespace();
        }
        this.dataBufferAppend(')');
    }

    private void parseEq() throws SAXException, IOException {
        this.skipWhitespace();
        this.require('=');
        this.skipWhitespace();
    }

    private void parseMarkupdecl() throws Exception {
        if (this.tryRead("<!ELEMENT")) {
            this.parseElementdecl();
        } else if (this.tryRead("<!ATTLIST")) {
            this.parseAttlistDecl();
        } else if (this.tryRead("<!ENTITY")) {
            this.parseEntityDecl();
        } else if (this.tryRead("<!NOTATION")) {
            this.parseNotationDecl();
        } else if (this.tryRead("<?")) {
            this.parsePI();
        } else if (this.tryRead("<!--")) {
            this.parseComment();
        } else if (this.tryRead("<![")) {
            if (this.inputStack.size() > 0) {
                this.parseConditionalSect();
            } else {
                this.error("conditional sections illegal in internal subset");
            }
        } else {
            this.error("expected markup declaration");
        }
    }

    private void parseMisc() throws Exception {
        while (true) {
            this.skipWhitespace();
            if (this.tryRead("<?")) {
                this.parsePI();
                continue;
            }
            if (!this.tryRead("<!--")) break;
            this.parseComment();
        }
    }

    private void parseMixed() throws Exception {
        this.skipWhitespace();
        if (this.tryRead(')')) {
            this.dataBufferAppend(")*");
            this.tryRead('*');
            return;
        }
        this.skipWhitespace();
        while (!this.tryRead(")*")) {
            this.require('|');
            this.dataBufferAppend('|');
            this.skipWhitespace();
            this.dataBufferAppend(this.readNmtoken(true));
            this.skipWhitespace();
        }
        this.dataBufferAppend(")*");
    }

    private void parseNotationDecl() throws Exception {
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        this.requireWhitespace();
        String[] stringArray = this.readExternalIds(true);
        if (stringArray[0] == null && stringArray[1] == null) {
            this.error("external identifer missing", string, null);
        }
        this.setNotation(string, stringArray[0], stringArray[1]);
        this.skipWhitespace();
        this.require('>');
    }

    private void parseNotationType() throws Exception {
        this.requireWhitespace();
        this.require('(');
        this.parseEnumeration(true);
    }

    private void parsePEReference() throws SAXException, IOException {
        String string = "%" + this.readNmtoken(true);
        this.require(';');
        switch (this.getEntityType(string)) {
            case 1: {
                if (this.inLiteral) {
                    this.pushString(string, this.getEntityValue(string));
                    break;
                }
                this.pushString(string, " " + this.getEntityValue(string) + ' ');
                break;
            }
            case 3: {
                if (!this.inLiteral) {
                    this.pushString(null, " ");
                }
                this.pushURL(string, this.getEntityPublicId(string), this.getEntitySystemId(string), null, null, null);
                if (this.inLiteral) break;
                this.pushString(null, " ");
                break;
            }
        }
    }

    private void parsePI() throws SAXException, IOException {
        boolean bl = this.expandPE;
        this.expandPE = false;
        String string = this.readNmtoken(true);
        if ("xml".equalsIgnoreCase(string)) {
            this.error("Illegal processing instruction target", string, null);
        }
        if (!this.tryRead("?>")) {
            this.requireWhitespace();
            this.parseUntil("?>");
        }
        this.expandPE = bl;
        this.handler.processingInstruction(string, this.dataBufferToString());
    }

    private void parseProlog() throws Exception {
        this.parseMisc();
        if (this.tryRead("<!DOCTYPE")) {
            this.parseDoctypedecl();
            this.parseMisc();
        }
    }

    private String parseTextDecl(boolean bl) throws SAXException, IOException {
        String string = null;
        int n = 112;
        if (this.tryRead("version")) {
            this.parseEq();
            String string2 = this.readLiteral(n);
            if (!string2.equals("1.0")) {
                this.error("unsupported XML version", string2, "1.0");
            }
            this.requireWhitespace();
        }
        this.require("encoding");
        this.parseEq();
        string = this.readLiteral(n);
        if (!bl) {
            this.setupDecoding(string);
        }
        this.skipWhitespace();
        this.require("?>");
        return string;
    }

    private void parseUntil(String string) throws SAXException, IOException {
        int n = this.line;
        try {
            while (!this.tryRead(string)) {
                char c = this.readCh();
                this.dataBufferAppend(c);
            }
        }
        catch (EOFException eOFException) {
            this.error("end of input while looking for delimiter (started on line " + n + ')', null, string);
        }
    }

    private void parseWhitespace() throws Exception {
        char c = this.readCh();
        while (this.isWhitespace(c)) {
            this.dataBufferAppend(c);
            c = this.readCh();
        }
        this.unread(c);
    }

    private String parseXMLDecl(boolean bl) throws SAXException, IOException {
        String string = null;
        String string2 = null;
        int n = 112;
        this.require("version");
        this.parseEq();
        String string3 = this.readLiteral(n);
        if (!string3.equals("1.0")) {
            this.error("unsupported XML version", string3, "1.0");
        }
        boolean bl2 = this.tryWhitespace();
        if (this.tryRead("encoding")) {
            if (!bl2) {
                this.error("whitespace required before 'encoding='");
            }
            this.parseEq();
            string = this.readLiteral(n);
            if (!bl) {
                this.setupDecoding(string);
            }
        }
        if (string != null) {
            bl2 = this.tryWhitespace();
        }
        if (this.tryRead("standalone")) {
            if (!bl2) {
                this.error("whitespace required before 'standalone='");
            }
            this.parseEq();
            string2 = this.readLiteral(n);
            if (!"yes".equals(string2) && !"no".equals(string2)) {
                this.error("standalone flag must be 'yes' or 'no'");
            }
        }
        this.skipWhitespace();
        this.require("?>");
        return string;
    }

    private void popInput() throws SAXException, IOException {
        switch (this.sourceType) {
            case 2: {
                if (this.externalEntity == null) break;
                this.handler.endExternalEntity(this.externalEntity.getURL().toString());
                break;
            }
            case 3: {
                if (this.baseURI != null) {
                    this.handler.endExternalEntity(this.baseURI);
                }
                this.is.close();
                break;
            }
            case 5: {
                if (this.baseURI != null) {
                    this.handler.endExternalEntity(this.baseURI);
                }
                this.reader.close();
                break;
            }
        }
        if (this.inputStack.isEmpty()) {
            throw new EOFException("no more input");
        }
        Object[] objectArray = (Object[])this.inputStack.pop();
        String string = (String)this.entityStack.pop();
        this.sourceType = (Integer)objectArray[0];
        this.externalEntity = (URLConnection)objectArray[1];
        this.readBuffer = (char[])objectArray[2];
        this.readBufferPos = (Integer)objectArray[3];
        this.readBufferLength = (Integer)objectArray[4];
        this.line = (Integer)objectArray[5];
        this.encoding = (Integer)objectArray[6];
        this.readBufferOverflow = (Integer)objectArray[7];
        this.is = (InputStream)objectArray[8];
        this.currentByteCount = (Integer)objectArray[9];
        this.column = (Integer)objectArray[10];
        this.reader = (Reader)objectArray[11];
    }

    private void pushCharArray(String string, char[] cArray, int n, int n2) throws SAXException {
        this.pushInput(string);
        this.sourceType = 1;
        this.readBuffer = cArray;
        this.readBufferPos = n;
        this.readBufferLength = n2;
        this.readBufferOverflow = -1;
    }

    private void pushInput(String string) throws SAXException {
        Object[] objectArray = new Object[12];
        if (string != null) {
            Enumeration enumeration = this.entityStack.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (string2 != string) continue;
                this.error("recursive reference to entity", string, null);
            }
        }
        this.entityStack.push(string);
        if (this.sourceType == 0) {
            return;
        }
        objectArray[0] = new Integer(this.sourceType);
        objectArray[1] = this.externalEntity;
        objectArray[2] = this.readBuffer;
        objectArray[3] = new Integer(this.readBufferPos);
        objectArray[4] = new Integer(this.readBufferLength);
        objectArray[5] = new Integer(this.line);
        objectArray[6] = new Integer(this.encoding);
        objectArray[7] = new Integer(this.readBufferOverflow);
        objectArray[8] = this.is;
        objectArray[9] = new Integer(this.currentByteCount);
        objectArray[10] = new Integer(this.column);
        objectArray[11] = this.reader;
        this.inputStack.push(objectArray);
    }

    private void pushString(String string, String string2) throws SAXException {
        char[] cArray = string2.toCharArray();
        this.pushCharArray(string, cArray, 0, cArray.length);
    }

    private void pushURL(String string, String string2, String string3, Reader reader, InputStream inputStream, String string4) throws SAXException, IOException {
        Object object;
        boolean bl = false;
        this.pushInput(string);
        this.readBuffer = new char[16388];
        this.readBufferPos = 0;
        this.readBufferLength = 0;
        this.readBufferOverflow = -1;
        this.is = null;
        this.line = 1;
        this.currentByteCount = 0;
        if (string3 != null && this.externalEntity != null) {
            string3 = new URL(this.externalEntity.getURL(), string3).toString();
        } else if (this.baseURI != null) {
            string3 = new URL(new URL(this.baseURI), string3).toString();
        }
        if (reader == null && inputStream == null && string3 != null && (object = this.handler.resolveEntity(string2, string3)) != null) {
            if (object instanceof String) {
                string3 = (String)object;
            } else if (object instanceof InputStream) {
                inputStream = (InputStream)object;
            } else if (object instanceof Reader) {
                reader = (Reader)object;
            }
        }
        if (string3 != null) {
            this.handler.startExternalEntity(string3);
        } else {
            this.handler.startExternalEntity("[unidentified data stream]");
        }
        if (reader != null) {
            this.sourceType = 5;
            this.reader = reader;
            this.tryEncodingDecl(true);
            return;
        }
        if (inputStream != null) {
            this.sourceType = 3;
            this.is = inputStream;
            Object var7_10 = null;
        } else {
            this.sourceType = 2;
            URL uRL = new URL(string3);
            this.externalEntity = uRL.openConnection();
            this.externalEntity.connect();
            this.is = this.externalEntity.getInputStream();
        }
        if (!this.is.markSupported()) {
            this.is = new BufferedInputStream(this.is);
        }
        if (string4 == null && this.externalEntity != null && !"file".equals(this.externalEntity.getURL().getProtocol())) {
            string4 = this.externalEntity.getContentType();
            int n = string4.indexOf("charset");
            if (n < 0) {
                string4 = null;
            } else {
                n = string4.indexOf(61, n + 7);
                if ((n = (string4 = string4.substring(n)).indexOf(59)) > 0) {
                    string4 = string4.substring(0, n);
                }
                if ((n = string4.indexOf(40)) > 0) {
                    string4 = string4.substring(0, n);
                }
                if ((n = string4.indexOf(34)) > 0) {
                    string4 = string4.substring(n + 1, string4.indexOf(34, n + 2));
                }
                string4.trim();
            }
        }
        if (string4 != null) {
            this.encoding = 0;
            this.setupDecoding(string4);
            bl = true;
        } else {
            this.detectEncoding();
            bl = false;
        }
        this.tryEncodingDecl(bl);
    }

    private void read8bitEncodingDeclaration() throws SAXException, IOException {
        this.readBufferLength = 0;
        this.readBufferPos = 0;
        while (true) {
            int n = this.is.read();
            this.readBuffer[this.readBufferLength++] = (char)n;
            switch (n) {
                case 62: {
                    return;
                }
                case -1: {
                    this.error("end of file before end of XML or encoding declaration.", null, "?>");
                }
            }
            if (this.readBuffer.length != this.readBufferLength) continue;
            this.error("unfinished XML or encoding declaration");
        }
    }

    private int readAttType() throws Exception {
        Integer n;
        if (this.tryRead('(')) {
            this.parseEnumeration(false);
            return 9;
        }
        String string = this.readNmtoken(true);
        if (string.equals("NOTATION")) {
            this.parseNotationType();
        }
        if ((n = (Integer)attributeTypeHash.get(string)) == null) {
            this.error("illegal attribute type", string, null);
            return 0;
        }
        return n;
    }

    private char readCh() throws SAXException, IOException {
        char c;
        block3: while (this.readBufferPos >= this.readBufferLength) {
            switch (this.sourceType) {
                case 2: 
                case 3: 
                case 5: {
                    this.readDataChunk();
                    while (this.readBufferLength < 1) {
                        this.popInput();
                        if (this.readBufferLength >= 1) continue;
                        this.readDataChunk();
                    }
                    continue block3;
                }
                default: {
                    this.popInput();
                    break;
                }
            }
        }
        if ((c = this.readBuffer[this.readBufferPos++]) == '\n') {
            ++this.line;
            this.column = 0;
        } else {
            if (c != '<') {
                if (c < ' ' && c != '\t' && c != '\r' || c > '\ufffd') {
                    this.error("illegal XML character U+" + Integer.toHexString(c));
                } else if (c == '%' && this.expandPE) {
                    if (this.peIsError) {
                        this.error("PE reference within decl in internal subset.");
                    }
                    this.parsePEReference();
                    return this.readCh();
                }
            }
            ++this.column;
        }
        return c;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void readDataChunk() throws SAXException, IOException {
        if (this.readBufferOverflow > -1) {
            this.readBuffer[0] = (char)this.readBufferOverflow;
            this.readBufferOverflow = -1;
            this.readBufferPos = 1;
            this.sawCR = true;
        } else {
            this.readBufferPos = 0;
            this.sawCR = false;
        }
        if (this.sourceType == 5) {
            var1_1 = this.reader.read(this.readBuffer, this.readBufferPos, 16384 - this.readBufferPos);
            this.readBufferLength = var1_1 < 0 ? this.readBufferPos : this.readBufferPos + var1_1;
            if (this.readBufferLength > 0) {
                this.filterCR(var1_1 >= 0);
            }
            this.sawCR = false;
            return;
        }
        var1_2 = this.is.read(this.rawReadBuffer, 0, 16384);
        if (var1_2 <= 0) ** GOTO lbl46
        switch (this.encoding) {
            case 9: {
                this.copyIso8859_1ReadBuffer(var1_2, '\u0080');
                break;
            }
            case 1: {
                this.copyUtf8ReadBuffer(var1_2);
                break;
            }
            case 2: {
                this.copyIso8859_1ReadBuffer(var1_2, '\u0000');
                break;
            }
            case 3: {
                this.copyUcs2ReadBuffer(var1_2, 8, 0);
                break;
            }
            case 4: {
                this.copyUcs2ReadBuffer(var1_2, 0, 8);
                break;
            }
            case 5: {
                this.copyUcs4ReadBuffer(var1_2, 24, 16, 8, 0);
                break;
            }
            case 6: {
                this.copyUcs4ReadBuffer(var1_2, 0, 8, 16, 24);
                break;
            }
            case 7: {
                this.copyUcs4ReadBuffer(var1_2, 16, 24, 0, 8);
                break;
            }
            case 8: {
                this.copyUcs4ReadBuffer(var1_2, 8, 0, 24, 16);
                break;
            }
lbl46:
            // 1 sources

            this.readBufferLength = this.readBufferPos;
            break;
        }
        this.readBufferPos = 0;
        if (this.sawCR) {
            this.filterCR(var1_2 >= 0);
            this.sawCR = false;
            if (this.readBufferLength == 0 && var1_2 >= 0) {
                this.readDataChunk();
            }
        }
        if (var1_2 > 0) {
            this.currentByteCount += var1_2;
        }
    }

    private String[] readExternalIds(boolean bl) throws Exception {
        String[] stringArray = new String[2];
        int n = 112;
        if (this.tryRead("PUBLIC")) {
            char c;
            this.requireWhitespace();
            stringArray[0] = this.readLiteral(4 | n);
            if (bl) {
                this.skipWhitespace();
                c = this.readCh();
                this.unread(c);
                if (c == '\"' || c == '\'') {
                    stringArray[1] = this.readLiteral(n);
                }
            } else {
                this.requireWhitespace();
                stringArray[1] = this.readLiteral(n);
            }
            int n2 = 0;
            while (n2 < stringArray[0].length()) {
                c = stringArray[0].charAt(n2);
                if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || " \r\n0123456789-' ()+,./:=?;!*#@$_%".indexOf(c) != -1)) {
                    this.error("illegal PUBLIC id character U+" + Integer.toHexString(c));
                }
                ++n2;
            }
        } else if (this.tryRead("SYSTEM")) {
            this.requireWhitespace();
            stringArray[1] = this.readLiteral(n);
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readLiteral(int n) throws SAXException, IOException {
        int n2 = this.line;
        boolean bl = this.expandPE;
        char c = this.readCh();
        if (c != '\"' && c != '\'' && c != '\u0000') {
            this.error("expected '\"' or \"'\"", c, null);
            return null;
        }
        this.inLiteral = true;
        if ((n & 0x10) != 0) {
            this.expandPE = false;
        }
        char[] cArray = this.readBuffer;
        try {
            char c2 = this.readCh();
            block7: while (c2 != c || this.readBuffer != cArray) {
                switch (c2) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        if ((n & 8) == 0) break;
                        c2 = ' ';
                        break;
                    }
                    case '&': {
                        c2 = this.readCh();
                        if (c2 == '#') {
                            if ((n & 0x20) != 0) {
                                this.dataBufferAppend('&');
                                this.dataBufferAppend('#');
                                continue block7;
                            }
                            this.parseCharRef();
                        } else {
                            this.unread(c2);
                            if ((n & 2) > 0) {
                                this.parseEntityRef(false);
                            } else if ((n & 0x40) != 0) {
                                this.dataBufferAppend('&');
                            } else {
                                String string = this.readNmtoken(true);
                                this.require(';');
                                if ((n & 0x80) != 0 && this.getEntityType(string) == 0) {
                                    this.error("General entity '" + string + "' must be declared before use");
                                }
                                this.dataBufferAppend('&');
                                this.dataBufferAppend(string);
                                this.dataBufferAppend(';');
                            }
                        }
                        c2 = this.readCh();
                        continue block7;
                    }
                    case '<': {
                        if ((n & 8) == 0) break;
                        this.error("attribute values may not contain '<'");
                    }
                }
                this.dataBufferAppend(c2);
                c2 = this.readCh();
            }
        }
        catch (EOFException eOFException) {
            this.error("end of input while looking for delimiter (started on line " + n2 + ')', null, new Character(c).toString());
        }
        this.inLiteral = false;
        this.expandPE = bl;
        if ((n & 4) > 0) {
            this.dataBufferNormalize();
        }
        return this.dataBufferToString();
    }

    private String readNmtoken(boolean bl) throws SAXException, IOException {
        char c;
        int n = this.readBufferPos;
        block7: while (n < this.readBufferLength) {
            c = this.readBuffer[n];
            switch (c) {
                case '%': {
                    if (this.expandPE) break block7;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '&': 
                case '\'': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '|': {
                    int n2 = this.readBufferPos;
                    if (n == n2) {
                        this.error("name expected", this.readBuffer[n], null);
                    }
                    this.readBufferPos = n;
                    return this.intern(this.readBuffer, n2, n - n2);
                }
                default: {
                    if (n == this.readBufferPos && bl) {
                        if (!Character.isUnicodeIdentifierStart(c) && c != ':' && c != '_') {
                            this.error("Not a name start character, U+" + Integer.toHexString(c));
                        }
                    } else if (!Character.isUnicodeIdentifierPart(c) && c != '-' && c != ':' && c != '_' && c != '.' && !XmlParser.isExtender(c)) {
                        this.error("Not a name character, U+" + Integer.toHexString(c));
                    }
                    ++n;
                }
            }
        }
        this.nameBufferPos = 0;
        while (true) {
            c = this.readCh();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '%': 
                case '&': 
                case '\'': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '|': {
                    this.unread(c);
                    if (this.nameBufferPos == 0) {
                        this.error("name expected");
                    }
                    if (bl && !Character.isUnicodeIdentifierStart(this.nameBuffer[0]) && ":_".indexOf(this.nameBuffer[0]) == -1) {
                        this.error("Not a name start character, U+" + Integer.toHexString(this.nameBuffer[0]));
                    }
                    String string = this.intern(this.nameBuffer, 0, this.nameBufferPos);
                    this.nameBufferPos = 0;
                    return string;
                }
            }
            if (!(this.nameBufferPos == 0 && bl || Character.isUnicodeIdentifierPart(c) || ":-_.".indexOf(c) != -1 || XmlParser.isExtender(c))) {
                this.error("Not a name character, U+" + Integer.toHexString(c));
            }
            if (this.nameBufferPos >= this.nameBuffer.length) {
                this.nameBuffer = (char[])this.extendArray(this.nameBuffer, this.nameBuffer.length, this.nameBufferPos);
            }
            this.nameBuffer[this.nameBufferPos++] = c;
        }
    }

    private void require(char c) throws SAXException, IOException {
        char c2 = this.readCh();
        if (c2 != c) {
            this.error("required character", c2, new Character(c).toString());
        }
    }

    private void require(String string) throws SAXException, IOException {
        char[] cArray;
        int n = string.length();
        if (n < this.dataBuffer.length) {
            cArray = this.dataBuffer;
            string.getChars(0, n, cArray, 0);
        } else {
            cArray = string.toCharArray();
        }
        if (n <= this.readBufferLength - this.readBufferPos) {
            int n2 = this.readBufferPos;
            int n4 = 0;
            while (n4 < n) {
                if (cArray[n4] != this.readBuffer[n2]) {
                    this.error("required string", null, string);
                }
                ++n4;
                ++n2;
            }
            this.readBufferPos = n2;
        } else {
            int n5 = 0;
            while (n5 < n) {
                this.require(cArray[n5]);
                ++n5;
            }
        }
    }

    private void requireWhitespace() throws SAXException, IOException {
        char c = this.readCh();
        if (this.isWhitespace(c)) {
            this.skipWhitespace();
        } else {
            this.error("whitespace required", c, null);
        }
    }

    private void setAttribute(String string, String string2, int n, String string3, String string4, int n2) throws Exception {
        Hashtable hashtable = this.getElementAttributes(string);
        if (hashtable.get(string2) != null) {
            return;
        }
        Object[] objectArray = new Object[]{new Integer(n), string4, new Integer(n2), string3, null};
        hashtable.put(string2, objectArray);
    }

    private Object[] setElement(String string, int n, String string2) {
        Object[] objectArray = (Object[])this.elementInfo.get(string);
        if (objectArray == null) {
            objectArray = new Object[]{new Integer(n), string2, new Hashtable(23)};
            this.elementInfo.put(string, objectArray);
            return objectArray;
        }
        if ((Integer)objectArray[0] != 0) {
            return objectArray;
        }
        objectArray[0] = new Integer(n);
        objectArray[1] = string2;
        return objectArray;
    }

    private void setEntity(String string, int n, String string2, String string3, String string4, String string5) {
        if (this.entityInfo.get(string) == null) {
            Object[] objectArray = new Object[]{new Integer(n), string2, string3, string4, string5};
            this.entityInfo.put(string, objectArray);
        }
    }

    private void setExternalDataEntity(String string, String string2, String string3, String string4) {
        this.setEntity(string, 2, string2, string3, null, string4);
    }

    private void setExternalTextEntity(String string, String string2, String string3) {
        this.setEntity(string, 3, string2, string3, null, null);
    }

    void setHandler(SAXDriver sAXDriver) {
        this.handler = sAXDriver;
    }

    private void setInternalEntity(String string, String string2) {
        this.setEntity(string, 1, null, null, string2, null);
    }

    private void setNotation(String string, String string2, String string3) throws Exception {
        if (this.notationInfo.get(string) == null) {
            Object[] objectArray = new Object[]{string2, string3};
            this.notationInfo.put(string, objectArray);
        }
    }

    private void setupDecoding(String string) throws SAXException, IOException {
        string = string.toUpperCase();
        if (this.encoding == 1 || this.encoding == 0) {
            if (string.equals("ISO-8859-1") || string.equals("8859_1") || string.equals("ISO8859_1")) {
                this.encoding = 2;
                return;
            }
            if (string.equals("US-ASCII") || string.equals("ASCII")) {
                this.encoding = 9;
                return;
            }
            if (string.equals("UTF-8") || string.equals("UTF8")) {
                this.encoding = 1;
                return;
            }
            if (this.encoding != 0) {
                this.error("unsupported ASCII-derived encoding", string, "UTF-8, US-ASCII, or ISO-8859-1");
            }
        }
        if (this.encoding == 3 || this.encoding == 4) {
            if (!(string.equals("ISO-10646-UCS-2") || string.equals("UTF-16") || string.equals("UTF-16BE") || string.equals("UTF-16LE"))) {
                this.error("unsupported Unicode encoding", string, "UTF-16");
            }
            return;
        }
        if (this.encoding == 5 || this.encoding == 6 || this.encoding == 7 || this.encoding == 8) {
            if (!string.equals("ISO-10646-UCS-4")) {
                this.error("unsupported 32-bit encoding", string, "ISO-10646-UCS-4");
            }
            return;
        }
        if (string.equals("UTF-16BE")) {
            this.encoding = 3;
            return;
        }
        if (string.equals("UTF-16LE")) {
            this.encoding = 4;
            return;
        }
        if (string.equals("UTF-16") || string.equals("ISO-10646-UCS-2")) {
            string = "Unicode";
        }
        this.reader = new InputStreamReader(this.is, string);
        this.sourceType = 5;
        this.is = null;
    }

    private void skipWhitespace() throws SAXException, IOException {
        int n = 0;
        int n2 = 0;
        int n4 = this.readBufferPos;
        block5: while (n4 < this.readBufferLength) {
            switch (this.readBuffer[n4]) {
                case '\t': 
                case '\r': 
                case ' ': {
                    ++n2;
                    break;
                }
                case '\n': {
                    ++n;
                    n2 = 0;
                    break;
                }
                case '%': {
                    if (this.expandPE) break block5;
                }
                default: {
                    this.readBufferPos = n4;
                    if (n > 0) {
                        this.line += n;
                        this.column = n2;
                    } else {
                        this.column += n2;
                    }
                    return;
                }
            }
            ++n4;
        }
        char c = this.readCh();
        while (this.isWhitespace(c)) {
            c = this.readCh();
        }
        this.unread(c);
    }

    private static boolean tryEncoding(byte[] byArray, byte by, byte by2) {
        return byArray[0] == by && byArray[1] == by2;
    }

    private static boolean tryEncoding(byte[] byArray, byte by, byte by2, byte by3, byte by4) {
        return byArray[0] == by && byArray[1] == by2 && byArray[2] == by3 && byArray[3] == by4;
    }

    private String tryEncodingDecl(boolean bl) throws SAXException, IOException {
        if (this.tryRead("<?xml")) {
            this.dataBufferFlush();
            if (this.tryWhitespace()) {
                if (this.inputStack.size() > 0) {
                    return this.parseTextDecl(bl);
                }
                return this.parseXMLDecl(bl);
            }
            this.unread("xml".toCharArray(), 3);
            this.parsePI();
        }
        return null;
    }

    private boolean tryRead(char c) throws SAXException, IOException {
        char c2 = this.readCh();
        if (c2 == c) {
            return true;
        }
        this.unread(c2);
        return false;
    }

    private boolean tryRead(String string) throws SAXException, IOException {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            char c = this.readCh();
            if (c != cArray[n]) {
                this.unread(c);
                if (n != 0) {
                    this.unread(cArray, n);
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean tryWhitespace() throws SAXException, IOException {
        char c = this.readCh();
        if (this.isWhitespace(c)) {
            this.skipWhitespace();
            return true;
        }
        this.unread(c);
        return false;
    }

    private void unread(char c) throws SAXException {
        if (c == '\n') {
            --this.line;
            this.column = -1;
        }
        if (this.readBufferPos > 0) {
            this.readBuffer[--this.readBufferPos] = c;
        } else {
            this.pushString(null, new Character(c).toString());
        }
    }

    private void unread(char[] cArray, int n) throws SAXException {
        int n2 = 0;
        while (n2 < n) {
            if (cArray[n2] == '\n') {
                --this.line;
                this.column = -1;
            }
            ++n2;
        }
        if (n < this.readBufferPos) {
            this.readBufferPos -= n;
        } else {
            this.pushCharArray(null, cArray, 0, n);
            this.sourceType = 4;
        }
    }
}

