/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSGroupDecl;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.psvi.XSObject;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.util.SimpleLocator;
import org.apache.xerces.util.SymbolHash;

public class XSConstraints {
    static final int OCCURRENCE_UNKNOWN = -2;
    static final XSSimpleType STRING_TYPE = (XSSimpleType)SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl("string");

    public static boolean checkTypeDerivationOk(XSTypeDecl xSTypeDecl, XSTypeDecl xSTypeDecl2, short s) {
        if (xSTypeDecl == SchemaGrammar.fAnyType) {
            return xSTypeDecl == xSTypeDecl2;
        }
        if (xSTypeDecl == SchemaGrammar.fAnySimpleType) {
            return xSTypeDecl2 == SchemaGrammar.fAnyType || xSTypeDecl2 == SchemaGrammar.fAnySimpleType;
        }
        if (xSTypeDecl.getTypeCategory() == 14) {
            if (xSTypeDecl2.getTypeCategory() == 13) {
                if (xSTypeDecl2 == SchemaGrammar.fAnyType) {
                    xSTypeDecl2 = SchemaGrammar.fAnySimpleType;
                } else {
                    return false;
                }
            }
            return XSConstraints.checkSimpleDerivation((XSSimpleType)xSTypeDecl, (XSSimpleType)xSTypeDecl2, s);
        }
        return XSConstraints.checkComplexDerivation((XSComplexTypeDecl)xSTypeDecl, xSTypeDecl2, s);
    }

    public static boolean checkSimpleDerivationOk(XSSimpleType xSSimpleType, XSTypeDecl xSTypeDecl, short s) {
        if (xSSimpleType == SchemaGrammar.fAnySimpleType) {
            return xSTypeDecl == SchemaGrammar.fAnyType || xSTypeDecl == SchemaGrammar.fAnySimpleType;
        }
        if (xSTypeDecl.getTypeCategory() == 13) {
            if (xSTypeDecl == SchemaGrammar.fAnyType) {
                xSTypeDecl = SchemaGrammar.fAnySimpleType;
            } else {
                return false;
            }
        }
        return XSConstraints.checkSimpleDerivation(xSSimpleType, (XSSimpleType)xSTypeDecl, s);
    }

    public static boolean checkComplexDerivationOk(XSComplexTypeDecl xSComplexTypeDecl, XSTypeDecl xSTypeDecl, short s) {
        if (xSComplexTypeDecl == SchemaGrammar.fAnyType) {
            return xSComplexTypeDecl == xSTypeDecl;
        }
        return XSConstraints.checkComplexDerivation(xSComplexTypeDecl, xSTypeDecl, s);
    }

    private static boolean checkSimpleDerivation(XSSimpleType xSSimpleType, XSSimpleType xSSimpleType2, short s) {
        if (xSSimpleType == xSSimpleType2) {
            return true;
        }
        if ((s & 2) != 0 || (xSSimpleType.getBaseType().getFinal() & 2) != 0) {
            return false;
        }
        XSSimpleType xSSimpleType3 = (XSSimpleType)xSSimpleType.getBaseType();
        if (xSSimpleType3 == xSSimpleType2) {
            return true;
        }
        if (xSSimpleType3 != SchemaGrammar.fAnySimpleType && XSConstraints.checkSimpleDerivation(xSSimpleType3, xSSimpleType2, s)) {
            return true;
        }
        if ((xSSimpleType.getVariety() == 2 || xSSimpleType.getVariety() == 3) && xSSimpleType2 == SchemaGrammar.fAnySimpleType) {
            return true;
        }
        if (xSSimpleType2.getVariety() == 3) {
            XSObjectList xSObjectList = xSSimpleType2.getMemberTypes();
            int n = xSObjectList.getLength();
            int n2 = 0;
            while (n2 < n) {
                xSSimpleType2 = (XSSimpleType)xSObjectList.getItem(n2);
                if (XSConstraints.checkSimpleDerivation(xSSimpleType, xSSimpleType2, s)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static boolean checkComplexDerivation(XSComplexTypeDecl xSComplexTypeDecl, XSTypeDecl xSTypeDecl, short s) {
        if (xSComplexTypeDecl == xSTypeDecl) {
            return true;
        }
        if ((xSComplexTypeDecl.fDerivedBy & s) != 0) {
            return false;
        }
        XSTypeDecl xSTypeDecl2 = xSComplexTypeDecl.fBaseType;
        if (xSTypeDecl2 == xSTypeDecl) {
            return true;
        }
        if (xSTypeDecl2 == SchemaGrammar.fAnyType || xSTypeDecl2 == SchemaGrammar.fAnySimpleType) {
            return false;
        }
        if (xSTypeDecl2.getTypeCategory() == 13) {
            return XSConstraints.checkComplexDerivation((XSComplexTypeDecl)xSTypeDecl2, xSTypeDecl, s);
        }
        if (xSTypeDecl2.getTypeCategory() == 14) {
            if (xSTypeDecl.getTypeCategory() == 13) {
                if (xSTypeDecl == SchemaGrammar.fAnyType) {
                    xSTypeDecl = SchemaGrammar.fAnySimpleType;
                } else {
                    return false;
                }
            }
            return XSConstraints.checkSimpleDerivation((XSSimpleType)xSTypeDecl2, (XSSimpleType)xSTypeDecl, s);
        }
        return false;
    }

    public static Object ElementDefaultValidImmediate(XSTypeDecl xSTypeDecl, Object object, ValidationContext validationContext, ValidatedInfo validatedInfo) {
        Object object2;
        XSSimpleType xSSimpleType = null;
        if (xSTypeDecl.getTypeCategory() == 14) {
            xSSimpleType = (XSSimpleType)xSTypeDecl;
        } else {
            object2 = (XSComplexTypeDecl)xSTypeDecl;
            if (((XSComplexTypeDecl)object2).fContentType == 1) {
                xSSimpleType = ((XSComplexTypeDecl)object2).fXSSimpleType;
            } else if (((XSComplexTypeDecl)object2).fContentType == 3) {
                if (!((XSParticleDecl)((XSComplexTypeDecl)object2).getParticle()).emptiable()) {
                    return null;
                }
            } else {
                return null;
            }
        }
        object2 = null;
        if (xSSimpleType == null) {
            xSSimpleType = STRING_TYPE;
        }
        try {
            if (object instanceof String) {
                object2 = xSSimpleType.validate((String)object, validationContext, validatedInfo);
            } else {
                ValidatedInfo validatedInfo2 = (ValidatedInfo)object;
                xSSimpleType.validate(validationContext, validatedInfo2);
                object2 = validatedInfo2.actualValue;
            }
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            return null;
        }
        return object2;
    }

    static void reportSchemaError(XMLErrorReporter xMLErrorReporter, SimpleLocator simpleLocator, String string, Object[] objectArray) {
        if (simpleLocator != null) {
            xMLErrorReporter.reportError(simpleLocator, "http://www.w3.org/TR/xml-schema-1", string, objectArray, (short)1);
        } else {
            xMLErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", string, objectArray, (short)1);
        }
    }

    public static void fullSchemaChecking(XSGrammarBucket xSGrammarBucket, SubstitutionGroupHandler substitutionGroupHandler, CMBuilder cMBuilder, XMLErrorReporter xMLErrorReporter) {
        Object object;
        int n;
        SimpleLocator[] simpleLocatorArray;
        XSObject[] xSObjectArray;
        SchemaGrammar[] schemaGrammarArray = xSGrammarBucket.getGrammars();
        int n2 = schemaGrammarArray.length - 1;
        while (n2 >= 0) {
            substitutionGroupHandler.addSubstitutionGroup(schemaGrammarArray[n2].getSubstitutionGroups());
            --n2;
        }
        XSParticleDecl xSParticleDecl = new XSParticleDecl();
        XSParticleDecl xSParticleDecl2 = new XSParticleDecl();
        xSParticleDecl.fType = (short)3;
        xSParticleDecl2.fType = (short)3;
        int n4 = schemaGrammarArray.length - 1;
        while (n4 >= 0) {
            xSObjectArray = schemaGrammarArray[n4].getRedefinedGroupDecls();
            simpleLocatorArray = schemaGrammarArray[n4].getRGLocators();
            n = 0;
            while (n < xSObjectArray.length) {
                XSGroupDecl xSGroupDecl = xSObjectArray[n++];
                XSModelGroupImpl xSModelGroupImpl = xSGroupDecl.fModelGroup;
                object = xSObjectArray[n++];
                XSModelGroupImpl xSModelGroupImpl2 = ((XSGroupDecl)object).fModelGroup;
                if (xSModelGroupImpl2 == null) {
                    if (xSModelGroupImpl == null) continue;
                    XSConstraints.reportSchemaError(xMLErrorReporter, simpleLocatorArray[n / 2 - 1], "src-redefine.6.2.2", new Object[]{xSGroupDecl.fName, "rcase-Recurse.2"});
                    continue;
                }
                xSParticleDecl.fValue = xSModelGroupImpl;
                xSParticleDecl2.fValue = xSModelGroupImpl2;
                try {
                    XSConstraints.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, xSParticleDecl2, substitutionGroupHandler);
                }
                catch (XMLSchemaException xMLSchemaException) {
                    String string = xMLSchemaException.getKey();
                    XSConstraints.reportSchemaError(xMLErrorReporter, simpleLocatorArray[n / 2 - 1], string, xMLSchemaException.getArgs());
                    XSConstraints.reportSchemaError(xMLErrorReporter, simpleLocatorArray[n / 2 - 1], "src-redefine.6.2.2", new Object[]{xSGroupDecl.fName, string});
                }
            }
            --n4;
        }
        object = new SymbolHash();
        int n5 = schemaGrammarArray.length - 1;
        while (n5 >= 0) {
            int n6 = 0;
            boolean bl = schemaGrammarArray[n5].fFullChecked;
            xSObjectArray = schemaGrammarArray[n5].getUncheckedComplexTypeDecls();
            simpleLocatorArray = schemaGrammarArray[n5].getUncheckedCTLocators();
            int n7 = xSObjectArray.length - 1;
            while (n7 >= 0) {
                Object object2;
                if (!bl && ((XSComplexTypeDecl)xSObjectArray[n7]).fParticle != null) {
                    ((SymbolHash)object).clear();
                    try {
                        XSConstraints.checkElementDeclsConsistent((XSComplexTypeDecl)xSObjectArray[n7], ((XSComplexTypeDecl)xSObjectArray[n7]).fParticle, (SymbolHash)object, substitutionGroupHandler);
                    }
                    catch (XMLSchemaException xMLSchemaException) {
                        XSConstraints.reportSchemaError(xMLErrorReporter, simpleLocatorArray[n7], xMLSchemaException.getKey(), xMLSchemaException.getArgs());
                    }
                }
                if (((XSComplexTypeDecl)xSObjectArray[n7]).fBaseType != null && ((XSComplexTypeDecl)xSObjectArray[n7]).fBaseType != SchemaGrammar.fAnyType && ((XSComplexTypeDecl)xSObjectArray[n7]).fDerivedBy == 2 && ((XSComplexTypeDecl)xSObjectArray[n7]).fBaseType instanceof XSComplexTypeDecl) {
                    object2 = ((XSComplexTypeDecl)xSObjectArray[n7]).fParticle;
                    XSParticleDecl xSParticleDecl3 = ((XSComplexTypeDecl)((XSComplexTypeDecl)xSObjectArray[n7]).fBaseType).fParticle;
                    if (object2 == null && xSParticleDecl3 != null && !xSParticleDecl3.emptiable()) {
                        XSConstraints.reportSchemaError(xMLErrorReporter, simpleLocatorArray[n7], "derivation-ok-restriction.5.2", new Object[]{((XSComplexTypeDecl)xSObjectArray[n7]).fName});
                    } else if (object2 != null && xSParticleDecl3 != null) {
                        try {
                            XSConstraints.particleValidRestriction(((XSComplexTypeDecl)xSObjectArray[n7]).fParticle, substitutionGroupHandler, ((XSComplexTypeDecl)((XSComplexTypeDecl)xSObjectArray[n7]).fBaseType).fParticle, substitutionGroupHandler);
                        }
                        catch (XMLSchemaException xMLSchemaException) {
                            XSConstraints.reportSchemaError(xMLErrorReporter, simpleLocatorArray[n7], xMLSchemaException.getKey(), xMLSchemaException.getArgs());
                            XSConstraints.reportSchemaError(xMLErrorReporter, simpleLocatorArray[n7], "derivation-ok-restriction.5.3", new Object[]{((XSComplexTypeDecl)xSObjectArray[n7]).fName});
                        }
                    }
                }
                object2 = ((XSComplexTypeDecl)xSObjectArray[n7]).getContentModel(cMBuilder);
                n = 0;
                if (object2 != null) {
                    try {
                        n = object2.checkUniqueParticleAttribution(substitutionGroupHandler) ? 1 : 0;
                    }
                    catch (XMLSchemaException xMLSchemaException) {
                        XSConstraints.reportSchemaError(xMLErrorReporter, simpleLocatorArray[n7], xMLSchemaException.getKey(), xMLSchemaException.getArgs());
                    }
                }
                if (!bl && n != 0) {
                    xSObjectArray[n6++] = xSObjectArray[n7];
                }
                --n7;
            }
            if (!bl) {
                schemaGrammarArray[n5].setUncheckedTypeNum(n6);
                schemaGrammarArray[n5].fFullChecked = true;
            }
            --n5;
        }
    }

    public static void checkElementDeclsConsistent(XSComplexTypeDecl xSComplexTypeDecl, XSParticleDecl xSParticleDecl, SymbolHash symbolHash, SubstitutionGroupHandler substitutionGroupHandler) throws XMLSchemaException {
        short s = xSParticleDecl.fType;
        if (s == 0 || s == 2) {
            return;
        }
        if (s == 1) {
            XSElementDecl xSElementDecl = (XSElementDecl)xSParticleDecl.fValue;
            XSConstraints.findElemInTable(xSComplexTypeDecl, xSElementDecl, symbolHash);
            if (xSElementDecl.fScope == 1) {
                XSElementDecl[] xSElementDeclArray = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl);
                int n = 0;
                while (n < xSElementDeclArray.length) {
                    XSConstraints.findElemInTable(xSComplexTypeDecl, xSElementDeclArray[n], symbolHash);
                    ++n;
                }
            }
            return;
        }
        XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.fValue;
        int n = 0;
        while (n < xSModelGroupImpl.fParticleCount) {
            XSConstraints.checkElementDeclsConsistent(xSComplexTypeDecl, xSModelGroupImpl.fParticles[n], symbolHash, substitutionGroupHandler);
            ++n;
        }
    }

    public static void findElemInTable(XSComplexTypeDecl xSComplexTypeDecl, XSElementDecl xSElementDecl, SymbolHash symbolHash) throws XMLSchemaException {
        String string = xSElementDecl.fName + "," + xSElementDecl.fTargetNamespace;
        XSElementDecl xSElementDecl2 = null;
        xSElementDecl2 = (XSElementDecl)symbolHash.get(string);
        if (xSElementDecl2 == null) {
            symbolHash.put(string, xSElementDecl);
        } else {
            if (xSElementDecl == xSElementDecl2) {
                return;
            }
            if (xSElementDecl.fType != xSElementDecl2.fType) {
                throw new XMLSchemaException("cos-element-consistent", new Object[]{xSComplexTypeDecl.fName, string});
            }
        }
    }

    private static void particleValidRestriction(XSParticleDecl xSParticleDecl, SubstitutionGroupHandler substitutionGroupHandler, XSParticleDecl xSParticleDecl2, SubstitutionGroupHandler substitutionGroupHandler2) throws XMLSchemaException {
        XSConstraints.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, xSParticleDecl2, substitutionGroupHandler2, true);
    }

    private static void particleValidRestriction(XSParticleDecl xSParticleDecl, SubstitutionGroupHandler substitutionGroupHandler, XSParticleDecl xSElementDeclArray, SubstitutionGroupHandler substitutionGroupHandler2, boolean bl) throws XMLSchemaException {
        int n;
        int n2;
        XSElementDecl[] xSElementDeclArray2;
        Vector<XSParticleDecl> vector = null;
        Vector vector2 = null;
        int n4 = -2;
        int n5 = -2;
        if (xSParticleDecl.isEmpty() != xSElementDeclArray.isEmpty()) {
            throw new XMLSchemaException("cos-particle-restrict", null);
        }
        int n6 = xSParticleDecl.fType;
        if (n6 == 3) {
            n6 = ((XSModelGroupImpl)xSParticleDecl.fValue).fCompositor;
            XSParticleDecl xSParticleDecl2 = XSConstraints.getNonUnaryGroup(xSParticleDecl);
            if (xSParticleDecl2 != xSParticleDecl) {
                xSParticleDecl = xSParticleDecl2;
                n6 = xSParticleDecl.fType;
                if (n6 == 3) {
                    n6 = ((XSModelGroupImpl)xSParticleDecl.fValue).fCompositor;
                }
            }
            vector = XSConstraints.removePointlessChildren(xSParticleDecl);
        }
        int n7 = xSParticleDecl.fMinOccurs;
        int n8 = xSParticleDecl.fMaxOccurs;
        if (substitutionGroupHandler != null && n6 == 1) {
            XSElementDecl xSElementDecl = (XSElementDecl)xSParticleDecl.fValue;
            if (xSElementDecl.fScope == 1 && (xSElementDeclArray2 = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl)).length > 0) {
                n6 = 101;
                n4 = n7;
                n5 = n8;
                vector = new Vector(xSElementDeclArray2.length + 1);
                n2 = 0;
                while (n2 < xSElementDeclArray2.length) {
                    XSConstraints.addElementToParticleVector(vector, xSElementDeclArray2[n2]);
                    ++n2;
                }
                XSConstraints.addElementToParticleVector(vector, xSElementDecl);
                substitutionGroupHandler = null;
            }
        }
        if ((n = xSElementDeclArray.fType) == 3) {
            n = ((XSModelGroupImpl)xSElementDeclArray.fValue).fCompositor;
            xSElementDeclArray2 = XSConstraints.getNonUnaryGroup((XSParticleDecl)xSElementDeclArray);
            if (xSElementDeclArray2 != xSElementDeclArray) {
                xSElementDeclArray = xSElementDeclArray2;
                n = xSElementDeclArray.fType;
                if (n == 3) {
                    n = ((XSModelGroupImpl)xSElementDeclArray.fValue).fCompositor;
                }
            }
            vector2 = XSConstraints.removePointlessChildren((XSParticleDecl)xSElementDeclArray);
        }
        int n9 = xSElementDeclArray.fMinOccurs;
        n2 = xSElementDeclArray.fMaxOccurs;
        if (substitutionGroupHandler2 != null && n == 1) {
            XSElementDecl[] xSElementDeclArray3;
            XSElementDecl xSElementDecl = (XSElementDecl)xSElementDeclArray.fValue;
            if (xSElementDecl.fScope == 1 && (xSElementDeclArray3 = substitutionGroupHandler2.getSubstitutionGroup(xSElementDecl)).length > 0) {
                n = 101;
                vector2 = new Vector(xSElementDeclArray3.length + 1);
                int n10 = 0;
                while (n10 < xSElementDeclArray3.length) {
                    XSConstraints.addElementToParticleVector(vector2, xSElementDeclArray3[n10]);
                    ++n10;
                }
                XSConstraints.addElementToParticleVector(vector2, xSElementDecl);
                substitutionGroupHandler2 = null;
            }
        }
        switch (n6) {
            case 1: {
                switch (n) {
                    case 1: {
                        XSConstraints.checkNameAndTypeOK((XSElementDecl)xSParticleDecl.fValue, n7, n8, (XSElementDecl)xSElementDeclArray.fValue, n9, n2);
                        return;
                    }
                    case 2: {
                        XSConstraints.checkNSCompat((XSElementDecl)xSParticleDecl.fValue, n7, n8, (XSWildcardDecl)xSElementDeclArray.fValue, n9, n2, bl);
                        return;
                    }
                    case 101: {
                        vector = new Vector<XSParticleDecl>();
                        vector.addElement(xSParticleDecl);
                        XSConstraints.checkRecurseLax(vector, 1, 1, substitutionGroupHandler, vector2, n9, n2, substitutionGroupHandler2);
                        return;
                    }
                    case 102: 
                    case 103: {
                        vector = new Vector();
                        vector.addElement(xSParticleDecl);
                        XSConstraints.checkRecurse(vector, 1, 1, substitutionGroupHandler, vector2, n9, n2, substitutionGroupHandler2);
                        return;
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
            case 2: {
                switch (n) {
                    case 2: {
                        XSConstraints.checkNSSubset((XSWildcardDecl)xSParticleDecl.fValue, n7, n8, (XSWildcardDecl)xSElementDeclArray.fValue, n9, n2);
                        return;
                    }
                    case 1: 
                    case 101: 
                    case 102: 
                    case 103: {
                        throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"any:choice,sequence,all,elt"});
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
            case 103: {
                switch (n) {
                    case 2: {
                        if (n4 == -2) {
                            n4 = xSParticleDecl.minEffectiveTotalRange();
                        }
                        if (n5 == -2) {
                            n5 = xSParticleDecl.maxEffectiveTotalRange();
                        }
                        XSConstraints.checkNSRecurseCheckCardinality(vector, n4, n5, substitutionGroupHandler, (XSParticleDecl)xSElementDeclArray, n9, n2, bl);
                        return;
                    }
                    case 103: {
                        XSConstraints.checkRecurse(vector, n7, n8, substitutionGroupHandler, vector2, n9, n2, substitutionGroupHandler2);
                        return;
                    }
                    case 1: 
                    case 101: 
                    case 102: {
                        throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"all:choice,sequence,elt"});
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
            case 101: {
                switch (n) {
                    case 2: {
                        if (n4 == -2) {
                            n4 = xSParticleDecl.minEffectiveTotalRange();
                        }
                        if (n5 == -2) {
                            n5 = xSParticleDecl.maxEffectiveTotalRange();
                        }
                        XSConstraints.checkNSRecurseCheckCardinality(vector, n4, n5, substitutionGroupHandler, (XSParticleDecl)xSElementDeclArray, n9, n2, bl);
                        return;
                    }
                    case 101: {
                        XSConstraints.checkRecurseLax(vector, n7, n8, substitutionGroupHandler, vector2, n9, n2, substitutionGroupHandler2);
                        return;
                    }
                    case 1: 
                    case 102: 
                    case 103: {
                        throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"choice:all,sequence,elt"});
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
            case 102: {
                switch (n) {
                    case 2: {
                        if (n4 == -2) {
                            n4 = xSParticleDecl.minEffectiveTotalRange();
                        }
                        if (n5 == -2) {
                            n5 = xSParticleDecl.maxEffectiveTotalRange();
                        }
                        XSConstraints.checkNSRecurseCheckCardinality(vector, n4, n5, substitutionGroupHandler, (XSParticleDecl)xSElementDeclArray, n9, n2, bl);
                        return;
                    }
                    case 103: {
                        XSConstraints.checkRecurseUnordered(vector, n7, n8, substitutionGroupHandler, vector2, n9, n2, substitutionGroupHandler2);
                        return;
                    }
                    case 102: {
                        XSConstraints.checkRecurse(vector, n7, n8, substitutionGroupHandler, vector2, n9, n2, substitutionGroupHandler2);
                        return;
                    }
                    case 101: {
                        int n11 = n7 * vector.size();
                        int n12 = n8 == -1 ? n8 : n8 * vector.size();
                        XSConstraints.checkMapAndSum(vector, n11, n12, substitutionGroupHandler, vector2, n9, n2, substitutionGroupHandler2);
                        return;
                    }
                    case 1: {
                        throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"seq:elt"});
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
        }
    }

    private static void addElementToParticleVector(Vector vector, XSElementDecl xSElementDecl) {
        XSParticleDecl xSParticleDecl = new XSParticleDecl();
        xSParticleDecl.fValue = xSElementDecl;
        xSParticleDecl.fType = 1;
        vector.addElement(xSParticleDecl);
    }

    private static XSParticleDecl getNonUnaryGroup(XSParticleDecl xSParticleDecl) {
        if (xSParticleDecl.fType == 1 || xSParticleDecl.fType == 2) {
            return xSParticleDecl;
        }
        if (xSParticleDecl.fMinOccurs == 1 && xSParticleDecl.fMaxOccurs == 1 && xSParticleDecl.fValue != null && ((XSModelGroupImpl)xSParticleDecl.fValue).fParticleCount == 1) {
            return XSConstraints.getNonUnaryGroup(((XSModelGroupImpl)xSParticleDecl.fValue).fParticles[0]);
        }
        return xSParticleDecl;
    }

    private static Vector removePointlessChildren(XSParticleDecl xSParticleDecl) {
        if (xSParticleDecl.fType == 1 || xSParticleDecl.fType == 2 || xSParticleDecl.fType == 0) {
            return null;
        }
        Vector vector = new Vector();
        XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.fValue;
        int n = 0;
        while (n < xSModelGroupImpl.fParticleCount) {
            XSConstraints.gatherChildren(xSModelGroupImpl.fCompositor, xSModelGroupImpl.fParticles[n], vector);
            ++n;
        }
        return vector;
    }

    private static void gatherChildren(int n, XSParticleDecl xSParticleDecl, Vector vector) {
        int n2 = xSParticleDecl.fMinOccurs;
        int n4 = xSParticleDecl.fMaxOccurs;
        short s = xSParticleDecl.fType;
        if (s == 3) {
            s = ((XSModelGroupImpl)xSParticleDecl.fValue).fCompositor;
        }
        if (s == 0) {
            return;
        }
        if (s == 1 || s == 2) {
            vector.addElement(xSParticleDecl);
            return;
        }
        if (n2 != 1 || n4 != 1) {
            vector.addElement(xSParticleDecl);
        } else if (n == s) {
            XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.fValue;
            int n5 = 0;
            while (n5 < xSModelGroupImpl.fParticleCount) {
                XSConstraints.gatherChildren(s, xSModelGroupImpl.fParticles[n5], vector);
                ++n5;
            }
        } else if (!xSParticleDecl.isEmpty()) {
            vector.addElement(xSParticleDecl);
        }
    }

    private static void checkNameAndTypeOK(XSElementDecl xSElementDecl, int n, int n2, XSElementDecl xSElementDecl2, int n4, int n5) throws XMLSchemaException {
        if (xSElementDecl.fName != xSElementDecl2.fName || xSElementDecl.fTargetNamespace != xSElementDecl2.fTargetNamespace) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.1", new Object[]{xSElementDecl.fName, xSElementDecl.fTargetNamespace, xSElementDecl2.fName, xSElementDecl2.fTargetNamespace});
        }
        if (!xSElementDecl2.getIsNillable() && xSElementDecl.getIsNillable()) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.2", new Object[]{xSElementDecl.fName});
        }
        if (!XSConstraints.checkOccurrenceRange(n, n2, n4, n5)) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.3", new Object[]{xSElementDecl.fName});
        }
        if (xSElementDecl2.getConstraintType() == 2) {
            if (xSElementDecl.getConstraintType() != 2) {
                throw new XMLSchemaException("rcase-NameAndTypeOK.4", new Object[]{xSElementDecl.fName});
            }
            XSSimpleType xSSimpleType = null;
            if (xSElementDecl.fType.getTypeCategory() == 14) {
                xSSimpleType = (XSSimpleType)xSElementDecl.fType;
            } else if (((XSComplexTypeDecl)xSElementDecl.fType).fContentType == 1) {
                xSSimpleType = ((XSComplexTypeDecl)xSElementDecl.fType).fXSSimpleType;
            }
            if (xSSimpleType == null && !xSElementDecl2.fDefault.normalizedValue.equals(xSElementDecl.fDefault.normalizedValue) || xSSimpleType != null && !xSSimpleType.isEqual(xSElementDecl2.fDefault.actualValue, xSElementDecl.fDefault.actualValue)) {
                throw new XMLSchemaException("rcase-NameAndTypeOK.4", new Object[]{xSElementDecl.fName});
            }
        }
        XSConstraints.checkIDConstraintRestriction(xSElementDecl, xSElementDecl2);
        short s = xSElementDecl.fBlock;
        short s2 = xSElementDecl2.fBlock;
        if ((s & s2) != s2 || s == 0 && s2 != 0) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.6", new Object[]{xSElementDecl.fName});
        }
        if (!XSConstraints.checkTypeDerivationOk(xSElementDecl.fType, xSElementDecl2.fType, (short)25)) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.7", new Object[]{xSElementDecl.fName});
        }
    }

    private static void checkIDConstraintRestriction(XSElementDecl xSElementDecl, XSElementDecl xSElementDecl2) throws XMLSchemaException {
    }

    private static boolean checkOccurrenceRange(int n, int n2, int n4, int n5) {
        return n >= n4 && (n5 == -1 || n2 != -1 && n2 <= n5);
    }

    private static void checkNSCompat(XSElementDecl xSElementDecl, int n, int n2, XSWildcardDecl xSWildcardDecl, int n4, int n5, boolean bl) throws XMLSchemaException {
        if (bl && !XSConstraints.checkOccurrenceRange(n, n2, n4, n5)) {
            throw new XMLSchemaException("rcase-NSCompat.2", new Object[]{xSElementDecl.fName});
        }
        if (!xSWildcardDecl.allowNamespace(xSElementDecl.fTargetNamespace)) {
            throw new XMLSchemaException("rcase-NSCompat.1", new Object[]{xSElementDecl.fName, xSElementDecl.fTargetNamespace});
        }
    }

    private static void checkNSSubset(XSWildcardDecl xSWildcardDecl, int n, int n2, XSWildcardDecl xSWildcardDecl2, int n4, int n5) throws XMLSchemaException {
        if (!XSConstraints.checkOccurrenceRange(n, n2, n4, n5)) {
            throw new XMLSchemaException("rcase-NSSubset.2", null);
        }
        if (!xSWildcardDecl.isSubsetOf(xSWildcardDecl2)) {
            throw new XMLSchemaException("rcase-NSSubset.1", null);
        }
    }

    private static void checkNSRecurseCheckCardinality(Vector vector, int n, int n2, SubstitutionGroupHandler substitutionGroupHandler, XSParticleDecl xSParticleDecl, int n4, int n5, boolean bl) throws XMLSchemaException {
        if (bl && !XSConstraints.checkOccurrenceRange(n, n2, n4, n5)) {
            throw new XMLSchemaException("rcase-NSRecurseCheckCardinality.2", null);
        }
        int n6 = vector.size();
        try {
            int n7 = 0;
            while (n7 < n6) {
                XSParticleDecl xSParticleDecl2 = (XSParticleDecl)vector.elementAt(n7);
                XSConstraints.particleValidRestriction(xSParticleDecl2, substitutionGroupHandler, xSParticleDecl, null, false);
                ++n7;
            }
        }
        catch (XMLSchemaException xMLSchemaException) {
            throw new XMLSchemaException("rcase-NSRecurseCheckCardinality.1", null);
        }
    }

    private static void checkRecurse(Vector vector, int n, int n2, SubstitutionGroupHandler substitutionGroupHandler, Vector vector2, int n4, int n5, SubstitutionGroupHandler substitutionGroupHandler2) throws XMLSchemaException {
        if (!XSConstraints.checkOccurrenceRange(n, n2, n4, n5)) {
            throw new XMLSchemaException("rcase-Recurse.1", null);
        }
        int n6 = vector.size();
        int n7 = vector2.size();
        int n8 = 0;
        int n9 = 0;
        while (n9 < n6) {
            block8: {
                XSParticleDecl xSParticleDecl = (XSParticleDecl)vector.elementAt(n9);
                int n10 = n8;
                while (n10 < n7) {
                    XSParticleDecl xSParticleDecl2 = (XSParticleDecl)vector2.elementAt(n10);
                    ++n8;
                    try {
                        XSConstraints.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, xSParticleDecl2, substitutionGroupHandler2);
                        break block8;
                    }
                    catch (XMLSchemaException xMLSchemaException) {
                        if (!xSParticleDecl2.emptiable()) {
                            throw new XMLSchemaException("rcase-Recurse.2", null);
                        }
                        ++n10;
                    }
                }
                throw new XMLSchemaException("rcase-Recurse.2", null);
            }
            ++n9;
        }
        int n11 = n8;
        while (n11 < n7) {
            XSParticleDecl xSParticleDecl = (XSParticleDecl)vector2.elementAt(n11);
            if (!xSParticleDecl.emptiable()) {
                throw new XMLSchemaException("rcase-Recurse.2", null);
            }
            ++n11;
        }
    }

    private static void checkRecurseUnordered(Vector vector, int n, int n2, SubstitutionGroupHandler substitutionGroupHandler, Vector vector2, int n4, int n5, SubstitutionGroupHandler substitutionGroupHandler2) throws XMLSchemaException {
        if (!XSConstraints.checkOccurrenceRange(n, n2, n4, n5)) {
            throw new XMLSchemaException("rcase-RecurseUnordered.1", null);
        }
        int n6 = vector.size();
        int n7 = vector2.size();
        boolean[] blArray = new boolean[n7];
        int n8 = 0;
        while (n8 < n6) {
            block8: {
                XSParticleDecl xSParticleDecl = (XSParticleDecl)vector.elementAt(n8);
                int n9 = 0;
                while (n9 < n7) {
                    XSParticleDecl xSParticleDecl2 = (XSParticleDecl)vector2.elementAt(n9);
                    try {
                        XSConstraints.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, xSParticleDecl2, substitutionGroupHandler2);
                        if (blArray[n9]) {
                            throw new XMLSchemaException("rcase-RecurseUnordered.2", null);
                        }
                        blArray[n9] = true;
                        break block8;
                    }
                    catch (XMLSchemaException xMLSchemaException) {
                        ++n9;
                    }
                }
                throw new XMLSchemaException("rcase-RecurseUnordered.2", null);
            }
            ++n8;
        }
        int n10 = 0;
        while (n10 < n7) {
            XSParticleDecl xSParticleDecl = (XSParticleDecl)vector2.elementAt(n10);
            if (!blArray[n10] && !xSParticleDecl.emptiable()) {
                throw new XMLSchemaException("rcase-RecurseUnordered.2", null);
            }
            ++n10;
        }
    }

    private static void checkRecurseLax(Vector vector, int n, int n2, SubstitutionGroupHandler substitutionGroupHandler, Vector vector2, int n4, int n5, SubstitutionGroupHandler substitutionGroupHandler2) throws XMLSchemaException {
        if (!XSConstraints.checkOccurrenceRange(n, n2, n4, n5)) {
            throw new XMLSchemaException("rcase-RecurseLax.1", null);
        }
        int n6 = vector.size();
        int n7 = vector2.size();
        int n8 = 0;
        int n9 = 0;
        while (n9 < n6) {
            block5: {
                XSParticleDecl xSParticleDecl = (XSParticleDecl)vector.elementAt(n9);
                int n10 = n8;
                while (n10 < n7) {
                    XSParticleDecl xSParticleDecl2 = (XSParticleDecl)vector2.elementAt(n10);
                    ++n8;
                    try {
                        XSConstraints.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, xSParticleDecl2, substitutionGroupHandler2);
                        break block5;
                    }
                    catch (XMLSchemaException xMLSchemaException) {
                        ++n10;
                    }
                }
                throw new XMLSchemaException("rcase-RecurseLax.2", null);
            }
            ++n9;
        }
    }

    private static void checkMapAndSum(Vector vector, int n, int n2, SubstitutionGroupHandler substitutionGroupHandler, Vector vector2, int n4, int n5, SubstitutionGroupHandler substitutionGroupHandler2) throws XMLSchemaException {
        if (!XSConstraints.checkOccurrenceRange(n, n2, n4, n5)) {
            throw new XMLSchemaException("rcase-MapAndSum.2", null);
        }
        int n6 = vector.size();
        int n7 = vector2.size();
        int n8 = 0;
        while (n8 < n6) {
            block5: {
                XSParticleDecl xSParticleDecl = (XSParticleDecl)vector.elementAt(n8);
                int n9 = 0;
                while (n9 < n7) {
                    XSParticleDecl xSParticleDecl2 = (XSParticleDecl)vector2.elementAt(n9);
                    try {
                        XSConstraints.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, xSParticleDecl2, substitutionGroupHandler2);
                        break block5;
                    }
                    catch (XMLSchemaException xMLSchemaException) {
                        ++n9;
                    }
                }
                throw new XMLSchemaException("rcase-MapAndSum.1", null);
            }
            ++n8;
        }
    }

    public static boolean overlapUPA(XSElementDecl xSElementDecl, XSElementDecl xSElementDecl2, SubstitutionGroupHandler substitutionGroupHandler) {
        if (xSElementDecl.fName == xSElementDecl2.fName && xSElementDecl.fTargetNamespace == xSElementDecl2.fTargetNamespace) {
            return true;
        }
        XSElementDecl[] xSElementDeclArray = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl);
        int n = xSElementDeclArray.length - 1;
        while (n >= 0) {
            if (xSElementDeclArray[n].fName == xSElementDecl2.fName && xSElementDeclArray[n].fTargetNamespace == xSElementDecl2.fTargetNamespace) {
                return true;
            }
            --n;
        }
        xSElementDeclArray = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl2);
        int n2 = xSElementDeclArray.length - 1;
        while (n2 >= 0) {
            if (xSElementDeclArray[n2].fName == xSElementDecl.fName && xSElementDeclArray[n2].fTargetNamespace == xSElementDecl.fTargetNamespace) {
                return true;
            }
            --n2;
        }
        return false;
    }

    public static boolean overlapUPA(XSElementDecl xSElementDecl, XSWildcardDecl xSWildcardDecl, SubstitutionGroupHandler substitutionGroupHandler) {
        if (xSWildcardDecl.allowNamespace(xSElementDecl.fTargetNamespace)) {
            return true;
        }
        XSElementDecl[] xSElementDeclArray = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl);
        int n = xSElementDeclArray.length - 1;
        while (n >= 0) {
            if (xSWildcardDecl.allowNamespace(xSElementDeclArray[n].fTargetNamespace)) {
                return true;
            }
            --n;
        }
        return false;
    }

    public static boolean overlapUPA(XSWildcardDecl xSWildcardDecl, XSWildcardDecl xSWildcardDecl2) {
        XSWildcardDecl xSWildcardDecl3 = xSWildcardDecl.performIntersectionWith(xSWildcardDecl2, xSWildcardDecl.fProcessContents);
        return xSWildcardDecl3 == null || xSWildcardDecl3.fType != 3 || xSWildcardDecl3.fNamespaceList.length != 0;
    }

    public static boolean overlapUPA(Object object, Object object2, SubstitutionGroupHandler substitutionGroupHandler) {
        if (object instanceof XSElementDecl) {
            if (object2 instanceof XSElementDecl) {
                return XSConstraints.overlapUPA((XSElementDecl)object, (XSElementDecl)object2, substitutionGroupHandler);
            }
            return XSConstraints.overlapUPA((XSElementDecl)object, (XSWildcardDecl)object2, substitutionGroupHandler);
        }
        if (object2 instanceof XSElementDecl) {
            return XSConstraints.overlapUPA((XSElementDecl)object2, (XSWildcardDecl)object, substitutionGroupHandler);
        }
        return XSConstraints.overlapUPA((XSWildcardDecl)object, (XSWildcardDecl)object2);
    }
}

