/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.util.Locale;
import org.apache.xerces.impl.msg.XMLMessageFormatter;
import org.apache.xerces.util.MessageFormatter;

public class UTF8Reader
extends Reader {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    private static final boolean DEBUG_READ = false;
    protected InputStream fInputStream;
    protected byte[] fBuffer;
    protected int fOffset;
    private int fSurrogate = -1;
    private MessageFormatter fFormatter = null;
    private Locale fLocale = null;

    public UTF8Reader(InputStream inputStream) {
        this(inputStream, 2048, new XMLMessageFormatter(), Locale.getDefault());
    }

    public UTF8Reader(InputStream inputStream, MessageFormatter messageFormatter, Locale locale) {
        this(inputStream, 2048, messageFormatter, locale);
    }

    public UTF8Reader(InputStream inputStream, int n, MessageFormatter messageFormatter, Locale locale) {
        this.fInputStream = inputStream;
        this.fBuffer = new byte[n];
        this.fFormatter = messageFormatter;
        this.fLocale = locale;
    }

    public int read() throws IOException {
        int n = this.fSurrogate;
        if (this.fSurrogate == -1) {
            int n2;
            int n4 = 0;
            int n5 = n2 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4++] & 0xFF;
            if (n2 == -1) {
                return -1;
            }
            if (n2 < 128) {
                n = (char)n2;
            } else if ((n2 & 0xE0) == 192) {
                int n6;
                int n7 = n6 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4++] & 0xFF;
                if (n6 == -1) {
                    this.expectedByte(2, 2);
                }
                if ((n6 & 0xC0) != 128) {
                    this.invalidByte(2, 2, n6);
                }
                n = n2 << 6 & 0x7C0 | n6 & 0x3F;
            } else if ((n2 & 0xF0) == 224) {
                int n8;
                int n9;
                int n10 = n9 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4++] & 0xFF;
                if (n9 == -1) {
                    this.expectedByte(2, 3);
                }
                if ((n9 & 0xC0) != 128) {
                    this.invalidByte(2, 3, n9);
                }
                int n11 = n8 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4++] & 0xFF;
                if (n8 == -1) {
                    this.expectedByte(3, 3);
                }
                if ((n8 & 0xC0) != 128) {
                    this.invalidByte(3, 3, n8);
                }
                n = n2 << 12 & 0xF000 | n9 << 6 & 0xFC0 | n8 & 0x3F;
            } else if ((n2 & 0xF8) == 240) {
                int n12;
                int n13;
                int n14;
                int n15;
                int n16 = n15 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4++] & 0xFF;
                if (n15 == -1) {
                    this.expectedByte(2, 4);
                }
                if ((n15 & 0xC0) != 128) {
                    this.invalidByte(2, 3, n15);
                }
                int n17 = n14 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4++] & 0xFF;
                if (n14 == -1) {
                    this.expectedByte(3, 4);
                }
                if ((n14 & 0xC0) != 128) {
                    this.invalidByte(3, 3, n14);
                }
                int n18 = n13 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4++] & 0xFF;
                if (n13 == -1) {
                    this.expectedByte(4, 4);
                }
                if ((n13 & 0xC0) != 128) {
                    this.invalidByte(4, 4, n13);
                }
                if ((n12 = n2 << 2 & 0x1C | n15 >> 4 & 3) > 16) {
                    this.invalidSurrogate(n12);
                }
                int n19 = n12 - 1;
                int n20 = 0xD800 | n19 << 6 & 0x3C0 | n15 << 2 & 0x3C | n14 >> 4 & 3;
                int n21 = 0xDC00 | n14 << 6 & 0x3C0 | n13 & 0x3F;
                n = n20;
                this.fSurrogate = n21;
            } else {
                this.invalidByte(1, 1, n2);
            }
        } else {
            this.fSurrogate = -1;
        }
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n4 = n;
        if (this.fSurrogate != -1) {
            cArray[n + 1] = (char)this.fSurrogate;
            this.fSurrogate = -1;
            --n2;
            ++n4;
        }
        int n5 = 0;
        if (this.fOffset == 0) {
            if (n2 > this.fBuffer.length) {
                n2 = this.fBuffer.length;
            }
            if ((n5 = this.fInputStream.read(this.fBuffer, 0, n2)) == -1) {
                return -1;
            }
            n5 += n4 - n;
        } else {
            n5 = this.fOffset;
            this.fOffset = 0;
        }
        int n6 = n5;
        int n7 = 0;
        while (n7 < n6) {
            int n8;
            int n9;
            int n10;
            int n11 = this.fBuffer[n7] & 0xFF;
            if (n11 < 128) {
                cArray[n4++] = (char)n11;
            } else if ((n11 & 0xE0) == 192) {
                n10 = -1;
                if (++n7 < n6) {
                    n10 = this.fBuffer[n7] & 0xFF;
                } else {
                    n10 = this.fInputStream.read();
                    if (n10 == -1) {
                        if (n4 > n) {
                            this.fBuffer[0] = (byte)n11;
                            this.fOffset = 1;
                            return n4 - n;
                        }
                        this.expectedByte(2, 2);
                    }
                    ++n5;
                }
                if ((n10 & 0xC0) != 128) {
                    if (n4 > n) {
                        this.fBuffer[0] = (byte)n11;
                        this.fBuffer[1] = (byte)n10;
                        this.fOffset = 2;
                        return n4 - n;
                    }
                    this.invalidByte(2, 2, n10);
                }
                n9 = n11 << 6 & 0x7C0 | n10 & 0x3F;
                cArray[n4++] = (char)n9;
                --n5;
            } else if ((n11 & 0xF0) == 224) {
                n10 = -1;
                if (++n7 < n6) {
                    n10 = this.fBuffer[n7] & 0xFF;
                } else {
                    n10 = this.fInputStream.read();
                    if (n10 == -1) {
                        if (n4 > n) {
                            this.fBuffer[0] = (byte)n11;
                            this.fOffset = 1;
                            return n4 - n;
                        }
                        this.expectedByte(2, 3);
                    }
                    ++n5;
                }
                if ((n10 & 0xC0) != 128) {
                    if (n4 > n) {
                        this.fBuffer[0] = (byte)n11;
                        this.fBuffer[1] = (byte)n10;
                        this.fOffset = 2;
                        return n4 - n;
                    }
                    this.invalidByte(2, 3, n10);
                }
                n9 = -1;
                if (++n7 < n6) {
                    n9 = this.fBuffer[n7] & 0xFF;
                } else {
                    n9 = this.fInputStream.read();
                    if (n9 == -1) {
                        if (n4 > n) {
                            this.fBuffer[0] = (byte)n11;
                            this.fBuffer[1] = (byte)n10;
                            this.fOffset = 2;
                            return n4 - n;
                        }
                        this.expectedByte(3, 3);
                    }
                    ++n5;
                }
                if ((n9 & 0xC0) != 128) {
                    if (n4 > n) {
                        this.fBuffer[0] = (byte)n11;
                        this.fBuffer[1] = (byte)n10;
                        this.fBuffer[2] = (byte)n9;
                        this.fOffset = 3;
                        return n4 - n;
                    }
                    this.invalidByte(3, 3, n9);
                }
                n8 = n11 << 12 & 0xF000 | n10 << 6 & 0xFC0 | n9 & 0x3F;
                cArray[n4++] = (char)n8;
                n5 -= 2;
            } else if ((n11 & 0xF8) == 240) {
                int n12;
                n10 = -1;
                if (++n7 < n6) {
                    n10 = this.fBuffer[n7] & 0xFF;
                } else {
                    n10 = this.fInputStream.read();
                    if (n10 == -1) {
                        if (n4 > n) {
                            this.fBuffer[0] = (byte)n11;
                            this.fOffset = 1;
                            return n4 - n;
                        }
                        this.expectedByte(2, 4);
                    }
                    ++n5;
                }
                if ((n10 & 0xC0) != 128) {
                    if (n4 > n) {
                        this.fBuffer[0] = (byte)n11;
                        this.fBuffer[1] = (byte)n10;
                        this.fOffset = 2;
                        return n4 - n;
                    }
                    this.invalidByte(2, 4, n10);
                }
                n9 = -1;
                if (++n7 < n6) {
                    n9 = this.fBuffer[n7] & 0xFF;
                } else {
                    n9 = this.fInputStream.read();
                    if (n9 == -1) {
                        if (n4 > n) {
                            this.fBuffer[0] = (byte)n11;
                            this.fBuffer[1] = (byte)n10;
                            this.fOffset = 2;
                            return n4 - n;
                        }
                        this.expectedByte(3, 4);
                    }
                    ++n5;
                }
                if ((n9 & 0xC0) != 128) {
                    if (n4 > n) {
                        this.fBuffer[0] = (byte)n11;
                        this.fBuffer[1] = (byte)n10;
                        this.fBuffer[2] = (byte)n9;
                        this.fOffset = 3;
                        return n4 - n;
                    }
                    this.invalidByte(3, 4, n9);
                }
                n8 = -1;
                if (++n7 < n6) {
                    n8 = this.fBuffer[n7] & 0xFF;
                } else {
                    n8 = this.fInputStream.read();
                    if (n8 == -1) {
                        if (n4 > n) {
                            this.fBuffer[0] = (byte)n11;
                            this.fBuffer[1] = (byte)n10;
                            this.fBuffer[2] = (byte)n9;
                            this.fOffset = 3;
                            return n4 - n;
                        }
                        this.expectedByte(4, 4);
                    }
                    ++n5;
                }
                if ((n8 & 0xC0) != 128) {
                    if (n4 > n) {
                        this.fBuffer[0] = (byte)n11;
                        this.fBuffer[1] = (byte)n10;
                        this.fBuffer[2] = (byte)n9;
                        this.fBuffer[3] = (byte)n8;
                        this.fOffset = 4;
                        return n4 - n;
                    }
                    this.invalidByte(4, 4, n9);
                }
                if ((n12 = n11 << 2 & 0x1C | n10 >> 4 & 3) > 16) {
                    this.invalidSurrogate(n12);
                }
                int n13 = n12 - 1;
                int n14 = n10 & 0xF;
                int n15 = n9 & 0x3F;
                int n16 = n8 & 0x3F;
                int n17 = 0xD800 | n13 << 6 & 0x3C0 | n14 << 2 | n15 >> 4;
                int n18 = 0xDC00 | n15 << 6 & 0x3C0 | n16;
                cArray[n4++] = (char)n17;
                cArray[n4++] = (char)n18;
                n5 -= 2;
            } else {
                if (n4 > n) {
                    this.fBuffer[0] = (byte)n11;
                    this.fOffset = 1;
                    return n4 - n;
                }
                this.invalidByte(1, 1, n11);
            }
            ++n7;
        }
        return n5;
    }

    public long skip(long l) throws IOException {
        int n;
        int n2;
        long l2 = l;
        char[] cArray = new char[this.fBuffer.length];
        while ((n2 = this.read(cArray, 0, n = (long)cArray.length < l2 ? cArray.length : (int)l2)) > 0 && (l2 -= (long)n2) > 0L) {
        }
        long l3 = l - l2;
        return l3;
    }

    public boolean ready() throws IOException {
        return false;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) throws IOException {
        throw new IOException(this.fFormatter.formatMessage(this.fLocale, "OperationNotSupported", new Object[]{"mark()", "UTF-8"}));
    }

    public void reset() throws IOException {
        this.fOffset = 0;
        this.fSurrogate = -1;
    }

    public void close() throws IOException {
        this.fInputStream.close();
    }

    private void expectedByte(int n, int n2) throws UTFDataFormatException {
        String string = this.fFormatter.formatMessage(this.fLocale, "ExpectedByte", new Object[]{Integer.toString(n), Integer.toString(n2)});
        throw new UTFDataFormatException(string);
    }

    private void invalidByte(int n, int n2, int n4) throws UTFDataFormatException {
        String string = this.fFormatter.formatMessage(this.fLocale, "InvalidByte", new Object[]{Integer.toString(n), Integer.toString(n2)});
        throw new UTFDataFormatException(string);
    }

    private void invalidSurrogate(int n) throws UTFDataFormatException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("high surrogate bits in UTF-8 sequence must not exceed 0x10 but found 0x");
        String string = this.fFormatter.formatMessage(this.fLocale, "InvalidHighSurrogate", new Object[]{Integer.toHexString(n)});
        throw new UTFDataFormatException(string);
    }
}

