/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import org.apache.xerces.util.MessageFormatter;

public class ASCIIReader
extends Reader {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    protected InputStream fInputStream;
    protected byte[] fBuffer;
    private MessageFormatter fFormatter = null;
    private Locale fLocale = null;

    public ASCIIReader(InputStream inputStream, MessageFormatter messageFormatter, Locale locale) {
        this(inputStream, 2048, messageFormatter, locale);
    }

    public ASCIIReader(InputStream inputStream, int n, MessageFormatter messageFormatter, Locale locale) {
        this.fInputStream = inputStream;
        this.fBuffer = new byte[n];
        this.fFormatter = messageFormatter;
        this.fLocale = locale;
    }

    public int read() throws IOException {
        int n = this.fInputStream.read();
        if (n > 128) {
            throw new IOException(this.fFormatter.formatMessage(this.fLocale, "InvalidASCII", new Object[]{Integer.toString(n)}));
        }
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (n2 > this.fBuffer.length) {
            n2 = this.fBuffer.length;
        }
        int n4 = this.fInputStream.read(this.fBuffer, 0, n2);
        int n5 = 0;
        while (n5 < n4) {
            byte by = this.fBuffer[n5];
            if (by > 128) {
                throw new IOException(this.fFormatter.formatMessage(this.fLocale, "InvalidASCII", new Object[]{Integer.toString(by)}));
            }
            cArray[n + n5] = (char)by;
            ++n5;
        }
        return n4;
    }

    public long skip(long l) throws IOException {
        return this.fInputStream.skip(l);
    }

    public boolean ready() throws IOException {
        return false;
    }

    public boolean markSupported() {
        return this.fInputStream.markSupported();
    }

    public void mark(int n) throws IOException {
        this.fInputStream.mark(n);
    }

    public void reset() throws IOException {
        this.fInputStream.reset();
    }

    public void close() throws IOException {
        this.fInputStream.close();
    }
}

