/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.xerces.impl.dv.xs.SchemaDateTimeException;

public class MonthDayDV
extends AbstractDateTimeDV {
    private static final int MONTHDAY_SIZE = 7;

    public Object getActualValue(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return this.parse(string);
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "gMonthDay"});
        }
    }

    protected int[] parse(String string) throws SchemaDateTimeException {
        int n = string.length();
        int[] nArray = new int[8];
        int[] nArray2 = new int[2];
        nArray[0] = 2000;
        if (string.charAt(0) != '-' || string.charAt(1) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonthDay: " + string);
        }
        nArray[1] = this.parseInt(string, 2, 4);
        int n2 = 4;
        if (string.charAt(n2++) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonthDay: " + string);
        }
        nArray[2] = this.parseInt(string, n2, n2 + 2);
        if (7 < n) {
            int n4 = this.findUTCSign(string, 7, n);
            if (n4 < 0) {
                throw new SchemaDateTimeException("Error in month parsing:" + string);
            }
            this.getTimeZone(string, nArray, n4, n, nArray2);
        }
        this.validateDateTime(nArray, nArray2);
        if (nArray[7] != 0 && nArray[7] != 90) {
            this.normalize(nArray, nArray2);
        }
        return nArray;
    }

    protected String dateToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(8);
        stringBuffer.append('-');
        stringBuffer.append('-');
        stringBuffer.append(nArray[1]);
        stringBuffer.append('-');
        stringBuffer.append(nArray[2]);
        stringBuffer.append((char)nArray[7]);
        return stringBuffer.toString();
    }
}

