/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.xerces.impl.dv.xs.SchemaDateTimeException;

public class DurationDV
extends AbstractDateTimeDV {
    private static final int[][] DATETIMES = new int[][]{{1696, 9, 1, 0, 0, 0, 0, 90}, {1697, 2, 1, 0, 0, 0, 0, 90}, {1903, 3, 1, 0, 0, 0, 0, 90}, {1903, 7, 1, 0, 0, 0, 0, 90}};
    private int[][] fDuration = null;

    public Object getActualValue(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return this.parse(string);
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "duration"});
        }
    }

    protected int[] parse(String string) throws SchemaDateTimeException {
        int n;
        char c;
        int n2 = string.length();
        int[] nArray = new int[8];
        int n4 = 0;
        if ((c = string.charAt(n4++)) != 'P' && c != '-') {
            throw new SchemaDateTimeException();
        }
        int n5 = nArray[7] = c == '-' ? 45 : 0;
        if (c == '-' && string.charAt(n4++) != 'P') {
            throw new SchemaDateTimeException();
        }
        int n6 = 1;
        if (nArray[7] == 45) {
            n6 = -1;
        }
        boolean bl = false;
        int n7 = this.indexOf(string, n4, n2, 'T');
        if (n7 == -1) {
            n7 = n2;
        }
        if ((n = this.indexOf(string, n4, n7, 'Y')) != -1) {
            nArray[0] = n6 * this.parseInt(string, n4, n);
            n4 = n + 1;
            bl = true;
        }
        if ((n = this.indexOf(string, n4, n7, 'M')) != -1) {
            nArray[1] = n6 * this.parseInt(string, n4, n);
            n4 = n + 1;
            bl = true;
        }
        if ((n = this.indexOf(string, n4, n7, 'D')) != -1) {
            nArray[2] = n6 * this.parseInt(string, n4, n);
            n4 = n + 1;
            bl = true;
        }
        if (n2 == n7 && n4 != n2) {
            throw new SchemaDateTimeException();
        }
        if (n2 != n7) {
            if ((n = this.indexOf(string, ++n4, n2, 'H')) != -1) {
                nArray[3] = n6 * this.parseInt(string, n4, n);
                n4 = n + 1;
                bl = true;
            }
            if ((n = this.indexOf(string, n4, n2, 'M')) != -1) {
                nArray[4] = n6 * this.parseInt(string, n4, n);
                n4 = n + 1;
                bl = true;
            }
            if ((n = this.indexOf(string, n4, n2, 'S')) != -1) {
                int n8 = this.indexOf(string, n4, n, '.');
                if (n8 > 0) {
                    nArray[5] = n6 * this.parseInt(string, n4, n8);
                    nArray[6] = n6 * this.parseInt(string, n8 + 1, n);
                } else {
                    nArray[5] = n6 * this.parseInt(string, n4, n);
                }
                n4 = n + 1;
                bl = true;
            }
            if (n4 != n2 || string.charAt(--n4) == 'T') {
                throw new SchemaDateTimeException();
            }
        }
        if (!bl) {
            throw new SchemaDateTimeException();
        }
        return nArray;
    }

    protected short compareDates(int[] nArray, int[] nArray2, boolean bl) {
        int[] nArray3;
        int[] nArray4;
        short s = 2;
        short s2 = this.compareOrder(nArray, nArray2);
        if (s2 == 0) {
            return 0;
        }
        if (this.fDuration == null) {
            this.fDuration = new int[2][8];
        }
        if ((s2 = this.compareOrder(nArray4 = this.addDuration(nArray, 0, this.fDuration[0]), nArray3 = this.addDuration(nArray2, 0, this.fDuration[1]))) == 2) {
            return 2;
        }
        nArray4 = this.addDuration(nArray, 1, this.fDuration[0]);
        s = this.compareOrder(nArray4, nArray3 = this.addDuration(nArray2, 1, this.fDuration[1]));
        if ((s2 = this.compareResults(s2, s, bl)) == 2) {
            return 2;
        }
        nArray4 = this.addDuration(nArray, 2, this.fDuration[0]);
        s = this.compareOrder(nArray4, nArray3 = this.addDuration(nArray2, 2, this.fDuration[1]));
        if ((s2 = this.compareResults(s2, s, bl)) == 2) {
            return 2;
        }
        nArray4 = this.addDuration(nArray, 3, this.fDuration[0]);
        nArray3 = this.addDuration(nArray2, 3, this.fDuration[1]);
        s = this.compareOrder(nArray4, nArray3);
        s2 = this.compareResults(s2, s, bl);
        return s2;
    }

    private short compareResults(short s, short s2, boolean bl) {
        if (s2 == 2) {
            return 2;
        }
        if (s != s2 && bl) {
            return 2;
        }
        if (s != s2 && !bl) {
            if (s != 0 && s2 != 0) {
                return 2;
            }
            return s != 0 ? s : s2;
        }
        return s;
    }

    private int[] addDuration(int[] nArray, int n, int[] nArray2) {
        this.resetDateObj(nArray2);
        int n2 = DATETIMES[n][1] + nArray[1];
        nArray2[1] = this.modulo(n2, 1, 13);
        int n4 = this.fQuotient(n2, 1, 13);
        nArray2[0] = DATETIMES[n][0] + nArray[0] + n4;
        n2 = DATETIMES[n][5] + nArray[5];
        n4 = this.fQuotient(n2, 60);
        nArray2[5] = this.mod(n2, 60, n4);
        n2 = DATETIMES[n][4] + nArray[4] + n4;
        n4 = this.fQuotient(n2, 60);
        nArray2[4] = this.mod(n2, 60, n4);
        n2 = DATETIMES[n][3] + nArray[3] + n4;
        n4 = this.fQuotient(n2, 24);
        nArray2[3] = this.mod(n2, 24, n4);
        nArray2[2] = DATETIMES[n][2] + nArray[2] + n4;
        while (true) {
            n2 = this.maxDayInMonthFor(nArray2[0], nArray2[1]);
            if (nArray2[2] < 1) {
                nArray2[2] = nArray2[2] + this.maxDayInMonthFor(nArray2[0], nArray2[1] - 1);
                n4 = -1;
            } else {
                if (nArray2[2] <= n2) break;
                nArray2[2] = nArray2[2] - n2;
                n4 = 1;
            }
            n2 = nArray2[1] + n4;
            nArray2[1] = this.modulo(n2, 1, 13);
            nArray2[0] = nArray2[0] + this.fQuotient(n2, 1, 13);
        }
        nArray2[7] = 90;
        return nArray2;
    }

    protected String dateToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(30);
        int n = 1;
        if (nArray[0] < 0) {
            stringBuffer.append('-');
            n = -1;
        }
        stringBuffer.append('P');
        stringBuffer.append(n * nArray[0]);
        stringBuffer.append('Y');
        stringBuffer.append(n * nArray[1]);
        stringBuffer.append('M');
        stringBuffer.append(n * nArray[2]);
        stringBuffer.append('D');
        stringBuffer.append('T');
        stringBuffer.append(n * nArray[3]);
        stringBuffer.append('H');
        stringBuffer.append(n * nArray[4]);
        stringBuffer.append('M');
        stringBuffer.append(n * nArray[5]);
        stringBuffer.append('.');
        stringBuffer.append(n * nArray[6]);
        stringBuffer.append('S');
        return stringBuffer.toString();
    }
}

