/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.util;

import java.io.UnsupportedEncodingException;

public final class HexBin {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 16;
    private static final byte[] hexNumberTable = new byte[255];
    private static final byte[] lookUpHexAlphabet = new byte[16];

    static boolean isHex(byte by) {
        return hexNumberTable[by] != -1;
    }

    public static byte[] encode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        int n2 = n * 2;
        byte[] byArray2 = new byte[n2];
        int n4 = 0;
        while (n4 < n) {
            byArray2[n4 * 2] = lookUpHexAlphabet[byArray[n4] >> 4];
            byArray2[n4 * 2 + 1] = lookUpHexAlphabet[byArray[n4] & 0xF];
            ++n4;
        }
        return byArray2;
    }

    public static byte[] decode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        if (n % 2 != 0) {
            return null;
        }
        int n2 = n / 2;
        byte[] byArray2 = new byte[n2];
        int n4 = 0;
        while (n4 < n2) {
            if (!HexBin.isHex(byArray[n4 * 2]) || !HexBin.isHex(byArray[n4 * 2 + 1])) {
                return null;
            }
            byArray2[n4] = (byte)(hexNumberTable[byArray[n4 * 2]] << 4 | hexNumberTable[byArray[n4 * 2 + 1]]);
            ++n4;
        }
        return byArray2;
    }

    /*
     * Loose catch block
     */
    public static String decode(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = null;
        byArray = HexBin.decode(string.getBytes("utf-8"));
        Object var4_2 = null;
        String string2 = null;
        try {
            string2 = byArray == null ? null : new String(byArray, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
        {
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Object var4_3 = null;
                String string3 = null;
                try {
                    string3 = byArray == null ? null : new String(byArray, "8859_1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    // empty catch block
                }
                return string3;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            String string4 = null;
            try {
                string4 = byArray == null ? null : new String(byArray, "8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return string4;
        }
    }

    static {
        int n = 0;
        while (n < 255) {
            HexBin.hexNumberTable[n] = -1;
            ++n;
        }
        int n2 = 57;
        while (n2 >= 48) {
            HexBin.hexNumberTable[n2] = (byte)(n2 - 48);
            --n2;
        }
        int n4 = 70;
        while (n4 >= 65) {
            HexBin.hexNumberTable[n4] = (byte)(n4 - 65 + 10);
            --n4;
        }
        int n5 = 102;
        while (n5 >= 97) {
            HexBin.hexNumberTable[n5] = (byte)(n5 - 97 + 10);
            --n5;
        }
        int n6 = 0;
        while (n6 < 10) {
            HexBin.lookUpHexAlphabet[n6] = (byte)(48 + n6);
            ++n6;
        }
        int n7 = 10;
        while (n7 <= 15) {
            HexBin.lookUpHexAlphabet[n7] = (byte)(65 + n7 - 10);
            ++n7;
        }
    }
}

