/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.IOException;
import org.apache.xerces.impl.XMLDocumentScannerImpl;
import org.apache.xerces.impl.XMLScanner;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;

public class XML11DocumentScannerImpl
extends XMLDocumentScannerImpl {
    private String[] fStrings = new String[3];
    private XMLString fString = new XMLString();
    private XMLStringBuffer fStringBuffer = new XMLStringBuffer();
    private XMLStringBuffer fStringBuffer2 = new XMLStringBuffer();
    private XMLStringBuffer fStringBuffer3 = new XMLStringBuffer();

    protected int scanContent() throws IOException, XNIException {
        XMLString xMLString = this.fString;
        int n = this.fEntityScanner.scanContent(xMLString);
        if (n == 13 || n == 133 || n == 8232) {
            this.fEntityScanner.scanChar();
            this.fStringBuffer.clear();
            this.fStringBuffer.append(this.fString);
            this.fStringBuffer.append((char)n);
            xMLString = this.fStringBuffer;
            n = -1;
        }
        if (this.fDocumentHandler != null && xMLString.length > 0) {
            this.fDocumentHandler.characters(xMLString, null);
        }
        if (n == 93 && this.fString.length == 0) {
            this.fStringBuffer.clear();
            this.fStringBuffer.append((char)this.fEntityScanner.scanChar());
            this.fInScanContent = true;
            if (this.fEntityScanner.skipChar(93)) {
                this.fStringBuffer.append(']');
                while (this.fEntityScanner.skipChar(93)) {
                    this.fStringBuffer.append(']');
                }
                if (this.fEntityScanner.skipChar(62)) {
                    this.reportFatalError("CDEndInContent", null);
                }
            }
            if (this.fDocumentHandler != null && this.fStringBuffer.length != 0) {
                this.fDocumentHandler.characters(this.fStringBuffer, null);
            }
            this.fInScanContent = false;
            n = -1;
        }
        return n;
    }

    protected void scanXMLDeclOrTextDecl(boolean bl, String[] stringArray) throws IOException, XNIException {
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = this.fEntityScanner.skipSpaces();
        while (this.fEntityScanner.peekChar() != 63) {
            bl2 = true;
            String string4 = this.scanPseudoAttribute(bl, this.fString);
            switch (n) {
                case 0: {
                    if (string4 == XMLScanner.fVersionSymbol) {
                        if (!bl3) {
                            this.reportFatalError(bl ? "SpaceRequiredBeforeVersionInTextDecl" : "SpaceRequiredBeforeVersionInXMLDecl", null);
                        }
                        string = this.fString.toString();
                        n = 1;
                        if (string.equals("1.0") && string.equals("1.1")) break;
                        this.reportFatalError("VersionNotSupported", new Object[]{string});
                        break;
                    }
                    if (string4 == XMLScanner.fEncodingSymbol) {
                        if (!bl) {
                            this.reportFatalError("VersionInfoRequired", null);
                        }
                        if (!bl3) {
                            this.reportFatalError(bl ? "SpaceRequiredBeforeEncodingInTextDecl" : "SpaceRequiredBeforeEncodingInXMLDecl", null);
                        }
                        string2 = this.fString.toString();
                        n = bl ? 3 : 2;
                        break;
                    }
                    if (bl) {
                        this.reportFatalError("EncodingDeclRequired", null);
                        break;
                    }
                    this.reportFatalError("VersionInfoRequired", null);
                    break;
                }
                case 1: {
                    if (string4 == XMLScanner.fEncodingSymbol) {
                        if (!bl3) {
                            this.reportFatalError(bl ? "SpaceRequiredBeforeEncodingInTextDecl" : "SpaceRequiredBeforeEncodingInXMLDecl", null);
                        }
                        string2 = this.fString.toString();
                        n = bl ? 3 : 2;
                        break;
                    }
                    if (!bl && string4 == XMLScanner.fStandaloneSymbol) {
                        if (!bl3) {
                            this.reportFatalError("SpaceRequiredBeforeStandalone", null);
                        }
                        string3 = this.fString.toString();
                        n = 3;
                        if (string3.equals("yes") || string3.equals("no")) break;
                        this.reportFatalError("SDDeclInvalid", null);
                        break;
                    }
                    this.reportFatalError("EncodingDeclRequired", null);
                    break;
                }
                case 2: {
                    if (string4 == XMLScanner.fStandaloneSymbol) {
                        if (!bl3) {
                            this.reportFatalError("SpaceRequiredBeforeStandalone", null);
                        }
                        string3 = this.fString.toString();
                        n = 3;
                        if (string3.equals("yes") || string3.equals("no")) break;
                        this.reportFatalError("SDDeclInvalid", null);
                        break;
                    }
                    this.reportFatalError("EncodingDeclRequired", null);
                    break;
                }
                default: {
                    this.reportFatalError("NoMorePseudoAttributes", null);
                }
            }
            bl3 = this.fEntityScanner.skipSpaces();
        }
        if (bl && n != 3) {
            this.reportFatalError("MorePseudoAttributes", null);
        }
        if (bl) {
            if (!bl2 && string2 == null) {
                this.reportFatalError("EncodingDeclRequired", null);
            }
        } else if (!bl2 && string == null) {
            this.reportFatalError("VersionInfoRequired", null);
        }
        if (!this.fEntityScanner.skipChar(63)) {
            this.reportFatalError("XMLDeclUnterminated", null);
        }
        if (!this.fEntityScanner.skipChar(62)) {
            this.reportFatalError("XMLDeclUnterminated", null);
        }
        stringArray[0] = string;
        stringArray[1] = string2;
        stringArray[2] = string3;
    }

    protected void scanAttributeValue(XMLString xMLString, XMLString xMLString2, String string, XMLAttributes xMLAttributes, int n, boolean bl) throws IOException, XNIException {
        int n2;
        int n4 = this.fEntityScanner.peekChar();
        if (n4 != 39 && n4 != 34) {
            this.reportFatalError("OpenQuoteExpected", new Object[]{string});
        }
        this.fEntityScanner.scanChar();
        int n5 = this.fEntityDepth;
        int n6 = this.fEntityScanner.scanLiteral(n4, xMLString);
        this.fStringBuffer2.clear();
        this.fStringBuffer2.append(xMLString);
        this.normalizeWhitespace(xMLString);
        if (n6 != n4) {
            this.fScanningAttribute = true;
            this.fStringBuffer.clear();
            do {
                this.fStringBuffer.append(xMLString);
                if (n6 == 38) {
                    this.fEntityScanner.skipChar(38);
                    if (n5 == this.fEntityDepth) {
                        this.fStringBuffer2.append('&');
                    }
                    if (this.fEntityScanner.skipChar(35)) {
                        if (n5 == this.fEntityDepth) {
                            this.fStringBuffer2.append('#');
                        }
                        if ((n2 = this.scanCharReferenceValue(this.fStringBuffer, this.fStringBuffer2)) != -1) {
                            // empty if block
                        }
                    } else {
                        String string2 = this.fEntityScanner.scanName();
                        if (string2 == null) {
                            this.reportFatalError("NameRequiredInReference", null);
                        } else if (n5 == this.fEntityDepth) {
                            this.fStringBuffer2.append(string2);
                        }
                        if (!this.fEntityScanner.skipChar(59)) {
                            this.reportFatalError("SemicolonRequiredInReference", new Object[]{string2});
                        } else if (n5 == this.fEntityDepth) {
                            this.fStringBuffer2.append(';');
                        }
                        if (string2 == XMLScanner.fAmpSymbol) {
                            this.fStringBuffer.append('&');
                        } else if (string2 == XMLScanner.fAposSymbol) {
                            this.fStringBuffer.append('\'');
                        } else if (string2 == XMLScanner.fLtSymbol) {
                            this.fStringBuffer.append('<');
                        } else if (string2 == XMLScanner.fGtSymbol) {
                            this.fStringBuffer.append('>');
                        } else if (string2 == XMLScanner.fQuotSymbol) {
                            this.fStringBuffer.append('\"');
                        } else if (this.fEntityManager.isExternalEntity(string2)) {
                            this.reportFatalError("ReferenceToExternalEntity", new Object[]{string2});
                        } else {
                            if (!this.fEntityManager.isDeclaredEntity(string2)) {
                                if (bl) {
                                    if (this.fValidation) {
                                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EntityNotDeclared", new Object[]{string2}, (short)1);
                                    }
                                } else {
                                    this.reportFatalError("EntityNotDeclared", new Object[]{string2});
                                }
                            }
                            this.fEntityManager.startEntity(string2, true);
                        }
                    }
                } else if (n6 == 60) {
                    this.reportFatalError("LessthanInAttValue", new Object[]{null, string});
                    this.fEntityScanner.scanChar();
                    if (n5 == this.fEntityDepth) {
                        this.fStringBuffer2.append((char)n6);
                    }
                } else if (n6 == 37 || n6 == 93) {
                    this.fEntityScanner.scanChar();
                    this.fStringBuffer.append((char)n6);
                    if (n5 == this.fEntityDepth) {
                        this.fStringBuffer2.append((char)n6);
                    }
                } else if (n6 == 10 || n6 == 13 || n6 == 133 || n6 == 8232) {
                    this.fEntityScanner.scanChar();
                    this.fStringBuffer.append(' ');
                    if (n5 == this.fEntityDepth) {
                        this.fStringBuffer2.append('\n');
                    }
                } else if (n6 != -1 && XMLChar.isHighSurrogate(n6)) {
                    if (this.scanSurrogates(this.fStringBuffer3)) {
                        this.fStringBuffer.append(this.fStringBuffer3);
                        if (n5 == this.fEntityDepth) {
                            this.fStringBuffer2.append(this.fStringBuffer3);
                        }
                    }
                } else if (n6 != -1 && XMLChar.isInvalid(n6)) {
                    this.reportFatalError("InvalidCharInAttValue", new Object[]{Integer.toString(n6, 16)});
                    this.fEntityScanner.scanChar();
                    if (n5 == this.fEntityDepth) {
                        this.fStringBuffer2.append((char)n6);
                    }
                }
                n6 = this.fEntityScanner.scanLiteral(n4, xMLString);
                if (n5 == this.fEntityDepth) {
                    this.fStringBuffer2.append(xMLString);
                }
                this.normalizeWhitespace(xMLString);
            } while (n6 != n4 || n5 != this.fEntityDepth);
            this.fStringBuffer.append(xMLString);
            xMLString.setValues(this.fStringBuffer);
            this.fScanningAttribute = false;
        }
        xMLString2.setValues(this.fStringBuffer2);
        n2 = this.fEntityScanner.scanChar();
        if (n2 != n4) {
            this.reportFatalError("CloseQuoteExpected", new Object[]{string});
        }
    }

    protected boolean scanPubidLiteral(XMLString xMLString) throws IOException, XNIException {
        int n = this.fEntityScanner.scanChar();
        if (n != 39 && n != 34) {
            this.reportFatalError("QuoteRequiredInPublicID", null);
            return false;
        }
        this.fStringBuffer.clear();
        boolean bl = true;
        boolean bl2 = true;
        while (true) {
            int n2;
            if ((n2 = this.fEntityScanner.scanChar()) == 32 || n2 == 10 || n2 == 13 || n2 == 133 || n2 == 8232) {
                if (bl) continue;
                this.fStringBuffer.append(' ');
                bl = true;
                continue;
            }
            if (n2 == n) {
                if (bl) {
                    --this.fStringBuffer.length;
                }
                break;
            }
            if (XMLChar.isPubid(n2)) {
                this.fStringBuffer.append((char)n2);
                bl = false;
                continue;
            }
            if (n2 == -1) {
                this.reportFatalError("PublicIDUnterminated", null);
                return false;
            }
            bl2 = false;
            this.reportFatalError("InvalidCharInPublicID", new Object[]{Integer.toHexString(n2)});
        }
        xMLString.setValues(this.fStringBuffer);
        return bl2;
    }

    protected void normalizeWhitespace(XMLString xMLString) {
        int n = xMLString.offset + xMLString.length;
        int n2 = xMLString.offset;
        while (n2 < n) {
            char c = xMLString.ch[n2];
            if (XMLChar.isXML11Space(c)) {
                xMLString.ch[n2] = 32;
            }
            ++n2;
        }
    }
}

