/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom3.UserDataHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public abstract class NodeImpl
implements Node,
NodeList,
EventTarget,
Cloneable,
Serializable {
    public static final short TREE_POSITION_PRECEDING = 1;
    public static final short TREE_POSITION_FOLLOWING = 2;
    public static final short TREE_POSITION_ANCESTOR = 4;
    public static final short TREE_POSITION_DESCENDANT = 8;
    public static final short TREE_POSITION_EQUIVALENT = 16;
    public static final short TREE_POSITION_SAME_NODE = 32;
    public static final short TREE_POSITION_DISCONNECTED = 0;
    static final long serialVersionUID = -6316591992167219696L;
    public static final short ELEMENT_DEFINITION_NODE = -1;
    protected NodeImpl ownerNode;
    protected short flags;
    protected static final short READONLY = 1;
    protected static final short SYNCDATA = 2;
    protected static final short SYNCCHILDREN = 4;
    protected static final short OWNED = 8;
    protected static final short FIRSTCHILD = 16;
    protected static final short SPECIFIED = 32;
    protected static final short IGNORABLEWS = 64;
    protected static final short HASSTRING = 128;
    protected static final short UNNORMALIZED = 256;
    protected static final short IDATTRIBUTE = 512;

    protected NodeImpl(CoreDocumentImpl coreDocumentImpl) {
        this.ownerNode = coreDocumentImpl;
    }

    public NodeImpl() {
    }

    public abstract short getNodeType();

    public abstract String getNodeName();

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String string) throws DOMException {
    }

    public Node appendChild(Node node) throws DOMException {
        return this.insertBefore(node, null);
    }

    public Node cloneNode(boolean bl) {
        NodeImpl nodeImpl;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        try {
            nodeImpl = (NodeImpl)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("**Internal Error**" + cloneNotSupportedException);
        }
        nodeImpl.ownerNode = this.ownerDocument();
        nodeImpl.isOwned(false);
        nodeImpl.isReadOnly(false);
        this.ownerDocument().callUserDataHandlers(this, nodeImpl, (short)1);
        return nodeImpl;
    }

    public Document getOwnerDocument() {
        if (this.isOwned()) {
            return this.ownerNode.ownerDocument();
        }
        return (Document)((Object)this.ownerNode);
    }

    CoreDocumentImpl ownerDocument() {
        if (this.isOwned()) {
            return this.ownerNode.ownerDocument();
        }
        return (CoreDocumentImpl)this.ownerNode;
    }

    void setOwnerDocument(CoreDocumentImpl coreDocumentImpl) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (!this.isOwned()) {
            this.ownerNode = coreDocumentImpl;
        }
    }

    public Node getParentNode() {
        return null;
    }

    NodeImpl parentNode() {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    ChildNode previousSibling() {
        return null;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
    }

    public Node removeChild(Node node) throws DOMException {
        throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null));
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
    }

    public int getLength() {
        return 0;
    }

    public Node item(int n) {
        return null;
    }

    public void normalize() {
    }

    public boolean isSupported(String string, String string2) {
        return this.ownerDocument().getImplementation().hasFeature(string, string2);
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setPrefix(String string) throws DOMException {
        throw new DOMException(14, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null));
    }

    public String getLocalName() {
        return null;
    }

    public void addEventListener(String string, EventListener eventListener, boolean bl) {
        this.ownerDocument().addEventListener(this, string, eventListener, bl);
    }

    public void removeEventListener(String string, EventListener eventListener, boolean bl) {
        this.ownerDocument().removeEventListener(this, string, eventListener, bl);
    }

    public boolean dispatchEvent(Event event) {
        return this.ownerDocument().dispatchEvent(this, event);
    }

    public String getBaseURI() {
        return null;
    }

    public short compareTreePosition(Node node) {
        int n;
        if (this == node) {
            return 48;
        }
        short s = this.getNodeType();
        short s2 = node.getNodeType();
        if (s == 6 || s == 12 || s2 == 6 || s2 == 12) {
            return 0;
        }
        Node node2 = this;
        Node node3 = node;
        int n2 = 0;
        int n4 = 0;
        Node node4 = this;
        while (node4 != null) {
            ++n2;
            if (node4 == node) {
                return 5;
            }
            node2 = node4;
            node4 = node4.getParentNode();
        }
        node4 = node;
        while (node4 != null) {
            ++n4;
            if (node4 == this) {
                return 10;
            }
            node3 = node4;
            node4 = node4.getParentNode();
        }
        Node node5 = this;
        Node node6 = node;
        short s3 = node2.getNodeType();
        short s4 = node3.getNodeType();
        if (s3 == 2) {
            node5 = ((AttrImpl)node2).getOwnerElement();
        }
        if (s4 == 2) {
            node6 = ((AttrImpl)node3).getOwnerElement();
        }
        if (s3 == 2 && s4 == 2 && node5 == node6) {
            return 16;
        }
        if (s3 == 2) {
            n2 = 0;
            node4 = node5;
            while (node4 != null) {
                ++n2;
                if (node4 == node6) {
                    return 1;
                }
                node2 = node4;
                node4 = node4.getParentNode();
            }
        }
        if (s4 == 2) {
            n4 = 0;
            node4 = node6;
            while (node4 != null) {
                ++n4;
                if (node4 == node5) {
                    return 2;
                }
                node3 = node4;
                node4 = node4.getParentNode();
            }
        }
        if (node2 != node3) {
            return 0;
        }
        if (n2 > n4) {
            n = 0;
            while (n < n2 - n4) {
                node5 = node5.getParentNode();
                ++n;
            }
            if (node5 == node6) {
                return 1;
            }
        } else {
            n = 0;
            while (n < n4 - n2) {
                node6 = node6.getParentNode();
                ++n;
            }
            if (node6 == node5) {
                return 2;
            }
        }
        Node node7 = node5.getParentNode();
        Node node8 = node6.getParentNode();
        while (node7 != node8) {
            node5 = node7;
            node6 = node8;
            node7 = node7.getParentNode();
            node8 = node8.getParentNode();
        }
        Node node9 = node7.getFirstChild();
        while (node9 != null) {
            if (node9 == node6) {
                return 1;
            }
            if (node9 == node5) {
                return 2;
            }
            node9 = node9.getNextSibling();
        }
        return 0;
    }

    public String getTextContent() throws DOMException {
        return this.getNodeValue();
    }

    void getTextContent(StringBuffer stringBuffer) throws DOMException {
        String string = this.getNodeValue();
        if (string != null) {
            stringBuffer.append(string);
        }
    }

    public void setTextContent(String string) throws DOMException {
        this.setNodeValue(string);
    }

    public boolean isSameNode(Node node) {
        return this == node;
    }

    public boolean isDefaultNamespace(String string) {
        short s = this.getNodeType();
        switch (s) {
            case 1: {
                NodeImpl nodeImpl;
                NodeImpl nodeImpl2;
                String string2 = this.getNamespaceURI();
                String string3 = this.getPrefix();
                if (string3 == null || string3.length() == 0) {
                    if (string == null) {
                        return string2 == string;
                    }
                    return string.equals(string2);
                }
                if (this.hasAttributes() && (nodeImpl2 = (NodeImpl)((Object)((ElementImpl)(nodeImpl = (ElementImpl)this)).getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns"))) != null) {
                    String string4 = nodeImpl2.getNodeValue();
                    if (string == null) {
                        return string2 == string4;
                    }
                    return string.equals(string4);
                }
                nodeImpl = (NodeImpl)this.getElementAncestor(this);
                if (nodeImpl != null) {
                    return nodeImpl.isDefaultNamespace(string);
                }
                return false;
            }
            case 9: {
                return ((NodeImpl)((Object)((Document)((Object)this)).getDocumentElement())).isDefaultNamespace(string);
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return false;
            }
            case 2: {
                if (this.ownerNode.getNodeType() == 1) {
                    return this.ownerNode.isDefaultNamespace(string);
                }
                return false;
            }
        }
        NodeImpl nodeImpl = (NodeImpl)this.getElementAncestor(this);
        if (nodeImpl != null) {
            return nodeImpl.isDefaultNamespace(string);
        }
        return false;
    }

    public String lookupNamespacePrefix(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        short s = this.getNodeType();
        switch (s) {
            case 1: {
                String string2 = this.getNamespaceURI();
                return this.lookupNamespacePrefix(string, bl, (ElementImpl)this);
            }
            case 9: {
                return ((NodeImpl)((Object)((Document)((Object)this)).getDocumentElement())).lookupNamespacePrefix(string, bl);
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
            case 2: {
                if (this.ownerNode.getNodeType() == 1) {
                    return this.ownerNode.lookupNamespacePrefix(string, bl);
                }
                return null;
            }
        }
        NodeImpl nodeImpl = (NodeImpl)this.getElementAncestor(this);
        if (nodeImpl != null) {
            return nodeImpl.lookupNamespacePrefix(string, bl);
        }
        return null;
    }

    public String lookupNamespaceURI(String string) {
        short s = this.getNodeType();
        switch (s) {
            case 1: {
                Object object;
                String string2 = this.getNamespaceURI();
                String string3 = this.getPrefix();
                if (string2 != null) {
                    if (string == null && string3 == string) {
                        return string2;
                    }
                    if (string3 != null && string3.equals(string)) {
                        return string2;
                    }
                }
                if (this.hasAttributes()) {
                    object = this.getAttributes();
                    int n = object.getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        Node node = object.item(n2);
                        String string4 = node.getPrefix();
                        String string5 = node.getNodeValue();
                        string2 = node.getNamespaceURI();
                        if (string2 != null && string2.equals("http://www.w3.org/2000/xmlns/")) {
                            if (string == null && node.getNodeName().equals("xmlns")) {
                                return string5;
                            }
                            if (string4 != null && string4.equals("xmlns") && node.getLocalName().equals(string)) {
                                return string5;
                            }
                        }
                        ++n2;
                    }
                }
                if ((object = (NodeImpl)this.getElementAncestor(this)) != null) {
                    return ((NodeImpl)object).lookupNamespaceURI(string);
                }
                return null;
            }
            case 9: {
                return ((NodeImpl)((Object)((Document)((Object)this)).getDocumentElement())).lookupNamespaceURI(string);
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
            case 2: {
                if (this.ownerNode.getNodeType() == 1) {
                    return this.ownerNode.lookupNamespaceURI(string);
                }
                return null;
            }
        }
        NodeImpl nodeImpl = (NodeImpl)this.getElementAncestor(this);
        if (nodeImpl != null) {
            return nodeImpl.lookupNamespaceURI(string);
        }
        return null;
    }

    Node getElementAncestor(Node node) {
        Node node2 = node.getParentNode();
        if (node2 != null) {
            short s = node2.getNodeType();
            if (s == 1) {
                return node2;
            }
            return this.getElementAncestor(node2);
        }
        return null;
    }

    String lookupNamespacePrefix(String string, boolean bl, ElementImpl elementImpl) {
        Object object;
        String string2 = this.getNamespaceURI();
        String string3 = this.getPrefix();
        if (string2 != null && string2.equals(string) && (bl || string3 != null) && (object = elementImpl.lookupNamespaceURI(string3)) != null && ((String)object).equals(string)) {
            return string3;
        }
        if (this.hasAttributes()) {
            object = this.getAttributes();
            int n = object.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string4;
                String string5;
                Node node = object.item(n2);
                String string6 = node.getPrefix();
                String string7 = node.getNodeValue();
                string2 = node.getNamespaceURI();
                if (string2 != null && string2.equals("http://www.w3.org/2000/xmlns/") && (bl && node.getNodeName().equals("xmlns") || string6 != null && string6.equals("xmlns") && string7.equals(string)) && (string5 = elementImpl.lookupNamespaceURI(string4 = node.getLocalName())) != null && string5.equals(string)) {
                    return string4;
                }
                ++n2;
            }
        }
        if ((object = (NodeImpl)this.getElementAncestor(this)) != null) {
            return ((NodeImpl)object).lookupNamespacePrefix(string, bl, elementImpl);
        }
        return null;
    }

    public boolean isEqualNode(Node node) {
        if (node == this) {
            return true;
        }
        if (node.getNodeType() != this.getNodeType()) {
            return false;
        }
        if (this.getNodeName() == null ? node.getNodeName() != null : !this.getNodeName().equals(node.getNodeName())) {
            return false;
        }
        if (this.getLocalName() == null ? node.getLocalName() != null : !this.getLocalName().equals(node.getLocalName())) {
            return false;
        }
        if (this.getNamespaceURI() == null ? node.getNamespaceURI() != null : !this.getNamespaceURI().equals(node.getNamespaceURI())) {
            return false;
        }
        if (this.getPrefix() == null ? node.getPrefix() != null : !this.getPrefix().equals(node.getPrefix())) {
            return false;
        }
        if (this.getNodeValue() == null ? node.getNodeValue() != null : !this.getNodeValue().equals(node.getNodeValue())) {
            return false;
        }
        return !(this.getBaseURI() == null ? ((NodeImpl)node).getBaseURI() != null : !this.getBaseURI().equals(((NodeImpl)node).getBaseURI()));
    }

    public Node getInterface(String string) {
        return this.isSupported(string, null) ? this : null;
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        return this.ownerDocument().setUserData(this, string, object, userDataHandler);
    }

    public Object getUserData(String string) {
        return this.ownerDocument().getUserData(this, string);
    }

    public void setReadOnly(boolean bl, boolean bl2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.isReadOnly(bl);
    }

    public boolean getReadOnly() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.isReadOnly();
    }

    public void setUserData(Object object) {
        this.ownerDocument().setUserData(this, object);
    }

    public Object getUserData() {
        return this.ownerDocument().getUserData(this);
    }

    protected void changed() {
        this.ownerDocument().changed();
    }

    protected int changes() {
        return this.ownerDocument().changes();
    }

    protected void synchronizeData() {
        this.needsSyncData(false);
    }

    final boolean isReadOnly() {
        return (this.flags & 1) != 0;
    }

    final void isReadOnly(boolean bl) {
        this.flags = bl ? (short)(this.flags | 1) : (short)(this.flags & 0xFFFFFFFE);
    }

    final boolean needsSyncData() {
        return (this.flags & 2) != 0;
    }

    final void needsSyncData(boolean bl) {
        this.flags = bl ? (short)(this.flags | 2) : (short)(this.flags & 0xFFFFFFFD);
    }

    final boolean needsSyncChildren() {
        return (this.flags & 4) != 0;
    }

    public final void needsSyncChildren(boolean bl) {
        this.flags = bl ? (short)(this.flags | 4) : (short)(this.flags & 0xFFFFFFFB);
    }

    final boolean isOwned() {
        return (this.flags & 8) != 0;
    }

    final void isOwned(boolean bl) {
        this.flags = bl ? (short)(this.flags | 8) : (short)(this.flags & 0xFFFFFFF7);
    }

    final boolean isFirstChild() {
        return (this.flags & 0x10) != 0;
    }

    final void isFirstChild(boolean bl) {
        this.flags = bl ? (short)(this.flags | 0x10) : (short)(this.flags & 0xFFFFFFEF);
    }

    final boolean isSpecified() {
        return (this.flags & 0x20) != 0;
    }

    final void isSpecified(boolean bl) {
        this.flags = bl ? (short)(this.flags | 0x20) : (short)(this.flags & 0xFFFFFFDF);
    }

    final boolean internalIsIgnorableWhitespace() {
        return (this.flags & 0x40) != 0;
    }

    final void isIgnorableWhitespace(boolean bl) {
        this.flags = bl ? (short)(this.flags | 0x40) : (short)(this.flags & 0xFFFFFFBF);
    }

    final boolean hasStringValue() {
        return (this.flags & 0x80) != 0;
    }

    final void hasStringValue(boolean bl) {
        this.flags = bl ? (short)(this.flags | 0x80) : (short)(this.flags & 0xFFFFFF7F);
    }

    final boolean isNormalized() {
        return (this.flags & 0x100) == 0;
    }

    final void isNormalized(boolean bl) {
        if (!bl && this.isNormalized() && this.ownerNode != null) {
            this.ownerNode.isNormalized(false);
        }
        this.flags = bl ? (short)(this.flags & 0xFFFFFEFF) : (short)(this.flags | 0x100);
    }

    final boolean isIdAttribute() {
        return (this.flags & 0x200) != 0;
    }

    final void isIdAttribute(boolean bl) {
        this.flags = bl ? (short)(this.flags | 0x200) : (short)(this.flags & 0xFFFFFDFF);
    }

    public String toString() {
        return "[" + this.getNodeName() + ": " + this.getNodeValue() + "]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        objectOutputStream.defaultWriteObject();
    }
}

