/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import java.io.File;

class ConvertToURI {
    private static final long L_DIGIT = ConvertToURI.lowMask('0', '9');
    private static final long H_DIGIT = 0L;
    private static final long L_UPALPHA = 0L;
    private static final long H_UPALPHA = ConvertToURI.highMask('A', 'Z');
    private static final long L_LOWALPHA = 0L;
    private static final long H_LOWALPHA = ConvertToURI.highMask('a', 'z');
    private static final long L_ALPHA = 0L;
    private static final long H_ALPHA = H_LOWALPHA | H_UPALPHA;
    private static final long L_ALPHANUM = L_DIGIT | 0L;
    private static final long H_ALPHANUM = 0L | H_ALPHA;
    private static final long L_HEX = L_DIGIT;
    private static final long H_HEX = ConvertToURI.highMask('A', 'F') | ConvertToURI.highMask('a', 'f');
    private static final long L_MARK = ConvertToURI.lowMask("-_.!~*'()");
    private static final long H_MARK = ConvertToURI.highMask("-_.!~*'()");
    private static final long L_UNRESERVED = L_ALPHANUM | L_MARK;
    private static final long H_UNRESERVED = H_ALPHANUM | H_MARK;
    private static final long L_RESERVED = ConvertToURI.lowMask(";/?:@&=+$,[]");
    private static final long H_RESERVED = ConvertToURI.highMask(";/?:@&=+$,[]");
    private static final long L_ESCAPED = 1L;
    private static final long H_ESCAPED = 0L;
    private static final long L_URIC = L_RESERVED | L_UNRESERVED | 1L;
    private static final long H_URIC = H_RESERVED | H_UNRESERVED | 0L;
    private static final long L_PCHAR = L_UNRESERVED | 1L | ConvertToURI.lowMask(":@&=+$,");
    private static final long H_PCHAR = H_UNRESERVED | 0L | ConvertToURI.highMask(":@&=+$,");
    private static final long L_PATH = L_PCHAR | ConvertToURI.lowMask(";/");
    private static final long H_PATH = H_PCHAR | ConvertToURI.highMask(";/");
    private static final long L_DASH = ConvertToURI.lowMask("-");
    private static final long H_DASH = ConvertToURI.highMask("-");
    private static final long L_DOT = ConvertToURI.lowMask(".");
    private static final long H_DOT = ConvertToURI.highMask(".");
    private static final long L_USERINFO = L_UNRESERVED | 1L | ConvertToURI.lowMask(";:&=+$,");
    private static final long H_USERINFO = H_UNRESERVED | 0L | ConvertToURI.highMask(";:&=+$,");
    private static final long L_REG_NAME = L_UNRESERVED | 1L | ConvertToURI.lowMask("$,;:@&=+");
    private static final long H_REG_NAME = H_UNRESERVED | 0L | ConvertToURI.highMask("$,;:@&=+");
    private static final long L_SERVER = L_USERINFO | L_ALPHANUM | L_DASH | ConvertToURI.lowMask(".:@[]");
    private static final long H_SERVER = H_USERINFO | H_ALPHANUM | H_DASH | ConvertToURI.highMask(".:@[]");
    private static final long L_SCHEME = 0L | L_DIGIT | ConvertToURI.lowMask("+-.");
    private static final long H_SCHEME = H_ALPHA | 0L | ConvertToURI.highMask("+-.");
    private static final long L_URIC_NO_SLASH = L_UNRESERVED | 1L | ConvertToURI.lowMask(";?:@&=+$,");
    private static final long H_URIC_NO_SLASH = H_UNRESERVED | 0L | ConvertToURI.highMask(";?:@&=+$,");
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    ConvertToURI() {
    }

    private static long lowMask(String string) {
        int n = string.length();
        long l = 0L;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c < '@') {
                l |= 1L << c;
            }
            ++n2;
        }
        return l;
    }

    private static long highMask(String string) {
        int n = string.length();
        long l = 0L;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c >= '@' && c < '\u0080') {
                l |= 1L << c - 64;
            }
            ++n2;
        }
        return l;
    }

    private static long lowMask(char c, char c2) {
        long l = 0L;
        int n = Math.max(Math.min(c, 63), 0);
        int n2 = Math.max(Math.min(c2, 63), 0);
        int n4 = n;
        while (n4 <= n2) {
            l |= 1L << n4;
            ++n4;
        }
        return l;
    }

    private static long highMask(char c, char c2) {
        long l = 0L;
        int n = Math.max(Math.min(c, 127), 64) - 64;
        int n2 = Math.max(Math.min(c2, 127), 64) - 64;
        int n4 = n;
        while (n4 <= n2) {
            l |= 1L << n4;
            ++n4;
        }
        return l;
    }

    private static boolean match(char c, long l, long l2) {
        if (c < '@') {
            return (1L << c & l) != 0L;
        }
        if (c < '\u0080') {
            return (1L << c - 64 & l2) != 0L;
        }
        return false;
    }

    public static String getEscapedURI(String string) {
        return ConvertToURI.quote(ConvertToURI.normalize(ConvertToURI.slashify(string)), L_PATH, H_PATH);
    }

    private static void appendEscape(StringBuffer stringBuffer, byte by) {
        stringBuffer.append('%');
        stringBuffer.append(hexDigits[by >> 4 & 0xF]);
        stringBuffer.append(hexDigits[by >> 0 & 0xF]);
    }

    private static String slashify(String string) {
        String string2 = string;
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        return string2;
    }

    private static String quote(String string, long l, long l2) {
        int n = string.length();
        StringBuffer stringBuffer = null;
        boolean bl = (l & 1L) != 0L;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c < '\u0080') {
                if (!ConvertToURI.match(c, l, l2)) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                        stringBuffer.append(string.substring(0, n2));
                    }
                    ConvertToURI.appendEscape(stringBuffer, (byte)c);
                } else if (stringBuffer != null) {
                    stringBuffer.append(c);
                }
            } else {
                if (bl && (Character.isSpaceChar(c) || Character.isISOControl(c))) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                        stringBuffer.append(string.substring(0, n2));
                    }
                    throw new InternalError();
                }
                if (stringBuffer != null) {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    private static byte decode(char c, char c2) {
        return (byte)((ConvertToURI.decode(c) & 0xF) << 4 | (ConvertToURI.decode(c2) & 0xF) << 0);
    }

    private static void split(char[] cArray, int[] nArray) {
        int n = cArray.length - 1;
        int n2 = 0;
        int n4 = 0;
        while (n2 <= n) {
            if (cArray[n2] != '/') break;
            cArray[n2] = '\u0000';
            ++n2;
        }
        block1: while (n2 <= n) {
            nArray[n4++] = n2++;
            while (n2 <= n) {
                if (cArray[n2++] != '/') continue;
                cArray[n2 - 1] = '\u0000';
                while (n2 <= n) {
                    if (cArray[n2] != '/') continue block1;
                    cArray[n2++] = '\u0000';
                }
                continue block1;
            }
        }
        if (n4 != nArray.length) {
            throw new InternalError();
        }
    }

    private static String normalize(String string) {
        int n = ConvertToURI.needsNormalization(string);
        if (n < 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int[] nArray = new int[n];
        ConvertToURI.split(cArray, nArray);
        ConvertToURI.removeDots(cArray, nArray);
        return new String(cArray, 0, ConvertToURI.join(cArray, nArray));
    }

    private static int join(char[] cArray, int[] nArray) {
        int n = nArray.length;
        int n2 = cArray.length - 1;
        int n4 = 0;
        if (cArray[n4] == '\u0000') {
            cArray[n4++] = 47;
        }
        int n5 = 0;
        while (n5 < n) {
            int n6 = nArray[n5];
            if (n6 != -1) {
                if (n4 == n6) {
                    while (n4 <= n2 && cArray[n4] != '\u0000') {
                        ++n4;
                    }
                    if (n4 <= n2) {
                        cArray[n4++] = 47;
                    }
                } else if (n4 < n6) {
                    while (n6 <= n2 && cArray[n6] != '\u0000') {
                        cArray[n4++] = cArray[n6++];
                    }
                    if (n6 <= n2) {
                        cArray[n4++] = 47;
                    }
                } else {
                    throw new InternalError();
                }
            }
            ++n5;
        }
        return n4;
    }

    private static void removeDots(char[] cArray, int[] nArray) {
        int n = nArray.length;
        int n2 = cArray.length - 1;
        int n4 = 0;
        while (n4 < n) {
            int n5;
            int n6 = 0;
            do {
                if (cArray[n5 = nArray[n4]] != '.') continue;
                if (n5 == n2) {
                    n6 = 1;
                    break;
                }
                if (cArray[n5 + 1] == '\u0000') {
                    n6 = 1;
                    break;
                }
                if (cArray[n5 + 1] != '.' || n5 + 1 != n2 && cArray[n5 + 2] != '\u0000') continue;
                n6 = 2;
                break;
            } while (++n4 < n);
            if (n4 > n || n6 == 0) break;
            if (n6 == 1) {
                nArray[n4] = -1;
            } else {
                int n7;
                n5 = n4 - 1;
                while (n5 >= 0) {
                    if (nArray[n5] != -1) break;
                    --n5;
                }
                if (n5 >= 0 && (cArray[n7 = nArray[n5]] != '.' || cArray[n7 + 1] != '.' || cArray[n7 + 2] != '\u0000')) {
                    nArray[n4] = -1;
                    nArray[n5] = -1;
                }
            }
            ++n4;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int needsNormalization(String var0) {
        var1_1 = true;
        var2_2 = 0;
        var3_3 = var0.length() - 1;
        var4_4 = 0;
        while (var4_4 <= var3_3) {
            if (var0.charAt(var4_4) != '/') break;
            ++var4_4;
        }
        if (var4_4 > 1) {
            var1_1 = false;
        }
        block1: while (var4_4 <= var3_3) {
            if (var0.charAt(var4_4) == '.' && (var4_4 == var3_3 || var0.charAt(var4_4 + 1) == '/' || var0.charAt(var4_4 + 1) == '.' && (var4_4 + 1 == var3_3 || var0.charAt(var4_4 + 2) == '/'))) {
                var1_1 = false;
            }
            ++var2_2;
            while (var4_4 <= var3_3) {
                if (var0.charAt(var4_4++) == '/') ** GOTO lbl21
                continue;
                while (var0.charAt(var4_4) == '/') {
                    var1_1 = false;
                    ++var4_4;
lbl21:
                    // 2 sources

                    if (var4_4 <= var3_3) continue;
                    continue block1;
                }
                continue block1;
            }
        }
        return var1_1 != false ? -1 : var2_2;
    }
}

