/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.db.rdf.vocabulary;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.rdf.model.Model;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;
import org.w3c.rdf.util.RDFFactoryImpl;
import org.w3c.rdf.util.RDFUtil;
import org.w3c.rdf.util.SetOperations;
import org.w3c.rdf.vocabulary.dublin_core_19990702.DC;
import org.w3c.rdf.vocabulary.rdf_schema_19990303.RDFS;

/*
 * Exception performing whole class analysis ignored.
 */
public class Generator {
    static final String DEFAULT_PACKAGE_CLASS = "UnspecifiedClass";
    static final String NS_IMPORT = "import org.w3c.rdf.model.*;\n";
    static final String DEFAULT_NODE_FACTORY = "org.w3c.rdf.implementation.model.NodeFactoryImpl";
    static final String NS_COMMENT = "/**\n * This class provides convenient access to schema information.\n * DO NOT MODIFY THIS FILE.\n * It was generated automatically by edu.stanford.db.rdf.vocabulary.Generator\n */\n";
    static final String NS_NSDEF = "  /** Namespace URI of this schema */";
    static final String NS_ID = "_Namespace";
    static Hashtable reservedWords = new Hashtable();

    static {
        Generator.addReservedWord((String)"import");
        Generator.addReservedWord((String)"class");
        Generator.addReservedWord((String)"interface");
        Generator.addReservedWord((String)"public");
        Generator.addReservedWord((String)"private");
        Generator.addReservedWord((String)"extends");
        Generator.addReservedWord((String)"implements");
        Generator.addReservedWord((String)"final");
        Generator.addReservedWord((String)"int");
        Generator.addReservedWord((String)"float");
        Generator.addReservedWord((String)"double");
        Generator.addReservedWord((String)"long");
        Generator.addReservedWord((String)"boolean");
        Generator.addReservedWord((String)"throws");
        Generator.addReservedWord((String)"catch");
        Generator.addReservedWord((String)"void");
        Generator.addReservedWord((String)"default");
        Generator.addReservedWord((String)"static");
        Generator.addReservedWord((String)"transient");
        Generator.addReservedWord((String)"_Namespace");
    }

    static void addReservedWord(String string) {
        reservedWords.put(string, string);
    }

    static void closeFileStream(OutputStream outputStream) throws IOException {
        if (outputStream != System.out) {
            outputStream.close();
        }
    }

    static void createJavaVocabulary(String string, Model model, String string2, String string3, String string4) throws Exception {
        int n;
        String string5 = null;
        String string6 = null;
        if (string4 == null) {
            string4 = "org.w3c.rdf.implementation.model.NodeFactoryImpl";
        }
        if ((n = string.lastIndexOf(46)) < 0) {
            string6 = string;
            string5 = "";
        } else {
            string6 = string.substring(n + 1);
            string5 = string.substring(0, n);
        }
        System.err.println("Creating interface " + string6 + " within package " + string5 + (string3 != null ? " in " + string3 : ""));
        String string7 = Generator.prepareOutputDir((String)string5, (String)string3);
        OutputStream outputStream = Generator.openFileStream((String)string7, (String)string6, (String)string3);
        Generator.dumpVocabulary((OutputStream)outputStream, (String)string5, (String)string6, (Model)model, (String)string2, (String)string4);
        Generator.closeFileStream((OutputStream)outputStream);
    }

    static void dumpVocabulary(OutputStream outputStream, String string, String string2, Model model, String string3, String string4) throws Exception {
        String string5;
        String string6;
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        if (!"".equals(string)) {
            printWriter.println("package " + string + ";\n");
        }
        printWriter.println("import org.w3c.rdf.model.*;\n");
        printWriter.println("/**\n * This class provides convenient access to schema information.\n * DO NOT MODIFY THIS FILE.\n * It was generated automatically by edu.stanford.db.rdf.vocabulary.Generator\n */\n");
        printWriter.println("public class " + string2 + " {\n");
        printWriter.println("  /** Namespace URI of this schema */");
        printWriter.println("  public static final String _Namespace = \"" + string3 + "\";\n");
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = RDFUtil.getResources(model).elements();
        while (enumeration.hasMoreElements()) {
            Resource resource = (Resource)enumeration.nextElement();
            string6 = resource.toString();
            if (!string6.startsWith(string3) || (string5 = string6.substring(string3.length())).length() <= 0) continue;
            vector.addElement(string5);
            Statement statement = RDFUtil.get1(model.find(resource, RDFS.comment, null));
            if (statement == null) {
                statement = RDFUtil.get1(model.find(resource, DC.Description, null));
            }
            if (statement != null) {
                printWriter.println("  /** " + statement.object() + " */");
            }
            printWriter.println("  public static Resource " + Generator.toJavaName((String)string5) + ";\n");
        }
        printWriter.println("  static {\n    try {\n      setNodeFactory(new " + string4 + "());\n" + "    } catch (ModelException ex) { ex.printStackTrace(System.err); }\n" + "  }\n\n" + "  private static Resource createResource(NodeFactory f, String suffix) throws ModelException {\n" + "    return f.createResource(_Namespace, suffix);\n" + "  }\n\n" + "  public static void setNodeFactory(NodeFactory f) throws ModelException {\n");
        int n = 0;
        while (n < vector.size()) {
            string6 = (String)vector.elementAt(n);
            string5 = Generator.toJavaName((String)string6);
            printWriter.println("    " + string5 + " = createResource(f, \"" + string6 + "\");");
            ++n;
        }
        printWriter.println("  }\n}");
        printWriter.flush();
    }

    static boolean isReservedWord(String string) {
        return reservedWords.contains(string);
    }

    public static void main(String[] stringArray) {
        RDFFactoryImpl rDFFactoryImpl = new RDFFactoryImpl();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("-d")) {
                string = stringArray[n + 1];
                n += 2;
                continue;
            }
            if (stringArray[n].startsWith("-o")) {
                string2 = stringArray[n + 1];
                n += 2;
                continue;
            }
            if (stringArray[n].startsWith("-s")) {
                hashtable.put(stringArray[n + 1], stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].startsWith("-n")) {
                string3 = stringArray[n + 1];
                n += 2;
                continue;
            }
            if (stringArray[n].startsWith("-f")) {
                string4 = stringArray[n + 1];
                n += 2;
                continue;
            }
            hashtable.clear();
            break;
        }
        if (hashtable.size() == 0) {
            System.err.println("Usage: Generator  [-d <output directory>] [-o <output class name>] [-n <namespace>] [-f <node factory class name>] {-s <schema file or URL>}+\nIf -d is not specified, generated class will be printed to standard output.");
            System.exit(1);
        }
        if (string2 == null) {
            string2 = "UnspecifiedClass";
        }
        try {
            Model model = null;
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                String string5 = (String)enumeration.nextElement();
                if (string3 == null) {
                    string3 = string5;
                }
                Model model2 = rDFFactoryImpl.createModel();
                RDFUtil.parse(string5, rDFFactoryImpl.createParser(), model2);
                System.err.println("Reading schema from " + string5);
                if (model == null) {
                    model = model2;
                    continue;
                }
                SetOperations.unite(model, model2);
            }
            System.err.println("Total statements: " + model.size());
            Generator.createJavaVocabulary((String)string2, (Model)model, (String)string3, (String)string, string4);
        }
        catch (Exception exception) {
            System.err.println("Could not generate vocabulary: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    static OutputStream openFileStream(String string, String string2, String string3) throws IOException {
        if (string3 == null) {
            return System.out;
        }
        File file = new File(String.valueOf(string) + File.separator + string2 + ".java");
        System.err.println("WRITING " + file);
        new RandomAccessFile(file, "rw").close();
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    static String prepareOutputDir(String string, String string2) throws IOException {
        File file;
        if (string2 == null) {
            return null;
        }
        if (string == null) {
            string = "";
        }
        if (!(file = new File(string2)).isDirectory()) {
            throw new IOException("Invalid output directory: " + string2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            if (!(file = new File(file, stringTokenizer.nextToken())).exists()) {
                file.mkdir();
                continue;
            }
            if (file.isDirectory()) continue;
            throw new IOException("Cannot create directory: " + file);
        }
        return file.getPath();
    }

    static String toJavaName(String string) {
        if (Generator.isReservedWord((String)string)) {
            return "_" + string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '-' || c == '.') {
                stringBuffer.append('_');
            } else if (!Character.isJavaIdentifierPart(c)) {
                stringBuffer.append("c" + c);
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        if (Character.isDigit(string.charAt(0))) {
            return "_" + stringBuffer;
        }
        return stringBuffer.toString();
    }
}

