/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.db.rdf.uml;

import edu.stanford.db.rdf.schema.InvalidModelException;
import edu.stanford.db.rdf.schema.RDFSchemaModel;
import edu.stanford.db.rdf.uml.vocabulary.uml_core_20000422.UMLCore;
import edu.stanford.db.rdf.uml.vocabulary.uml_datatypes_20000507.DataTypes;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.rdf.implementation.model.NodeFactoryImpl;
import org.w3c.rdf.model.Literal;
import org.w3c.rdf.model.Model;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.NodeFactory;
import org.w3c.rdf.model.RDFNode;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;
import org.w3c.rdf.model.VirtualModel;
import org.w3c.rdf.util.RDFFactory;
import org.w3c.rdf.util.RDFFactoryImpl;
import org.w3c.rdf.util.RDFUtil;
import org.w3c.rdf.util.SetOperations;
import org.w3c.rdf.vocabulary.rdf_schema_19990303.RDFS;
import org.w3c.rdf.vocabulary.rdf_syntax_19990222.RDF;

/*
 * Exception performing whole class analysis ignored.
 */
public class UMLModel
implements VirtualModel {
    NodeFactory nodeFactory;
    Model instances;
    Model schema;
    Hashtable inverse;

    public UMLModel() {
        this((NodeFactory)new NodeFactoryImpl());
    }

    public UMLModel(Model model, Model model2) {
        this();
        this.instances = model;
        this.schema = model2;
    }

    public UMLModel(NodeFactory nodeFactory) {
        this(nodeFactory, new Hashtable());
    }

    private UMLModel(NodeFactory nodeFactory, Hashtable hashtable) {
        this.inverse = hashtable;
        this.nodeFactory = nodeFactory;
    }

    public UMLModel(NodeFactory nodeFactory, Model model, Model model2) {
        this(nodeFactory);
        this.instances = model;
        this.schema = model2;
    }

    private UMLModel(NodeFactory nodeFactory, Model model, Model model2, Hashtable hashtable) {
        this(nodeFactory, hashtable);
        this.instances = model;
        this.schema = model2;
    }

    public void add(Statement statement) throws ModelException {
        this.instances.add(statement);
    }

    static boolean checkDataType(StringBuffer stringBuffer, Statement statement, Resource resource) throws ModelException {
        RDFNode rDFNode = statement.object();
        String string = rDFNode.getLabel();
        if (DataTypes.Integer.equals(resource)) {
            if (!(rDFNode instanceof Literal) || !UMLModel.isValidNumber((String)string)) {
                UMLModel.invalid((StringBuffer)stringBuffer, (Statement)statement, (String)"Attribute value must be an integer.");
            }
        } else if (DataTypes.UnlimitedInteger.equals(resource)) {
            if (!(DataTypes.UnlimitedInteger_c42.equals(rDFNode) || rDFNode instanceof Literal && UMLModel.isValidNumber((String)string))) {
                UMLModel.invalid((StringBuffer)stringBuffer, (Statement)statement, (String)("Attribute value must be an integer or " + DataTypes.UnlimitedInteger_c42));
            }
        } else {
            return false;
        }
        return true;
    }

    private void collectInverse(Model model, Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        Resource resource3 = (Resource)this.inverse.get(resource2);
        if (resource3 != null) {
            Model model2 = this.instances.find((Resource)rDFNode, resource3, resource);
            Enumeration enumeration = model2.elements();
            while (enumeration.hasMoreElements()) {
                Statement statement = (Statement)enumeration.nextElement();
                if (!(statement.object() instanceof Resource)) continue;
                model.add(this.nodeFactory.createStatement((Resource)statement.object(), resource2, statement.subject()));
            }
        }
    }

    public static Hashtable computeInverse(Model model) throws ModelException {
        Hashtable<Resource, Resource> hashtable = new Hashtable<Resource, Resource>();
        Model model2 = model.find(null, RDF.type, UMLCore.Association);
        Enumeration enumeration = model2.elements();
        while (enumeration.hasMoreElements()) {
            Resource resource = ((Statement)enumeration.nextElement()).subject();
            Model model3 = model.find(resource, UMLCore.Association_connection, null);
            if (model3.size() != 2) {
                throw new InvalidModelException("[UMLModel] cardinality violation: " + model3.size() + " instead of 2 objects for property " + UMLCore.Association_connection + " found for " + resource);
            }
            Enumeration enumeration2 = model3.elements();
            Resource resource2 = (Resource)((Statement)enumeration2.nextElement()).object();
            Resource resource3 = (Resource)((Statement)enumeration2.nextElement()).object();
            hashtable.put(resource2, resource3);
            hashtable.put(resource3, resource2);
        }
        return hashtable;
    }

    public boolean contains(Statement statement) throws ModelException {
        return this.find(statement.subject(), statement.predicate(), statement.object()).isEmpty() ^ true;
    }

    public Model create() throws ModelException {
        return new UMLModel(this.nodeFactory, this.instances.create(), this.schema, this.inverse);
    }

    public static Model create(Model model) throws ModelException {
        UMLModel uMLModel = new UMLModel(model, model);
        SetOperations.unite((Model)uMLModel, UMLModel.getRDFSClassHierarchy((Model)uMLModel));
        Model model2 = RDFSchemaModel.computeRDFSClosure((Model)uMLModel);
        return new UMLModel((Model)new RDFSchemaModel(model, model2), (Model)uMLModel);
    }

    public Model duplicate() throws ModelException {
        return new UMLModel(this.nodeFactory, this.instances.duplicate(), this.schema, this.inverse);
    }

    public Enumeration elements() throws ModelException {
        return this.find(null, null, null).elements();
    }

    public Model find(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        this.getInverse();
        Model model = this.instances.find(resource, resource2, rDFNode);
        Model model2 = model.create();
        if (resource2 != null) {
            this.collectInverse(model2, resource, resource2, rDFNode);
        } else {
            Enumeration enumeration = model.elements();
            while (enumeration.hasMoreElements()) {
                Statement statement = (Statement)enumeration.nextElement();
                Resource resource3 = (Resource)this.inverse.get(statement.predicate());
                if (resource3 == null || !(statement.object() instanceof Resource)) continue;
                model2.add(this.nodeFactory.createStatement((Resource)statement.object(), resource3, statement.subject()));
            }
        }
        SetOperations.unite(model, model2);
        return model;
    }

    public Model getGroundModel() throws ModelException {
        return this.instances;
    }

    private Hashtable getInverse() throws ModelException {
        Hashtable hashtable = this.inverse;
        synchronized (hashtable) {
            if (this.inverse.isEmpty()) {
                this.inverse = UMLModel.computeInverse((Model)this.schema);
            }
            Hashtable hashtable2 = this.inverse;
            Object var3_3 = null;
            return hashtable2;
        }
    }

    public String getLabel() throws ModelException {
        return this.instances.getLabel();
    }

    public String getLocalName() throws ModelException {
        return this.instances.getLocalName();
    }

    public String getNamespace() throws ModelException {
        return this.instances.getNamespace();
    }

    public NodeFactory getNodeFactory() throws ModelException {
        return this.nodeFactory;
    }

    public static Model getRDFSClassHierarchy(Model model) throws ModelException {
        Model model2 = model.create();
        NodeFactory nodeFactory = model.getNodeFactory();
        Model model3 = model.find(null, RDF.type, UMLCore.Generalization);
        Enumeration enumeration = model3.elements();
        while (enumeration.hasMoreElements()) {
            Resource resource = ((Statement)enumeration.nextElement()).subject();
            Resource resource2 = RDFUtil.getObjectResource(model, resource, UMLCore.Generalization_parent);
            Resource resource3 = RDFUtil.getObjectResource(model, resource, UMLCore.Generalization_child);
            if (resource2 == null) {
                throw new InvalidModelException("[UMLModel] no parent in Generalization " + resource);
            }
            if (resource3 == null) {
                throw new InvalidModelException("[UMLModel] no child in Generalization " + resource);
            }
            model2.add(nodeFactory.createStatement(resource3, RDFS.subClassOf, resource2));
        }
        return model2;
    }

    public String getSourceURI() throws ModelException {
        return this.instances.getSourceURI();
    }

    public String getURI() throws ModelException {
        return this.instances.getURI();
    }

    static void invalid(StringBuffer stringBuffer, Statement statement, String string) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append('\n');
        }
        if (statement != null) {
            stringBuffer.append("Invalid statement:\n\t" + statement + ".\n\t");
        }
        stringBuffer.append(string);
    }

    public boolean isEmpty() throws ModelException {
        return this.instances.isEmpty();
    }

    static boolean isInstanceOf(Model model, Model model2, Resource resource, Resource resource2) throws ModelException {
        return RDFUtil.isInstanceOf(model, resource, resource2) || RDFUtil.isInstanceOf(model2, resource, resource2);
    }

    public boolean isMutable() throws ModelException {
        return this.instances.isMutable();
    }

    static boolean isValidNumber(String string) {
        try {
            new BigInteger(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.err.println("UMLModel <instance URL> {<schema URL>}+");
            System.exit(1);
        }
        RDFFactoryImpl rDFFactoryImpl = new RDFFactoryImpl();
        Model model = rDFFactoryImpl.createModel();
        Model model2 = rDFFactoryImpl.createModel();
        RDFSchemaModel.readModelsFromArgList((RDFFactory)rDFFactoryImpl, (Model)model, (Model)model2, (String[])stringArray);
        try {
            UMLModel.validateRawSchema((Model)model, (Model)model2);
            System.err.println("Model is valid.");
        }
        catch (InvalidModelException invalidModelException) {
            System.err.println(invalidModelException.getMessage());
        }
    }

    public void remove(Statement statement) throws ModelException {
        this.instances.remove(statement);
    }

    public void setSourceURI(String string) throws ModelException {
        this.instances.setSourceURI(string);
    }

    public int size() throws ModelException {
        return -1;
    }

    public String toString() {
        try {
            return "[UMLModel " + this.getURI() + "]";
        }
        catch (ModelException modelException) {
            return "[UMLModel: " + modelException + "]";
        }
    }

    public static void validateRawSchema(Model model, Model model2) throws ModelException {
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable<Resource, Resource> hashtable = new Hashtable<Resource, Resource>();
        UMLModel uMLModel = new UMLModel(model2, model2);
        UMLModel uMLModel2 = new UMLModel(model, model2);
        Model model3 = RDFSchemaModel.computeRDFSClosure((Model)UMLModel.getRDFSClassHierarchy((Model)uMLModel));
        RDFSchemaModel rDFSchemaModel = new RDFSchemaModel(model2, model3);
        RDFSchemaModel rDFSchemaModel2 = new RDFSchemaModel(model, model3);
        Hashtable hashtable2 = uMLModel.getInverse();
        Enumeration enumeration = model.elements();
        while (enumeration.hasMoreElements()) {
            Resource resource;
            Resource resource2;
            Resource resource3;
            Statement statement = (Statement)enumeration.nextElement();
            if (RDF.type.equals(statement.predicate())) {
                if (statement.object() instanceof Literal) {
                    UMLModel.invalid((StringBuffer)stringBuffer, (Statement)statement, (String)"Literals cannot be used for typing");
                }
                if ((resource3 = rDFSchemaModel.find((Resource)statement.object(), RDF.type, UMLCore.Classifier)).isEmpty()) {
                    UMLModel.invalid((StringBuffer)stringBuffer, (Statement)statement, (String)(String.valueOf(statement.object().toString()) + " must be an instance of " + UMLCore.Classifier));
                }
                resource2 = statement.subject();
                resource = (Resource)statement.object();
                if (hashtable.contains(resource2)) continue;
                hashtable.put(resource2, resource2);
                Model model4 = uMLModel.find(null, UMLCore.AssociationEnd_type, (RDFNode)resource);
                Enumeration enumeration2 = model4.elements();
                while (enumeration2.hasMoreElements()) {
                    Resource resource4;
                    Resource resource5 = ((Statement)enumeration2.nextElement()).subject();
                    Resource resource6 = (Resource)uMLModel.getInverse().get(resource5);
                    if (resource6 == null || (resource4 = RDFUtil.getObjectResource((Model)uMLModel, resource6, UMLCore.AssociationEnd_multiplicity)) == null) continue;
                    Model model5 = uMLModel2.find(resource2, resource6, null);
                    Model model6 = uMLModel.find(resource4, DataTypes.Multiplicity_range, null);
                    boolean bl = false;
                    String string = "";
                    Enumeration enumeration3 = model6.elements();
                    while (enumeration3.hasMoreElements()) {
                        try {
                            int n;
                            Resource resource7 = (Resource)((Statement)enumeration3.nextElement()).object();
                            String string2 = RDFUtil.getObjectLiteral((Model)uMLModel, resource7, DataTypes.MultiplicityRange_lower);
                            RDFNode rDFNode = RDFUtil.getObject((Model)uMLModel, resource7, DataTypes.MultiplicityRange_upper);
                            int n2 = Integer.parseInt(string2);
                            int n4 = n = rDFNode instanceof Resource ? Integer.MAX_VALUE : Integer.parseInt(rDFNode.getLabel());
                            if (!"".equals(string)) {
                                string = String.valueOf(string) + ",";
                            }
                            string = n2 == n ? String.valueOf(string) + string2 : String.valueOf(string) + string2 + "-" + (rDFNode instanceof Resource ? "*" : rDFNode.getLabel());
                            if (n2 > model5.size() || model5.size() > n) continue;
                            bl = true;
                            break;
                        }
                        catch (Exception exception) {}
                    }
                    if ("".equals(string) || bl) continue;
                    UMLModel.invalid((StringBuffer)stringBuffer, null, (String)("Resource " + resource2 + " (of type " + resource + ") is expected to have " + string + ", not " + model5.size() + ", properties of type " + resource6 + " (inverse of " + resource5 + ")"));
                }
                continue;
            }
            resource3 = RDFUtil.getObjectResource((Model)rDFSchemaModel, statement.predicate(), UMLCore.AssociationEnd_type);
            if (resource3 != null) {
                if (!UMLModel.isInstanceOf((Model)rDFSchemaModel2, (Model)rDFSchemaModel, (Resource)((Resource)statement.object()), (Resource)resource3)) {
                    UMLModel.invalid((StringBuffer)stringBuffer, (Statement)statement, (String)("Object must be instance of " + resource3));
                }
                if ((resource2 = (Resource)hashtable2.get(statement.predicate())) == null) {
                    UMLModel.invalid((StringBuffer)stringBuffer, null, (String)("Bad schema definition of " + statement.predicate() + ", no other AssociationEnd found"));
                    continue;
                }
                resource = RDFUtil.getObjectResource((Model)rDFSchemaModel, resource2, UMLCore.AssociationEnd_type);
                if (resource == null) {
                    UMLModel.invalid((StringBuffer)stringBuffer, null, (String)("No association end type defined for " + resource2));
                    continue;
                }
                if (UMLModel.isInstanceOf((Model)rDFSchemaModel2, (Model)rDFSchemaModel, (Resource)statement.subject(), (Resource)resource)) continue;
                UMLModel.invalid((StringBuffer)stringBuffer, (Statement)statement, (String)("Subject must be instance of " + resource));
                continue;
            }
            resource2 = RDFUtil.getObjectResource((Model)rDFSchemaModel, statement.predicate(), UMLCore.StructuralFeature_type);
            if (resource2 == null || UMLModel.checkDataType((StringBuffer)stringBuffer, (Statement)statement, (Resource)resource2) || statement.object() instanceof Resource && UMLModel.isInstanceOf((Model)rDFSchemaModel2, (Model)rDFSchemaModel, (Resource)((Resource)statement.object()), (Resource)resource2)) continue;
            UMLModel.invalid((StringBuffer)stringBuffer, (Statement)statement, (String)("Attribute value must be instance of " + resource2));
        }
        if (stringBuffer.length() > 0) {
            throw new InvalidModelException(stringBuffer.toString());
        }
    }
}

