/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.db.rdf.syntax.strawman;

import edu.stanford.db.rdf.syntax.generic.GenericXML2RDF;
import edu.stanford.db.rdf.syntax.strawman.StrawArc;
import edu.stanford.db.rdf.syntax.strawman.StrawElement;
import edu.stanford.db.xml.util.Element;
import edu.stanford.db.xml.util.GenericParser;
import edu.stanford.db.xml.util.QName;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.rdf.digest.DigestException;
import org.w3c.rdf.digest.DigestUtil;
import org.w3c.rdf.digest.Digestable;
import org.w3c.rdf.digest.RDFDigestUtil;
import org.w3c.rdf.model.Literal;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.RDFNode;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;
import org.w3c.rdf.syntax.RDFParser;
import org.w3c.rdf.vocabulary.rdf_schema_19990303.RDFS;
import org.w3c.rdf.vocabulary.rdf_syntax_19990222.RDF;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class StrawmanParser
extends GenericXML2RDF {
    public static final String REVISION = "Strawman RDF parser v0.3 2000-10-31";
    public static final String _Namespace = "http://interdataworking.com/vocabulary/strawman-20000408#";
    public static final QName RDF_INSTANCE = GenericParser.createQName((String)"http://interdataworking.com/vocabulary/strawman-20000408#", (String)"instance");
    public static final QName RDF_RESOURCE = GenericParser.createQName((String)"http://interdataworking.com/vocabulary/strawman-20000408#", (String)"resource");
    public static final QName RDF_FOR = GenericParser.createQName((String)"http://interdataworking.com/vocabulary/strawman-20000408#", (String)"for");
    int shift = 0;
    int strawDepth = 0;
    boolean useDigests = false;
    static int genidCounter = 0;

    public StrawmanParser() {
    }

    public StrawmanParser(boolean bl, boolean bl2) {
        super(bl2);
        this.useDigests = bl;
    }

    static void bailOut() {
        System.err.println("Usage: java -Dorg.xml.sax.parser=<classname> org.w3c.rdf.syntax.strawman.StrawmanParser [-d] <URI | filename>");
        System.err.println("This is revision Strawman RDF parser v0.3 2000-10-31");
        System.exit(1);
    }

    void collectCDATA(StrawElement strawElement) throws ModelException {
        if (strawElement.getValue().length() > 0 || strawElement.getType() == 0 && strawElement.arcs.size() == 0 && strawElement.getAttribute(RDF_RESOURCE) == null) {
            strawElement.addArc(this.nodeFactory.createOrdinal(strawElement.next()), (Object)this.nodeFactory.createLiteral(strawElement.getValue()));
            strawElement.setValue("");
        }
    }

    protected Element createElement() {
        return new StrawElement();
    }

    protected Statement createStatement(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        if (!resource2.equals(RDF.type) || !rDFNode.equals(RDFS.Resource)) {
            return super.createStatement(resource, resource2, rDFNode);
        }
        return null;
    }

    int depth(Element element) {
        return ((StrawElement)element).depth;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.finishElement();
        if (this.current.getAttribute(RDF_FOR) != null) {
            this.current = this.current.getParent();
            this.finishElement();
        }
        if (this.strawDepth > 0) {
            --this.strawDepth;
        }
        this._endElement(string, string2);
    }

    StrawArc findArc(Vector vector, StrawElement strawElement) {
        int n = 0;
        while (n < vector.size()) {
            StrawArc strawArc = (StrawArc)vector.elementAt(n);
            if (strawArc.object() == strawElement) {
                return strawArc;
            }
            ++n;
        }
        return null;
    }

    StrawArc findArc(Vector vector, Resource resource) {
        int n = 0;
        while (n < vector.size()) {
            StrawArc strawArc = (StrawArc)vector.elementAt(n);
            if (strawArc.predicate().equals(resource)) {
                return strawArc;
            }
            ++n;
        }
        return null;
    }

    void finishElement() throws SAXException {
        try {
            Object object;
            Object object2;
            StrawElement strawElement = (StrawElement)this.current;
            boolean bl = false;
            this.collectCDATA(strawElement);
            Vector vector = strawElement.arcs;
            StrawArc strawArc = this.findArc(vector, this.nodeFactory.createOrdinal(1));
            if (strawArc != null && strawArc.object() instanceof Literal && this.findArc(vector, this.nodeFactory.createOrdinal(2)) == null) {
                strawArc.predicate = RDF.value;
            }
            if (vector.size() == 1) {
                StrawArc strawArc2 = (StrawArc)vector.elementAt(0);
                if (strawElement.anonymous && strawArc2.predicate().equals(RDF.value) && this.isProperty((Element)strawElement) && (object2 = this.findArc((Vector)(object = this.getParent((Element)strawElement).arcs), strawElement)) != null) {
                    ((StrawArc)object2).object = strawArc2.object();
                    bl = true;
                }
            }
            if (!bl) {
                if (!this.isProperty((Element)strawElement)) {
                    strawElement.addArc(RDF.type, (Object)this.createResource(strawElement.getName()));
                }
                if (strawElement.anonymous) {
                    if (this.useDigests) {
                        int n = 0;
                        while (n < vector.size()) {
                            object = (StrawArc)vector.elementAt(n);
                            this.updateDigest(strawElement, object);
                            ++n;
                        }
                        strawElement.subject = this.createResource(String.valueOf(this.getSourceURI()) + "#", String.valueOf(RDFDigestUtil.getDigestAlgorithm()) + "-" + DigestUtil.toHexString(strawElement.digestPath));
                    } else {
                        strawElement.subject = this.createResource(String.valueOf(this.getSourceURI()) + "#", "genid-" + ++genidCounter);
                    }
                }
                int n = 0;
                while (n < vector.size()) {
                    RDFNode rDFNode;
                    object = (StrawArc)vector.elementAt(n);
                    object2 = object.object();
                    RDFNode rDFNode2 = rDFNode = object2 instanceof RDFNode ? (RDFNode)object2 : ((StrawElement)object2).subject;
                    if (strawElement.subject != null) {
                        this.createStatement(strawElement.subject, object.predicate(), rDFNode);
                    }
                    ++n;
                }
                strawElement.arcs = null;
            }
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    Resource getArcFromParent(Element element) {
        return ((StrawElement)element).arcFromParent;
    }

    byte[] getDigest(Object object) throws DigestException {
        if (object instanceof Digestable) {
            return ((Digestable)object).getDigest().getDigestBytes();
        }
        if (object instanceof StrawElement) {
            StrawElement strawElement = (StrawElement)object;
            if (strawElement.anonymous) {
                return strawElement.digestPath;
            }
            return this.getDigest((Object)strawElement.subject);
        }
        throw new RuntimeException("No digest for " + object);
    }

    StrawElement getParent(Element element) {
        return (StrawElement)element.getParent();
    }

    boolean isProperty(Element element) {
        return element.getAttribute(RDF_FOR) != null || element.getParent() != null && element.getAttribute(RDF_INSTANCE) == null;
    }

    public static void main(String[] stringArray) throws Exception {
        boolean bl = false;
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string2.startsWith("-d")) {
                bl = true;
            } else {
                string = string2;
                if (n + 1 < stringArray.length) {
                    StrawmanParser.bailOut();
                }
            }
            ++n;
        }
        if (string == null) {
            StrawmanParser.bailOut();
        }
        GenericXML2RDF._main(string, (RDFParser)new StrawmanParser(bl, true));
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this._startElement(string, string2, attributes);
        try {
            Object object;
            StrawElement strawElement = (StrawElement)this.current;
            String string4 = strawElement.getAttribute(RDF_INSTANCE);
            String string5 = strawElement.getAttribute(RDF_RESOURCE);
            String string6 = strawElement.getAttribute(RDF_FOR);
            if (this.strawDepth == 0 && string4 == null && string5 == null && string6 == null) {
                return;
            }
            ++this.strawDepth;
            StrawElement strawElement2 = this.getParent((Element)strawElement);
            if (string4 != null && string5 != null) {
                throw new SAXException("Invalid XML element: attributes 'instance' and 'resource' are mutually exclusive!");
            }
            if (string4 != null && string4.length() > 0) {
                strawElement.subject = this.createResource(string4);
            } else if (string5 != null && string5.length() > 0) {
                strawElement.subject = this.createResource(string5);
            } else {
                strawElement.anonymous = true;
            }
            Enumeration enumeration = strawElement.getAttributes();
            while (enumeration.hasMoreElements()) {
                object = (QName)enumeration.nextElement();
                if (object.equals((Object)RDF_RESOURCE) || object.equals((Object)RDF_INSTANCE) || object.equals((Object)RDF_FOR)) continue;
                strawElement.addArc(this.createResource(object), (Object)this.nodeFactory.createLiteral(strawElement.getAttribute(object)));
            }
            if (string6 != null) {
                object = new StrawElement();
                if (strawElement2 != null) {
                    strawElement2.setChild((Element)object);
                }
                object.setChild((Element)strawElement);
                object.setAttribute(RDF_FOR, string6);
                strawElement.setParent((Element)object);
                object.setParent((Element)strawElement2);
                if (string6.length() > 0) {
                    object.subject = this.createResource(string6);
                } else {
                    object.anonymous = true;
                }
                strawElement.arcFromParent = this.createResource(strawElement.getName());
                object.addArc(strawElement.arcFromParent, (Object)strawElement);
                strawElement.depth = 1;
                if (this.useDigests) {
                    strawElement.digestPath = this.getDigest((Object)strawElement.arcFromParent);
                }
            } else if (strawElement2 != null) {
                this.collectCDATA(strawElement2);
                strawElement.arcFromParent = this.isProperty((Element)strawElement) ? this.createResource(strawElement.getName()) : this.nodeFactory.createOrdinal(strawElement2.next());
                strawElement2.addArc(strawElement.arcFromParent, (Object)strawElement);
                strawElement.depth = strawElement2.depth + 1;
                if (this.useDigests) {
                    object = this.getDigest((Object)this.getArcFromParent((Element)strawElement));
                    if (this.depth((Element)strawElement) == 1) {
                        strawElement.digestPath = (byte[])object;
                    } else {
                        strawElement.digestPath = new byte[strawElement2.digestPath.length];
                        System.arraycopy(strawElement2.digestPath, 0, strawElement.digestPath, 0, strawElement2.digestPath.length);
                        DigestUtil.xor(strawElement.digestPath, (byte[])object, this.depth((Element)strawElement) - 1);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    protected void updateDigest(StrawElement strawElement, StrawArc strawArc) throws DigestException {
        if (strawElement.digestPath == null) {
            strawElement.digestPath = this.getDigest((Object)strawArc.predicate());
        } else {
            DigestUtil.xor(strawElement.digestPath, this.getDigest((Object)strawArc.predicate()), strawElement.depth);
        }
        DigestUtil.xor(strawElement.digestPath, this.getDigest(strawArc.object()), strawElement.depth + 1);
    }
}

