/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.db.rdf.syntax.generic;

import edu.stanford.db.xml.util.GenericSerializer;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import org.w3c.rdf.model.Literal;
import org.w3c.rdf.model.Model;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.RDFNode;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;
import org.w3c.rdf.syntax.RDFSerializer;
import org.w3c.rdf.syntax.SerializationException;

public class TripleSerializer
implements RDFSerializer {
    static final int MAX_STMT_CACHE = 1000;
    static final int MAX_NS = 1000;
    public static final String NS = "http://www.interdataworking.com/rdf/syntax/triples/0.1/";
    HashMap seenModels;
    HashMap seenStmts;
    HashMap seenNs;

    void indent(int n, Writer writer) throws IOException {
        writer.write(10);
        int n2 = 0;
        while (n2 < n) {
            writer.write(9);
            ++n2;
        }
    }

    public void serialize(Model model, Writer writer) throws SerializationException, IOException, ModelException {
        this.seenModels = new HashMap();
        this.seenStmts = new HashMap();
        this.seenNs = new HashMap();
        writer.write("<?xml version=\"1.0\"?>");
        this.writeModel(model, writer, 0);
        this.seenModels = null;
        writer.flush();
    }

    public void writeModel(Model model, Writer writer, int n) throws ModelException, IOException {
        String string = (String)this.seenModels.get(model);
        if (string != null) {
            writer.write("<model idref=\"" + string + "\"/>");
            return;
        }
        string = "m" + this.seenModels.size();
        this.seenModels.put(model, string);
        this.indent(n, writer);
        writer.write("<model ");
        boolean bl = false;
        if (n == 0) {
            writer.write("xmlns=\"http://www.interdataworking.com/rdf/syntax/triples/0.1/\" ");
            bl = true;
        }
        writer.write("id=\"" + string + "\">");
        Enumeration enumeration = model.elements();
        while (enumeration.hasMoreElements()) {
            if (bl || this.seenStmts.size() >= 1000 || this.seenNs.size() >= 1000) {
                this.indent(n + 1, writer);
                writer.write("<cache maxstmt=\"1000\" maxns=\"1000\"/>");
                this.seenStmts.clear();
                this.seenNs.clear();
                bl = false;
            }
            Statement statement = (Statement)enumeration.nextElement();
            this.writeStatement(statement, writer, n + 1, true);
            writer.flush();
        }
        this.indent(n, writer);
        writer.write("</model>");
    }

    void writeNode(String string, RDFNode rDFNode, Writer writer, int n) throws ModelException, IOException {
        this.indent(n, writer);
        writer.write("<" + string + ">");
        if (rDFNode instanceof Literal) {
            String string2 = ((Literal)rDFNode).getLabel();
            boolean bl = GenericSerializer.isCDATA((String)string2);
            if (bl) {
                writer.write("<l xml:space=\"preserve\"><![CDATA[");
                GenericSerializer.writeCDATA((String)string2, (Writer)writer);
                writer.write("]]>");
            } else {
                writer.write("<l>");
                writer.write(rDFNode.getLabel());
            }
            writer.write("</l>");
        } else if (rDFNode instanceof Statement) {
            this.writeStatement((Statement)rDFNode, writer, n, false);
        } else if (rDFNode instanceof Model) {
            this.writeModel((Model)rDFNode, writer, n);
        } else if (rDFNode instanceof Resource) {
            Resource resource = (Resource)rDFNode;
            String string3 = resource.getNamespace();
            String string4 = resource.getLocalName();
            if (string3 != null && string3.length() > 0) {
                writer.write("<r name=\"" + string4 + "\" ");
                String string5 = (String)this.seenNs.get(string3);
                if (string5 == null) {
                    string5 = "ns" + this.seenNs.size();
                    this.seenNs.put(string3, string5);
                    writer.write("ns=\"" + string3 + "\" nsid=\"" + string5 + "\"/>");
                } else {
                    writer.write("nsref=\"" + string5 + "\"/>");
                }
            } else {
                writer.write("<r uri=\"" + resource.getURI() + "\"/>");
            }
        } else {
            writer.write(rDFNode.getLabel());
        }
        writer.write("</" + string + ">");
    }

    void writeStatement(Statement statement, Writer writer, int n, boolean bl) throws ModelException, IOException {
        String string = (String)this.seenStmts.get(statement);
        if (string != null) {
            if (bl) {
                this.indent(n, writer);
            }
            writer.write("<stmt idref=\"" + string + "\"/>");
            return;
        }
        string = "s" + this.seenStmts.size();
        this.seenStmts.put(statement, string);
        if (bl) {
            this.indent(n, writer);
        }
        writer.write("<stmt id=\"" + string + "\">");
        this.writeNode("s", (RDFNode)statement.subject(), writer, n + 1);
        this.writeNode("p", (RDFNode)statement.predicate(), writer, n + 1);
        this.writeNode("o", statement.object(), writer, n + 1);
        writer.write("</stmt>");
    }
}

