/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.db.rdf.syntax.generic;

import edu.stanford.db.rdf.syntax.generic.GenericXML2RDF;
import edu.stanford.db.xml.util.QName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.RDFNode;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;
import org.w3c.rdf.syntax.RDFParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TripleParser
extends GenericXML2RDF {
    static final String N_MODEL = "model";
    static final String N_STMT = "stmt";
    static final String N_CACHE = "cache";
    static final String N_S = "s";
    static final String N_P = "p";
    static final String N_O = "o";
    static final String N_R = "r";
    static final String N_L = "l";
    static final QName A_ID = new QName("id");
    static final QName A_IDREF = new QName("idref");
    static final QName A_URI = new QName("uri");
    static final QName A_NSID = new QName("nsid");
    static final QName A_NSREF = new QName("nsref");
    static final QName A_NS = new QName("ns");
    static final QName A_NAME = new QName("name");
    HashMap seenModels;
    HashMap seenStmts;
    HashMap seenNs;
    List tokens = new ArrayList();
    int nesting = 0;
    public static final String NS = "http://www.interdataworking.com/rdf/syntax/triples/0.1/";

    protected Statement createStatement(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        Statement statement = this.nodeFactory.createStatement(resource, resource2, rDFNode);
        if (this.nesting == 2) {
            this.consumer.addStatement(statement);
        }
        return statement;
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        if (this.tokens.size() > 0) {
            this.error("Remaining " + this.tokens.size() + " tokens on stack: " + this.tokens);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            QName qName = this.current.getName();
            string = qName.getNamespace();
            string2 = qName.getLocalName();
            if (NS.equals(string)) {
                if (N_R.equals(string2)) {
                    String string4 = this.current.getAttribute(A_URI);
                    if (string4 != null) {
                        this.push((Object)this.nodeFactory.createResource(string4));
                    } else {
                        String string5 = this.current.getAttribute(A_NAME);
                        String string6 = this.current.getAttribute(A_NSREF);
                        String string7 = null;
                        if (string6 != null) {
                            string7 = (String)this.seenNs.get(string6);
                            if (string7 == null) {
                                this.error("Unresolved namespace reference: " + string6);
                            }
                        } else {
                            string7 = this.current.getAttribute(A_NS);
                            String string8 = this.current.getAttribute(A_NSID);
                            if (string8 != null) {
                                this.seenNs.put(string8, string7);
                            }
                        }
                        this.push((Object)this.nodeFactory.createResource(string7, string5));
                    }
                } else if (N_L.equals(string2)) {
                    this.push((Object)this.nodeFactory.createLiteral(this.current.getValue()));
                } else if (N_CACHE.equals(string2)) {
                    this.seenNs.clear();
                    this.seenStmts.clear();
                } else if (N_S.equals(string2)) {
                    this.push((Object)N_S);
                } else if (N_P.equals(string2)) {
                    this.push((Object)N_P);
                } else if (N_O.equals(string2)) {
                    this.push((Object)N_O);
                } else if (N_STMT.equals(string2)) {
                    String string9 = this.current.getAttribute(A_IDREF);
                    if (string9 != null) {
                        Statement statement = (Statement)this.seenStmts.get(string9);
                        if (statement == null) {
                            this.error("Dangling statement reference: " + string9);
                        } else if (this.nesting > 2) {
                            this.push((Object)statement);
                        }
                    } else {
                        String string10;
                        Object object;
                        Object object2 = null;
                        Object object3 = null;
                        Object object4 = null;
                        int n = 0;
                        while (n < 3) {
                            object = this.pop();
                            if (N_O.equals(object)) {
                                object4 = this.pop();
                            } else if (N_P.equals(object)) {
                                object3 = this.pop();
                            } else if (N_S.equals(object)) {
                                object2 = this.pop();
                            } else {
                                this.error("Invalid token on stack, subject, predicate or object expected");
                            }
                            ++n;
                        }
                        if (!(object2 instanceof Resource && object3 instanceof Resource && object4 instanceof RDFNode)) {
                            this.error("Invalid statement, subject, predicate or object missing or type is wrong");
                        }
                        object = this.createStatement((Resource)object2, (Resource)object3, (RDFNode)object4);
                        if (this.nesting > 2) {
                            this.push(object);
                        }
                        if ((string10 = this.current.getAttribute(A_ID)) != null) {
                            this.seenStmts.put(string10, object);
                        }
                    }
                    --this.nesting;
                } else if (N_MODEL.equals(string2)) {
                    --this.nesting;
                }
            }
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        this._endElement(string, string2);
    }

    void error(String string) throws SAXException {
        throw new SAXParseException(string, this.locator);
    }

    public static void main(String[] stringArray) throws Exception {
        GenericXML2RDF._main((String)stringArray[0], (RDFParser)new TripleParser());
    }

    Object pop() {
        return this.tokens.size() > 0 ? this.tokens.remove(this.tokens.size() - 1) : null;
    }

    void push(Object object) {
        this.tokens.add(object);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.seenModels = new HashMap();
        this.seenStmts = new HashMap();
        this.seenNs = new HashMap();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this._startElement(string, string2, attributes);
        if (NS.equals(string)) {
            if (N_MODEL.equals(string2)) {
                if (this.nesting > 0) {
                    this.error("Nested models are not supported in the current version of RDFConsumer");
                }
                ++this.nesting;
            } else if (N_STMT.equals(string2)) {
                ++this.nesting;
            }
        }
    }
}

